/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.ch.qos.logback.core.util;

import java.util.regex.Pattern;

public class FileSize {
    private static final Pattern FILE_SIZE_PATTERN = Pattern.compile("([0-9]+)\\s*(|kb|mb|gb)s?", 2);
    final long size;

    public FileSize(long size) {
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public String toString() {
        long inKB = this.size / 1024L;
        if (inKB == 0L) {
            return this.size + " Bytes";
        }
        long inMB = this.size / 0x100000L;
        if (inMB == 0L) {
            return inKB + " KB";
        }
        long inGB = this.size / 0x40000000L;
        if (inGB == 0L) {
            return inMB + " MB";
        }
        return inGB + " GB";
    }
}

