/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.util;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.agent.jul.Level;
import org.glowroot.agent.jul.Logger;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.io.grpc.ConnectivityState;
import org.glowroot.agent.shaded.io.grpc.EquivalentAddressGroup;
import org.glowroot.agent.shaded.io.grpc.LoadBalancer;
import org.glowroot.agent.shaded.io.grpc.LoadBalancerProvider;
import org.glowroot.agent.shaded.io.grpc.Status;
import org.glowroot.agent.shaded.io.grpc.internal.PickFirstLoadBalancerProvider;
import org.glowroot.agent.shaded.io.grpc.util.ForwardingLoadBalancerHelper;
import org.glowroot.agent.shaded.io.grpc.util.GracefulSwitchLoadBalancer;

public abstract class MultiChildLoadBalancer
extends LoadBalancer {
    private static final Logger logger = Logger.getLogger(MultiChildLoadBalancer.class.getName());
    private final Map<Object, ChildLbState> childLbStates = new LinkedHashMap<Object, ChildLbState>();
    private final LoadBalancer.Helper helper;
    protected boolean resolvingAddresses;
    protected final LoadBalancerProvider pickFirstLbProvider = new PickFirstLoadBalancerProvider();
    protected ConnectivityState currentConnectivityState;

    protected MultiChildLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        logger.log(Level.FINE, "Created");
    }

    protected abstract LoadBalancer.SubchannelPicker getSubchannelPicker(Map<Object, LoadBalancer.SubchannelPicker> var1);

    protected LoadBalancer.SubchannelPicker getInitialPicker() {
        return EMPTY_PICKER;
    }

    protected LoadBalancer.SubchannelPicker getErrorPicker(Status error) {
        return new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError(error));
    }

    protected ImmutableMap<Object, ChildLbState> getImmutableChildMap() {
        return ImmutableMap.copyOf(this.childLbStates);
    }

    protected Collection<ChildLbState> getChildLbStates() {
        return this.childLbStates.values();
    }

    protected ChildLbState getChildLbState(Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof EquivalentAddressGroup) {
            key = new Endpoint((EquivalentAddressGroup)key);
        }
        return this.childLbStates.get(key);
    }

    protected ChildLbState getChildLbStateEag(EquivalentAddressGroup eag) {
        return this.getChildLbState(new Endpoint(eag));
    }

    protected Map<Object, ChildLbState> createChildLbMap(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        HashMap<Object, ChildLbState> childLbMap = new HashMap<Object, ChildLbState>();
        List<EquivalentAddressGroup> addresses = resolvedAddresses.getAddresses();
        for (EquivalentAddressGroup eag : addresses) {
            Endpoint endpoint = new Endpoint(eag);
            ChildLbState existingChildLbState = this.childLbStates.get(endpoint);
            if (existingChildLbState != null) {
                childLbMap.put(endpoint, existingChildLbState);
                continue;
            }
            childLbMap.put(endpoint, this.createChildLbState(endpoint, null, this.getInitialPicker(), resolvedAddresses));
        }
        return childLbMap;
    }

    protected ChildLbState createChildLbState(Object key, Object policyConfig, LoadBalancer.SubchannelPicker initialPicker, LoadBalancer.ResolvedAddresses resolvedAddresses) {
        return new ChildLbState(key, this.pickFirstLbProvider, policyConfig, initialPicker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        try {
            this.resolvingAddresses = true;
            AcceptResolvedAddressRetVal acceptRetVal = this.acceptResolvedAddressesInternal(resolvedAddresses);
            if (!acceptRetVal.status.isOk()) {
                Status status = acceptRetVal.status;
                return status;
            }
            this.updateOverallBalancingState();
            this.shutdownRemoved(acceptRetVal.removedChildren);
            Status status = acceptRetVal.status;
            return status;
        }
        finally {
            this.resolvingAddresses = false;
        }
    }

    protected LoadBalancer.ResolvedAddresses getChildAddresses(Object key, LoadBalancer.ResolvedAddresses resolvedAddresses, Object childConfig) {
        Endpoint endpointKey;
        if (key instanceof EquivalentAddressGroup) {
            endpointKey = new Endpoint((EquivalentAddressGroup)key);
        } else {
            Preconditions.checkArgument(key instanceof Endpoint, "key is wrong type");
            endpointKey = (Endpoint)key;
        }
        EquivalentAddressGroup eagToUse = null;
        for (EquivalentAddressGroup currEag : resolvedAddresses.getAddresses()) {
            if (!endpointKey.equals(new Endpoint(currEag))) continue;
            eagToUse = currEag;
            break;
        }
        Preconditions.checkNotNull(eagToUse, key + " no longer present in load balancer children");
        return resolvedAddresses.toBuilder().setAddresses(Collections.singletonList(eagToUse)).setLoadBalancingPolicyConfig(childConfig).build();
    }

    protected AcceptResolvedAddressRetVal acceptResolvedAddressesInternal(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        logger.log(Level.FINE, "Received resolution result: {0}", resolvedAddresses);
        Map<Object, ChildLbState> newChildren = this.createChildLbMap(resolvedAddresses);
        if (newChildren.isEmpty()) {
            Status unavailableStatus = Status.UNAVAILABLE.withDescription("NameResolver returned no usable address. " + resolvedAddresses);
            this.handleNameResolutionError(unavailableStatus);
            return new AcceptResolvedAddressRetVal(unavailableStatus, null);
        }
        for (Map.Entry<Object, ChildLbState> entry : newChildren.entrySet()) {
            Object key = entry.getKey();
            LoadBalancerProvider childPolicyProvider = entry.getValue().getPolicyProvider();
            Object childConfig = entry.getValue().getConfig();
            if (!this.childLbStates.containsKey(key)) {
                this.childLbStates.put(key, entry.getValue());
            } else {
                ChildLbState existingChildLbState = this.childLbStates.get(key);
                if (existingChildLbState.isDeactivated() && this.reactivateChildOnReuse()) {
                    existingChildLbState.reactivate(childPolicyProvider);
                }
            }
            ChildLbState childLbState = this.childLbStates.get(key);
            LoadBalancer.ResolvedAddresses childAddresses = this.getChildAddresses(key, resolvedAddresses, childConfig);
            this.childLbStates.get(key).setResolvedAddresses(childAddresses);
            if (childLbState.deactivated) continue;
            childLbState.lb.handleResolvedAddresses(childAddresses);
        }
        ArrayList<ChildLbState> removedChildren = new ArrayList<ChildLbState>();
        for (Object key : ImmutableList.copyOf(this.childLbStates.keySet())) {
            if (newChildren.containsKey(key)) continue;
            ChildLbState childLbState = this.childLbStates.get(key);
            childLbState.deactivate();
            removedChildren.add(childLbState);
        }
        return new AcceptResolvedAddressRetVal(Status.OK, removedChildren);
    }

    protected void shutdownRemoved(List<ChildLbState> removedChildren) {
        for (ChildLbState childLbState : removedChildren) {
            childLbState.shutdown();
        }
    }

    @Override
    public void handleNameResolutionError(Status error) {
        if (this.currentConnectivityState != ConnectivityState.READY) {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, this.getErrorPicker(error));
        }
    }

    protected void handleNameResolutionError(ChildLbState child, Status error) {
        child.lb.handleNameResolutionError(error);
    }

    protected boolean reconnectOnIdle() {
        return true;
    }

    protected boolean reactivateChildOnReuse() {
        return true;
    }

    @Override
    public void shutdown() {
        logger.log(Level.INFO, "Shutdown");
        for (ChildLbState state : this.childLbStates.values()) {
            state.shutdown();
        }
        this.childLbStates.clear();
    }

    protected void updateOverallBalancingState() {
        ConnectivityState overallState = null;
        HashMap<Object, LoadBalancer.SubchannelPicker> childPickers = new HashMap<Object, LoadBalancer.SubchannelPicker>();
        for (ChildLbState childLbState : this.getChildLbStates()) {
            if (childLbState.deactivated) continue;
            childPickers.put(childLbState.key, childLbState.currentPicker);
            overallState = MultiChildLoadBalancer.aggregateState(overallState, childLbState.currentState);
        }
        if (overallState != null) {
            this.helper.updateBalancingState(overallState, this.getSubchannelPicker(childPickers));
            this.currentConnectivityState = overallState;
        }
    }

    @Nullable
    protected static ConnectivityState aggregateState(@Nullable ConnectivityState overallState, ConnectivityState childState) {
        if (overallState == null) {
            return childState;
        }
        if (overallState == ConnectivityState.READY || childState == ConnectivityState.READY) {
            return ConnectivityState.READY;
        }
        if (overallState == ConnectivityState.CONNECTING || childState == ConnectivityState.CONNECTING) {
            return ConnectivityState.CONNECTING;
        }
        if (overallState == ConnectivityState.IDLE || childState == ConnectivityState.IDLE) {
            return ConnectivityState.IDLE;
        }
        return overallState;
    }

    protected LoadBalancer.Helper getHelper() {
        return this.helper;
    }

    protected void removeChild(Object key) {
        this.childLbStates.remove(key);
    }

    protected List<ChildLbState> getReadyChildren() {
        ArrayList<ChildLbState> activeChildren = new ArrayList<ChildLbState>();
        for (ChildLbState child : this.getChildLbStates()) {
            if (child.isDeactivated() || child.getCurrentState() != ConnectivityState.READY) continue;
            activeChildren.add(child);
        }
        return activeChildren;
    }

    protected static class AcceptResolvedAddressRetVal {
        public final Status status;
        public final List<ChildLbState> removedChildren;

        public AcceptResolvedAddressRetVal(Status status, List<ChildLbState> removedChildren) {
            this.status = status;
            this.removedChildren = removedChildren;
        }
    }

    protected static class Endpoint {
        final String[] addrs;
        final int hashCode;

        public Endpoint(EquivalentAddressGroup eag) {
            Preconditions.checkNotNull(eag, "eag");
            this.addrs = new String[eag.getAddresses().size()];
            int i = 0;
            for (SocketAddress address : eag.getAddresses()) {
                this.addrs[i] = address.toString();
            }
            Arrays.sort(this.addrs);
            this.hashCode = Arrays.hashCode(this.addrs);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof Endpoint)) {
                return false;
            }
            Endpoint o = (Endpoint)other;
            if (o.hashCode != this.hashCode || o.addrs.length != this.addrs.length) {
                return false;
            }
            return Arrays.equals(o.addrs, this.addrs);
        }

        public String toString() {
            return Arrays.toString(this.addrs);
        }
    }

    public class ChildLbState {
        private final Object key;
        private LoadBalancer.ResolvedAddresses resolvedAddresses;
        private final Object config;
        private final GracefulSwitchLoadBalancer lb;
        private final LoadBalancerProvider policyProvider;
        private ConnectivityState currentState;
        private LoadBalancer.SubchannelPicker currentPicker;
        private boolean deactivated;

        public ChildLbState(Object key, LoadBalancerProvider policyProvider, Object childConfig, LoadBalancer.SubchannelPicker initialPicker) {
            this(key, policyProvider, childConfig, initialPicker, null, false);
        }

        public ChildLbState(Object key, LoadBalancerProvider policyProvider, Object childConfig, LoadBalancer.SubchannelPicker initialPicker, LoadBalancer.ResolvedAddresses resolvedAddrs, boolean deactivated) {
            this.key = key;
            this.policyProvider = policyProvider;
            this.deactivated = deactivated;
            this.currentPicker = initialPicker;
            this.config = childConfig;
            this.lb = new GracefulSwitchLoadBalancer(new ChildLbStateHelper());
            this.currentState = deactivated ? ConnectivityState.IDLE : ConnectivityState.CONNECTING;
            this.resolvedAddresses = resolvedAddrs;
            if (!deactivated) {
                this.lb.switchTo(policyProvider);
            }
        }

        public String toString() {
            return "Address = " + this.key + ", state = " + (Object)((Object)this.currentState) + ", picker type: " + this.currentPicker.getClass() + ", lb: " + this.lb.delegate().getClass() + (this.deactivated ? ", deactivated" : "");
        }

        public Object getKey() {
            return this.key;
        }

        Object getConfig() {
            return this.config;
        }

        protected GracefulSwitchLoadBalancer getLb() {
            return this.lb;
        }

        public LoadBalancerProvider getPolicyProvider() {
            return this.policyProvider;
        }

        protected LoadBalancer.Subchannel getSubchannels(LoadBalancer.PickSubchannelArgs args) {
            if (this.getCurrentPicker() == null) {
                return null;
            }
            return this.getCurrentPicker().pickSubchannel(args).getSubchannel();
        }

        public ConnectivityState getCurrentState() {
            return this.currentState;
        }

        public LoadBalancer.SubchannelPicker getCurrentPicker() {
            return this.currentPicker;
        }

        public EquivalentAddressGroup getEag() {
            if (this.resolvedAddresses == null || this.resolvedAddresses.getAddresses().isEmpty()) {
                return null;
            }
            return this.resolvedAddresses.getAddresses().get(0);
        }

        public boolean isDeactivated() {
            return this.deactivated;
        }

        protected void setDeactivated() {
            this.deactivated = true;
        }

        protected void markReactivated() {
            this.deactivated = false;
        }

        protected void setResolvedAddresses(LoadBalancer.ResolvedAddresses newAddresses) {
            Preconditions.checkNotNull(newAddresses, "Missing address list for child");
            this.resolvedAddresses = newAddresses;
        }

        protected void deactivate() {
            if (this.deactivated) {
                return;
            }
            MultiChildLoadBalancer.this.childLbStates.remove(this.key);
            this.deactivated = true;
            logger.log(Level.FINE, "Child balancer {0} deactivated", this.key);
        }

        protected void reactivate(LoadBalancerProvider policyProvider) {
            this.deactivated = false;
        }

        protected void shutdown() {
            this.lb.shutdown();
            this.currentState = ConnectivityState.SHUTDOWN;
            logger.log(Level.FINE, "Child balancer {0} deleted", this.key);
        }

        protected LoadBalancer.ResolvedAddresses getResolvedAddresses() {
            return this.resolvedAddresses;
        }

        private final class ChildLbStateHelper
        extends ForwardingLoadBalancerHelper {
            private ChildLbStateHelper() {
            }

            @Override
            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                if (!MultiChildLoadBalancer.this.childLbStates.containsKey(ChildLbState.this.key)) {
                    return;
                }
                ChildLbState.this.currentState = newState;
                ChildLbState.this.currentPicker = newPicker;
                if (!ChildLbState.this.deactivated && !MultiChildLoadBalancer.this.resolvingAddresses) {
                    if (newState == ConnectivityState.IDLE && MultiChildLoadBalancer.this.reconnectOnIdle()) {
                        ChildLbState.this.lb.requestConnection();
                    }
                    MultiChildLoadBalancer.this.updateOverallBalancingState();
                }
            }

            @Override
            protected LoadBalancer.Helper delegate() {
                return MultiChildLoadBalancer.this.helper;
            }
        }
    }
}

