/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.netty.util.concurrent;

import org.glowroot.agent.shaded.io.netty.util.concurrent.DefaultPromise;
import org.glowroot.agent.shaded.io.netty.util.concurrent.Future;
import org.glowroot.agent.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.glowroot.agent.shaded.io.netty.util.concurrent.ProgressivePromise;

public class DefaultProgressivePromise<V>
extends DefaultPromise<V>
implements ProgressivePromise<V> {
    @Override
    public boolean tryProgress(long progress, long total) {
        if (total < 0L) {
            total = -1L;
            if (progress < 0L || this.isDone()) {
                return false;
            }
        } else if (progress < 0L || progress > total || this.isDone()) {
            return false;
        }
        this.notifyProgressiveListeners(progress, total);
        return true;
    }

    @Override
    public ProgressivePromise<V> addListener(GenericFutureListener<? extends Future<? super V>> listener) {
        super.addListener((GenericFutureListener)listener);
        return this;
    }

    @Override
    public ProgressivePromise<V> removeListener(GenericFutureListener<? extends Future<? super V>> listener) {
        super.removeListener((GenericFutureListener)listener);
        return this;
    }

    @Override
    public ProgressivePromise<V> sync() throws InterruptedException {
        super.sync();
        return this;
    }

    @Override
    public ProgressivePromise<V> await() throws InterruptedException {
        super.await();
        return this;
    }

    @Override
    public ProgressivePromise<V> setSuccess(V result) {
        super.setSuccess(result);
        return this;
    }

    @Override
    public ProgressivePromise<V> setFailure(Throwable cause) {
        super.setFailure(cause);
        return this;
    }
}

