/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.netty.util.internal;

import java.util.Collection;
import java.util.Map;

public final class ObjectUtil {
    public static <T> T checkNotNull(T arg, String text) {
        if (arg == null) {
            throw new NullPointerException(text);
        }
        return arg;
    }

    public static <T> T[] deepCheckNotNull(String text, T ... varargs) {
        if (varargs == null) {
            throw new NullPointerException(text);
        }
        for (T element : varargs) {
            if (element != null) continue;
            throw new NullPointerException(text);
        }
        return varargs;
    }

    public static <T> T checkNotNullWithIAE(T arg, String paramName) throws IllegalArgumentException {
        if (arg == null) {
            throw new IllegalArgumentException("Param '" + paramName + "' must not be null");
        }
        return arg;
    }

    public static <T> T checkNotNullArrayParam(T value, int index, String name) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Array index " + index + " of parameter '" + name + "' must not be null");
        }
        return value;
    }

    public static int checkPositive(int i, String name) {
        if (i <= 0) {
            throw new IllegalArgumentException(name + " : " + i + " (expected: > 0)");
        }
        return i;
    }

    public static long checkPositive(long l, String name) {
        if (l <= 0L) {
            throw new IllegalArgumentException(name + " : " + l + " (expected: > 0)");
        }
        return l;
    }

    public static int checkPositiveOrZero(int i, String name) {
        if (i < 0) {
            throw new IllegalArgumentException(name + " : " + i + " (expected: >= 0)");
        }
        return i;
    }

    public static long checkPositiveOrZero(long l, String name) {
        if (l < 0L) {
            throw new IllegalArgumentException(name + " : " + l + " (expected: >= 0)");
        }
        return l;
    }

    public static int checkInRange(int i, int start, int end, String name) {
        if (i < start || i > end) {
            throw new IllegalArgumentException(name + ": " + i + " (expected: " + start + "-" + end + ")");
        }
        return i;
    }

    public static <T> T[] checkNonEmpty(T[] array, String name) {
        if (ObjectUtil.checkNotNull(array, name).length == 0) {
            throw new IllegalArgumentException("Param '" + name + "' must not be empty");
        }
        return array;
    }

    public static <T extends Collection<?>> T checkNonEmpty(T collection, String name) {
        if (ObjectUtil.checkNotNull(collection, name).isEmpty()) {
            throw new IllegalArgumentException("Param '" + name + "' must not be empty");
        }
        return collection;
    }

    public static String checkNonEmpty(String value, String name) {
        if (ObjectUtil.checkNotNull(value, name).isEmpty()) {
            throw new IllegalArgumentException("Param '" + name + "' must not be empty");
        }
        return value;
    }

    public static <K, V, T extends Map<K, V>> T checkNonEmpty(T value, String name) {
        if (ObjectUtil.checkNotNull(value, name).isEmpty()) {
            throw new IllegalArgumentException("Param '" + name + "' must not be empty");
        }
        return value;
    }

    public static String checkNonEmptyAfterTrim(String value, String name) {
        String trimmed = ObjectUtil.checkNotNull(value, name).trim();
        return ObjectUtil.checkNonEmpty(trimmed, name);
    }
}

