/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.config;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.common.config.GaugeConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableMBeanAttribute;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GaugeConfig", generator="Immutables")
@Immutable
public final class ImmutableGaugeConfig
extends GaugeConfig {
    private final String mbeanObjectName;
    private final ImmutableList<ImmutableMBeanAttribute> mbeanAttributes;

    private ImmutableGaugeConfig(String mbeanObjectName, ImmutableList<ImmutableMBeanAttribute> mbeanAttributes) {
        this.mbeanObjectName = mbeanObjectName;
        this.mbeanAttributes = mbeanAttributes;
    }

    @Override
    @JsonProperty(value="mbeanObjectName")
    public String mbeanObjectName() {
        return this.mbeanObjectName;
    }

    @Override
    @JsonProperty(value="mbeanAttributes")
    public ImmutableList<ImmutableMBeanAttribute> mbeanAttributes() {
        return this.mbeanAttributes;
    }

    public final ImmutableGaugeConfig withMbeanObjectName(String value) {
        String newValue = Objects.requireNonNull(value, "mbeanObjectName");
        if (this.mbeanObjectName.equals(newValue)) {
            return this;
        }
        return new ImmutableGaugeConfig(newValue, this.mbeanAttributes);
    }

    public final ImmutableGaugeConfig withMbeanAttributes(ImmutableMBeanAttribute ... elements) {
        ImmutableList<ImmutableMBeanAttribute> newValue = ImmutableList.copyOf(elements);
        return new ImmutableGaugeConfig(this.mbeanObjectName, newValue);
    }

    public final ImmutableGaugeConfig withMbeanAttributes(Iterable<? extends ImmutableMBeanAttribute> elements) {
        if (this.mbeanAttributes == elements) {
            return this;
        }
        ImmutableList<ImmutableMBeanAttribute> newValue = ImmutableList.copyOf(elements);
        return new ImmutableGaugeConfig(this.mbeanObjectName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGaugeConfig && this.equalTo(0, (ImmutableGaugeConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableGaugeConfig another) {
        return this.mbeanObjectName.equals(another.mbeanObjectName) && this.mbeanAttributes.equals(another.mbeanAttributes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.mbeanObjectName.hashCode();
        h += (h << 5) + this.mbeanAttributes.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("GaugeConfig").omitNullValues().add("mbeanObjectName", this.mbeanObjectName).add("mbeanAttributes", this.mbeanAttributes).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGaugeConfig fromJson(Json json) {
        Builder builder = ImmutableGaugeConfig.builder();
        if (json.mbeanObjectName != null) {
            builder.mbeanObjectName(json.mbeanObjectName);
        }
        if (json.mbeanAttributes != null) {
            builder.addAllMbeanAttributes(json.mbeanAttributes);
        }
        return builder.build();
    }

    public static ImmutableGaugeConfig copyOf(GaugeConfig instance) {
        if (instance instanceof ImmutableGaugeConfig) {
            return (ImmutableGaugeConfig)instance;
        }
        return ImmutableGaugeConfig.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GaugeConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MBEAN_OBJECT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String mbeanObjectName;
        private ImmutableList.Builder<ImmutableMBeanAttribute> mbeanAttributes = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(GaugeConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.mbeanObjectName(instance.mbeanObjectName());
            this.addAllMbeanAttributes(instance.mbeanAttributes());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mbeanObjectName(String mbeanObjectName) {
            this.mbeanObjectName = Objects.requireNonNull(mbeanObjectName, "mbeanObjectName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMbeanAttributes(ImmutableMBeanAttribute element) {
            this.mbeanAttributes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMbeanAttributes(ImmutableMBeanAttribute ... elements) {
            this.mbeanAttributes.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mbeanAttributes(Iterable<? extends ImmutableMBeanAttribute> elements) {
            this.mbeanAttributes = ImmutableList.builder();
            return this.addAllMbeanAttributes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMbeanAttributes(Iterable<? extends ImmutableMBeanAttribute> elements) {
            this.mbeanAttributes.addAll(elements);
            return this;
        }

        public ImmutableGaugeConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGaugeConfig(this.mbeanObjectName, (ImmutableList)this.mbeanAttributes.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("mbeanObjectName");
            }
            return "Cannot build GaugeConfig, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GaugeConfig", generator="Immutables")
    static final class Json
    extends GaugeConfig {
        @Nullable
        String mbeanObjectName;
        @Nullable
        ImmutableList<ImmutableMBeanAttribute> mbeanAttributes = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="mbeanObjectName")
        public void setMbeanObjectName(String mbeanObjectName) {
            this.mbeanObjectName = mbeanObjectName;
        }

        @JsonProperty(value="mbeanAttributes")
        public void setMbeanAttributes(ImmutableList<ImmutableMBeanAttribute> mbeanAttributes) {
            this.mbeanAttributes = mbeanAttributes;
        }

        @Override
        public String mbeanObjectName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<ImmutableMBeanAttribute> mbeanAttributes() {
            throw new UnsupportedOperationException();
        }
    }
}

