/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.model;

import org.glowroot.agent.shaded.org.glowroot.common.model.ImmutableOverallSummary;
import org.immutables.value.Value;

public class OverallSummaryCollector {
    private double totalDurationNanos;
    private double totalCpuNanos;
    private double totalAllocatedBytes;
    private long transactionCount;
    private long lastCaptureTime;

    public long getLastCaptureTime() {
        return this.lastCaptureTime;
    }

    public OverallSummary getOverallSummary() {
        return ImmutableOverallSummary.builder().totalDurationNanos(this.totalDurationNanos).totalCpuNanos(this.totalCpuNanos).totalAllocatedBytes(this.totalAllocatedBytes).transactionCount(this.transactionCount).build();
    }

    public void mergeSummary(double totalDurationNanos, double totalCpuNanos, double totalAllocatedBytes, long transactionCount, long captureTime) {
        this.totalDurationNanos += totalDurationNanos;
        this.totalCpuNanos += totalCpuNanos;
        this.totalAllocatedBytes += totalAllocatedBytes;
        this.transactionCount += transactionCount;
        this.lastCaptureTime = Math.max(this.lastCaptureTime, captureTime);
    }

    @Value.Immutable
    public static interface OverallSummary {
        public double totalDurationNanos();

        public double totalCpuNanos();

        public double totalAllocatedBytes();

        public long transactionCount();
    }
}

