/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.util;

import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JavaVersion {
    private static final boolean IS_JAVA_6;
    private static final boolean IS_GREATER_THAN_OR_EQUAL_TO_JAVA_8;
    private static final boolean IS_GREATER_THAN_OR_EQUAL_TO_JAVA_9;
    private static final boolean IS_GREATER_THAN_OR_EQUAL_TO_JAVA_10;
    private static final boolean J9_JVM;
    private static final boolean JROCKIT_JVM;
    private static final boolean OSX;

    private JavaVersion() {
    }

    public static boolean isJava6() {
        return IS_JAVA_6;
    }

    public static boolean isGreaterThanOrEqualToJava8() {
        return IS_GREATER_THAN_OR_EQUAL_TO_JAVA_8;
    }

    public static boolean isGreaterThanOrEqualToJava9() {
        return IS_GREATER_THAN_OR_EQUAL_TO_JAVA_9;
    }

    public static boolean isGreaterThanOrEqualToJava10() {
        return IS_GREATER_THAN_OR_EQUAL_TO_JAVA_10;
    }

    public static boolean isJ9Jvm() {
        return J9_JVM;
    }

    public static boolean isJRockitJvm() {
        return JROCKIT_JVM;
    }

    public static boolean isOSX() {
        return OSX;
    }

    static boolean parseIsJava6(@Nullable String javaVersion) {
        return javaVersion != null && javaVersion.startsWith("1.6");
    }

    static boolean parseIsGreaterThanOrEqualToJava8(@Nullable String javaVersion) {
        return javaVersion != null && !javaVersion.startsWith("1.6") && !javaVersion.startsWith("1.7");
    }

    static boolean parseIsGreaterThanOrEqualToJava9(@Nullable String javaVersion) {
        return javaVersion != null && !javaVersion.startsWith("1.");
    }

    static boolean parseIsGreaterThanOrEqualToJava10(@Nullable String javaVersion) {
        return javaVersion != null && !javaVersion.startsWith("1.") && !javaVersion.startsWith("9.");
    }

    static {
        String normalizedOsName;
        String javaVersion = System.getProperty("java.version");
        IS_JAVA_6 = JavaVersion.parseIsJava6(javaVersion);
        IS_GREATER_THAN_OR_EQUAL_TO_JAVA_8 = JavaVersion.parseIsGreaterThanOrEqualToJava8(javaVersion);
        IS_GREATER_THAN_OR_EQUAL_TO_JAVA_9 = JavaVersion.parseIsGreaterThanOrEqualToJava9(javaVersion);
        IS_GREATER_THAN_OR_EQUAL_TO_JAVA_10 = JavaVersion.parseIsGreaterThanOrEqualToJava10(javaVersion);
        String javaVmName = System.getProperty("java.vm.name");
        J9_JVM = "IBM J9 VM".equals(javaVmName) || "Eclipse OpenJ9 VM".equals(javaVmName);
        JROCKIT_JVM = "Oracle JRockit(R)".equals(javaVmName);
        String osName = System.getProperty("os.name");
        OSX = osName == null ? false : (normalizedOsName = osName.toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]+", "")).startsWith("macosx") || normalizedOsName.startsWith("osx");
    }
}

