/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.com.google.common.cache.CacheBuilder;
import org.glowroot.agent.shaded.com.google.common.cache.CacheLoader;
import org.glowroot.agent.shaded.com.google.common.cache.LoadingCache;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.MapMaker;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.Reflections;
import org.glowroot.agent.weaving.Accessor;

public class Beans {
    private static final Logger logger = LoggerFactory.getLogger(Beans.class);
    private static final Accessor SENTINEL_ACCESSOR;
    private static final LoadingCache<Class<?>, ConcurrentMap<String, Accessor>> getters;

    private Beans() {
    }

    public static @Nullable Object value(@Nullable Object obj, List<String> path) throws Exception {
        return Beans.value(obj, path, 0);
    }

    private static @Nullable Object value(@Nullable Object obj, List<String> path, int currIndex) throws Exception {
        if (obj == null) {
            return null;
        }
        if (currIndex == path.size()) {
            return obj;
        }
        String curr = path.get(currIndex);
        if (obj instanceof Map) {
            if (curr.equals("size")) {
                return ((Map)obj).size();
            }
            return Beans.value(((Map)obj).get(curr), path, currIndex + 1);
        }
        if (obj instanceof List) {
            if (curr.equals("size")) {
                return ((List)obj).size();
            }
            ArrayList<Object> values = Lists.newArrayList();
            for (Object val : (List)obj) {
                values.add(Beans.value(val, path, currIndex));
            }
            return values;
        }
        Accessor accessor = Beans.getAccessor(obj.getClass(), curr);
        if (accessor.equals(SENTINEL_ACCESSOR)) {
            return null;
        }
        Object currItem = accessor.evaluate(obj);
        return Beans.value(currItem, path, currIndex + 1);
    }

    private static Accessor getAccessor(Class<?> clazz, String name) {
        ConcurrentMap<String, Accessor> accessorsForType = getters.getUnchecked(clazz);
        Accessor accessor = (Accessor)accessorsForType.get(name);
        if (accessor == null) {
            accessor = Beans.loadPossiblyArrayBasedAccessor(clazz, name);
            if (accessor == null) {
                accessor = SENTINEL_ACCESSOR;
            }
            accessorsForType.put(name, accessor);
        }
        return accessor;
    }

    static @Nullable Accessor loadPossiblyArrayBasedAccessor(Class<?> clazz, String name) {
        if (clazz.getComponentType() != null && name.equals("length")) {
            return Accessor.arrayLength();
        }
        Class<?> componentType = clazz;
        while (componentType.getComponentType() != null) {
            componentType = componentType.getComponentType();
        }
        return Beans.loadAccessor(componentType, name);
    }

    private static @Nullable Accessor loadAccessor(Class<?> clazz, String name) {
        String capitalizedName = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        try {
            Method method = Reflections.getAnyMethod(clazz, "get" + capitalizedName, new Class[0]);
            return Accessor.fromMethod(method);
        }
        catch (Exception e) {
            logger.trace(e.getMessage(), e);
            try {
                Method method = Reflections.getAnyMethod(clazz, "is" + capitalizedName, new Class[0]);
                return Accessor.fromMethod(method);
            }
            catch (Exception f) {
                logger.trace(f.getMessage(), f);
                try {
                    Method method = Reflections.getAnyMethod(clazz, name, new Class[0]);
                    return Accessor.fromMethod(method);
                }
                catch (Exception g) {
                    logger.trace(g.getMessage(), g);
                    try {
                        Field field = Reflections.getAnyField(clazz, name);
                        return Accessor.fromField(field);
                    }
                    catch (Exception h) {
                        logger.trace(h.getMessage(), h);
                        logger.debug("no accessor found for {} in class {}", (Object)name, (Object)clazz.getName());
                        return null;
                    }
                }
            }
        }
    }

    private static void sentinelMethod() {
    }

    static {
        try {
            SENTINEL_ACCESSOR = Accessor.fromMethod(Beans.class.getDeclaredMethod("sentinelMethod", new Class[0]));
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        getters = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, ConcurrentMap<String, Accessor>>(){

            @Override
            public ConcurrentMap<String, Accessor> load(Class<?> clazz) {
                return new MapMaker().weakValues().makeMap();
            }
        });
    }
}

