/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.weaving.AnalyzedWorld;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AnalyzedWorld.ParseContext", generator="Immutables")
@Immutable
final class ImmutableParseContext
extends AnalyzedWorld.ParseContext {
    private final String className;
    private final @org.checkerframework.checker.nullness.qual.Nullable CodeSource codeSource;

    private ImmutableParseContext(String className, @org.checkerframework.checker.nullness.qual.Nullable CodeSource codeSource) {
        this.className = Objects.requireNonNull(className, "className");
        this.codeSource = codeSource;
    }

    private ImmutableParseContext(ImmutableParseContext original, String className, @org.checkerframework.checker.nullness.qual.Nullable CodeSource codeSource) {
        this.className = className;
        this.codeSource = codeSource;
    }

    @Override
    @JsonProperty(value="className")
    String className() {
        return this.className;
    }

    @Override
    @JsonProperty(value="codeSource")
    @org.checkerframework.checker.nullness.qual.Nullable CodeSource codeSource() {
        return this.codeSource;
    }

    public final ImmutableParseContext withClassName(String value) {
        String newValue = Objects.requireNonNull(value, "className");
        if (this.className.equals(newValue)) {
            return this;
        }
        return new ImmutableParseContext(this, newValue, this.codeSource);
    }

    public final ImmutableParseContext withCodeSource(@org.checkerframework.checker.nullness.qual.Nullable CodeSource value) {
        if (this.codeSource == value) {
            return this;
        }
        return new ImmutableParseContext(this, this.className, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableParseContext && this.equalTo(0, (ImmutableParseContext)another);
    }

    private boolean equalTo(int synthetic, ImmutableParseContext another) {
        return this.className.equals(another.className) && Objects.equals(this.codeSource, another.codeSource);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.className.hashCode();
        h += (h << 5) + Objects.hashCode(this.codeSource);
        return h;
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableParseContext fromJson(Json json) {
        Builder builder = ImmutableParseContext.builder();
        if (json.className != null) {
            builder.className(json.className);
        }
        if (json.codeSource != null) {
            builder.codeSource(json.codeSource);
        }
        return builder.build();
    }

    public static ImmutableParseContext of(String className, @org.checkerframework.checker.nullness.qual.Nullable CodeSource codeSource) {
        return new ImmutableParseContext(className, codeSource);
    }

    public static ImmutableParseContext copyOf(AnalyzedWorld.ParseContext instance) {
        if (instance instanceof ImmutableParseContext) {
            return (ImmutableParseContext)instance;
        }
        return ImmutableParseContext.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AnalyzedWorld.ParseContext", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CLASS_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String className;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable CodeSource codeSource;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(AnalyzedWorld.ParseContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.className(instance.className());
            @org.checkerframework.checker.nullness.qual.Nullable CodeSource codeSourceValue = instance.codeSource();
            if (codeSourceValue != null) {
                this.codeSource(codeSourceValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder className(String className) {
            this.className = Objects.requireNonNull(className, "className");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder codeSource(@org.checkerframework.checker.nullness.qual.Nullable CodeSource codeSource) {
            this.codeSource = codeSource;
            return this;
        }

        public ImmutableParseContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableParseContext(null, this.className, this.codeSource);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("className");
            }
            return "Cannot build ParseContext, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AnalyzedWorld.ParseContext", generator="Immutables")
    static final class Json
    extends AnalyzedWorld.ParseContext {
        @Nullable
        String className;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable CodeSource codeSource;

        Json() {
        }

        @JsonProperty(value="className")
        public void setClassName(String className) {
            this.className = className;
        }

        @JsonProperty(value="codeSource")
        public void setCodeSource(@org.checkerframework.checker.nullness.qual.Nullable CodeSource codeSource) {
            this.codeSource = codeSource;
        }

        @Override
        String className() {
            throw new UnsupportedOperationException();
        }

        @Override
        @org.checkerframework.checker.nullness.qual.Nullable CodeSource codeSource() {
            throw new UnsupportedOperationException();
        }
    }
}

