/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.lang.reflect.Method;
import org.glowroot.agent.plugin.api.weaving.Shim;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.weaving.ImmutableShimType;
import org.immutables.value.Value;

@Value.Immutable
abstract class ShimType {
    ShimType() {
    }

    static ShimType create(Shim shim, Class<?> iface) {
        ImmutableShimType.Builder builder = ImmutableShimType.builder();
        builder.addTargets(shim.value());
        builder.iface(Type.getType(iface));
        for (Method method : iface.getMethods()) {
            if (!method.isAnnotationPresent(Shim.class)) continue;
            builder.addShimMethods(method);
        }
        return builder.build();
    }

    abstract Type iface();

    abstract ImmutableList<String> targets();

    abstract ImmutableList<Method> shimMethods();
}

