/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.io.File;
import java.io.IOException;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.security.CodeSource;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.config.ConfigService;
import org.glowroot.agent.impl.ThreadContextImpl;
import org.glowroot.agent.impl.TimerImpl;
import org.glowroot.agent.impl.TimerNameCache;
import org.glowroot.agent.impl.TransactionRegistry;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.config.ConfigListener;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.shaded.com.google.common.base.StandardSystemProperty;
import org.glowroot.agent.shaded.com.google.common.base.Supplier;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.com.google.common.io.Files;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.org.glowroot.common.util.ScheduledRunnable;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassReader;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassWriter;
import org.glowroot.agent.shaded.org.objectweb.asm.Label;
import org.glowroot.agent.shaded.org.objectweb.asm.MethodVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.shaded.org.objectweb.asm.commons.AdviceAdapter;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.IterableWithSelfRemovableEntries;
import org.glowroot.agent.weaving.Advice;
import org.glowroot.agent.weaving.AnalyzedWorld;
import org.glowroot.agent.weaving.ClassAnalyzer;
import org.glowroot.agent.weaving.ClassLoaders;
import org.glowroot.agent.weaving.ClassNames;
import org.glowroot.agent.weaving.JSRInlinerClassVisitor;
import org.glowroot.agent.weaving.MixinType;
import org.glowroot.agent.weaving.PointcutClassVisitor;
import org.glowroot.agent.weaving.ShimType;
import org.glowroot.agent.weaving.ThinClassVisitor;
import org.glowroot.agent.weaving.WeavingClassVisitor;

public class Weaver {
    private static final Logger logger = LoggerFactory.getLogger(Weaver.class);
    private static final @Nullable String DEBUG_CLASS_NAME;
    private final Supplier<List<Advice>> advisors;
    private final ImmutableList<ShimType> shimTypes;
    private final ImmutableList<MixinType> mixinTypes;
    private final AnalyzedWorld analyzedWorld;
    private final TransactionRegistry transactionRegistry;
    private final Ticker ticker;
    private final TimerName timerName;
    private volatile boolean weavingTimerEnabled;
    private volatile boolean noLongerNeedToWeaveMainMethods;
    private volatile boolean weavingDisabledForLoggingDeadlock;
    private final IterableWithSelfRemovableEntries<ActiveWeaving> activeWeavings = new IterableWithSelfRemovableEntries();

    public Weaver(Supplier<List<Advice>> advisors, List<ShimType> shimTypes, List<MixinType> mixinTypes, AnalyzedWorld analyzedWorld, TransactionRegistry transactionRegistry, Ticker ticker, TimerNameCache timerNameCache, final ConfigService configService) {
        this.advisors = advisors;
        this.shimTypes = ImmutableList.copyOf(shimTypes);
        this.mixinTypes = ImmutableList.copyOf(mixinTypes);
        this.analyzedWorld = analyzedWorld;
        this.transactionRegistry = transactionRegistry;
        this.ticker = ticker;
        configService.addConfigListener(new ConfigListener(){

            @Override
            public void onChange() {
                Weaver.this.weavingTimerEnabled = configService.getAdvancedConfig().weavingTimer();
            }
        });
        this.timerName = timerNameCache.getTimerName(OnlyForTheTimerName.class);
    }

    public void setNoLongerNeedToWeaveMainMethods() {
        this.noLongerNeedToWeaveMainMethods = true;
    }

    public void checkForDeadlockedActiveWeaving() {
        long currTick = this.ticker.read();
        ArrayList<Long> threadIds = Lists.newArrayList();
        for (ActiveWeaving activeWeaving : this.activeWeavings) {
            if (TimeUnit.NANOSECONDS.toSeconds(currTick - activeWeaving.startTick) <= 5L) continue;
            threadIds.add(activeWeaving.threadId);
        }
        if (!threadIds.isEmpty()) {
            this.checkForDeadlockedActiveWeaving(threadIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] weave(byte[] classBytes, String className, @Nullable Class<?> classBeingRedefined, @Nullable CodeSource codeSource, @Nullable ClassLoader loader) {
        if (this.weavingDisabledForLoggingDeadlock) {
            return null;
        }
        long startTick = this.ticker.read();
        TimerImpl weavingTimer = this.startWeavingTimer(startTick);
        IterableWithSelfRemovableEntries.SelfRemovableEntry activeWeavingEntry = this.activeWeavings.add(new ActiveWeaving(Thread.currentThread().getId(), startTick));
        try {
            logger.trace("transform(): className={}", (Object)className);
            byte[] transformedBytes = this.weaveUnderTimer(classBytes, className, classBeingRedefined, codeSource, loader);
            if (transformedBytes != null) {
                logger.debug("transform(): transformed {}", (Object)className);
            }
            byte[] byArray = transformedBytes;
            return byArray;
        }
        finally {
            activeWeavingEntry.remove();
            if (weavingTimer != null) {
                weavingTimer.stop();
            }
        }
    }

    private @Nullable TimerImpl startWeavingTimer(long startTick) {
        if (!this.weavingTimerEnabled) {
            return null;
        }
        ThreadContextImpl threadContext = (ThreadContextImpl)this.transactionRegistry.getCurrentThreadContextHolder().get();
        if (threadContext == null) {
            return null;
        }
        TimerImpl currentTimer = threadContext.getCurrentTimer();
        if (currentTimer == null) {
            return null;
        }
        return currentTimer.startNestedTimer(this.timerName, startTick);
    }

    private byte[] weaveUnderTimer(byte[] classBytes, String className, @Nullable Class<?> classBeingRedefined, @Nullable CodeSource codeSource, @Nullable ClassLoader loader) {
        byte[] transformedBytes;
        ClassReader cr;
        ClassVisitor cv;
        ClassWriter cw;
        List<Advice> advisors = AnalyzedWorld.mergeInstrumentationAnnotations(this.advisors.get(), classBytes, loader, className);
        ThinClassVisitor accv = new ThinClassVisitor();
        new ClassReader(classBytes).accept(accv, 5);
        boolean frames = accv.getMajorVersion() >= 50;
        int parsingOptions = frames ? 8 : 4;
        byte[] maybeProcessedBytes = null;
        if (accv.isConstructorPointcut()) {
            cw = new ClassWriter(1);
            cv = new PointcutClassVisitor(cw);
            cr = new ClassReader(classBytes);
            cr.accept(new JSRInlinerClassVisitor(cv), parsingOptions);
            maybeProcessedBytes = cw.toByteArray();
        } else if (className.equals("org/jboss/weld/util/Decorators")) {
            cw = new ClassWriter(1);
            cv = new JBossWeldHackClassVisitor(cw);
            cr = new ClassReader(classBytes);
            cr.accept(new JSRInlinerClassVisitor(cv), parsingOptions);
            maybeProcessedBytes = cw.toByteArray();
        } else if (className.equals("org/jboss/net/protocol/URLStreamHandlerFactory")) {
            cw = new ClassWriter(1);
            cv = new JBossUrlHackClassVisitor(cw);
            cr = new ClassReader(classBytes);
            cr.accept(new JSRInlinerClassVisitor(cv), parsingOptions);
            maybeProcessedBytes = cw.toByteArray();
        } else if (className.equals("java/lang/ClassLoader")) {
            cw = new ClassWriter(1);
            cv = new ClassLoaderHackClassVisitor(cw);
            cr = new ClassReader(classBytes);
            cr.accept(new JSRInlinerClassVisitor(cv), parsingOptions);
            maybeProcessedBytes = cw.toByteArray();
        }
        ClassAnalyzer classAnalyzer = new ClassAnalyzer(accv.getThinClass(), advisors, this.shimTypes, this.mixinTypes, loader, this.analyzedWorld, codeSource, classBytes, classBeingRedefined, this.noLongerNeedToWeaveMainMethods);
        try {
            classAnalyzer.analyzeMethods();
        }
        catch (ClassNotFoundException e) {
            logger.error("error analyzing {}: {}", className, e.getMessage(), e);
            return null;
        }
        catch (IOException e) {
            logger.error("error analyzing {}: {}", className, e.getMessage(), e);
            return null;
        }
        if (!classAnalyzer.isWeavingRequired()) {
            this.analyzedWorld.add(classAnalyzer.getAnalyzedClass(), loader);
            return maybeProcessedBytes;
        }
        AbstractCollection matchedShimTypes = classAnalyzer.getMatchedShimTypes();
        List<MixinType> reweavableMatchedMixinTypes = classAnalyzer.getMatchedReweavableMixinTypes();
        if (!(classBeingRedefined == null || matchedShimTypes.isEmpty() && reweavableMatchedMixinTypes.isEmpty())) {
            HashSet<String> interfaceNames = Sets.newHashSet();
            for (Class<?> iface : classBeingRedefined.getInterfaces()) {
                interfaceNames.add(iface.getName());
            }
            matchedShimTypes = Lists.newArrayList(matchedShimTypes);
            for (ShimType matchedShimType : matchedShimTypes) {
                if (interfaceNames.contains(matchedShimType.iface().getClassName())) continue;
                logger.error("not reweaving {} because cannot add shim type: {}", (Object)ClassNames.fromInternalName(className), (Object)matchedShimType.iface().getClassName());
                return null;
            }
            for (MixinType matchedMixinType : reweavableMatchedMixinTypes) {
                for (Type mixinInterface : matchedMixinType.interfaces()) {
                    if (interfaceNames.contains(mixinInterface.getClassName())) continue;
                    logger.error("not reweaving {} because cannot add mixin type: {}", (Object)ClassNames.fromInternalName(className), (Object)mixinInterface.getClassName());
                    return null;
                }
            }
        }
        ClassWriter cw2 = new ClassWriter(1);
        WeavingClassVisitor cv2 = new WeavingClassVisitor(cw2, loader, frames, this.noLongerNeedToWeaveMainMethods, classAnalyzer.getAnalyzedClass(), classAnalyzer.isClassLoader(), classAnalyzer.getMethodsThatOnlyNowFulfillAdvice(), (List<ShimType>)((Object)matchedShimTypes), reweavableMatchedMixinTypes, classAnalyzer.getMethodAdvisors(), this.analyzedWorld);
        ClassReader cr2 = new ClassReader(maybeProcessedBytes == null ? classBytes : maybeProcessedBytes);
        try {
            cr2.accept(new JSRInlinerClassVisitor(cv2), parsingOptions);
            transformedBytes = cw2.toByteArray();
        }
        catch (RuntimeException e) {
            logger.error("unable to weave {}: {}", className, e.getMessage(), e);
            try {
                File tempFile = Weaver.getTempFile(className, "glowroot-weaving-error-", ".class");
                Files.write(classBytes, tempFile);
                logger.error("wrote bytecode to: {}", (Object)tempFile.getAbsolutePath());
            }
            catch (IOException f) {
                logger.error(f.getMessage(), f);
            }
            return null;
        }
        if (className.equals(DEBUG_CLASS_NAME)) {
            try {
                File tempFile = File.createTempFile("glowroot-transformed-", ".class");
                Files.write(transformedBytes, tempFile);
                logger.info("class file for {} (transformed) written to: {}", (Object)className, (Object)tempFile.getAbsolutePath());
                tempFile = File.createTempFile("glowroot-original-", ".class");
                Files.write(classBytes, tempFile);
                logger.info("class file for {} (original) written to: {}", (Object)className, (Object)tempFile.getAbsolutePath());
            }
            catch (IOException e) {
                logger.warn(e.getMessage(), e);
            }
        }
        if (loader != null) {
            try {
                for (Advice usedAdvice : cv2.getUsedAdvisors()) {
                    ClassLoaders.LazyDefinedClass nonBootstrapLoaderAdviceClass = usedAdvice.nonBootstrapLoaderAdviceClass();
                    if (nonBootstrapLoaderAdviceClass == null) continue;
                    ClassLoaders.defineClassIfNotExists(nonBootstrapLoaderAdviceClass, loader);
                }
            }
            catch (Exception e) {
                logger.error("unable to weave {}: {}", className, e.getMessage(), e);
                return null;
            }
        }
        return transformedBytes;
    }

    private void checkForDeadlockedActiveWeaving(List<Long> activeWeavingThreadIds) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        long[] deadlockedThreadIds = threadBean.findDeadlockedThreads();
        if (deadlockedThreadIds == null || Collections.disjoint(Longs.asList(deadlockedThreadIds), activeWeavingThreadIds)) {
            return;
        }
        this.weavingDisabledForLoggingDeadlock = true;
        try {
            @Nullable ThreadInfo[] threadInfos = threadBean.getThreadInfo(deadlockedThreadIds, threadBean.isObjectMonitorUsageSupported(), false);
            StringBuilder sb = new StringBuilder();
            for (ThreadInfo threadInfo : threadInfos) {
                if (threadInfo == null) continue;
                sb.append('\n');
                Weaver.appendThreadInfo(sb, threadInfo);
            }
            logger.error("deadlock detected in class weaving, please report to the Glowroot project:\n{}", (Object)sb);
            throw new ScheduledRunnable.TerminateSubsequentExecutionsException();
        }
        catch (Throwable throwable) {
            this.weavingDisabledForLoggingDeadlock = false;
            throw throwable;
        }
    }

    private static File getTempFile(String className, String prefix, String suffix) {
        String tmpDirProperty = StandardSystemProperty.JAVA_IO_TMPDIR.value();
        File tmpDir = tmpDirProperty == null ? new File(".") : new File(tmpDirProperty);
        int index = className.lastIndexOf(47);
        String simpleName = index == -1 ? className : className.substring(index + 1);
        return new File(tmpDir, prefix + simpleName + suffix);
    }

    private static void appendThreadInfo(StringBuilder sb, ThreadInfo threadInfo) {
        sb.append('\"');
        sb.append(threadInfo.getThreadName());
        sb.append("\" #");
        sb.append(threadInfo.getThreadId());
        sb.append("\n   java.lang.Thread.State: ");
        sb.append(threadInfo.getThreadState().name());
        sb.append('\n');
        LockInfo lockInfo = threadInfo.getLockInfo();
        StackTraceElement[] stackTrace = threadInfo.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            sb.append("        ");
            sb.append(stackTraceElement);
            sb.append('\n');
            if (i == 0 && lockInfo != null) {
                Thread.State threadState = threadInfo.getThreadState();
                switch (threadState) {
                    case BLOCKED: {
                        sb.append("        -  blocked on ");
                        sb.append(lockInfo);
                        sb.append('\n');
                        break;
                    }
                    case WAITING: 
                    case TIMED_WAITING: {
                        sb.append("        -  waiting on ");
                        sb.append(lockInfo);
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (MonitorInfo monitorInfo : threadInfo.getLockedMonitors()) {
                if (monitorInfo.getLockedStackDepth() != i) continue;
                sb.append("        -  locked ");
                sb.append(monitorInfo);
                sb.append('\n');
            }
        }
    }

    static {
        String debugClassName = System.getProperty("glowroot.debug.className");
        DEBUG_CLASS_NAME = debugClassName == null ? null : ClassNames.toInternalName(debugClassName);
    }

    @Pointcut(className="", methodName="", methodParameterTypes={}, timerName="glowroot weaving")
    private static class OnlyForTheTimerName {
        private OnlyForTheTimerName() {
        }
    }

    private static class ClassLoaderHackMethodVisitor
    extends AdviceAdapter {
        private ClassLoaderHackMethodVisitor(MethodVisitor mv, int access, String name, String descriptor) {
            super(589824, mv, access, name, descriptor);
        }

        @Override
        protected void onMethodEnter() {
            this.visitVarInsn(25, 0);
            this.visitVarInsn(25, 1);
            this.visitMethodInsn(184, "org/glowroot/agent/bytecode/api/Bytecode", "preloadSomeSuperTypes", "(Ljava/lang/ClassLoader;Ljava/lang/String;)V", false);
        }
    }

    private static class ClassLoaderHackClassVisitor
    extends ClassVisitor {
        private final ClassWriter cw;

        private ClassLoaderHackClassVisitor(ClassWriter cw) {
            super(589824, cw);
            this.cw = cw;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String descriptor, @Nullable String signature, String[] exceptions) {
            MethodVisitor mv = this.cw.visitMethod(access, name, descriptor, signature, exceptions);
            if (name.equals("defineClass") && descriptor.equals("(Ljava/lang/String;[BIILjava/security/ProtectionDomain;)Ljava/lang/Class;")) {
                return new ClassLoaderHackMethodVisitor(mv, access, name, descriptor);
            }
            return mv;
        }
    }

    private static class JBossUrlHackMethodVisitor
    extends AdviceAdapter {
        private JBossUrlHackMethodVisitor(MethodVisitor mv, int access, String name, String descriptor) {
            super(589824, mv, access, name, descriptor);
        }

        @Override
        protected void onMethodEnter() {
            Label l0 = new Label();
            Label l1 = new Label();
            Label l2 = new Label();
            this.mv.visitTryCatchBlock(l0, l1, l2, "java/lang/Throwable");
            this.mv.visitLabel(l0);
            this.visitClassForName("org.jboss.net.protocol.file.Handler");
            this.visitClassForName("org.jboss.net.protocol.file.FileURLConnection");
            this.visitClassForName("org.jboss.net.protocol.resource.Handler");
            this.visitClassForName("org.jboss.net.protocol.resource.ResourceURLConnection");
            this.mv.visitLabel(l1);
            Label l3 = new Label();
            this.mv.visitJumpInsn(167, l3);
            this.mv.visitLabel(l2);
            if (logger.isDebugEnabled()) {
                this.mv.visitMethodInsn(182, "java/lang/Throwable", "printStackTrace", "()V", false);
            } else {
                this.mv.visitInsn(87);
            }
            this.mv.visitLabel(l3);
        }

        private void visitClassForName(String className) {
            this.mv.visitLdcInsn(className);
            this.mv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;", false);
            this.mv.visitInsn(87);
        }
    }

    private static class JBossUrlHackClassVisitor
    extends ClassVisitor {
        private final ClassWriter cw;

        private JBossUrlHackClassVisitor(ClassWriter cw) {
            super(589824, cw);
            this.cw = cw;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String descriptor, @Nullable String signature, String[] exceptions) {
            MethodVisitor mv = this.cw.visitMethod(access, name, descriptor, signature, exceptions);
            if (name.equals("<clinit>") && descriptor.equals("()V")) {
                return new JBossUrlHackMethodVisitor(mv, access, name, descriptor);
            }
            return mv;
        }
    }

    private static class JBossWeldHackMethodVisitor
    extends MethodVisitor {
        private JBossWeldHackMethodVisitor(MethodVisitor mv) {
            super(589824, mv);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean itf) {
            super.visitMethodInsn(opcode, owner, name, descriptor, itf);
            if (name.equals("getDecoratedTypes") && descriptor.equals("()Ljava/util/Set;")) {
                super.visitMethodInsn(184, "org/glowroot/agent/bytecode/api/Util", "stripGlowrootTypes", "(Ljava/util/Set;)Ljava/util/Set;", false);
            }
        }
    }

    private static class JBossWeldHackClassVisitor
    extends ClassVisitor {
        private final ClassWriter cw;

        private JBossWeldHackClassVisitor(ClassWriter cw) {
            super(589824, cw);
            this.cw = cw;
        }

        @Override
        public @Nullable MethodVisitor visitMethod(int access, String name, String descriptor, @Nullable String signature, String[] exceptions) {
            MethodVisitor mv = this.cw.visitMethod(access, name, descriptor, signature, exceptions);
            if (name.equals("checkDelegateType") && descriptor.equals("(Ljavax/enterprise/inject/spi/Decorator;)V")) {
                return new JBossWeldHackMethodVisitor(mv);
            }
            return mv;
        }
    }

    private static class ActiveWeaving {
        private final long threadId;
        private final long startTick;

        private ActiveWeaving(long threadId, long startTick) {
            this.threadId = threadId;
            this.startTick = startTick;
        }
    }
}

