/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded;

import java.io.File;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.CodeSource;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.agent.Directories;
import org.glowroot.agent.MainEntryPoint;
import org.glowroot.agent.embedded.init.EmbeddedGlowrootAgentInitFactory;
import org.glowroot.agent.embedded.shaded.org.h2.tools.Console;
import org.glowroot.agent.embedded.shaded.org.h2.tools.Recover;
import org.glowroot.agent.embedded.shaded.org.h2.tools.RunScript;
import org.glowroot.agent.embedded.shaded.org.h2.tools.Script;
import org.glowroot.agent.embedded.shaded.org.h2.tools.Shell;
import org.glowroot.agent.init.GlowrootAgentInitFactory;
import org.glowroot.agent.shaded.com.google.common.annotations.VisibleForTesting;
import org.glowroot.agent.shaded.com.google.common.base.Charsets;
import org.glowroot.agent.shaded.com.google.common.base.Joiner;
import org.glowroot.agent.shaded.com.google.common.io.Files;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

public class ToolMain {
    private static volatile @MonotonicNonNull Logger startupLogger;

    private ToolMain() {
    }

    public static void main(String[] args, Directories directories) throws Exception {
        startupLogger = LoggerFactory.getLogger((String)"org.glowroot");
        if (directories.getAgentDirLockCloseable() == null) {
            startupLogger.error("Directory in use by another jvm process, unable to obtain lock: {}", (Object)new File(directories.getTmpDir(), ".lock"));
            return;
        }
        if (!directories.hasDataDir()) {
            File glowrootJarFile = directories.getGlowrootJarFile();
            String path = glowrootJarFile == null ? "/path/to/glowroot.jar" : glowrootJarFile.getAbsolutePath();
            startupLogger.info("To run Glowroot, you need to add \"-javaagent:{}\" to your application's JVM args.", (Object)path);
            return;
        }
        if (args.length == 0) {
            MainEntryPoint.runOfflineViewer((Directories)directories, (GlowrootAgentInitFactory)new EmbeddedGlowrootAgentInitFactory());
            TimeUnit.MILLISECONDS.sleep(Long.MAX_VALUE);
            return;
        }
        String command = args[0];
        if (command.equals("h2")) {
            String subcommand = args[1];
            if (subcommand.equals("console") && args.length == 2) {
                ToolMain.console(directories.getDataDir());
                return;
            }
            if (subcommand.equals("shell") && args.length == 2) {
                ToolMain.shell(directories.getDataDir());
                return;
            }
            if (subcommand.equals("run") && args.length == 3) {
                ToolMain.run(directories.getDataDir(), args[2]);
                return;
            }
            if (subcommand.equals("recreate") && args.length == 2) {
                ToolMain.recreate(directories.getDataDir());
                return;
            }
            if (subcommand.equals("recover") && args.length == 2) {
                ToolMain.recover(directories.getDataDir());
                return;
            }
        } else if (command.equals("mask-central-data") && args.length == 1) {
            ToolMain.maskCentralData(directories.getDataDir());
            return;
        }
        startupLogger.error("unexpected args: \"{}\"", (Object)Joiner.on((String)"\", \"").join((Object[])args));
    }

    @VisibleForTesting
    static @Nullable File getGlowrootJarFile(@Nullable CodeSource codeSource) throws URISyntaxException {
        if (codeSource == null) {
            return null;
        }
        File codeSourceFile = new File(codeSource.getLocation().toURI());
        if (codeSourceFile.getName().endsWith(".jar")) {
            return codeSourceFile;
        }
        return null;
    }

    private static void console(File dataDir) throws Exception {
        System.setProperty("h2.bindAddress", "127.0.0.1");
        Console.main("-url", "jdbc:h2:" + dataDir.getPath() + File.separator + "data", "-user", "sa");
    }

    private static void shell(File dataDir) throws Exception {
        Shell.main("-url", "jdbc:h2:" + dataDir.getPath() + File.separator + "data", "-user", "sa");
    }

    private static void run(File dataDir, String sql) throws Exception {
        Shell.main("-url", "jdbc:h2:" + dataDir.getPath() + File.separator + "data", "-user", "sa", "-sql", sql);
    }

    @RequiresNonNull(value={"startupLogger"})
    private static void recreate(File dataDir) throws Exception {
        File backupFile = new File(dataDir, "backup.sql");
        if (backupFile.exists() && !backupFile.delete()) {
            startupLogger.warn("recreate failed: cannot delete existing backup.sql");
        }
        Script.main("-url", "jdbc:h2:" + dataDir.getPath() + File.separator + "data", "-user", "sa", "-script", backupFile.getPath());
        File dbFile = new File(dataDir, "data.h2.db");
        File dbBakFile = new File(dataDir, "data.h2.db.bak");
        if (dbBakFile.exists() && !dbBakFile.delete()) {
            startupLogger.warn("recreate failed, cannot delete existing file: {}", (Object)dbBakFile.getPath());
        }
        if (!dbFile.renameTo(dbBakFile)) {
            startupLogger.warn("recreate failed, cannot rename {} to {}", (Object)dbFile.getPath(), (Object)dbBakFile.getPath());
            return;
        }
        RunScript.main("-url", "jdbc:h2:" + dataDir.getPath() + File.separator + "data", "-script", backupFile.getPath());
        startupLogger.info("recreate succeeded");
        if (!dbBakFile.delete()) {
            startupLogger.info("failed to clean-up, cannot delete file: {}", (Object)dbBakFile.getPath());
        }
        if (!backupFile.delete()) {
            startupLogger.info("failed to clean-up, cannot delete file: {}", (Object)backupFile.getPath());
        }
    }

    @RequiresNonNull(value={"startupLogger"})
    private static void recover(File dataDir) throws Exception {
        File recoverFile = new File(dataDir, "data.h2.sql");
        if (recoverFile.exists() && !recoverFile.delete()) {
            startupLogger.warn("recover failed: cannot delete existing data.h2.sql");
        }
        Recover.main("-dir", dataDir.getPath(), "-db", "data");
        File dbFile = new File(dataDir, "data.h2.db");
        File dbBakFile = new File(dataDir, "data.h2.db.bak");
        if (dbBakFile.exists() && !dbBakFile.delete()) {
            startupLogger.warn("recover failed, cannot delete existing file: {}", (Object)dbBakFile.getPath());
        }
        if (!dbFile.renameTo(dbBakFile)) {
            startupLogger.warn("recover failed, cannot rename {} to {}", (Object)dbFile.getPath(), (Object)dbBakFile.getPath());
            return;
        }
        RunScript.main("-url", "jdbc:h2:" + dataDir.getPath() + File.separator + "data", "-script", recoverFile.getPath());
        startupLogger.info("recover succeeded");
        if (!dbBakFile.delete()) {
            startupLogger.info("failed to clean-up, cannot delete file: {}", (Object)dbBakFile.getPath());
        }
        if (!recoverFile.delete()) {
            startupLogger.info("failed to clean-up, cannot delete file: {}", (Object)recoverFile.getPath());
        }
    }

    @RequiresNonNull(value={"startupLogger"})
    private static void maskCentralData(File dataDir) throws Exception {
        File maskScriptFile = File.createTempFile("mask-central-data", ".sql");
        try (PrintWriter out = new PrintWriter(Files.newWriter((File)maskScriptFile, (Charset)Charsets.UTF_8));){
            out.println("update trace set headline = left(headline, position(': ', headline) + 1) || " + ToolMain.applyHash("substr(headline, position(': ', headline) + 2)") + " where transaction_type <> 'Web' and headline like '%: %';");
            out.println("update trace set headline = left(headline, position('?', headline)) || " + ToolMain.applyHash("substr(headline, position('?', headline) + 1)") + " where transaction_type = 'Web' and headline like '%?%';");
            out.println("update trace set user = " + ToolMain.applyHash("user") + " where transaction_type = 'Web' and user is not null;");
        }
        RunScript.main("-url", "jdbc:h2:" + dataDir.getPath() + File.separator + "data", "-user", "sa", "-script", maskScriptFile.getPath());
        if (!maskScriptFile.delete()) {
            startupLogger.info("failed to clean-up, cannot delete file: {}", (Object)maskScriptFile.getPath());
        }
        ToolMain.recover(dataDir);
    }

    private static String applyHash(String sql) {
        return "left(hash('sha256', stringtoutf8(" + sql + "), 100000), 40)";
    }
}

