/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.init;

import java.io.File;
import java.io.Serializable;
import java.lang.instrument.Instrumentation;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.collector.Collector;
import org.glowroot.agent.config.ConfigService;
import org.glowroot.agent.config.PluginCache;
import org.glowroot.agent.embedded.init.EmbeddedCollector;
import org.glowroot.agent.embedded.init.OfflineViewerAgentModule;
import org.glowroot.agent.embedded.init.PreInitializeStorageShutdownClasses;
import org.glowroot.agent.embedded.repo.AgentDisplayRepositoryImpl;
import org.glowroot.agent.embedded.repo.ConfigRepositoryImpl;
import org.glowroot.agent.embedded.repo.PlatformMBeanServerLifecycle;
import org.glowroot.agent.embedded.repo.SimpleRepoModule;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableRoleConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.RoleConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ActiveAgentRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ImmutableAgentRollup;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ImmutableTopLevelAgentRollup;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.CreateUiModuleBuilder;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.SessionMapFactory;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.UiModule;
import org.glowroot.agent.embedded.sql.SQLException;
import org.glowroot.agent.embedded.util.DataSource;
import org.glowroot.agent.impl.BytecodeServiceImpl;
import org.glowroot.agent.init.AgentModule;
import org.glowroot.agent.init.CollectorProxy;
import org.glowroot.agent.init.EnvironmentCreator;
import org.glowroot.agent.init.JRebelWorkaround;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Stopwatch;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.org.glowroot.common.config.JvmConfig;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveAggregateRepository;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveJvmService;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveTraceRepository;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveWeavingService;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.glowroot.common.util.Versions;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.LazyPlatformMBeanServer;
import org.glowroot.agent.util.ThreadFactories;

class EmbeddedAgentModule {
    private static final Logger startupLogger = LoggerFactory.getLogger((String)"org.glowroot");
    private static final @Nullable Integer WEB_PORT_OVERRIDE = Integer.getInteger("glowroot.agent.port");
    private final File logDir;
    private final List<File> confDirs;
    private final Ticker ticker;
    private final Clock clock;
    private final PluginCache pluginCache;
    private final @Nullable AgentModule agentModule;
    private final @Nullable OfflineViewerAgentModule offlineViewerAgentModule;
    private final String version;
    private volatile @MonotonicNonNull ScheduledExecutorService backgroundExecutor;
    private volatile @MonotonicNonNull SimpleRepoModule simpleRepoModule;
    private volatile @MonotonicNonNull UiModule uiModule;
    private final CountDownLatch simpleRepoModuleInit = new CountDownLatch(1);

    EmbeddedAgentModule(@Nullable File pluginsDir, List<File> confDirs, boolean configReadOnly, File logDir, File tmpDir, @Nullable Instrumentation instrumentation, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable PreCheckLoadedClasses.PreCheckClassFileTransformer preCheckClassFileTransformer, @Nullable File glowrootJarFile, String glowrootVersion, boolean offlineViewer) throws Exception {
        this.ticker = Ticker.systemTicker();
        this.clock = Clock.systemClock();
        JRebelWorkaround.perform();
        this.pluginCache = PluginCache.create((File)pluginsDir, (boolean)false);
        if (offlineViewer) {
            this.agentModule = null;
            this.offlineViewerAgentModule = new OfflineViewerAgentModule(pluginsDir, confDirs, configReadOnly);
        } else {
            ConfigService configService = ConfigService.create(confDirs, (boolean)configReadOnly, (List)this.pluginCache.pluginDescriptors());
            this.agentModule = new AgentModule(this.clock, null, this.pluginCache, configService, instrumentation, glowrootJarFile, tmpDir, preCheckClassFileTransformer);
            this.offlineViewerAgentModule = null;
        }
        this.confDirs = confDirs;
        this.logDir = logDir;
        this.version = glowrootVersion;
    }

    void setOnEnteringMain(BytecodeServiceImpl.OnEnteringMain onEnteringMain) {
        Preconditions.checkNotNull((Object)this.agentModule);
        this.agentModule.setOnEnteringMain(onEnteringMain);
    }

    void onEnteringMain(final List<File> confDirs, boolean configReadOnly, final File dataDir, @Nullable File glowrootJarFile, Map<String, String> properties, @Nullable Instrumentation instrumentation, final @Nullable Class<? extends Collector> collectorProxyClass, final String glowrootVersion, @Nullable String mainClass) throws Exception {
        PreInitializeStorageShutdownClasses.preInitializeClasses();
        final boolean h2MemDb = Boolean.parseBoolean(properties.get("glowroot.internal.h2.memdb"));
        if (this.agentModule == null) {
            Preconditions.checkNotNull((Object)this.offlineViewerAgentModule);
            ConfigRepositoryImpl configRepository = new ConfigRepositoryImpl(confDirs, configReadOnly, WEB_PORT_OVERRIDE, this.offlineViewerAgentModule.getConfigService(), this.pluginCache);
            DataSource dataSource = EmbeddedAgentModule.createDataSource(h2MemDb, dataDir);
            this.simpleRepoModule = new SimpleRepoModule(dataSource, dataDir, this.clock, this.ticker, configRepository, null);
            this.simpleRepoModuleInit.countDown();
        } else {
            this.backgroundExecutor = Executors.newScheduledThreadPool(2, ThreadFactories.create((String)"Glowroot-Background-%d"));
            final CollectorProxy collectorProxy = new CollectorProxy();
            this.agentModule.onEnteringMain(this.backgroundExecutor, (Collector)collectorProxy, instrumentation, glowrootJarFile, mainClass);
            final ConfigRepositoryImpl configRepository = new ConfigRepositoryImpl(confDirs, configReadOnly, WEB_PORT_OVERRIDE, this.agentModule.getConfigService(), this.pluginCache);
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Preconditions.checkNotNull((Object)EmbeddedAgentModule.this.agentModule);
                        DataSource dataSource = EmbeddedAgentModule.createDataSource(h2MemDb, dataDir);
                        if (EmbeddedAgentModule.needToAddAlertPermission(dataSource)) {
                            EmbeddedAgentModule.addAlertPermission(configRepository);
                        }
                        SimpleRepoModule simpleRepoModule = new SimpleRepoModule(dataSource, dataDir, EmbeddedAgentModule.this.clock, EmbeddedAgentModule.this.ticker, configRepository, EmbeddedAgentModule.this.backgroundExecutor);
                        simpleRepoModule.registerMBeans(new PlatformMBeanServerLifecycleImpl(EmbeddedAgentModule.this.agentModule.getLazyPlatformMBeanServer()));
                        EmbeddedCollector collector = new EmbeddedCollector(simpleRepoModule.getEnvironmentDao(), simpleRepoModule.getAggregateDao(), simpleRepoModule.getTraceDao(), simpleRepoModule.getGaugeValueDao(), configRepository, simpleRepoModule.getAlertingService(), simpleRepoModule.getAlertingDisabledDao(), simpleRepoModule.getHttpClient(), EmbeddedAgentModule.this.clock);
                        if (collectorProxyClass != null) {
                            startupLogger.info("using collector proxy: {}", (Object)collectorProxyClass.getName());
                            collector = (Collector)collectorProxyClass.getConstructor(Collector.class).newInstance(collector);
                        }
                        collectorProxy.setInstance((Collector)collector);
                        collector.init(confDirs, EnvironmentCreator.create((String)glowrootVersion, (JvmConfig)EmbeddedAgentModule.this.agentModule.getConfigService().getJvmConfig()), AgentConfigOuterClass.AgentConfig.getDefaultInstance(), new Collector.AgentConfigUpdater(){

                            public void update(AgentConfigOuterClass.AgentConfig agentConfig) {
                            }
                        });
                        EmbeddedAgentModule.this.simpleRepoModule = simpleRepoModule;
                    }
                    catch (Throwable t) {
                        startupLogger.error("Glowroot cannot start: {}", (Object)t.getMessage(), (Object)t);
                    }
                    finally {
                        EmbeddedAgentModule.this.simpleRepoModuleInit.countDown();
                    }
                }
            });
            thread.setName("Glowroot-Init-Repo");
            thread.setDaemon(true);
            thread.start();
            this.simpleRepoModuleInit.await(5L, TimeUnit.SECONDS);
        }
    }

    void initEmbeddedServer() throws Exception {
        if (this.simpleRepoModule == null) {
            return;
        }
        if (this.agentModule != null) {
            this.uiModule = new CreateUiModuleBuilder().central(false).servlet(false).offlineViewer(false).webPortReadOnly(WEB_PORT_OVERRIDE != null).confDirs(this.confDirs).logDir(this.logDir).logFileNamePattern(Pattern.compile("glowroot.*\\.log")).ticker(this.ticker).clock(this.clock).liveJvmService((LiveJvmService)this.agentModule.getLiveJvmService()).agentDisplayRepository(new AgentDisplayRepositoryImpl()).configRepository(this.simpleRepoModule.getConfigRepository()).alertingDisabledRepository(this.simpleRepoModule.getAlertingDisabledDao()).activeAgentRepository(new ActiveAgentRepositoryImpl()).environmentRepository(this.simpleRepoModule.getEnvironmentDao()).transactionTypeRepository(this.simpleRepoModule.getTransactionTypeRepository()).traceAttributeNameRepository(this.simpleRepoModule.getTraceAttributeNameRepository()).aggregateRepository(this.simpleRepoModule.getAggregateDao()).traceRepository(this.simpleRepoModule.getTraceDao()).gaugeValueRepository(this.simpleRepoModule.getGaugeValueDao()).syntheticResultRepository(null).incidentRepository(this.simpleRepoModule.getIncidentDao()).repoAdmin(this.simpleRepoModule.getRepoAdmin()).rollupLevelService(this.simpleRepoModule.getRollupLevelService()).liveTraceRepository((LiveTraceRepository)this.agentModule.getLiveTraceRepository()).liveAggregateRepository((LiveAggregateRepository)this.agentModule.getLiveAggregateRepository()).liveWeavingService((LiveWeavingService)this.agentModule.getLiveWeavingService()).sessionMapFactory(new SessionMapFactory(){

                @Override
                public <V extends Serializable> ConcurrentMap<String, V> create() {
                    return Maps.newConcurrentMap();
                }
            }).httpClient(this.simpleRepoModule.getHttpClient()).numWorkerThreads(2).version(this.version).build();
        } else {
            Preconditions.checkNotNull((Object)this.offlineViewerAgentModule);
            this.uiModule = new CreateUiModuleBuilder().central(false).servlet(false).offlineViewer(true).webPortReadOnly(WEB_PORT_OVERRIDE != null).confDirs(this.confDirs).logDir(this.logDir).logFileNamePattern(Pattern.compile("glowroot.*\\.log")).ticker(this.ticker).clock(this.clock).liveJvmService(null).agentDisplayRepository(new AgentDisplayRepositoryImpl()).configRepository(this.simpleRepoModule.getConfigRepository()).alertingDisabledRepository(this.simpleRepoModule.getAlertingDisabledDao()).activeAgentRepository(new ActiveAgentRepositoryImpl()).environmentRepository(this.simpleRepoModule.getEnvironmentDao()).transactionTypeRepository(this.simpleRepoModule.getTransactionTypeRepository()).traceAttributeNameRepository(this.simpleRepoModule.getTraceAttributeNameRepository()).aggregateRepository(this.simpleRepoModule.getAggregateDao()).traceRepository(this.simpleRepoModule.getTraceDao()).gaugeValueRepository(this.simpleRepoModule.getGaugeValueDao()).syntheticResultRepository(null).incidentRepository(this.simpleRepoModule.getIncidentDao()).repoAdmin(this.simpleRepoModule.getRepoAdmin()).rollupLevelService(this.simpleRepoModule.getRollupLevelService()).liveTraceRepository((LiveTraceRepository)new LiveTraceRepository.LiveTraceRepositoryNop()).liveAggregateRepository((LiveAggregateRepository)new LiveAggregateRepository.LiveAggregateRepositoryNop()).liveWeavingService(null).sessionMapFactory(new SessionMapFactory(){

                @Override
                public <V extends Serializable> ConcurrentMap<String, V> create() {
                    return Maps.newConcurrentMap();
                }
            }).httpClient(this.simpleRepoModule.getHttpClient()).numWorkerThreads(10).version(this.version).build();
        }
    }

    void waitForSimpleRepoModule() throws InterruptedException {
        this.simpleRepoModuleInit.await();
    }

    @OnlyUsedByTests
    public SimpleRepoModule getSimpleRepoModule() throws InterruptedException {
        this.simpleRepoModuleInit.await();
        return (SimpleRepoModule)Preconditions.checkNotNull((Object)this.simpleRepoModule);
    }

    @OnlyUsedByTests
    public AgentModule getAgentModule() {
        Preconditions.checkNotNull((Object)this.agentModule);
        return this.agentModule;
    }

    @OnlyUsedByTests
    public UiModule getUiModule() throws InterruptedException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (stopwatch.elapsed(TimeUnit.SECONDS) < 60L) {
            if (this.uiModule != null) {
                return this.uiModule;
            }
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        throw new IllegalStateException("UI Module failed to start");
    }

    @OnlyUsedByTests
    public void close() throws Exception {
        if (this.uiModule != null) {
            this.uiModule.close(false);
        }
        if (this.agentModule != null) {
            this.agentModule.close();
        }
        ((SimpleRepoModule)Preconditions.checkNotNull((Object)this.simpleRepoModule)).close();
        if (this.backgroundExecutor != null) {
            this.backgroundExecutor.shutdown();
            if (!this.backgroundExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Could not terminate executor");
            }
        }
    }

    private static DataSource createDataSource(boolean h2MemDb, File dataDir) throws SQLException {
        if (h2MemDb) {
            return new DataSource();
        }
        return new DataSource(new File(dataDir, "data.h2.db"));
    }

    private static boolean needToAddAlertPermission(DataSource dataSource) throws SQLException {
        if (dataSource.tableExists("trace")) {
            return false;
        }
        if (!dataSource.tableExists("triggered_alert")) {
            return true;
        }
        return dataSource.columnExists("triggered_alert", "alert_config_version");
    }

    private static void addAlertPermission(ConfigRepositoryImpl configRepository) throws Exception {
        for (RoleConfig config : configRepository.getRoleConfigs().toCompletableFuture().join()) {
            if (!config.isPermitted(RoleConfig.SimplePermission.create("agent:transaction:overview")) && !config.isPermitted(RoleConfig.SimplePermission.create("agent:error:overview")) && !config.isPermitted(RoleConfig.SimplePermission.create("agent:jvm:gauges"))) continue;
            ImmutableRoleConfig updatedConfig = ImmutableRoleConfig.builder().copyFrom(config).addPermissions("agent:alert").build();
            configRepository.updateRoleConfig(updatedConfig, Versions.getJsonVersion((Object)config), CassandraProfile.web).toCompletableFuture().join();
        }
    }

    private static class ActiveAgentRepositoryImpl
    implements ActiveAgentRepository {
        private ActiveAgentRepositoryImpl() {
        }

        @Override
        public CompletionStage<List<ActiveAgentRepository.TopLevelAgentRollup>> readActiveTopLevelAgentRollups(long from, long to, CassandraProfile profile) {
            return CompletableFuture.completedFuture(ImmutableList.of((Object)ImmutableTopLevelAgentRollup.builder().id("").display("").build()));
        }

        @Override
        public CompletionStage<List<ActiveAgentRepository.AgentRollup>> readActiveChildAgentRollups(String topLevelId, long from, long to, CassandraProfile profile) {
            return CompletableFuture.completedFuture(ImmutableList.of((Object)ImmutableAgentRollup.builder().id("").display("").lastDisplayPart("").build()));
        }

        @Override
        public CompletionStage<List<ActiveAgentRepository.AgentRollup>> readRecentlyActiveAgentRollups(long lastXMillis, CassandraProfile profile) {
            return CompletableFuture.completedFuture(ImmutableList.of((Object)ImmutableAgentRollup.builder().id("").display("").lastDisplayPart("").build()));
        }

        @Override
        public CompletionStage<List<ActiveAgentRepository.AgentRollup>> readActiveAgentRollups(long from, long to, CassandraProfile profile) {
            return CompletableFuture.completedFuture(ImmutableList.of((Object)ImmutableAgentRollup.builder().id("").display("").lastDisplayPart("").build()));
        }
    }

    private static class PlatformMBeanServerLifecycleImpl
    implements PlatformMBeanServerLifecycle {
        private final LazyPlatformMBeanServer lazyPlatformMBeanServer;

        private PlatformMBeanServerLifecycleImpl(LazyPlatformMBeanServer lazyPlatformMBeanServer) {
            this.lazyPlatformMBeanServer = lazyPlatformMBeanServer;
        }

        @Override
        public void lazyRegisterMBean(Object object, String name) {
            this.lazyPlatformMBeanServer.lazyRegisterMBean(object, name);
        }
    }
}

