/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.repo;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicLongArray;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.agent.collector.Collector;
import org.glowroot.agent.embedded.repo.AggregateInsert;
import org.glowroot.agent.embedded.repo.ConfigRepositoryImpl;
import org.glowroot.agent.embedded.repo.FullQueryTextDao;
import org.glowroot.agent.embedded.repo.ImmutableCappedId;
import org.glowroot.agent.embedded.repo.ImmutableMutableOverallAggregate;
import org.glowroot.agent.embedded.repo.ImmutableMutableTransactionAggregate;
import org.glowroot.agent.embedded.repo.ImmutableTruncatedQueryText;
import org.glowroot.agent.embedded.repo.TransactionTypeDao;
import org.glowroot.agent.embedded.repo.proto.Stored;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.AggregateRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.MutableAggregate;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.RollupLevelService;
import org.glowroot.agent.embedded.sql.SQLException;
import org.glowroot.agent.embedded.util.CappedDatabase;
import org.glowroot.agent.embedded.util.DataSource;
import org.glowroot.agent.embedded.util.ImmutableColumn;
import org.glowroot.agent.embedded.util.ImmutableIndex;
import org.glowroot.agent.embedded.util.RowMappers;
import org.glowroot.agent.embedded.util.Schemas;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.glowroot.agent.shaded.com.google.protobuf.Parser;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableOverviewAggregate;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutablePercentileAggregate;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableThroughputAggregate;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveAggregateRepository;
import org.glowroot.agent.shaded.org.glowroot.common.model.LazyHistogram;
import org.glowroot.agent.shaded.org.glowroot.common.model.OverallErrorSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.OverallSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.ProfileCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.QueryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.ServiceCallCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.TransactionNameErrorSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.TransactionNameSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.ProfileOuterClass;
import org.glowroot.agent.util.Checkers;
import org.immutables.value.Value;

public class AggregateDao
implements AggregateRepository {
    private static final String AGENT_ID = "";
    private static final ImmutableList<Schemas.Column> overallAggregatePointColumns = ImmutableList.of((Object)ImmutableColumn.of("transaction_type", Schemas.ColumnType.VARCHAR), (Object)ImmutableColumn.of("capture_time", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("total_duration_nanos", Schemas.ColumnType.DOUBLE), (Object)ImmutableColumn.of("transaction_count", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("error_count", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("async_transactions", Schemas.ColumnType.BOOLEAN), (Object)ImmutableColumn.of("queries_capped_id", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("service_calls_capped_id", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("main_thread_profile_capped_id", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("aux_thread_profile_capped_id", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("main_thread_root_timers", Schemas.ColumnType.VARBINARY), (Object)ImmutableColumn.of("main_thread_total_cpu_nanos", Schemas.ColumnType.DOUBLE), (Object[])new Schemas.Column[]{ImmutableColumn.of("main_thread_total_blocked_nanos", Schemas.ColumnType.DOUBLE), ImmutableColumn.of("main_thread_total_waited_nanos", Schemas.ColumnType.DOUBLE), ImmutableColumn.of("main_thread_total_allocated_bytes", Schemas.ColumnType.DOUBLE), ImmutableColumn.of("aux_thread_root_timer", Schemas.ColumnType.VARBINARY), ImmutableColumn.of("aux_thread_total_cpu_nanos", Schemas.ColumnType.DOUBLE), ImmutableColumn.of("aux_thread_total_blocked_nanos", Schemas.ColumnType.DOUBLE), ImmutableColumn.of("aux_thread_total_waited_nanos", Schemas.ColumnType.DOUBLE), ImmutableColumn.of("aux_thread_total_allocated_bytes", Schemas.ColumnType.DOUBLE), ImmutableColumn.of("async_timers", Schemas.ColumnType.VARBINARY), ImmutableColumn.of("duration_nanos_histogram", Schemas.ColumnType.VARBINARY)});
    private static final ImmutableList<Schemas.Column> transactionAggregateColumns = ImmutableList.of((Object)ImmutableColumn.of("transaction_type", Schemas.ColumnType.VARCHAR), (Object)ImmutableColumn.of("transaction_name", Schemas.ColumnType.VARCHAR), (Object)ImmutableColumn.of("capture_time", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("total_duration_nanos", Schemas.ColumnType.DOUBLE), (Object)ImmutableColumn.of("transaction_count", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("error_count", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("async_transactions", Schemas.ColumnType.BOOLEAN), (Object)ImmutableColumn.of("queries_capped_id", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("service_calls_capped_id", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("main_thread_profile_capped_id", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("aux_thread_profile_capped_id", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("main_thread_root_timers", Schemas.ColumnType.VARBINARY), (Object[])new Schemas.Column[]{ImmutableColumn.of("main_thread_total_cpu_nanos", Schemas.ColumnType.DOUBLE), ImmutableColumn.of("main_thread_total_blocked_nanos", Schemas.ColumnType.DOUBLE), ImmutableColumn.of("main_thread_total_waited_nanos", Schemas.ColumnType.DOUBLE), ImmutableColumn.of("main_thread_total_allocated_bytes", Schemas.ColumnType.DOUBLE), ImmutableColumn.of("aux_thread_root_timer", Schemas.ColumnType.VARBINARY), ImmutableColumn.of("aux_thread_total_cpu_nanos", Schemas.ColumnType.DOUBLE), ImmutableColumn.of("aux_thread_total_blocked_nanos", Schemas.ColumnType.DOUBLE), ImmutableColumn.of("aux_thread_total_waited_nanos", Schemas.ColumnType.DOUBLE), ImmutableColumn.of("aux_thread_total_allocated_bytes", Schemas.ColumnType.DOUBLE), ImmutableColumn.of("async_timers", Schemas.ColumnType.VARBINARY), ImmutableColumn.of("duration_nanos_histogram", Schemas.ColumnType.VARBINARY)});
    private static final ImmutableList<String> overallAggregateIndexColumns = ImmutableList.of((Object)"capture_time", (Object)"transaction_type", (Object)"total_duration_nanos", (Object)"transaction_count", (Object)"error_count", (Object)"main_thread_total_cpu_nanos", (Object)"aux_thread_total_cpu_nanos", (Object)"main_thread_total_allocated_bytes", (Object)"aux_thread_total_allocated_bytes");
    private static final ImmutableList<String> transactionAggregateIndexColumns = ImmutableList.of((Object)"capture_time", (Object)"transaction_type", (Object)"transaction_name", (Object)"total_duration_nanos", (Object)"transaction_count", (Object)"error_count", (Object)"main_thread_total_cpu_nanos", (Object)"aux_thread_total_cpu_nanos", (Object)"main_thread_total_allocated_bytes", (Object)"aux_thread_total_allocated_bytes");
    private final DataSource dataSource;
    private final List<CappedDatabase> rollupCappedDatabases;
    private final ConfigRepositoryImpl configRepository;
    private final TransactionTypeDao transactionTypeDao;
    private final FullQueryTextDao fullQueryTextDao;
    private final AtomicLongArray lastRollupTimes;
    private final Object rollupLock = new Object();

    AggregateDao(DataSource dataSource, List<CappedDatabase> rollupCappedDatabases, ConfigRepositoryImpl configRepository, TransactionTypeDao transactionTypeDao, FullQueryTextDao fullQueryTextDao) throws Exception {
        this.dataSource = dataSource;
        this.rollupCappedDatabases = rollupCappedDatabases;
        this.configRepository = configRepository;
        this.transactionTypeDao = transactionTypeDao;
        this.fullQueryTextDao = fullQueryTextDao;
        ImmutableList<ConfigRepository.RollupConfig> rollupConfigs = configRepository.getRollupConfigs();
        for (int i = 0; i < rollupConfigs.size(); ++i) {
            String overallTableName = "aggregate_tt_rollup_" + Checkers.castUntainted((Object)i);
            dataSource.syncTable(overallTableName, (List<Schemas.Column>)overallAggregatePointColumns);
            dataSource.syncIndexes(overallTableName, (ImmutableList<Schemas.Index>)ImmutableList.of((Object)ImmutableIndex.of(overallTableName + "_idx", overallAggregateIndexColumns)));
            String transactionTableName = "aggregate_tn_rollup_" + Checkers.castUntainted((Object)i);
            dataSource.syncTable(transactionTableName, (List<Schemas.Column>)transactionAggregateColumns);
            dataSource.syncIndexes(transactionTableName, (ImmutableList<Schemas.Index>)ImmutableList.of((Object)ImmutableIndex.of(transactionTableName + "_idx", transactionAggregateIndexColumns)));
        }
        long[] lastRollupTimes = new long[rollupConfigs.size()];
        lastRollupTimes[0] = 0L;
        for (int i = 1; i < lastRollupTimes.length; ++i) {
            lastRollupTimes[i] = dataSource.queryForLong("select ifnull(max(capture_time), 0) from aggregate_tt_rollup_" + Checkers.castUntainted((Object)i), new Object[0]);
        }
        this.lastRollupTimes = new AtomicLongArray(lastRollupTimes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Collector.AggregateReader aggregateReader) throws Exception {
        final long captureTime = aggregateReader.captureTime();
        final CappedDatabase cappedDatabase = this.rollupCappedDatabases.get(0);
        final ArrayList truncatedQueryTexts = Lists.newArrayList();
        aggregateReader.accept(new Collector.AggregateVisitor(){

            public void visitOverallAggregate(String transactionType, List<String> sharedQueryTexts, AggregateOuterClass.Aggregate overallAggregate) throws Exception {
                this.addToTruncatedQueryTexts(sharedQueryTexts);
                AggregateDao.this.dataSource.update(new AggregateInsert(transactionType, null, captureTime, overallAggregate, truncatedQueryTexts, 0, cappedDatabase));
                AggregateDao.this.transactionTypeDao.updateLastCaptureTime(transactionType, captureTime);
            }

            public void visitTransactionAggregate(String transactionType, String transactionName, List<String> sharedQueryTexts, AggregateOuterClass.Aggregate transactionAggregate) throws Exception {
                this.addToTruncatedQueryTexts(sharedQueryTexts);
                AggregateDao.this.dataSource.update(new AggregateInsert(transactionType, transactionName, captureTime, transactionAggregate, truncatedQueryTexts, 0, cappedDatabase));
            }

            private void addToTruncatedQueryTexts(List<String> sharedQueryTexts) throws SQLException {
                for (String sharedQueryText : sharedQueryTexts) {
                    String fullTextSha1;
                    String truncatedText;
                    if (sharedQueryText.length() > 120) {
                        truncatedText = sharedQueryText.substring(0, 120);
                        fullTextSha1 = AggregateDao.this.fullQueryTextDao.updateLastCaptureTime(sharedQueryText, captureTime);
                    } else {
                        truncatedText = sharedQueryText;
                        fullTextSha1 = null;
                    }
                    truncatedQueryTexts.add(ImmutableTruncatedQueryText.of(truncatedText, fullTextSha1));
                }
            }
        });
        Object object = this.rollupLock;
        synchronized (object) {
            ImmutableList<ConfigRepository.RollupConfig> rollupConfigs = this.configRepository.getRollupConfigs();
            for (int i = 1; i < rollupConfigs.size(); ++i) {
                long lastRollupTime;
                ConfigRepository.RollupConfig rollupConfig = (ConfigRepository.RollupConfig)rollupConfigs.get(i);
                long safeRollupTime = RollupLevelService.getSafeRollupTime(captureTime, rollupConfig.intervalMillis());
                if (safeRollupTime <= (lastRollupTime = this.lastRollupTimes.get(i))) continue;
                this.rollup(lastRollupTime, safeRollupTime, rollupConfig.intervalMillis(), i, i - 1);
                this.lastRollupTimes.set(i, safeRollupTime);
            }
        }
    }

    @Override
    public CompletionStage<?> mergeOverallSummaryInto(String agentRollupId, LiveAggregateRepository.SummaryQuery query, OverallSummaryCollector collector, CassandraProfile profile) {
        try {
            this.dataSource.query(new OverallSummaryQuery(collector, query));
            return CompletableFuture.completedFuture(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<?> mergeTransactionNameSummariesInto(String agentRollupId, LiveAggregateRepository.SummaryQuery query, TransactionNameSummaryCollector.SummarySortOrder sortOrder, int limit, TransactionNameSummaryCollector collector, CassandraProfile profile) {
        try {
            this.dataSource.query(new TransactionNameSummaryQuery(query, sortOrder, limit, collector));
            return CompletableFuture.completedFuture(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<?> mergeOverallErrorSummaryInto(String agentRollupId, LiveAggregateRepository.SummaryQuery query, OverallErrorSummaryCollector collector, CassandraProfile profile) {
        try {
            this.dataSource.query(new OverallErrorSummaryQuery(collector, query));
            return CompletableFuture.completedFuture(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<?> mergeTransactionNameErrorSummariesInto(String agentRollupId, LiveAggregateRepository.SummaryQuery query, TransactionNameErrorSummaryCollector.ErrorSummarySortOrder sortOrder, int limit, TransactionNameErrorSummaryCollector collector, CassandraProfile profile) {
        try {
            this.dataSource.query(new TransactionNameErrorSummaryQuery(query, sortOrder, limit, collector));
            return CompletableFuture.completedFuture(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<List<LiveAggregateRepository.OverviewAggregate>> readOverviewAggregates(String agentRollupId, LiveAggregateRepository.AggregateQuery query, CassandraProfile profile) {
        try {
            return CompletableFuture.completedFuture(this.dataSource.query(new OverviewAggregateQuery(query)));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<List<LiveAggregateRepository.PercentileAggregate>> readPercentileAggregates(String agentRollupId, LiveAggregateRepository.AggregateQuery query, CassandraProfile profile) {
        try {
            return CompletableFuture.completedFuture(this.dataSource.query(new PercentileAggregateQuery(query)));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<List<LiveAggregateRepository.ThroughputAggregate>> readThroughputAggregates(String agentRollupId, LiveAggregateRepository.AggregateQuery query, CassandraProfile profile) {
        try {
            return CompletableFuture.completedFuture(this.dataSource.query(new ThroughputAggregateQuery(query)));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<?> mergeQueriesInto(String agentRollupId, LiveAggregateRepository.AggregateQuery query, QueryCollector collector, CassandraProfile profile) {
        try {
            List<CappedId> cappedIds = this.dataSource.query(new CappedIdQuery("queries_capped_id", query));
            long captureTime = Long.MIN_VALUE;
            for (CappedId cappedId : cappedIds) {
                captureTime = Math.max(captureTime, cappedId.captureTime());
                List<Stored.QueriesByType> queries = this.rollupCappedDatabases.get(query.rollupLevel()).readMessages(cappedId.cappedId(), Stored.QueriesByType.parser());
                for (Stored.QueriesByType toBeMergedQueries : queries) {
                    for (Stored.Query toBeMergedQuery : toBeMergedQueries.getQueryList()) {
                        collector.mergeQuery(toBeMergedQueries.getType(), toBeMergedQuery.getTruncatedText(), Strings.emptyToNull((String)toBeMergedQuery.getFullTextSha1()), toBeMergedQuery.getTotalDurationNanos(), toBeMergedQuery.getExecutionCount(), toBeMergedQuery.hasTotalRows(), toBeMergedQuery.getTotalRows().getValue());
                    }
                }
                collector.updateLastCaptureTime(captureTime);
            }
            return CompletableFuture.completedFuture(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<?> mergeServiceCallsInto(String agentRollupId, LiveAggregateRepository.AggregateQuery query, ServiceCallCollector collector, CassandraProfile profile) {
        try {
            List<CappedId> cappedIds = this.dataSource.query(new CappedIdQuery("service_calls_capped_id", query));
            long captureTime = Long.MIN_VALUE;
            for (CappedId cappedId : cappedIds) {
                captureTime = Math.max(captureTime, cappedId.captureTime());
                List<Stored.ServiceCallsByType> serviceCalls = this.rollupCappedDatabases.get(query.rollupLevel()).readMessages(cappedId.cappedId(), Stored.ServiceCallsByType.parser());
                for (Stored.ServiceCallsByType toBeMergedServiceCalls : serviceCalls) {
                    for (Stored.ServiceCall toBeMergedQuery : toBeMergedServiceCalls.getServiceCallList()) {
                        collector.mergeServiceCall(toBeMergedServiceCalls.getType(), toBeMergedQuery.getText(), toBeMergedQuery.getTotalDurationNanos(), toBeMergedQuery.getExecutionCount());
                    }
                }
                collector.updateLastCaptureTime(captureTime);
            }
            return CompletableFuture.completedFuture(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<?> mergeMainThreadProfilesInto(String agentRollupId, LiveAggregateRepository.AggregateQuery query, ProfileCollector collector, CassandraProfile profile) {
        this.mergeProfilesInto(collector, query, "main_thread_profile_capped_id");
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletionStage<?> mergeAuxThreadProfilesInto(String agentRollupId, LiveAggregateRepository.AggregateQuery query, ProfileCollector collector, CassandraProfile profile) {
        this.mergeProfilesInto(collector, query, "aux_thread_profile_capped_id");
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletionStage<String> readFullQueryText(String agentRollupId, String fullQueryTextSha1, CassandraProfile profile) {
        try {
            return CompletableFuture.completedFuture(this.fullQueryTextDao.getFullText(fullQueryTextSha1));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<Boolean> hasMainThreadProfile(String agentRollupId, LiveAggregateRepository.AggregateQuery query, CassandraProfile profile) throws Exception {
        return CompletableFuture.completedFuture(!this.dataSource.query(new CappedIdQuery("main_thread_profile_capped_id", query)).isEmpty());
    }

    @Override
    public CompletionStage<Boolean> hasAuxThreadProfile(String agentRollupId, LiveAggregateRepository.AggregateQuery query, CassandraProfile profile) throws Exception {
        return CompletableFuture.completedFuture(!this.dataSource.query(new CappedIdQuery("aux_thread_profile_capped_id", query)).isEmpty());
    }

    @Override
    public CompletionStage<Boolean> shouldHaveMainThreadProfile(String agentRollupId, LiveAggregateRepository.AggregateQuery query) throws Exception {
        return CompletableFuture.completedFuture(this.dataSource.query(new ShouldHaveSomethingQuery(query, "main_thread_profile_capped_id")));
    }

    @Override
    public CompletionStage<Boolean> shouldHaveAuxThreadProfile(String agentRollupId, LiveAggregateRepository.AggregateQuery query) throws Exception {
        return CompletableFuture.completedFuture(this.dataSource.query(new ShouldHaveSomethingQuery(query, "aux_thread_profile_capped_id")));
    }

    @Override
    public CompletionStage<Boolean> shouldHaveQueries(String agentRollupId, LiveAggregateRepository.AggregateQuery query) throws Exception {
        return CompletableFuture.completedFuture(this.dataSource.query(new ShouldHaveSomethingQuery(query, "queries_capped_id")));
    }

    @Override
    public CompletionStage<Boolean> shouldHaveServiceCalls(String agentRollupId, LiveAggregateRepository.AggregateQuery query) throws Exception {
        return CompletableFuture.completedFuture(this.dataSource.query(new ShouldHaveSomethingQuery(query, "service_calls_capped_id")));
    }

    void deleteBefore(long captureTime, int rollupLevel) throws SQLException {
        this.dataSource.deleteBefore("aggregate_tt_rollup_" + Checkers.castUntainted((Object)rollupLevel), captureTime);
        this.dataSource.deleteBefore("aggregate_tn_rollup_" + Checkers.castUntainted((Object)rollupLevel), captureTime);
    }

    private void rollup(long lastRollupTime, long curentRollupTime, long fixedIntervalMillis, int toRollupLevel, int fromRollupLevel) throws Exception {
        List<Long> rollupTimes = this.dataSource.query(new RollupTimeRowMapper(fromRollupLevel, fixedIntervalMillis, lastRollupTime, curentRollupTime));
        for (Long rollupTime : rollupTimes) {
            this.dataSource.query(new RollupOverallAggregates(rollupTime, fixedIntervalMillis, fromRollupLevel, toRollupLevel));
            this.dataSource.query(new RollupTransactionAggregates(rollupTime, fixedIntervalMillis, fromRollupLevel, toRollupLevel));
        }
    }

    private void mergeProfilesInto(ProfileCollector collector, LiveAggregateRepository.AggregateQuery query, @Untainted String cappedIdColumnName) {
        try {
            List<CappedId> cappedIds = this.dataSource.query(new CappedIdQuery(cappedIdColumnName, query));
            long captureTime = Long.MIN_VALUE;
            for (CappedId cappedId : cappedIds) {
                captureTime = Math.max(captureTime, cappedId.captureTime());
                ProfileOuterClass.Profile profile = (ProfileOuterClass.Profile)this.rollupCappedDatabases.get(query.rollupLevel()).readMessage(cappedId.cappedId(), ProfileOuterClass.Profile.parser());
                if (profile == null) continue;
                collector.mergeProfile(profile);
                collector.updateLastCaptureTime(captureTime);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void merge(MutableAggregate mergedAggregate, ResultSet resultSet, int startColumnIndex, int fromRollupLevel) throws Exception {
        ProfileOuterClass.Profile auxThreadProfile;
        ProfileOuterClass.Profile mainThreadProfile;
        List<Stored.ServiceCallsByType> serviceCalls;
        List<Stored.QueriesByType> queries;
        double auxThreadTotalAllocatedBytes;
        double auxThreadTotalWaitedNanos;
        double auxThreadTotalBlockedNanos;
        double auxThreadTotalCpuNanos;
        byte[] auxThreadRootTimers;
        int i = startColumnIndex;
        double totalDurationNanos = resultSet.getDouble(i++);
        long transactionCount = resultSet.getLong(i++);
        long errorCount = resultSet.getLong(i++);
        boolean asyncTransactions = resultSet.getBoolean(i++);
        Long queriesCappedId = RowMappers.getLong(resultSet, i++);
        Long serviceCallsCappedId = RowMappers.getLong(resultSet, i++);
        Long mainThreadProfileCappedId = RowMappers.getLong(resultSet, i++);
        Long auxThreadProfileCappedId = RowMappers.getLong(resultSet, i++);
        byte[] mainThreadRootTimers = (byte[])Preconditions.checkNotNull((Object)resultSet.getBytes(i++));
        double mainThreadTotalCpuNanos = AggregateDao.getNextThreadStat(resultSet, i++);
        double mainThreadTotalBlockedNanos = AggregateDao.getNextThreadStat(resultSet, i++);
        double mainThreadTotalWaitedNanos = AggregateDao.getNextThreadStat(resultSet, i++);
        double mainThreadTotalAllocatedBytes = AggregateDao.getNextThreadStat(resultSet, i++);
        if ((auxThreadRootTimers = resultSet.getBytes(i++)) == null) {
            auxThreadTotalCpuNanos = 0.0;
            auxThreadTotalBlockedNanos = 0.0;
            auxThreadTotalWaitedNanos = 0.0;
            auxThreadTotalAllocatedBytes = 0.0;
            i += 4;
        } else {
            auxThreadTotalCpuNanos = AggregateDao.getNextThreadStat(resultSet, i++);
            auxThreadTotalBlockedNanos = AggregateDao.getNextThreadStat(resultSet, i++);
            auxThreadTotalWaitedNanos = AggregateDao.getNextThreadStat(resultSet, i++);
            auxThreadTotalAllocatedBytes = AggregateDao.getNextThreadStat(resultSet, i++);
        }
        byte[] asyncTimers = resultSet.getBytes(i++);
        byte[] durationNanosHistogram = (byte[])Preconditions.checkNotNull((Object)resultSet.getBytes(i++));
        mergedAggregate.addTotalDurationNanos(totalDurationNanos);
        mergedAggregate.addTransactionCount(transactionCount);
        mergedAggregate.addErrorCount(errorCount);
        mergedAggregate.addAsyncTransactions(asyncTransactions);
        mergedAggregate.mergeMainThreadRootTimers(AggregateDao.readMessages(mainThreadRootTimers, AggregateOuterClass.Aggregate.Timer.parser()));
        mergedAggregate.addMainThreadTotalCpuNanos(mainThreadTotalCpuNanos);
        mergedAggregate.addMainThreadTotalBlockedNanos(mainThreadTotalBlockedNanos);
        mergedAggregate.addMainThreadTotalWaitedNanos(mainThreadTotalWaitedNanos);
        mergedAggregate.addMainThreadTotalAllocatedBytes(mainThreadTotalAllocatedBytes);
        if (auxThreadRootTimers != null) {
            List list = AggregateDao.readMessages(auxThreadRootTimers, AggregateOuterClass.Aggregate.Timer.parser());
            mergedAggregate.mergeAuxThreadRootTimer((AggregateOuterClass.Aggregate.Timer)list.get(0));
            mergedAggregate.addAuxThreadTotalCpuNanos(auxThreadTotalCpuNanos);
            mergedAggregate.addAuxThreadTotalBlockedNanos(auxThreadTotalBlockedNanos);
            mergedAggregate.addAuxThreadTotalWaitedNanos(auxThreadTotalWaitedNanos);
            mergedAggregate.addAuxThreadTotalAllocatedBytes(auxThreadTotalAllocatedBytes);
        }
        if (asyncTimers != null) {
            mergedAggregate.mergeAsyncTimers(AggregateDao.readMessages(asyncTimers, AggregateOuterClass.Aggregate.Timer.parser()));
        }
        mergedAggregate.mergeDurationNanosHistogram(AggregateOuterClass.Aggregate.Histogram.parseFrom((byte[])durationNanosHistogram));
        if (queriesCappedId != null && (queries = this.rollupCappedDatabases.get(fromRollupLevel).readMessages(queriesCappedId, Stored.QueriesByType.parser())) != null) {
            for (Stored.QueriesByType queriesByType : queries) {
                for (Stored.Query query : queriesByType.getQueryList()) {
                    mergedAggregate.mergeQuery(queriesByType.getType(), query.getTruncatedText(), Strings.emptyToNull((String)query.getFullTextSha1()), query.getTotalDurationNanos(), query.getExecutionCount(), query.hasTotalRows(), query.getTotalRows().getValue());
                }
            }
        }
        if (serviceCallsCappedId != null && (serviceCalls = this.rollupCappedDatabases.get(fromRollupLevel).readMessages(serviceCallsCappedId, Stored.ServiceCallsByType.parser())) != null) {
            for (Stored.ServiceCallsByType serviceCallsByType : serviceCalls) {
                for (Stored.ServiceCall serviceCall : serviceCallsByType.getServiceCallList()) {
                    mergedAggregate.mergeServiceCall(serviceCallsByType.getType(), serviceCall.getText(), serviceCall.getTotalDurationNanos(), serviceCall.getExecutionCount());
                }
            }
        }
        if (mainThreadProfileCappedId != null && (mainThreadProfile = (ProfileOuterClass.Profile)this.rollupCappedDatabases.get(fromRollupLevel).readMessage(mainThreadProfileCappedId, ProfileOuterClass.Profile.parser())) != null) {
            mergedAggregate.mergeMainThreadProfile(mainThreadProfile);
        }
        if (auxThreadProfileCappedId != null && (auxThreadProfile = (ProfileOuterClass.Profile)this.rollupCappedDatabases.get(fromRollupLevel).readMessage(auxThreadProfileCappedId, ProfileOuterClass.Profile.parser())) != null) {
            mergedAggregate.mergeAuxThreadProfile(auxThreadProfile);
        }
    }

    private int getMaxQueryAggregates() throws Exception {
        AgentConfigOuterClass.AgentConfig.AdvancedConfig advancedConfig = this.configRepository.getAdvancedConfig(AGENT_ID).toCompletableFuture().get();
        if (advancedConfig.hasMaxQueryAggregates()) {
            return advancedConfig.getMaxQueryAggregates().getValue();
        }
        return 500;
    }

    private int getMaxServiceCallAggregates() throws Exception {
        AgentConfigOuterClass.AgentConfig.AdvancedConfig advancedConfig = this.configRepository.getAdvancedConfig(AGENT_ID).toCompletableFuture().get();
        if (advancedConfig.hasMaxServiceCallAggregates()) {
            return advancedConfig.getMaxServiceCallAggregates().getValue();
        }
        return 500;
    }

    private static @Untainted String getTableName(LiveAggregateRepository.AggregateQuery query) {
        if (query.transactionName() == null) {
            return "aggregate_tt_rollup_" + Checkers.castUntainted((Object)query.rollupLevel());
        }
        return "aggregate_tn_rollup_" + Checkers.castUntainted((Object)query.rollupLevel());
    }

    private static @Untainted String getTransactionNameCriteria(LiveAggregateRepository.AggregateQuery query) {
        if (query.transactionName() == null) {
            return AGENT_ID;
        }
        return " and transaction_name = ?";
    }

    private static int bindQuery(PreparedStatement preparedStatement, LiveAggregateRepository.AggregateQuery query) throws SQLException {
        int i = 1;
        preparedStatement.setString(i++, query.transactionType());
        String transactionName = query.transactionName();
        if (transactionName != null) {
            preparedStatement.setString(i++, transactionName);
        }
        preparedStatement.setLong(i++, query.from());
        preparedStatement.setLong(i++, query.to());
        return i;
    }

    private static <T> List<T> readMessages(byte[] bytes, Parser<T> parser) throws InvalidProtocolBufferException {
        Object message;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ArrayList messages = Lists.newArrayList();
        while ((message = parser.parseDelimitedFrom((InputStream)bais)) != null) {
            messages.add(message);
        }
        return messages;
    }

    private static double getNextThreadStat(ResultSet resultSet, int columnIndex) throws SQLException {
        double value = resultSet.getDouble(columnIndex);
        if (resultSet.wasNull()) {
            return -1.0;
        }
        return value;
    }

    @Value.Immutable
    @Styles.AllParameters
    static interface TruncatedQueryText {
        public String truncatedText();

        public @Nullable String fullTextSha1();
    }

    @Value.Immutable
    @Styles.AllParameters
    static interface MutableTransactionAggregate {
        public String transactionType();

        public String transactionName();

        public MutableAggregate aggregate();
    }

    @Value.Immutable
    @Styles.AllParameters
    static interface MutableOverallAggregate {
        public String transactionType();

        public MutableAggregate aggregate();
    }

    @Value.Immutable
    @Styles.AllParameters
    static interface CappedId {
        public long captureTime();

        public long cappedId();
    }

    private static class RollupTimeRowMapper
    implements DataSource.JdbcRowQuery<Long> {
        private final int rollupLevel;
        private final long fixedIntervalMillis;
        private final long lastRollupTime;
        private final long curentRollupTime;

        private RollupTimeRowMapper(int rollupLevel, long fixedIntervalMillis, long lastRollupTime, long curentRollupTime) {
            this.rollupLevel = rollupLevel;
            this.fixedIntervalMillis = fixedIntervalMillis;
            this.lastRollupTime = lastRollupTime;
            this.curentRollupTime = curentRollupTime;
        }

        @Override
        public @Untainted String getSql() {
            String captureTimeSql = (String)Checkers.castUntainted((Object)("ceil(capture_time / " + this.fixedIntervalMillis + ".0) * " + this.fixedIntervalMillis));
            return "select distinct " + captureTimeSql + " from aggregate_tt_rollup_" + Checkers.castUntainted((Object)this.rollupLevel) + " where capture_time > ? and capture_time <= ?";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            preparedStatement.setLong(1, this.lastRollupTime);
            preparedStatement.setLong(2, this.curentRollupTime);
        }

        @Override
        public Long mapRow(ResultSet resultSet) throws SQLException {
            return resultSet.getLong(1);
        }
    }

    private static class ShouldHaveSomethingQuery
    implements DataSource.JdbcQuery<Boolean> {
        private final LiveAggregateRepository.AggregateQuery query;
        private final @Untainted String cappedIdColumnName;

        private ShouldHaveSomethingQuery(LiveAggregateRepository.AggregateQuery query, @Untainted String cappedIdColumnName) {
            this.query = query;
            this.cappedIdColumnName = cappedIdColumnName;
        }

        @Override
        public @Untainted String getSql() {
            String tableName = AggregateDao.getTableName(this.query);
            String transactionNameCriteria = AggregateDao.getTransactionNameCriteria(this.query);
            return "select 1 from " + tableName + " where transaction_type = ?" + transactionNameCriteria + " and capture_time > ? and capture_time <= ? and " + this.cappedIdColumnName + " is not null limit 1";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws Exception {
            int i = 1;
            preparedStatement.setString(i++, this.query.transactionType());
            String transactionName = this.query.transactionName();
            if (transactionName != null) {
                preparedStatement.setString(i++, transactionName);
            }
            preparedStatement.setLong(i++, this.query.from());
            preparedStatement.setLong(i++, this.query.to());
        }

        @Override
        public Boolean processResultSet(ResultSet resultSet) throws Exception {
            return resultSet.next();
        }

        @Override
        public Boolean valueIfDataSourceClosed() {
            return false;
        }
    }

    private class CappedIdQuery
    implements DataSource.JdbcQuery<List<CappedId>> {
        private final @Untainted String cappedIdColumnName;
        private final LiveAggregateRepository.AggregateQuery query;
        private final long smallestNonExpiredCappedId;

        private CappedIdQuery(String cappedIdColumnName, LiveAggregateRepository.AggregateQuery query) {
            this.cappedIdColumnName = cappedIdColumnName;
            this.query = query;
            this.smallestNonExpiredCappedId = ((CappedDatabase)AggregateDao.this.rollupCappedDatabases.get(query.rollupLevel())).getSmallestNonExpiredId();
        }

        @Override
        public @Untainted String getSql() {
            String tableName = AggregateDao.getTableName(this.query);
            String transactionNameCriteria = AggregateDao.getTransactionNameCriteria(this.query);
            return "select capture_time, " + this.cappedIdColumnName + " from " + tableName + " where transaction_type = ?" + transactionNameCriteria + " and capture_time > ? and capture_time <= ? and " + this.cappedIdColumnName + " >= ?";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws Exception {
            int i = AggregateDao.bindQuery(preparedStatement, this.query);
            preparedStatement.setLong(i++, this.smallestNonExpiredCappedId);
        }

        @Override
        public List<CappedId> processResultSet(ResultSet resultSet) throws Exception {
            ArrayList cappedIds = Lists.newArrayList();
            while (resultSet.next()) {
                cappedIds.add(ImmutableCappedId.of(resultSet.getLong(1), resultSet.getLong(2)));
            }
            return cappedIds;
        }

        @Override
        public List<CappedId> valueIfDataSourceClosed() {
            return ImmutableList.of();
        }
    }

    private class RollupTransactionAggregates
    implements DataSource.JdbcQuery<Void> {
        private final long rollupCaptureTime;
        private final long fixedIntervalMillis;
        private final int fromRollupLevel;
        private final int toRollupLevel;

        private RollupTransactionAggregates(long rollupCaptureTime, long fixedIntervalMillis, int fromRollupLevel, int toRollupLevel) {
            this.rollupCaptureTime = rollupCaptureTime;
            this.fixedIntervalMillis = fixedIntervalMillis;
            this.fromRollupLevel = fromRollupLevel;
            this.toRollupLevel = toRollupLevel;
        }

        @Override
        public @Untainted String getSql() {
            return "select transaction_type, transaction_name, total_duration_nanos, transaction_count, error_count, async_transactions, queries_capped_id, service_calls_capped_id, main_thread_profile_capped_id, aux_thread_profile_capped_id, main_thread_root_timers, main_thread_total_cpu_nanos, main_thread_total_blocked_nanos, main_thread_total_waited_nanos, main_thread_total_allocated_bytes, aux_thread_root_timer, aux_thread_total_cpu_nanos, aux_thread_total_blocked_nanos, aux_thread_total_waited_nanos, aux_thread_total_allocated_bytes, async_timers, duration_nanos_histogram from aggregate_tn_rollup_" + Checkers.castUntainted((Object)this.fromRollupLevel) + " where capture_time > ? and capture_time <= ? order by transaction_type, transaction_name";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws Exception {
            preparedStatement.setLong(1, this.rollupCaptureTime - this.fixedIntervalMillis);
            preparedStatement.setLong(2, this.rollupCaptureTime);
        }

        @Override
        public @Nullable Void processResultSet(ResultSet resultSet) throws Exception {
            int maxQueryAggregates = AggregateDao.this.getMaxQueryAggregates();
            int maxServiceCallAggregates = AggregateDao.this.getMaxServiceCallAggregates();
            CappedDatabase cappedDatabase = (CappedDatabase)AggregateDao.this.rollupCappedDatabases.get(this.toRollupLevel);
            LazyHistogram.ScratchBuffer scratchBuffer = new LazyHistogram.ScratchBuffer();
            MutableTransactionAggregate curr = null;
            while (resultSet.next()) {
                int i = 1;
                String transactionType = (String)Preconditions.checkNotNull((Object)resultSet.getString(i++));
                String transactionName = (String)Preconditions.checkNotNull((Object)resultSet.getString(i++));
                if (curr == null || !transactionType.equals(curr.transactionType()) || !transactionName.equals(curr.transactionName())) {
                    if (curr != null) {
                        AggregateDao.this.dataSource.update(new AggregateInsert(curr.transactionType(), curr.transactionName(), this.rollupCaptureTime, curr.aggregate(), this.toRollupLevel, cappedDatabase, scratchBuffer));
                    }
                    curr = ImmutableMutableTransactionAggregate.of(transactionType, transactionName, new MutableAggregate(maxQueryAggregates, maxServiceCallAggregates));
                }
                AggregateDao.this.merge(curr.aggregate(), resultSet, i++, this.fromRollupLevel);
            }
            if (curr != null) {
                AggregateDao.this.dataSource.update(new AggregateInsert(curr.transactionType(), curr.transactionName(), this.rollupCaptureTime, curr.aggregate(), this.toRollupLevel, cappedDatabase, scratchBuffer));
            }
            return null;
        }

        @Override
        public @Nullable Void valueIfDataSourceClosed() {
            return null;
        }
    }

    private class RollupOverallAggregates
    implements DataSource.JdbcQuery<Void> {
        private final long rollupCaptureTime;
        private final long fixedIntervalMillis;
        private final int fromRollupLevel;
        private final int toRollupLevel;
        private final LazyHistogram.ScratchBuffer scratchBuffer = new LazyHistogram.ScratchBuffer();

        private RollupOverallAggregates(long rollupCaptureTime, long fixedIntervalMillis, int fromRollupLevel, int toRollupLevel) {
            this.rollupCaptureTime = rollupCaptureTime;
            this.fixedIntervalMillis = fixedIntervalMillis;
            this.fromRollupLevel = fromRollupLevel;
            this.toRollupLevel = toRollupLevel;
        }

        @Override
        public @Untainted String getSql() {
            return "select transaction_type, total_duration_nanos, transaction_count, error_count, async_transactions, queries_capped_id, service_calls_capped_id, main_thread_profile_capped_id, aux_thread_profile_capped_id, main_thread_root_timers, main_thread_total_cpu_nanos, main_thread_total_blocked_nanos, main_thread_total_waited_nanos, main_thread_total_allocated_bytes, aux_thread_root_timer, aux_thread_total_cpu_nanos, aux_thread_total_blocked_nanos, aux_thread_total_waited_nanos, aux_thread_total_allocated_bytes, async_timers, duration_nanos_histogram from aggregate_tt_rollup_" + Checkers.castUntainted((Object)this.fromRollupLevel) + " where capture_time > ? and capture_time <= ? order by transaction_type";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws Exception {
            preparedStatement.setLong(1, this.rollupCaptureTime - this.fixedIntervalMillis);
            preparedStatement.setLong(2, this.rollupCaptureTime);
        }

        @Override
        public @Nullable Void processResultSet(ResultSet resultSet) throws Exception {
            int maxQueryAggregates = AggregateDao.this.getMaxQueryAggregates();
            int maxServiceCallAggregates = AggregateDao.this.getMaxServiceCallAggregates();
            CappedDatabase cappedDatabase = (CappedDatabase)AggregateDao.this.rollupCappedDatabases.get(this.toRollupLevel);
            MutableOverallAggregate curr = null;
            while (resultSet.next()) {
                String transactionType = (String)Preconditions.checkNotNull((Object)resultSet.getString(1));
                if (curr == null || !transactionType.equals(curr.transactionType())) {
                    if (curr != null) {
                        AggregateDao.this.dataSource.update(new AggregateInsert(curr.transactionType(), null, this.rollupCaptureTime, curr.aggregate(), this.toRollupLevel, cappedDatabase, this.scratchBuffer));
                    }
                    curr = ImmutableMutableOverallAggregate.of(transactionType, new MutableAggregate(maxQueryAggregates, maxServiceCallAggregates));
                }
                AggregateDao.this.merge(curr.aggregate(), resultSet, 2, this.fromRollupLevel);
            }
            if (curr != null) {
                AggregateDao.this.dataSource.update(new AggregateInsert(curr.transactionType(), null, this.rollupCaptureTime, curr.aggregate(), this.toRollupLevel, cappedDatabase, this.scratchBuffer));
            }
            return null;
        }

        @Override
        public @Nullable Void valueIfDataSourceClosed() {
            return null;
        }
    }

    private static class ThroughputAggregateQuery
    implements DataSource.JdbcRowQuery<LiveAggregateRepository.ThroughputAggregate> {
        private final LiveAggregateRepository.AggregateQuery query;

        private ThroughputAggregateQuery(LiveAggregateRepository.AggregateQuery query) {
            this.query = query;
        }

        @Override
        public @Untainted String getSql() {
            String tableName = AggregateDao.getTableName(this.query);
            String transactionNameCriteria = AggregateDao.getTransactionNameCriteria(this.query);
            return "select capture_time, transaction_count, error_count from " + tableName + " where transaction_type = ?" + transactionNameCriteria + " and capture_time >= ? and capture_time <= ? order by capture_time";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            AggregateDao.bindQuery(preparedStatement, this.query);
        }

        @Override
        public LiveAggregateRepository.ThroughputAggregate mapRow(ResultSet resultSet) throws Exception {
            int i = 1;
            return ImmutableThroughputAggregate.builder().captureTime(resultSet.getLong(i++)).transactionCount(resultSet.getLong(i++)).errorCount(Long.valueOf(resultSet.getLong(i++))).build();
        }
    }

    private static class PercentileAggregateQuery
    implements DataSource.JdbcRowQuery<LiveAggregateRepository.PercentileAggregate> {
        private final LiveAggregateRepository.AggregateQuery query;

        private PercentileAggregateQuery(LiveAggregateRepository.AggregateQuery query) {
            this.query = query;
        }

        @Override
        public @Untainted String getSql() {
            String tableName = AggregateDao.getTableName(this.query);
            String transactionNameCriteria = AggregateDao.getTransactionNameCriteria(this.query);
            return "select capture_time, total_duration_nanos, transaction_count, duration_nanos_histogram from " + tableName + " where transaction_type = ?" + transactionNameCriteria + " and capture_time >= ? and capture_time <= ? order by capture_time";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            AggregateDao.bindQuery(preparedStatement, this.query);
        }

        @Override
        public LiveAggregateRepository.PercentileAggregate mapRow(ResultSet resultSet) throws Exception {
            int i = 1;
            ImmutablePercentileAggregate.Builder builder = ImmutablePercentileAggregate.builder().captureTime(resultSet.getLong(i++)).totalDurationNanos((double)resultSet.getLong(i++)).transactionCount(resultSet.getLong(i++));
            byte[] durationNanosHistogram = (byte[])Preconditions.checkNotNull((Object)resultSet.getBytes(i++));
            builder.durationNanosHistogram((AggregateOuterClass.Aggregate.Histogram)AggregateOuterClass.Aggregate.Histogram.parser().parseFrom(durationNanosHistogram));
            return builder.build();
        }
    }

    private static class OverviewAggregateQuery
    implements DataSource.JdbcRowQuery<LiveAggregateRepository.OverviewAggregate> {
        private final LiveAggregateRepository.AggregateQuery query;

        private OverviewAggregateQuery(LiveAggregateRepository.AggregateQuery query) {
            this.query = query;
        }

        @Override
        public @Untainted String getSql() {
            String tableName = AggregateDao.getTableName(this.query);
            String transactionNameCriteria = AggregateDao.getTransactionNameCriteria(this.query);
            return "select capture_time, total_duration_nanos, transaction_count, async_transactions, main_thread_root_timers, main_thread_total_cpu_nanos, main_thread_total_blocked_nanos, main_thread_total_waited_nanos, main_thread_total_allocated_bytes, aux_thread_root_timer, aux_thread_total_cpu_nanos, aux_thread_total_blocked_nanos, aux_thread_total_waited_nanos, aux_thread_total_allocated_bytes, async_timers from " + tableName + " where transaction_type = ?" + transactionNameCriteria + " and capture_time >= ? and capture_time <= ? order by capture_time";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            AggregateDao.bindQuery(preparedStatement, this.query);
        }

        @Override
        public LiveAggregateRepository.OverviewAggregate mapRow(ResultSet resultSet) throws Exception {
            byte[] mainThreadRootTimers;
            int i = 1;
            ImmutableOverviewAggregate.Builder builder = ImmutableOverviewAggregate.builder().captureTime(resultSet.getLong(i++)).totalDurationNanos(resultSet.getDouble(i++)).transactionCount(resultSet.getLong(i++)).asyncTransactions(resultSet.getBoolean(i++));
            if ((mainThreadRootTimers = resultSet.getBytes(i++)) != null) {
                builder.mainThreadRootTimers((Iterable)AggregateDao.readMessages(mainThreadRootTimers, AggregateOuterClass.Aggregate.Timer.parser()));
            }
            builder.mainThreadStats(AggregateOuterClass.Aggregate.ThreadStats.newBuilder().setTotalCpuNanos(AggregateDao.getNextThreadStat(resultSet, i++)).setTotalBlockedNanos(AggregateDao.getNextThreadStat(resultSet, i++)).setTotalWaitedNanos(AggregateDao.getNextThreadStat(resultSet, i++)).setTotalAllocatedBytes(AggregateDao.getNextThreadStat(resultSet, i++)).build());
            byte[] auxThreadRootTimers = resultSet.getBytes(i++);
            if (auxThreadRootTimers == null) {
                i += 4;
            } else {
                List list = AggregateDao.readMessages(auxThreadRootTimers, AggregateOuterClass.Aggregate.Timer.parser());
                builder.auxThreadRootTimer((AggregateOuterClass.Aggregate.Timer)list.get(0));
                builder.auxThreadStats(AggregateOuterClass.Aggregate.ThreadStats.newBuilder().setTotalCpuNanos(AggregateDao.getNextThreadStat(resultSet, i++)).setTotalBlockedNanos(AggregateDao.getNextThreadStat(resultSet, i++)).setTotalWaitedNanos(AggregateDao.getNextThreadStat(resultSet, i++)).setTotalAllocatedBytes(AggregateDao.getNextThreadStat(resultSet, i++)).build());
            }
            byte[] asyncTimers = resultSet.getBytes(i++);
            if (asyncTimers != null) {
                builder.asyncTimers((Iterable)AggregateDao.readMessages(asyncTimers, AggregateOuterClass.Aggregate.Timer.parser()));
            }
            return builder.build();
        }
    }

    private static class TransactionNameErrorSummaryQuery
    implements DataSource.JdbcQuery<Void> {
        private final LiveAggregateRepository.SummaryQuery query;
        private final TransactionNameErrorSummaryCollector.ErrorSummarySortOrder sortOrder;
        private final int limit;
        private final TransactionNameErrorSummaryCollector collector;

        private TransactionNameErrorSummaryQuery(LiveAggregateRepository.SummaryQuery query, TransactionNameErrorSummaryCollector.ErrorSummarySortOrder sortOrder, int limit, TransactionNameErrorSummaryCollector collector) {
            this.query = query;
            this.sortOrder = sortOrder;
            this.limit = limit;
            this.collector = collector;
        }

        @Override
        public @Untainted String getSql() {
            StringBuilder sb = new StringBuilder();
            sb.append("select transaction_name, sum(error_count), sum(transaction_count),");
            sb.append(" max(capture_time) from aggregate_tn_rollup_");
            sb.append(Checkers.castUntainted((Object)this.query.rollupLevel()));
            sb.append(" where transaction_type = ? and capture_time > ? and capture_time <= ? group by transaction_name having sum(error_count) > 0 order by ");
            sb.append(TransactionNameErrorSummaryQuery.getSortClause(this.sortOrder));
            sb.append(", transaction_name limit ?");
            return (String)Checkers.castUntainted((Object)sb.toString());
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            int i = 1;
            preparedStatement.setString(i++, this.query.transactionType());
            preparedStatement.setLong(i++, this.query.from());
            preparedStatement.setLong(i++, this.query.to());
            preparedStatement.setInt(i++, this.limit + 100);
        }

        @Override
        public @Nullable Void processResultSet(ResultSet resultSet) throws Exception {
            while (resultSet.next()) {
                int i = 1;
                String transactionName = (String)Preconditions.checkNotNull((Object)resultSet.getString(i++));
                long errorCount = resultSet.getLong(i++);
                long transactionCount = resultSet.getLong(i++);
                long maxCaptureTime = resultSet.getLong(i++);
                this.collector.collect(transactionName, errorCount, transactionCount, maxCaptureTime);
            }
            return null;
        }

        @Override
        public @Nullable Void valueIfDataSourceClosed() {
            return null;
        }

        private static @Untainted String getSortClause(TransactionNameErrorSummaryCollector.ErrorSummarySortOrder sortOrder) {
            switch (sortOrder) {
                case ERROR_COUNT: {
                    return "sum(error_count) desc";
                }
                case ERROR_RATE: {
                    return "sum(error_count) / sum(transaction_count) desc";
                }
            }
            throw new AssertionError((Object)("Unexpected sort order: " + sortOrder));
        }
    }

    private static class OverallErrorSummaryQuery
    implements DataSource.JdbcQuery<Void> {
        private final OverallErrorSummaryCollector collector;
        private final LiveAggregateRepository.SummaryQuery query;

        private OverallErrorSummaryQuery(OverallErrorSummaryCollector collector, LiveAggregateRepository.SummaryQuery query) {
            this.collector = collector;
            this.query = query;
        }

        @Override
        public @Untainted String getSql() {
            return "select sum(error_count), sum(transaction_count), max(capture_time) from aggregate_tt_rollup_" + Checkers.castUntainted((Object)this.query.rollupLevel()) + " where transaction_type = ? and capture_time > ? and capture_time <= ?";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws Exception {
            int i = 1;
            preparedStatement.setString(i++, this.query.transactionType());
            preparedStatement.setLong(i++, this.query.from());
            preparedStatement.setLong(i++, this.query.to());
        }

        @Override
        public @Nullable Void processResultSet(ResultSet resultSet) throws Exception {
            if (!resultSet.next()) {
                throw new SQLException("Aggregate query did not return any results");
            }
            int i = 1;
            long errorCount = resultSet.getLong(i++);
            long transactionCount = resultSet.getLong(i++);
            long captureTime = resultSet.getLong(i++);
            this.collector.mergeErrorSummary(errorCount, transactionCount, captureTime);
            return null;
        }

        @Override
        public @Nullable Void valueIfDataSourceClosed() {
            return null;
        }
    }

    private static class TransactionNameSummaryQuery
    implements DataSource.JdbcQuery<Void> {
        private final LiveAggregateRepository.SummaryQuery query;
        private final TransactionNameSummaryCollector.SummarySortOrder sortOrder;
        private final int limit;
        private final TransactionNameSummaryCollector collector;

        private TransactionNameSummaryQuery(LiveAggregateRepository.SummaryQuery query, TransactionNameSummaryCollector.SummarySortOrder sortOrder, int limit, TransactionNameSummaryCollector collector) {
            this.query = query;
            this.sortOrder = sortOrder;
            this.limit = limit;
            this.collector = collector;
        }

        @Override
        public @Untainted String getSql() {
            StringBuilder sb = new StringBuilder();
            sb.append("select transaction_name, sum(total_duration_nanos), sum(main_thread_total_cpu_nanos) + sum(aux_thread_total_cpu_nanos), sum(main_thread_total_allocated_bytes) + sum(aux_thread_total_allocated_bytes), sum(transaction_count), max(capture_time) from aggregate_tn_rollup_");
            sb.append(this.query.rollupLevel());
            sb.append(" where transaction_type = ? and capture_time > ? and capture_time <= ? group by transaction_name order by ");
            sb.append(TransactionNameSummaryQuery.getSortClause(this.sortOrder));
            sb.append(", transaction_name limit ?");
            return (String)Checkers.castUntainted((Object)sb.toString());
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            int i = 1;
            preparedStatement.setString(i++, this.query.transactionType());
            preparedStatement.setLong(i++, this.query.from());
            preparedStatement.setLong(i++, this.query.to());
            preparedStatement.setInt(i++, this.limit + 100);
        }

        @Override
        public @Nullable Void processResultSet(ResultSet resultSet) throws Exception {
            while (resultSet.next()) {
                int i = 1;
                String transactionName = (String)Preconditions.checkNotNull((Object)resultSet.getString(i++));
                double totalDurationNanos = resultSet.getDouble(i++);
                double totalCpuNanos = resultSet.getDouble(i++);
                double totalAllocatedBytes = resultSet.getDouble(i++);
                long transactionCount = resultSet.getLong(i++);
                long maxCaptureTime = resultSet.getLong(i++);
                this.collector.collect(transactionName, totalDurationNanos, totalCpuNanos, totalAllocatedBytes, transactionCount, maxCaptureTime);
            }
            return null;
        }

        @Override
        public @Nullable Void valueIfDataSourceClosed() {
            return null;
        }

        private static @Untainted String getSortClause(TransactionNameSummaryCollector.SummarySortOrder sortOrder) {
            switch (sortOrder) {
                case TOTAL_TIME: {
                    return "sum(total_duration_nanos) desc";
                }
                case AVERAGE_TIME: {
                    return "sum(total_duration_nanos) / sum(transaction_count) desc";
                }
                case THROUGHPUT: {
                    return "sum(transaction_count) desc";
                }
                case TOTAL_CPU_TIME: {
                    return "sum(main_thread_total_cpu_nanos) + sum(aux_thread_total_cpu_nanos) desc";
                }
                case AVERAGE_CPU_TIME: {
                    return "(sum(main_thread_total_cpu_nanos) + sum(aux_thread_total_cpu_nanos)) / sum(transaction_count) desc";
                }
                case TOTAL_ALLOCATED_MEMORY: {
                    return "sum(main_thread_total_allocated_bytes) + sum(aux_thread_total_allocated_bytes) desc";
                }
                case AVERAGE_ALLOCATED_MEMORY: {
                    return "(sum(main_thread_total_allocated_bytes) + sum(aux_thread_total_allocated_bytes)) / sum(transaction_count) desc";
                }
            }
            throw new AssertionError((Object)("Unexpected sort order: " + sortOrder));
        }
    }

    private static class OverallSummaryQuery
    implements DataSource.JdbcQuery<Void> {
        private final OverallSummaryCollector collector;
        private final LiveAggregateRepository.SummaryQuery query;

        private OverallSummaryQuery(OverallSummaryCollector collector, LiveAggregateRepository.SummaryQuery query) {
            this.collector = collector;
            this.query = query;
        }

        @Override
        public @Untainted String getSql() {
            return "select sum(total_duration_nanos), sum(main_thread_total_cpu_nanos) + sum(aux_thread_total_cpu_nanos), sum(main_thread_total_allocated_bytes) + sum(aux_thread_total_allocated_bytes), sum(transaction_count), max(capture_time) from aggregate_tt_rollup_" + Checkers.castUntainted((Object)this.query.rollupLevel()) + " where transaction_type = ? and capture_time > ? and capture_time <= ?";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws Exception {
            int i = 1;
            preparedStatement.setString(i++, this.query.transactionType());
            preparedStatement.setLong(i++, this.query.from());
            preparedStatement.setLong(i++, this.query.to());
        }

        @Override
        public @Nullable Void processResultSet(ResultSet resultSet) throws Exception {
            if (!resultSet.next()) {
                throw new SQLException("Aggregate query did not return any results");
            }
            int i = 1;
            double totalDurationNanos = resultSet.getDouble(i++);
            double totalCpuNanos = resultSet.getDouble(i++);
            double totalAllocatedBytes = resultSet.getDouble(i++);
            long transactionCount = resultSet.getLong(i++);
            long captureTime = resultSet.getLong(i++);
            this.collector.mergeSummary(totalDurationNanos, totalCpuNanos, totalAllocatedBytes, transactionCount, captureTime);
            return null;
        }

        @Override
        public @Nullable Void valueIfDataSourceClosed() {
            return null;
        }
    }
}

