/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.repo;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.agent.embedded.repo.AggregateDao;
import org.glowroot.agent.embedded.repo.proto.Stored;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.MutableAggregate;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.MutableThreadStats;
import org.glowroot.agent.embedded.sql.SQLException;
import org.glowroot.agent.embedded.util.CappedDatabase;
import org.glowroot.agent.embedded.util.DataSource;
import org.glowroot.agent.embedded.util.RowMappers;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.protobuf.AbstractMessage;
import org.glowroot.agent.shaded.org.glowroot.common.model.LazyHistogram;
import org.glowroot.agent.shaded.org.glowroot.common.model.MutableProfile;
import org.glowroot.agent.shaded.org.glowroot.common.model.MutableQuery;
import org.glowroot.agent.shaded.org.glowroot.common.model.MutableServiceCall;
import org.glowroot.agent.shaded.org.glowroot.common.model.QueryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.ServiceCallCollector;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.ProfileOuterClass;
import org.glowroot.agent.util.Checkers;

class AggregateInsert
implements DataSource.JdbcUpdate {
    private final String transactionType;
    private final @Nullable String transactionName;
    private final long captureTime;
    private final double totalDurationNanos;
    private final long transactionCount;
    private final long errorCount;
    private final boolean asyncTransactions;
    private final @Nullable Long queriesCappedId;
    private final @Nullable Long serviceCallsCappedId;
    private final @Nullable Long mainThreadProfileCappedId;
    private final @Nullable Long auxThreadProfileCappedId;
    private final byte[] mainThreadRootTimers;
    private final double mainThreadTotalCpuNanos;
    private final double mainThreadTotalBlockedNanos;
    private final double mainThreadTotalWaitedNanos;
    private final double mainThreadTotalAllocatedBytes;
    private final byte[] auxThreadRootTimer;
    private final double auxThreadTotalCpuNanos;
    private final double auxThreadTotalBlockedNanos;
    private final double auxThreadTotalWaitedNanos;
    private final double auxThreadTotalAllocatedBytes;
    private final byte[] asyncTimers;
    private final byte[] durationNanosHistogramBytes;
    private final int rollupLevel;

    AggregateInsert(String transactionType, @Nullable String transactionName, long captureTime, AggregateOuterClass.Aggregate aggregate, List<AggregateDao.TruncatedQueryText> truncatedQueryTexts, int rollupLevel, CappedDatabase cappedDatabase) throws IOException {
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        this.captureTime = captureTime;
        this.rollupLevel = rollupLevel;
        this.totalDurationNanos = aggregate.getTotalDurationNanos();
        this.transactionCount = aggregate.getTransactionCount();
        this.errorCount = aggregate.getErrorCount();
        this.asyncTransactions = aggregate.getAsyncTransactions();
        this.queriesCappedId = AggregateInsert.writeQueries(cappedDatabase, AggregateInsert.toStored(aggregate.getQueryList(), truncatedQueryTexts));
        this.serviceCallsCappedId = AggregateInsert.writeServiceCalls(cappedDatabase, AggregateInsert.toStored(aggregate.getServiceCallList()));
        this.mainThreadProfileCappedId = aggregate.hasMainThreadProfile() ? AggregateInsert.writeProfile(cappedDatabase, aggregate.getMainThreadProfile()) : null;
        this.auxThreadProfileCappedId = aggregate.hasAuxThreadProfile() ? AggregateInsert.writeProfile(cappedDatabase, aggregate.getAuxThreadProfile()) : null;
        this.mainThreadRootTimers = AggregateInsert.toByteArray(aggregate.getMainThreadRootTimerList());
        AggregateOuterClass.Aggregate.ThreadStats mainThreadStats = aggregate.getMainThreadStats();
        this.mainThreadTotalCpuNanos = mainThreadStats.getTotalCpuNanos();
        this.mainThreadTotalBlockedNanos = mainThreadStats.getTotalBlockedNanos();
        this.mainThreadTotalWaitedNanos = mainThreadStats.getTotalWaitedNanos();
        this.mainThreadTotalAllocatedBytes = mainThreadStats.getTotalAllocatedBytes();
        if (aggregate.hasAuxThreadRootTimer()) {
            this.auxThreadRootTimer = AggregateInsert.toByteArray((List<? extends AbstractMessage>)ImmutableList.of((Object)aggregate.getAuxThreadRootTimer()));
            AggregateOuterClass.Aggregate.ThreadStats auxThreadStats = aggregate.getAuxThreadStats();
            this.auxThreadTotalCpuNanos = auxThreadStats.getTotalCpuNanos();
            this.auxThreadTotalBlockedNanos = auxThreadStats.getTotalBlockedNanos();
            this.auxThreadTotalWaitedNanos = auxThreadStats.getTotalWaitedNanos();
            this.auxThreadTotalAllocatedBytes = auxThreadStats.getTotalAllocatedBytes();
        } else {
            this.auxThreadRootTimer = null;
            this.auxThreadTotalCpuNanos = 0.0;
            this.auxThreadTotalBlockedNanos = 0.0;
            this.auxThreadTotalWaitedNanos = 0.0;
            this.auxThreadTotalAllocatedBytes = 0.0;
        }
        this.asyncTimers = AggregateInsert.toByteArray(aggregate.getAsyncTimerList());
        this.durationNanosHistogramBytes = aggregate.getDurationNanosHistogram().toByteArray();
    }

    AggregateInsert(String transactionType, @Nullable String transactionName, long captureTime, MutableAggregate aggregate, int rollupLevel, CappedDatabase cappedDatabase, LazyHistogram.ScratchBuffer scratchBuffer) throws IOException {
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        this.captureTime = captureTime;
        this.rollupLevel = rollupLevel;
        this.totalDurationNanos = aggregate.getTotalDurationNanos();
        this.transactionCount = aggregate.getTransactionCount();
        this.errorCount = aggregate.getErrorCount();
        this.asyncTransactions = aggregate.isAsyncTransactions();
        this.queriesCappedId = AggregateInsert.writeQueries(cappedDatabase, AggregateInsert.toStored(aggregate.getQueries()));
        this.serviceCallsCappedId = AggregateInsert.writeServiceCalls(cappedDatabase, AggregateInsert.toStored(aggregate.getServiceCalls()));
        this.mainThreadProfileCappedId = AggregateInsert.writeProfile(cappedDatabase, aggregate.getMainThreadProfile());
        this.auxThreadProfileCappedId = AggregateInsert.writeProfile(cappedDatabase, aggregate.getAuxThreadProfile());
        this.mainThreadRootTimers = AggregateInsert.toByteArray(aggregate.getMainThreadRootTimersProto());
        MutableThreadStats mainThreadStats = aggregate.getMainThreadStats();
        this.mainThreadTotalCpuNanos = mainThreadStats.getTotalCpuNanos();
        this.mainThreadTotalBlockedNanos = mainThreadStats.getTotalBlockedNanos();
        this.mainThreadTotalWaitedNanos = mainThreadStats.getTotalWaitedNanos();
        this.mainThreadTotalAllocatedBytes = mainThreadStats.getTotalAllocatedBytes();
        AggregateOuterClass.Aggregate.Timer auxThreadRootTimer = aggregate.getAuxThreadRootTimerProto();
        if (auxThreadRootTimer == null) {
            this.auxThreadRootTimer = null;
            this.auxThreadTotalCpuNanos = 0.0;
            this.auxThreadTotalBlockedNanos = 0.0;
            this.auxThreadTotalWaitedNanos = 0.0;
            this.auxThreadTotalAllocatedBytes = 0.0;
        } else {
            this.auxThreadRootTimer = AggregateInsert.toByteArray((List<? extends AbstractMessage>)ImmutableList.of((Object)auxThreadRootTimer));
            MutableThreadStats auxThreadStats = (MutableThreadStats)Preconditions.checkNotNull((Object)aggregate.getAuxThreadStats());
            this.auxThreadTotalCpuNanos = auxThreadStats.getTotalCpuNanos();
            this.auxThreadTotalBlockedNanos = auxThreadStats.getTotalBlockedNanos();
            this.auxThreadTotalWaitedNanos = auxThreadStats.getTotalWaitedNanos();
            this.auxThreadTotalAllocatedBytes = auxThreadStats.getTotalAllocatedBytes();
        }
        this.asyncTimers = AggregateInsert.toByteArray(aggregate.getAsyncTimersProto());
        this.durationNanosHistogramBytes = aggregate.getDurationNanosHistogram().toProto(scratchBuffer).toByteArray();
    }

    @Override
    public @Untainted String getSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("merge into aggregate_");
        if (this.transactionName != null) {
            sb.append("tn_");
        } else {
            sb.append("tt_");
        }
        sb.append("rollup_");
        sb.append(Checkers.castUntainted((Object)this.rollupLevel));
        sb.append(" (transaction_type,");
        if (this.transactionName != null) {
            sb.append(" transaction_name,");
        }
        sb.append(" capture_time, total_duration_nanos, transaction_count, error_count, async_transactions, queries_capped_id, service_calls_capped_id, main_thread_profile_capped_id, aux_thread_profile_capped_id, main_thread_root_timers, main_thread_total_cpu_nanos, main_thread_total_blocked_nanos, main_thread_total_waited_nanos, main_thread_total_allocated_bytes, aux_thread_root_timer, aux_thread_total_cpu_nanos, aux_thread_total_blocked_nanos, aux_thread_total_waited_nanos, aux_thread_total_allocated_bytes, async_timers, duration_nanos_histogram) key (transaction_type");
        if (this.transactionName != null) {
            sb.append(", transaction_name");
        }
        sb.append(", capture_time) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?");
        if (this.transactionName != null) {
            sb.append(", ?");
        }
        sb.append(")");
        return (String)Checkers.castUntainted((Object)sb.toString());
    }

    @Override
    public void bind(PreparedStatement preparedStatement) throws SQLException {
        int i = 1;
        preparedStatement.setString(i++, this.transactionType);
        if (this.transactionName != null) {
            preparedStatement.setString(i++, this.transactionName);
        }
        preparedStatement.setLong(i++, this.captureTime);
        preparedStatement.setDouble(i++, this.totalDurationNanos);
        preparedStatement.setLong(i++, this.transactionCount);
        preparedStatement.setLong(i++, this.errorCount);
        preparedStatement.setBoolean(i++, this.asyncTransactions);
        RowMappers.setLong(preparedStatement, i++, this.queriesCappedId);
        RowMappers.setLong(preparedStatement, i++, this.serviceCallsCappedId);
        RowMappers.setLong(preparedStatement, i++, this.mainThreadProfileCappedId);
        RowMappers.setLong(preparedStatement, i++, this.auxThreadProfileCappedId);
        RowMappers.setBytes(preparedStatement, i++, this.mainThreadRootTimers);
        preparedStatement.setDouble(i++, this.mainThreadTotalCpuNanos);
        preparedStatement.setDouble(i++, this.mainThreadTotalBlockedNanos);
        preparedStatement.setDouble(i++, this.mainThreadTotalWaitedNanos);
        preparedStatement.setDouble(i++, this.mainThreadTotalAllocatedBytes);
        RowMappers.setBytes(preparedStatement, i++, this.auxThreadRootTimer);
        preparedStatement.setDouble(i++, this.auxThreadTotalCpuNanos);
        preparedStatement.setDouble(i++, this.auxThreadTotalBlockedNanos);
        preparedStatement.setDouble(i++, this.auxThreadTotalWaitedNanos);
        preparedStatement.setDouble(i++, this.auxThreadTotalAllocatedBytes);
        RowMappers.setBytes(preparedStatement, i++, this.asyncTimers);
        preparedStatement.setBytes(i++, this.durationNanosHistogramBytes);
    }

    private static List<Stored.QueriesByType> toStored(List<AggregateOuterClass.Aggregate.Query> aggregateQueries, List<AggregateDao.TruncatedQueryText> truncatedQueryTexts) {
        HashMap builders = Maps.newHashMap();
        for (AggregateOuterClass.Aggregate.Query aggregateQuery : aggregateQueries) {
            String queryType;
            Stored.QueriesByType.Builder queriesByType;
            AggregateDao.TruncatedQueryText truncatedQueryText = truncatedQueryTexts.get(aggregateQuery.getSharedQueryTextIndex());
            Stored.Query.Builder query = Stored.Query.newBuilder().setTruncatedText(truncatedQueryText.truncatedText()).setFullTextSha1(Strings.nullToEmpty((String)truncatedQueryText.fullTextSha1())).setTotalDurationNanos(aggregateQuery.getTotalDurationNanos()).setExecutionCount(aggregateQuery.getExecutionCount());
            if (aggregateQuery.hasTotalRows()) {
                query.setTotalRows(Stored.OptionalInt64.newBuilder().setValue(aggregateQuery.getTotalRows().getValue()).build());
            }
            if ((queriesByType = (Stored.QueriesByType.Builder)builders.get(queryType = aggregateQuery.getType())) == null) {
                queriesByType = Stored.QueriesByType.newBuilder().setType(queryType);
                builders.put(queryType, queriesByType);
            }
            queriesByType.addQuery(query.build());
        }
        ArrayList queries = Lists.newArrayList();
        for (Stored.QueriesByType.Builder builder : builders.values()) {
            queries.add(builder.build());
        }
        return queries;
    }

    private static List<Stored.QueriesByType> toStored(@Nullable QueryCollector collector) {
        if (collector == null) {
            return ImmutableList.of();
        }
        HashMap builders = Maps.newHashMap();
        for (MutableQuery mutableQuery : collector.getSortedAndTruncatedQueries()) {
            String queryType;
            Stored.QueriesByType.Builder queriesByType;
            Stored.Query.Builder query = Stored.Query.newBuilder().setTruncatedText(mutableQuery.getTruncatedText()).setFullTextSha1(Strings.nullToEmpty((String)mutableQuery.getFullTextSha1())).setTotalDurationNanos(mutableQuery.getTotalDurationNanos()).setExecutionCount(mutableQuery.getExecutionCount());
            if (mutableQuery.hasTotalRows()) {
                query.setTotalRows(Stored.OptionalInt64.newBuilder().setValue(mutableQuery.getTotalRows()).build());
            }
            if ((queriesByType = (Stored.QueriesByType.Builder)builders.get(queryType = mutableQuery.getType())) == null) {
                queriesByType = Stored.QueriesByType.newBuilder().setType(queryType);
                builders.put(queryType, queriesByType);
            }
            queriesByType.addQuery(query.build());
        }
        ArrayList queries = Lists.newArrayList();
        for (Stored.QueriesByType.Builder builder : builders.values()) {
            queries.add(builder.build());
        }
        return queries;
    }

    private static List<Stored.ServiceCallsByType> toStored(List<AggregateOuterClass.Aggregate.ServiceCall> aggregateServiceCalls) {
        HashMap builders = Maps.newHashMap();
        for (AggregateOuterClass.Aggregate.ServiceCall aggregateServiceCall : aggregateServiceCalls) {
            Stored.ServiceCall.Builder serviceCall = Stored.ServiceCall.newBuilder().setText(aggregateServiceCall.getText()).setTotalDurationNanos(aggregateServiceCall.getTotalDurationNanos()).setExecutionCount(aggregateServiceCall.getExecutionCount());
            String serviceCallType = aggregateServiceCall.getType();
            Stored.ServiceCallsByType.Builder serviceCallsByType = (Stored.ServiceCallsByType.Builder)builders.get(serviceCallType);
            if (serviceCallsByType == null) {
                serviceCallsByType = Stored.ServiceCallsByType.newBuilder().setType(serviceCallType);
                builders.put(serviceCallType, serviceCallsByType);
            }
            serviceCallsByType.addServiceCall(serviceCall.build());
        }
        ArrayList serviceCalls = Lists.newArrayList();
        for (Stored.ServiceCallsByType.Builder builder : builders.values()) {
            serviceCalls.add(builder.build());
        }
        return serviceCalls;
    }

    private static List<Stored.ServiceCallsByType> toStored(@Nullable ServiceCallCollector collector) {
        if (collector == null) {
            return ImmutableList.of();
        }
        HashMap builders = Maps.newHashMap();
        for (MutableServiceCall mutableServiceCall : collector.getSortedAndTruncatedServiceCalls()) {
            Stored.ServiceCall.Builder serviceCall = Stored.ServiceCall.newBuilder().setText(mutableServiceCall.getText()).setTotalDurationNanos(mutableServiceCall.getTotalDurationNanos()).setExecutionCount(mutableServiceCall.getExecutionCount());
            String serviceCallType = mutableServiceCall.getType();
            Stored.ServiceCallsByType.Builder serviceCallsByType = (Stored.ServiceCallsByType.Builder)builders.get(serviceCallType);
            if (serviceCallsByType == null) {
                serviceCallsByType = Stored.ServiceCallsByType.newBuilder().setType(serviceCallType);
                builders.put(serviceCallType, serviceCallsByType);
            }
            serviceCallsByType.addServiceCall(serviceCall.build());
        }
        ArrayList serviceCalls = Lists.newArrayList();
        for (Stored.ServiceCallsByType.Builder builder : builders.values()) {
            serviceCalls.add(builder.build());
        }
        return serviceCalls;
    }

    private static @Nullable Long writeQueries(CappedDatabase cappedDatabase, List<Stored.QueriesByType> queries) throws IOException {
        if (queries.isEmpty()) {
            return null;
        }
        return cappedDatabase.writeMessages(queries, "aggregate queries");
    }

    private static @Nullable Long writeServiceCalls(CappedDatabase cappedDatabase, List<Stored.ServiceCallsByType> serviceCalls) throws IOException {
        if (serviceCalls.isEmpty()) {
            return null;
        }
        return cappedDatabase.writeMessages(serviceCalls, "aggregate service calls");
    }

    private static @Nullable Long writeProfile(CappedDatabase cappedDatabase, @Nullable MutableProfile profile) throws IOException {
        if (profile == null) {
            return null;
        }
        return cappedDatabase.writeMessage((AbstractMessage)profile.toProto(), "aggregate profiles");
    }

    private static @Nullable Long writeProfile(CappedDatabase cappedDatabase, ProfileOuterClass.Profile profile) throws IOException {
        return cappedDatabase.writeMessage((AbstractMessage)profile, "aggregate profiles");
    }

    private static byte[] toByteArray(List<? extends AbstractMessage> messages) throws IOException {
        if (messages.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (AbstractMessage abstractMessage : messages) {
            abstractMessage.writeDelimitedTo((OutputStream)baos);
        }
        return baos.toByteArray();
    }
}

