/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.repo;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.agent.embedded.repo.ImmutableGaugeNameRow;
import org.glowroot.agent.embedded.sql.SQLException;
import org.glowroot.agent.embedded.util.DataSource;
import org.glowroot.agent.embedded.util.ImmutableColumn;
import org.glowroot.agent.embedded.util.ImmutableIndex;
import org.glowroot.agent.embedded.util.Schemas;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.cache.Cache;
import org.glowroot.agent.shaded.com.google.common.cache.CacheBuilder;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.org.glowroot.common.util.CaptureTimes;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.immutables.value.Value;

class GaugeNameDao {
    static final ImmutableList<Schemas.Column> columns = ImmutableList.of((Object)ImmutableColumn.of("capture_time", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("gauge_name", Schemas.ColumnType.VARCHAR));
    static final ImmutableList<Schemas.Index> indexes = ImmutableList.of((Object)ImmutableIndex.of("gauge_idx", (ImmutableList<String>)ImmutableList.of((Object)"capture_time", (Object)"gauge_name")));
    private final DataSource dataSource;
    private final Cache<GaugeNameRow, Boolean> rowInsertedInThePastDay = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(10000L).build();
    private final Object lock = new Object();

    GaugeNameDao(DataSource dataSource) throws Exception {
        this.dataSource = dataSource;
        dataSource.syncTable("gauge_name", (List<Schemas.Column>)columns);
        dataSource.syncIndexes("gauge_name", indexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insert(long captureTime, String gaugeName) throws SQLException {
        long rollupCaptureTime = CaptureTimes.getRollup((long)captureTime, (long)TimeUnit.DAYS.toMillis(1L));
        ImmutableGaugeNameRow key = ImmutableGaugeNameRow.of(rollupCaptureTime, gaugeName);
        if (this.rowInsertedInThePastDay.getIfPresent((Object)key) != null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.dataSource.update("merge into gauge_name (capture_time, gauge_name) key (capture_time, gauge_name) values (?, ?)", rollupCaptureTime, gaugeName);
        }
        this.rowInsertedInThePastDay.put((Object)key, (Object)true);
    }

    Set<String> readAllGaugeNames(long from, long to) {
        try {
            return this.dataSource.query(new GaugeNameQuery(from, to));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void deleteBefore(long captureTime) throws SQLException {
        this.dataSource.deleteBeforeUsingLock("gauge_name", "capture_time", captureTime, this.lock);
    }

    void invalidateCache() {
        this.rowInsertedInThePastDay.invalidateAll();
    }

    private static class GaugeNameQuery
    implements DataSource.JdbcQuery<Set<String>> {
        private final long from;
        private final long to;

        private GaugeNameQuery(long from, long to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public @Untainted String getSql() {
            return "select gauge_name from gauge_name where capture_time >= ? and capture_time <= ?";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            long rolledUpFrom = CaptureTimes.getRollup((long)this.from, (long)TimeUnit.DAYS.toMillis(1L));
            long rolledUpTo = CaptureTimes.getRollup((long)this.to, (long)TimeUnit.DAYS.toMillis(1L));
            preparedStatement.setLong(1, rolledUpFrom);
            preparedStatement.setLong(2, rolledUpTo);
        }

        @Override
        public Set<String> processResultSet(ResultSet resultSet) throws Exception {
            HashSet gaugeNames = Sets.newHashSet();
            while (resultSet.next()) {
                gaugeNames.add((String)Preconditions.checkNotNull((Object)resultSet.getString(1)));
            }
            return gaugeNames;
        }

        @Override
        public Set<String> valueIfDataSourceClosed() {
            return ImmutableSet.of();
        }
    }

    @Value.Immutable
    @Styles.AllParameters
    static interface GaugeNameRow {
        public long captureTime();

        public String gaugeName();
    }
}

