/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.repo;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.Encryption;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.LazySecretKey;
import org.glowroot.agent.shaded.com.google.common.io.Files;

class LazySecretKeyImpl
implements LazySecretKey {
    private static final String SECRET_FILE_NAME = "secret";
    private final List<File> confDirs;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private @MonotonicNonNull SecretKey secretKey;

    LazySecretKeyImpl(List<File> confDirs) {
        this.confDirs = confDirs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable SecretKey getExisting() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            File secretFile;
            if (this.secretKey == null && (secretFile = LazySecretKeyImpl.getSecretFile(this.confDirs)) != null) {
                this.secretKey = LazySecretKeyImpl.loadKey(secretFile);
            }
            return this.secretKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecretKey getOrCreate() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.secretKey == null) {
                File secretFile = LazySecretKeyImpl.getSecretFile(this.confDirs);
                if (secretFile == null) {
                    secretFile = new File(this.confDirs.get(0), SECRET_FILE_NAME);
                    this.secretKey = Encryption.generateNewKey();
                    Files.write((byte[])this.secretKey.getEncoded(), (File)secretFile);
                } else {
                    this.secretKey = LazySecretKeyImpl.loadKey(secretFile);
                }
            }
            return this.secretKey;
        }
    }

    private static @Nullable File getSecretFile(List<File> confDirs) {
        for (File confDir : confDirs) {
            File secretFile = new File(confDir, SECRET_FILE_NAME);
            if (!secretFile.exists()) continue;
            return secretFile;
        }
        return null;
    }

    private static SecretKey loadKey(File secretFile) throws IOException {
        byte[] bytes = Files.toByteArray((File)secretFile);
        return new SecretKeySpec(bytes, "AES");
    }
}

