/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.repo;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.agent.embedded.repo.ImmutableTraceAttributeNameKey;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.TraceAttributeNameRepository;
import org.glowroot.agent.embedded.sql.SQLException;
import org.glowroot.agent.embedded.util.DataSource;
import org.glowroot.agent.embedded.util.ImmutableColumn;
import org.glowroot.agent.embedded.util.ImmutableIndex;
import org.glowroot.agent.embedded.util.Schemas;
import org.glowroot.agent.shaded.com.google.common.cache.Cache;
import org.glowroot.agent.shaded.com.google.common.cache.CacheBuilder;
import org.glowroot.agent.shaded.com.google.common.collect.ArrayListMultimap;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.common.collect.ListMultimap;
import org.glowroot.agent.shaded.com.google.common.collect.Multimaps;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.immutables.value.Value;

class TraceAttributeNameDao
implements TraceAttributeNameRepository {
    private static final ImmutableList<Schemas.Column> columns = ImmutableList.of((Object)ImmutableColumn.of("transaction_type", Schemas.ColumnType.VARCHAR), (Object)ImmutableColumn.of("trace_attribute_name", Schemas.ColumnType.VARCHAR), (Object)ImmutableColumn.of("last_capture_time", Schemas.ColumnType.BIGINT));
    private static final ImmutableList<Schemas.Index> indexes = ImmutableList.of((Object)ImmutableIndex.of("trace_attribute_name_idx", (ImmutableList<String>)ImmutableList.of((Object)"transaction_type", (Object)"trace_attribute_name")));
    private final DataSource dataSource;
    private final Cache<TraceAttributeNameKey, Boolean> lastCaptureTimeUpdatedInThePastDay = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(10000L).build();
    private final Object lock = new Object();

    TraceAttributeNameDao(DataSource dataSource) throws Exception {
        this.dataSource = dataSource;
        dataSource.syncTable("trace_attribute_name", (List<Schemas.Column>)columns);
        dataSource.syncIndexes("trace_attribute_name", indexes);
    }

    @Override
    public Map<String, List<String>> read(String agentRollupId) throws Exception {
        return this.dataSource.query(new TraceAttributeQuery());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLastCaptureTime(String transactionType, String traceAttributeName, long captureTime) throws Exception {
        ImmutableTraceAttributeNameKey key = ImmutableTraceAttributeNameKey.of(transactionType, traceAttributeName);
        if (this.lastCaptureTimeUpdatedInThePastDay.getIfPresent((Object)key) != null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            int updateCount = this.dataSource.update("update trace_attribute_name set last_capture_time = ? where transaction_type = ? and trace_attribute_name = ?", captureTime, transactionType, traceAttributeName);
            if (updateCount == 0) {
                this.dataSource.update("insert into trace_attribute_name (transaction_type, trace_attribute_name, last_capture_time) values (?, ?, ?)", transactionType, traceAttributeName, captureTime);
            }
        }
        this.lastCaptureTimeUpdatedInThePastDay.put((Object)key, (Object)true);
    }

    void deleteBefore(long captureTime) throws SQLException {
        this.dataSource.deleteBeforeUsingLock("trace_attribute_name", "last_capture_time", captureTime - TimeUnit.DAYS.toMillis(1L), this.lock);
    }

    void invalidateCache() {
        this.lastCaptureTimeUpdatedInThePastDay.invalidateAll();
    }

    @Value.Immutable
    @Styles.AllParameters
    static interface TraceAttributeNameKey {
        public String transactionType();

        public String traceAttributeName();
    }

    private static class TraceAttributeQuery
    implements DataSource.JdbcQuery<Map<String, List<String>>> {
        private TraceAttributeQuery() {
        }

        @Override
        public @Untainted String getSql() {
            return "select transaction_type, trace_attribute_name from trace_attribute_name";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) {
        }

        @Override
        public Map<String, List<String>> processResultSet(ResultSet resultSet) throws Exception {
            ArrayListMultimap multimap = ArrayListMultimap.create();
            while (resultSet.next()) {
                multimap.put((Object)resultSet.getString(1), (Object)resultSet.getString(2));
            }
            return Multimaps.asMap((ListMultimap)multimap);
        }

        @Override
        public Map<String, List<String>> valueIfDataSourceClosed() {
            return ImmutableMap.of();
        }
    }
}

