/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.repo;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.agent.embedded.repo.ImmutableParameterizedSql;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.TraceRepository;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveTraceRepository;
import org.glowroot.agent.shaded.org.glowroot.common.live.StringComparator;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.immutables.value.Value;

class TracePointQueryBuilder {
    private final LiveTraceRepository.TraceKind traceKind;
    private final TraceRepository.TraceQuery query;
    private final LiveTraceRepository.TracePointFilter filter;
    private final int limit;

    TracePointQueryBuilder(LiveTraceRepository.TraceKind traceKind, TraceRepository.TraceQuery query, LiveTraceRepository.TracePointFilter filter, int limit) {
        this.traceKind = traceKind;
        this.query = query;
        this.filter = filter;
        this.limit = limit;
    }

    ParameterizedSql getParameterizedSql() {
        ParameterizedSqlBuilder builder = new ParameterizedSqlBuilder();
        builder.appendText("select trace.id, trace.capture_time, trace.duration_nanos, trace.partial, trace.error from trace");
        ParameterizedSql criteria = this.getAttributeCriteria();
        if (criteria == null) {
            builder.appendText(" where");
        } else {
            builder.appendText(", trace_attribute attr where attr.trace_id = trace.id and attr.capture_time > ? and attr.capture_time <= ? and" + criteria.sql());
            builder.addArg(this.query.from());
            builder.addArg(this.query.to());
            builder.addArgs((List<Object>)criteria.args());
        }
        builder.appendText(" trace.capture_time > ? and trace.capture_time <= ?");
        builder.addArg(this.query.from());
        builder.addArg(this.query.to());
        this.appendTraceKindCriteria(builder);
        this.appendTransactionTypeCriteria(builder);
        this.appendTransactionNameCriteria(builder);
        this.appendDurationNanosCriteria(builder);
        this.appendHeadlineCriteria(builder);
        this.appendErrorCriteria(builder);
        this.appendUserCriteria(builder);
        this.appendOrderByAndLimit(builder);
        return builder.build();
    }

    private @Nullable ParameterizedSql getAttributeCriteria() {
        String sql = "";
        ArrayList args = Lists.newArrayList();
        String attributeName = this.filter.attributeName();
        if (!Strings.isNullOrEmpty((String)attributeName)) {
            sql = sql + " upper(attr.name) = ? and";
            args.add(attributeName.toUpperCase(Locale.ENGLISH));
        }
        StringComparator attributeValueComparator = this.filter.attributeValueComparator();
        String attributeValue = this.filter.attributeValue();
        if (attributeValueComparator != null && !Strings.isNullOrEmpty((String)attributeValue)) {
            sql = sql + " upper(attr.value) " + attributeValueComparator.getComparator() + " ? and";
            args.add(attributeValueComparator.formatParameter(attributeValue));
        }
        if (sql.isEmpty()) {
            return null;
        }
        return ImmutableParameterizedSql.of(sql, args);
    }

    private void appendTraceKindCriteria(ParameterizedSqlBuilder builder) {
        if (this.traceKind == LiveTraceRepository.TraceKind.SLOW) {
            builder.appendText(" and trace.slow = ?");
            builder.addArg(true);
        } else {
            builder.appendText(" and trace.error = ?");
            builder.addArg(true);
        }
    }

    private void appendTransactionTypeCriteria(ParameterizedSqlBuilder builder) {
        builder.appendText(" and trace.transaction_type = ?");
        builder.addArg(this.query.transactionType());
    }

    private void appendTransactionNameCriteria(ParameterizedSqlBuilder builder) {
        String transactionName = this.query.transactionName();
        if (transactionName != null) {
            builder.appendText(" and trace.transaction_name = ?");
            builder.addArg(transactionName);
        }
    }

    private void appendDurationNanosCriteria(ParameterizedSqlBuilder builder) {
        Long durationNanosHigh;
        long durationNanosLow = this.filter.durationNanosLow();
        if (durationNanosLow > 0L) {
            builder.appendText(" and trace.duration_nanos >= ?");
            builder.addArg(durationNanosLow);
        }
        if ((durationNanosHigh = this.filter.durationNanosHigh()) != null) {
            builder.appendText(" and trace.duration_nanos <= ?");
            builder.addArg(durationNanosHigh);
        }
    }

    private void appendHeadlineCriteria(ParameterizedSqlBuilder builder) {
        StringComparator headlineComparator = this.filter.headlineComparator();
        String headline = this.filter.headline();
        if (headlineComparator != null && !Strings.isNullOrEmpty((String)headline)) {
            builder.appendText(" and upper(trace.headline) " + headlineComparator.getComparator() + " ?");
            builder.addArg(headlineComparator.formatParameter(headline));
        }
    }

    private void appendErrorCriteria(ParameterizedSqlBuilder builder) {
        StringComparator errorComparator = this.filter.errorMessageComparator();
        String error = this.filter.errorMessage();
        if (errorComparator != null && !Strings.isNullOrEmpty((String)error)) {
            builder.appendText(" and upper(trace.error_message) " + errorComparator.getComparator() + " ?");
            builder.addArg(errorComparator.formatParameter(error));
        }
    }

    private void appendUserCriteria(ParameterizedSqlBuilder builder) {
        StringComparator userComparator = this.filter.userComparator();
        String user = this.filter.user();
        if (userComparator != null && !Strings.isNullOrEmpty((String)user)) {
            builder.appendText(" and upper(trace.user) " + userComparator.getComparator() + " ?");
            builder.addArg(userComparator.formatParameter(user));
        }
    }

    private void appendOrderByAndLimit(ParameterizedSqlBuilder builder) {
        builder.appendText(" order by trace.duration_nanos");
        if (this.limit != 0) {
            builder.appendText(" desc limit ?");
            builder.addArg(this.limit + 1);
        }
    }

    private static class ParameterizedSqlBuilder {
        private @Untainted String sql = "";
        private final List<Object> args = Lists.newArrayList();

        private ParameterizedSqlBuilder() {
        }

        private void appendText(@Untainted String sql) {
            this.sql = this.sql + sql;
        }

        public void addArg(Object arg) {
            this.args.add(arg);
        }

        public void addArgs(List<Object> args) {
            this.args.addAll(args);
        }

        private ParameterizedSql build() {
            return ImmutableParameterizedSql.of(this.sql, this.args);
        }
    }

    @Value.Immutable
    @Styles.AllParameters
    static abstract class ParameterizedSql {
        ParameterizedSql() {
        }

        abstract @Untainted String sql();

        abstract ImmutableList<Object> args();
    }
}

