/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.config;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.RoleConfig;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RoleConfig", generator="Immutables")
@Immutable
public final class ImmutableRoleConfig
extends RoleConfig {
    private final String name;
    private final ImmutableSet<String> permissions;
    private final boolean central;
    private final transient ImmutableSet<RoleConfig.SimplePermission> simplePermissions;
    private final transient String version;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRoleConfig(Builder builder) {
        this.name = builder.name;
        this.permissions = builder.permissions.build();
        if (builder.centralIsSet()) {
            this.initShim.central(builder.central);
        }
        this.central = this.initShim.central();
        this.simplePermissions = this.initShim.simplePermissions();
        this.version = this.initShim.version();
        this.initShim = null;
    }

    private ImmutableRoleConfig(String name, ImmutableSet<String> permissions, boolean central) {
        this.name = name;
        this.permissions = permissions;
        this.initShim.central(central);
        this.central = this.initShim.central();
        this.simplePermissions = this.initShim.simplePermissions();
        this.version = this.initShim.version();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="permissions")
    public ImmutableSet<String> permissions() {
        return this.permissions;
    }

    @Override
    @JsonProperty(value="central")
    @JsonIgnore
    public boolean central() {
        InitShim shim = this.initShim;
        return shim != null ? shim.central() : this.central;
    }

    @Override
    @JsonProperty(value="simplePermissions")
    @JsonIgnore
    public ImmutableSet<RoleConfig.SimplePermission> simplePermissions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.simplePermissions() : this.simplePermissions;
    }

    @Override
    @JsonProperty(value="version")
    @JsonIgnore
    public String version() {
        InitShim shim = this.initShim;
        return shim != null ? shim.version() : this.version;
    }

    public final ImmutableRoleConfig withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableRoleConfig(newValue, this.permissions, this.central);
    }

    public final ImmutableRoleConfig withPermissions(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableRoleConfig(this.name, (ImmutableSet<String>)newValue, this.central);
    }

    public final ImmutableRoleConfig withPermissions(Iterable<String> elements) {
        if (this.permissions == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableRoleConfig(this.name, (ImmutableSet<String>)newValue, this.central);
    }

    public final ImmutableRoleConfig withCentral(boolean value) {
        if (this.central == value) {
            return this;
        }
        return new ImmutableRoleConfig(this.name, this.permissions, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRoleConfig && this.equalTo(0, (ImmutableRoleConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableRoleConfig another) {
        return this.name.equals(another.name) && this.permissions.equals(another.permissions) && this.central == another.central && this.simplePermissions.equals(another.simplePermissions) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.permissions.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.central);
        h += (h << 5) + this.simplePermissions.hashCode();
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RoleConfig").omitNullValues().add("name", (Object)this.name).add("permissions", this.permissions).add("central", this.central).add("simplePermissions", this.simplePermissions).add("version", (Object)this.version).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRoleConfig fromJson(Json json) {
        Builder builder = ImmutableRoleConfig.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.permissions != null) {
            builder.addAllPermissions((Iterable<String>)json.permissions);
        }
        if (json.centralIsSet) {
            builder.central(json.central);
        }
        return builder.build();
    }

    public static ImmutableRoleConfig copyOf(RoleConfig instance) {
        if (instance instanceof ImmutableRoleConfig) {
            return (ImmutableRoleConfig)instance;
        }
        return ImmutableRoleConfig.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RoleConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long OPT_BIT_CENTRAL = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String name;
        private ImmutableSet.Builder<String> permissions = ImmutableSet.builder();
        private boolean central;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(RoleConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.addAllPermissions((Iterable<String>)instance.permissions());
            this.central(instance.central());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPermissions(String element) {
            this.permissions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPermissions(String ... elements) {
            this.permissions.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder permissions(Iterable<String> elements) {
            this.permissions = ImmutableSet.builder();
            return this.addAllPermissions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPermissions(Iterable<String> elements) {
            this.permissions.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder central(boolean central) {
            this.central = central;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableRoleConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRoleConfig(this);
        }

        private boolean centralIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build RoleConfig, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RoleConfig", generator="Immutables")
    static final class Json
    extends RoleConfig {
        @Nullable
        String name;
        @Nullable
        ImmutableSet<String> permissions = ImmutableSet.of();
        boolean central;
        boolean centralIsSet;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="permissions")
        public void setPermissions(ImmutableSet<String> permissions) {
            this.permissions = permissions;
        }

        @JsonProperty(value="central")
        @JsonIgnore
        public void setCentral(boolean central) {
            this.central = central;
            this.centralIsSet = true;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableSet<String> permissions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean central() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public ImmutableSet<RoleConfig.SimplePermission> simplePermissions() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String version() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="RoleConfig", generator="Immutables")
    private final class InitShim {
        private byte centralBuildStage = 0;
        private boolean central;
        private byte simplePermissionsBuildStage = 0;
        private ImmutableSet<RoleConfig.SimplePermission> simplePermissions;
        private byte versionBuildStage = 0;
        private String version;

        private InitShim() {
        }

        boolean central() {
            if (this.centralBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.centralBuildStage == 0) {
                this.centralBuildStage = (byte)-1;
                this.central = ImmutableRoleConfig.super.central();
                this.centralBuildStage = 1;
            }
            return this.central;
        }

        void central(boolean central) {
            this.central = central;
            this.centralBuildStage = 1;
        }

        ImmutableSet<RoleConfig.SimplePermission> simplePermissions() {
            if (this.simplePermissionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.simplePermissionsBuildStage == 0) {
                this.simplePermissionsBuildStage = (byte)-1;
                this.simplePermissions = Objects.requireNonNull(ImmutableRoleConfig.super.simplePermissions(), "simplePermissions");
                this.simplePermissionsBuildStage = 1;
            }
            return this.simplePermissions;
        }

        String version() {
            if (this.versionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.versionBuildStage == 0) {
                this.versionBuildStage = (byte)-1;
                this.version = Objects.requireNonNull(ImmutableRoleConfig.super.version(), "version");
                this.versionBuildStage = 1;
            }
            return this.version;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.centralBuildStage == -1) {
                attributes.add("central");
            }
            if (this.simplePermissionsBuildStage == -1) {
                attributes.add("simplePermissions");
            }
            if (this.versionBuildStage == -1) {
                attributes.add("version");
            }
            return "Cannot build RoleConfig, attribute initializers form cycle " + attributes;
        }
    }
}

