/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo;

import java.security.GeneralSecurityException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.PasswordHash;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.Encryption;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.LazySecretKey;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;

public class AllAdminConfigUtil {
    public static void updatePasswords(JsonNode rootNode, ConfigRepository configRepository) throws Exception {
        LazySecretKey lazySecretKey = configRepository.getLazySecretKey();
        AllAdminConfigUtil.updateEncryptedPassword((ObjectNode)rootNode.get("smtp"), configRepository.getSmtpConfig().toCompletableFuture().join().encryptedPassword(), lazySecretKey);
        AllAdminConfigUtil.updateEncryptedPassword((ObjectNode)rootNode.get("httpProxy"), configRepository.getHttpProxyConfig().toCompletableFuture().join().encryptedPassword(), lazySecretKey);
        AllAdminConfigUtil.updateEncryptedPassword((ObjectNode)rootNode.get("ldap"), configRepository.getLdapConfig().toCompletableFuture().join().encryptedPassword(), lazySecretKey);
        JsonNode usersNode = rootNode.get("users");
        if (usersNode instanceof ArrayNode) {
            for (JsonNode user : usersNode) {
                AllAdminConfigUtil.updateHashedPassword((ObjectNode)user);
            }
        }
    }

    public static void removePasswords(ObjectNode rootNode) {
        ((ObjectNode)Preconditions.checkNotNull((Object)rootNode.get("smtp"))).remove("encryptedPassword");
        ((ObjectNode)Preconditions.checkNotNull((Object)rootNode.get("httpProxy"))).remove("encryptedPassword");
        ((ObjectNode)Preconditions.checkNotNull((Object)rootNode.get("ldap"))).remove("encryptedPassword");
    }

    private static void updateEncryptedPassword(@Nullable ObjectNode objectNode, String existingEncryptedPassword, LazySecretKey lazySecretKey) throws Exception {
        if (objectNode == null) {
            return;
        }
        JsonNode passwordNode = objectNode.get("password");
        if (passwordNode == null) {
            JsonNode encryptedPasswordNode = objectNode.get("encryptedPassword");
            if (encryptedPasswordNode == null) {
                objectNode.put("encryptedPassword", existingEncryptedPassword);
            }
        } else {
            objectNode.put("encryptedPassword", Encryption.encrypt(passwordNode.asText(), lazySecretKey));
        }
    }

    private static void updateHashedPassword(ObjectNode objectNode) throws GeneralSecurityException {
        JsonNode passwordNode = objectNode.remove("password");
        if (passwordNode == null) {
            return;
        }
        if (objectNode.path("ldap").asBoolean()) {
            throw new IllegalStateException("Password not allowed when ldap is true");
        }
        if (objectNode.path("username").asText().equalsIgnoreCase("anonymous")) {
            throw new IllegalStateException("Password not allowed for anonymous user");
        }
        objectNode.put("passwordHash", PasswordHash.createHash(passwordNode.asText()));
    }
}

