/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ImmutableErrorInterval;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.SyntheticResult;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;

public class ErrorIntervalCollector {
    private final List<SyntheticResult.ErrorInterval> mergedErrorIntervals = Lists.newArrayList();
    private long currErrorFrom;
    private long currErrorTo;
    private int currErrorCount;
    private @Nullable String currErrorMessage;
    private boolean currErrorDoNotMergeToTheLeft;

    public void addErrorIntervals(List<SyntheticResult.ErrorInterval> errorIntervals) {
        for (SyntheticResult.ErrorInterval errorInterval : errorIntervals) {
            this.addErrorInterval(errorInterval);
        }
    }

    private void addErrorInterval(SyntheticResult.ErrorInterval errorInterval) {
        if (this.shouldMergeIntoCurrentInterval(errorInterval)) {
            this.currErrorTo = errorInterval.to();
            this.currErrorCount += errorInterval.count();
        } else {
            if (this.currErrorMessage != null) {
                this.mergedErrorIntervals.add(this.getCurrErrorInterval(errorInterval.doNotMergeToTheLeft()));
            }
            this.currErrorTo = errorInterval.to();
            this.currErrorFrom = errorInterval.from();
            this.currErrorCount = errorInterval.count();
            this.currErrorMessage = errorInterval.message();
            this.currErrorDoNotMergeToTheLeft = errorInterval.doNotMergeToTheLeft();
        }
        if (errorInterval.doNotMergeToTheRight()) {
            this.mergedErrorIntervals.add(this.getCurrErrorInterval(true));
            this.currErrorMessage = null;
        }
    }

    public void addGap() {
        if (this.currErrorMessage != null) {
            this.mergedErrorIntervals.add(this.getCurrErrorInterval(true));
            this.currErrorMessage = null;
        }
    }

    public List<SyntheticResult.ErrorInterval> getMergedErrorIntervals() {
        ArrayList mergedErrorIntervals = Lists.newArrayList(this.mergedErrorIntervals);
        if (this.currErrorMessage != null) {
            mergedErrorIntervals.add(this.getCurrErrorInterval(false));
        }
        return mergedErrorIntervals;
    }

    private boolean shouldMergeIntoCurrentInterval(SyntheticResult.ErrorInterval errorInterval) {
        if (this.currErrorMessage == null || errorInterval.doNotMergeToTheLeft()) {
            return false;
        }
        return errorInterval.message().equals(this.currErrorMessage);
    }

    private ImmutableErrorInterval getCurrErrorInterval(boolean doNotMergeToTheRight) {
        return ImmutableErrorInterval.builder().from(this.currErrorFrom).to(this.currErrorTo).count(this.currErrorCount).message((String)Preconditions.checkNotNull((Object)this.currErrorMessage)).doNotMergeToTheLeft(this.currErrorDoNotMergeToTheLeft).doNotMergeToTheRight(doNotMergeToTheRight).build();
    }
}

