/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConfigRepository.RollupConfig", generator="Immutables")
@Immutable
public final class ImmutableRollupConfig
extends ConfigRepository.RollupConfig {
    private final long intervalMillis;
    private final long viewThresholdMillis;

    private ImmutableRollupConfig(long intervalMillis, long viewThresholdMillis) {
        this.intervalMillis = intervalMillis;
        this.viewThresholdMillis = viewThresholdMillis;
    }

    @Override
    @JsonProperty(value="intervalMillis")
    public long intervalMillis() {
        return this.intervalMillis;
    }

    @Override
    @JsonProperty(value="viewThresholdMillis")
    public long viewThresholdMillis() {
        return this.viewThresholdMillis;
    }

    public final ImmutableRollupConfig withIntervalMillis(long value) {
        if (this.intervalMillis == value) {
            return this;
        }
        return new ImmutableRollupConfig(value, this.viewThresholdMillis);
    }

    public final ImmutableRollupConfig withViewThresholdMillis(long value) {
        if (this.viewThresholdMillis == value) {
            return this;
        }
        return new ImmutableRollupConfig(this.intervalMillis, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRollupConfig && this.equalTo(0, (ImmutableRollupConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableRollupConfig another) {
        return this.intervalMillis == another.intervalMillis && this.viewThresholdMillis == another.viewThresholdMillis;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.intervalMillis);
        h += (h << 5) + Longs.hashCode((long)this.viewThresholdMillis);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RollupConfig").omitNullValues().add("intervalMillis", this.intervalMillis).add("viewThresholdMillis", this.viewThresholdMillis).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRollupConfig fromJson(Json json) {
        Builder builder = ImmutableRollupConfig.builder();
        if (json.intervalMillisIsSet) {
            builder.intervalMillis(json.intervalMillis);
        }
        if (json.viewThresholdMillisIsSet) {
            builder.viewThresholdMillis(json.viewThresholdMillis);
        }
        return builder.build();
    }

    public static ImmutableRollupConfig of(long intervalMillis, long viewThresholdMillis) {
        return new ImmutableRollupConfig(intervalMillis, viewThresholdMillis);
    }

    public static ImmutableRollupConfig copyOf(ConfigRepository.RollupConfig instance) {
        if (instance instanceof ImmutableRollupConfig) {
            return (ImmutableRollupConfig)instance;
        }
        return ImmutableRollupConfig.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConfigRepository.RollupConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INTERVAL_MILLIS = 1L;
        private static final long INIT_BIT_VIEW_THRESHOLD_MILLIS = 2L;
        private long initBits = 3L;
        private long intervalMillis;
        private long viewThresholdMillis;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ConfigRepository.RollupConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.intervalMillis(instance.intervalMillis());
            this.viewThresholdMillis(instance.viewThresholdMillis());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder intervalMillis(long intervalMillis) {
            this.intervalMillis = intervalMillis;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder viewThresholdMillis(long viewThresholdMillis) {
            this.viewThresholdMillis = viewThresholdMillis;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRollupConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRollupConfig(this.intervalMillis, this.viewThresholdMillis);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("intervalMillis");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("viewThresholdMillis");
            }
            return "Cannot build RollupConfig, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConfigRepository.RollupConfig", generator="Immutables")
    static final class Json
    extends ConfigRepository.RollupConfig {
        long intervalMillis;
        boolean intervalMillisIsSet;
        long viewThresholdMillis;
        boolean viewThresholdMillisIsSet;

        Json() {
        }

        @JsonProperty(value="intervalMillis")
        public void setIntervalMillis(long intervalMillis) {
            this.intervalMillis = intervalMillis;
            this.intervalMillisIsSet = true;
        }

        @JsonProperty(value="viewThresholdMillis")
        public void setViewThresholdMillis(long viewThresholdMillis) {
            this.viewThresholdMillis = viewThresholdMillis;
            this.viewThresholdMillisIsSet = true;
        }

        @Override
        public long intervalMillis() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long viewThresholdMillis() {
            throw new UnsupportedOperationException();
        }
    }
}

