/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.glowroot.agent.shaded.com.google.common.annotations.VisibleForTesting;
import org.glowroot.agent.shaded.com.google.common.base.Charsets;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;

public class Compilations {
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("\\bpublic\\s+class\\s+([^\\s{]+)[\\s{]");
    private static final Pattern PACKAGE_NAME_PATTERN = Pattern.compile("^\\s*\\bpackage\\s+([^;]+)\\s*;");

    private Compilations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> compile(String source) throws Exception {
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        IsolatedClassLoader isolatedClassLoader = new IsolatedClassLoader();
        StandardJavaFileManager standardFileManager = javaCompiler.getStandardFileManager(diagnosticCollector, Locale.ENGLISH, Charsets.UTF_8);
        standardFileManager.setLocation(StandardLocation.CLASS_PATH, Compilations.getCompilationClassPath());
        try (IsolatedJavaFileManager fileManager = new IsolatedJavaFileManager(standardFileManager, isolatedClassLoader);){
            ArrayList compilationUnits = Lists.newArrayList();
            String className = Compilations.getPublicClassName(source);
            int index = className.lastIndexOf(46);
            String simpleName = index == -1 ? className : className.substring(index + 1);
            compilationUnits.add(new SourceJavaFileObject(simpleName, source));
            JavaCompiler.CompilationTask task = javaCompiler.getTask(null, fileManager, diagnosticCollector, null, null, compilationUnits);
            task.call();
            List diagnostics = diagnosticCollector.getDiagnostics();
            if (!diagnostics.isEmpty()) {
                ArrayList compilationErrors = Lists.newArrayList();
                for (Diagnostic diagnostic : diagnostics) {
                    compilationErrors.add((String)Preconditions.checkNotNull((Object)diagnostic.toString()));
                }
                throw new CompilationException(compilationErrors);
            }
            if (className.isEmpty()) {
                throw new CompilationException((List)ImmutableList.of((Object)"Class must be public"));
            }
            Class<?> clazz = isolatedClassLoader.loadClass(className);
            return clazz;
        }
    }

    private static List<File> getCompilationClassPath() throws Exception {
        return ImmutableList.of((Object)Compilations.getJarFile("org.apache.http.client.HttpClient"), (Object)Compilations.getJarFile("org.apache.http.HttpMessage"), (Object)Compilations.getJarFile("org.openqa.selenium.WebDriver"), (Object)Compilations.getJarFile("org.openqa.selenium.support.ui.ExpectedConditions"), (Object)Compilations.getJarFile("org.glowroot.agent.shaded.com.google.common.base.Function"));
    }

    private static File getJarFile(String className) throws Exception {
        CodeSource codeSource = Class.forName(className).getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            throw new IllegalStateException("Code source is null for class: " + className);
        }
        URL location = codeSource.getLocation();
        return new File(location.toURI());
    }

    @VisibleForTesting
    static String getPublicClassName(String source) {
        Matcher matcher = CLASS_NAME_PATTERN.matcher(source);
        if (matcher.find()) {
            return Compilations.getPackagePrefix(source) + matcher.group(1);
        }
        return "";
    }

    private static String getPackagePrefix(String source) {
        Matcher matcher = PACKAGE_NAME_PATTERN.matcher(source);
        if (matcher.find()) {
            return matcher.group(1) + ".";
        }
        return "";
    }

    private static class CompiledJavaFileObject
    extends SimpleJavaFileObject {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        protected CompiledJavaFileObject() {
            super(URI.create(""), JavaFileObject.Kind.CLASS);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.baos;
        }
    }

    private static class SourceJavaFileObject
    extends SimpleJavaFileObject {
        private final String source;

        private SourceJavaFileObject(String simpleClassName, String source) {
            super(URI.create(simpleClassName + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.source = source;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.source;
        }
    }

    private static class IsolatedClassLoader
    extends ClassLoader {
        private final Map<String, CompiledJavaFileObject> compiledJavaFileObjects = Maps.newHashMap();

        private IsolatedClassLoader() {
            super(IsolatedClassLoader.class.getClassLoader());
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            CompiledJavaFileObject compiledJavaFileObject = this.compiledJavaFileObjects.get(name);
            if (compiledJavaFileObject == null) {
                return super.findClass(name);
            }
            byte[] byteCode = compiledJavaFileObject.baos.toByteArray();
            return this.defineClass(name, byteCode, 0, byteCode.length);
        }
    }

    private static class IsolatedJavaFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        private final IsolatedClassLoader loader;

        private IsolatedJavaFileManager(JavaFileManager fileManager, IsolatedClassLoader loader) {
            super(fileManager);
            this.loader = loader;
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return this.loader;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            CompiledJavaFileObject javaFileObject = new CompiledJavaFileObject();
            this.loader.compiledJavaFileObjects.put(className, javaFileObject);
            return javaFileObject;
        }
    }

    public static class CompilationException
    extends Exception {
        private final List<String> compilationErrors;

        private CompilationException(List<String> compilationErrors) {
            this.compilationErrors = compilationErrors;
        }

        public List<String> getCompilationErrors() {
            return this.compilationErrors;
        }
    }
}

