/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;
import org.glowroot.agent.shaded.com.google.common.annotations.VisibleForTesting;

public class Formatting {
    private Formatting() {
    }

    public static String displaySixDigitsOfPrecision(double value) {
        return Formatting.displaySixDigitsOfPrecision(value, Locale.getDefault());
    }

    static String formatBytes(long bytes) {
        return Formatting.formatBytes(bytes, Locale.getDefault());
    }

    @VisibleForTesting
    static String displaySixDigitsOfPrecision(double value, Locale locale) {
        NumberFormat format = NumberFormat.getInstance(locale);
        format.setMaximumFractionDigits(20);
        if (value < 1000000.0) {
            return format.format(BigDecimal.valueOf(value).round(new MathContext(6, RoundingMode.HALF_UP)));
        }
        return format.format(Math.round(value));
    }

    @VisibleForTesting
    static String formatBytes(long bytes, Locale locale) {
        if (bytes == 0L) {
            return "0";
        }
        if (bytes == 1L) {
            return "1 byte";
        }
        String[] units = new String[]{"bytes", "KB", "MB", "GB", "TB", "PB"};
        int number = (int)Math.floor(Math.log(bytes) / Math.log(1024.0));
        double num = (double)bytes / Math.pow(1024.0, number);
        if (number == 0) {
            return Math.round(num) + " bytes";
        }
        NumberFormat format = NumberFormat.getInstance(locale);
        format.setGroupingUsed(false);
        format.setRoundingMode(RoundingMode.HALF_UP);
        format.setMinimumFractionDigits(1);
        format.setMaximumFractionDigits(1);
        return format.format(num) + ' ' + units[number];
    }
}

