/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.HttpProxyConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.Encryption;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Throwables;
import org.glowroot.agent.shaded.io.netty.bootstrap.Bootstrap;
import org.glowroot.agent.shaded.io.netty.buffer.Unpooled;
import org.glowroot.agent.shaded.io.netty.channel.Channel;
import org.glowroot.agent.shaded.io.netty.channel.ChannelHandler;
import org.glowroot.agent.shaded.io.netty.channel.ChannelHandlerContext;
import org.glowroot.agent.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.glowroot.agent.shaded.io.netty.channel.ChannelInitializer;
import org.glowroot.agent.shaded.io.netty.channel.ChannelPipeline;
import org.glowroot.agent.shaded.io.netty.channel.EventLoopGroup;
import org.glowroot.agent.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.glowroot.agent.shaded.io.netty.channel.socket.SocketChannel;
import org.glowroot.agent.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.DefaultFullHttpRequest;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpClientCodec;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpContent;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpMethod;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpObjectAggregator;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpResponse;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpVersion;
import org.glowroot.agent.shaded.io.netty.handler.proxy.HttpProxyHandler;
import org.glowroot.agent.shaded.io.netty.handler.ssl.SslContext;
import org.glowroot.agent.shaded.io.netty.handler.ssl.SslContextBuilder;
import org.glowroot.agent.shaded.io.netty.resolver.AddressResolverGroup;
import org.glowroot.agent.shaded.io.netty.resolver.NoopAddressResolverGroup;
import org.glowroot.agent.shaded.io.netty.util.CharsetUtil;
import org.glowroot.agent.shaded.io.netty.util.ReferenceCountUtil;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(HttpClient.class);
    private final ConfigRepository configRepository;

    public HttpClient(ConfigRepository configRepository) {
        this.configRepository = configRepository;
    }

    public void get(String url) throws Exception {
        this.postOrGet(url, null, null, this.configRepository.getHttpProxyConfig().toCompletableFuture().join(), null);
    }

    public String getWithHttpProxyConfigOverride(String url, HttpProxyConfig httpProxyConfig, @Nullable String passwordOverride) throws Exception {
        return this.postOrGet(url, null, null, httpProxyConfig, passwordOverride);
    }

    void post(String url, byte[] content, String contentType) throws Exception {
        this.postOrGet(url, content, contentType, this.configRepository.getHttpProxyConfig().toCompletableFuture().join(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String postOrGet(String url, byte[] content, @Nullable String contentType, HttpProxyConfig httpProxyConfig, @Nullable String passwordOverride) throws Exception {
        URI uri = new URI(url);
        String scheme = (String)Preconditions.checkNotNull((Object)uri.getScheme());
        final boolean ssl = scheme.equalsIgnoreCase("https");
        final String host = (String)Preconditions.checkNotNull((Object)uri.getHost());
        final int port = uri.getPort() == -1 ? (ssl ? 443 : 80) : uri.getPort();
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            DefaultFullHttpRequest request;
            Bootstrap bootstrap = new Bootstrap();
            final HttpProxyHandler httpProxyHandler = this.newHttpProxyHandlerIfNeeded(httpProxyConfig, passwordOverride);
            final HttpClientHandler handler = new HttpClientHandler();
            ((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    if (httpProxyHandler != null) {
                        p.addLast(new ChannelHandler[]{httpProxyHandler});
                    }
                    if (ssl) {
                        SslContext sslContext = SslContextBuilder.forClient().build();
                        p.addLast(new ChannelHandler[]{sslContext.newHandler(ch.alloc(), host, port)});
                    }
                    p.addLast(new ChannelHandler[]{new HttpClientCodec()});
                    p.addLast(new ChannelHandler[]{new HttpObjectAggregator(0x100000)});
                    p.addLast(new ChannelHandler[]{handler});
                }
            });
            if (!httpProxyConfig.host().isEmpty()) {
                bootstrap.resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
            }
            if (content == null) {
                request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri.getRawPath());
            } else {
                request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, uri.getRawPath(), Unpooled.wrappedBuffer((byte[])content));
                request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, Preconditions.checkNotNull((Object)contentType));
                request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.length);
            }
            request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)host);
            request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            Channel ch = bootstrap.connect(host, port).sync().channel();
            if (httpProxyHandler != null) {
                httpProxyHandler.connectFuture().get();
            }
            ch.writeAndFlush((Object)request).get();
            ch.closeFuture().sync().get();
            Throwable exception = handler.exception;
            if (exception != null) {
                Throwables.propagateIfPossible((Throwable)exception, Exception.class);
                throw new Exception(exception);
            }
            HttpResponseStatus responseStatus = (HttpResponseStatus)Preconditions.checkNotNull((Object)handler.responseStatus);
            int statusCode = responseStatus.code();
            if (statusCode == 429) {
                throw new TooManyRequestsHttpResponseException();
            }
            if (statusCode < 200 || statusCode >= 300) {
                throw new IOException("Unexpected response status code: " + statusCode);
            }
            String string = (String)Preconditions.checkNotNull((Object)handler.responseContent);
            return string;
        }
        finally {
            group.shutdownGracefully(0L, 10L, TimeUnit.SECONDS).get();
        }
    }

    private @Nullable HttpProxyHandler newHttpProxyHandlerIfNeeded(HttpProxyConfig httpProxyConfig, @Nullable String passwordOverride) throws Exception {
        String proxyHost = httpProxyConfig.host();
        if (proxyHost.isEmpty()) {
            return null;
        }
        int proxyPort = (Integer)MoreObjects.firstNonNull((Object)httpProxyConfig.port(), (Object)80);
        InetSocketAddress proxyAddress = new InetSocketAddress(proxyHost, proxyPort);
        String username = httpProxyConfig.username();
        if (username.isEmpty()) {
            return new HttpProxyHandler((SocketAddress)proxyAddress);
        }
        String password = this.getPassword(httpProxyConfig, passwordOverride);
        return new HttpProxyHandler((SocketAddress)proxyAddress, username, password);
    }

    private String getPassword(HttpProxyConfig httpProxyConfig, @Nullable String passwordOverride) throws Exception {
        if (passwordOverride != null) {
            return passwordOverride;
        }
        String password = httpProxyConfig.encryptedPassword();
        if (password.isEmpty()) {
            return "";
        }
        return Encryption.decrypt(password, this.configRepository.getLazySecretKey());
    }

    static class TooManyRequestsHttpResponseException
    extends Exception {
        TooManyRequestsHttpResponseException() {
        }
    }

    private static class HttpClientHandler
    extends ChannelInboundHandlerAdapter {
        private volatile @MonotonicNonNull HttpResponseStatus responseStatus;
        private volatile @Nullable String responseContent;
        private volatile @Nullable Throwable exception;

        private HttpClientHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            try {
                if (msg instanceof HttpResponse && msg instanceof HttpContent) {
                    this.responseStatus = ((HttpResponse)msg).status();
                    this.responseContent = ((HttpContent)msg).content().toString(CharsetUtil.UTF_8);
                } else {
                    this.exception = new Exception("Unexpected response message class: " + msg.getClass());
                }
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.debug(cause.getMessage(), cause);
            this.exception = cause;
            ctx.close();
        }
    }
}

