/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.MoreConfigDefaults;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.PagerDutyConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.SlackConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.AlertingDisabledRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.GaugeValueRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.SyntheticResultRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.Utils;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.AlertingService;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.Formatting;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.Gauges;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAgentRollupId;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindRequest;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GET;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GaugeValueJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableAlertConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableAlertConfigResponse;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableAlertListItem;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableAlertListResponse;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableEmailNotificationDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableHeartbeatConditionDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableMetricConditionDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutablePagerDutyNotificationDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableSlackNotificationDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableSlackWebhookItem;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableSyntheticMonitorConditionDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableSyntheticMonitorItem;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonServiceException;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.POST;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.google.common.annotations.VisibleForTesting;
import org.glowroot.agent.shaded.com.google.common.base.Optional;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.protobuf.AbstractMessage;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.glowroot.agent.shaded.org.glowroot.common.util.Versions;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.Proto;
import org.immutables.value.Value;

@JsonService
class AlertConfigJsonService {
    private static final ObjectMapper mapper = ObjectMappers.create((Module[])new Module[0]);
    @VisibleForTesting
    static final Ordering<AlertListItem> orderingByName = new Ordering<AlertListItem>(){

        public int compare(AlertListItem left, AlertListItem right) {
            return left.display().compareToIgnoreCase(right.display());
        }
    };
    private final ConfigRepository configRepository;
    private final AlertingDisabledRepository alertingDisableRepository;
    private final GaugeValueRepository gaugeValueRepository;
    private final @Nullable SyntheticResultRepository syntheticResultRepository;
    private final Clock clock;
    private final boolean central;

    AlertConfigJsonService(ConfigRepository configRepository, AlertingDisabledRepository alertingDisableRepository, GaugeValueRepository gaugeValueRepository, @Nullable SyntheticResultRepository syntheticResultRepository, Clock clock, boolean central) {
        this.configRepository = configRepository;
        this.alertingDisableRepository = alertingDisableRepository;
        this.gaugeValueRepository = gaugeValueRepository;
        this.syntheticResultRepository = syntheticResultRepository;
        this.clock = clock;
        this.central = central;
    }

    @GET(path="/backend/config/alerts", permission="agent:config:view:alert")
    String getAlert(@BindAgentRollupId String agentRollupId, @BindRequest AlertConfigRequest request) throws Exception {
        Optional<String> version = request.version();
        if (version.isPresent()) {
            AgentConfigOuterClass.AgentConfig.AlertConfig alertConfig = this.configRepository.getAlertConfig(agentRollupId, (String)version.get()).toCompletableFuture().join();
            if (alertConfig == null) {
                throw new JsonServiceException(HttpResponseStatus.NOT_FOUND);
            }
            return this.getAlertResponse(agentRollupId, alertConfig);
        }
        return this.getAlertList(agentRollupId);
    }

    @GET(path="/backend/config/alert-dropdowns", permission="agent:config:view:alert")
    String getAlertDropdowns(@BindAgentRollupId String agentRollupId) throws Exception {
        return this.getAlertResponse(agentRollupId, null);
    }

    @POST(path="/backend/config/alerts/add", permission="agent:config:edit:alerts")
    String addAlert(@BindAgentRollupId String agentRollupId, @BindRequest AlertConfigDto configDto) throws Exception {
        AlertConfigJsonService.validate(configDto);
        AgentConfigOuterClass.AgentConfig.AlertConfig alertConfig = configDto.toProto();
        this.configRepository.insertAlertConfig(agentRollupId, alertConfig, CassandraProfile.web).toCompletableFuture().join();
        return this.getAlertResponse(agentRollupId, alertConfig);
    }

    @POST(path="/backend/config/alerts/update", permission="agent:config:edit:alerts")
    String updateAlert(@BindAgentRollupId String agentRollupId, @BindRequest AlertConfigDto configDto) throws Exception {
        AlertConfigJsonService.validate(configDto);
        AgentConfigOuterClass.AgentConfig.AlertConfig alertConfig = configDto.toProto();
        this.configRepository.updateAlertConfig(agentRollupId, alertConfig, (String)configDto.version().get(), CassandraProfile.web).toCompletableFuture().join();
        return this.getAlertResponse(agentRollupId, alertConfig);
    }

    @POST(path="/backend/config/alerts/remove", permission="agent:config:edit:alerts")
    void removeAlert(@BindAgentRollupId String agentRollupId, @BindRequest AlertConfigRequest request) {
        this.configRepository.deleteAlertConfig(agentRollupId, (String)request.version().get(), CassandraProfile.web).toCompletableFuture().join();
    }

    @POST(path="/backend/config/disable-alerting", permission="agent:config:edit:alerts")
    String disableAlerting(@BindAgentRollupId String agentRollupId, @BindRequest DisableAlertingRequest request) throws Exception {
        this.alertingDisableRepository.setAlertingDisabledUntilTime(agentRollupId, this.clock.currentTimeMillis() + request.disableForNextMillis(), CassandraProfile.web).toCompletableFuture().join();
        return this.getAlertList(agentRollupId);
    }

    @POST(path="/backend/config/re-enable-alerting", permission="agent:config:edit:alerts")
    String reEnableAlerting(@BindAgentRollupId String agentRollupId) throws Exception {
        this.alertingDisableRepository.setAlertingDisabledUntilTime(agentRollupId, null, CassandraProfile.web).toCompletableFuture().join();
        return this.getAlertList(agentRollupId);
    }

    private String getAlertResponse(String agentRollupId, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable AgentConfigOuterClass.AgentConfig.AlertConfig alertConfig) throws Exception {
        ImmutableAlertConfigResponse.Builder builder = ImmutableAlertConfigResponse.builder();
        if (alertConfig != null) {
            builder.config(AlertConfigDto.toDto(alertConfig)).heading(AlertConfigJsonService.getConditionDisplay(agentRollupId, alertConfig.getCondition(), this.clock.currentTimeMillis(), this.configRepository, this.syntheticResultRepository));
        }
        builder.addAllGauges(this.getGaugeDropdownItems(agentRollupId)).addAllSyntheticMonitors(this.getSyntheticMonitorDropdownItems(agentRollupId)).addAllPagerDutyIntegrationKeys(this.configRepository.getPagerDutyConfig().toCompletableFuture().join().integrationKeys());
        for (SlackConfig.SlackWebhook slackWebhook : this.configRepository.getSlackConfig().toCompletableFuture().join().webhooks()) {
            builder.addSlackWebhooks((SlackWebhookItem)ImmutableSlackWebhookItem.builder().id(slackWebhook.id()).display(slackWebhook.display()).build());
        }
        return mapper.writeValueAsString((Object)builder.build());
    }

    private String getAlertList(String agentRollupId) throws Exception {
        long disabledForNextMillis;
        ArrayList alertListItems = Lists.newArrayList();
        List<AgentConfigOuterClass.AgentConfig.AlertConfig> alertConfigs = this.configRepository.getAlertConfigs(agentRollupId).toCompletableFuture().join();
        for (AgentConfigOuterClass.AgentConfig.AlertConfig alertConfig : alertConfigs) {
            alertListItems.add(ImmutableAlertListItem.builder().version(Versions.getVersion((AbstractMessage)alertConfig)).display(AlertConfigJsonService.getConditionDisplay(agentRollupId, alertConfig.getCondition(), this.clock.currentTimeMillis(), this.configRepository, this.syntheticResultRepository)).build());
        }
        alertListItems = orderingByName.immutableSortedCopy((Iterable)alertListItems);
        ImmutableAlertListResponse.Builder builder = ImmutableAlertListResponse.builder().alerts(alertListItems);
        Long disabledUntilTime = this.alertingDisableRepository.getAlertingDisabledUntilTime(agentRollupId, CassandraProfile.web).toCompletableFuture().join();
        if (disabledUntilTime != null && (disabledForNextMillis = disabledUntilTime - this.clock.currentTimeMillis()) > 0L) {
            builder.disabledForNextMillis(disabledForNextMillis);
        }
        return mapper.writeValueAsString((Object)builder.build());
    }

    private List<GaugeValueRepository.Gauge> getGaugeDropdownItems(String agentRollupId) throws Exception {
        List<GaugeValueRepository.Gauge> gauges = this.gaugeValueRepository.getRecentlyActiveGauges(agentRollupId).toCompletableFuture().get();
        return new GaugeValueJsonService.GaugeOrdering().immutableSortedCopy(gauges);
    }

    private List<SyntheticMonitorItem> getSyntheticMonitorDropdownItems(String agentRollupId) {
        if (!this.central) {
            return ImmutableList.of();
        }
        ArrayList items = Lists.newArrayList();
        for (AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig config : this.configRepository.getSyntheticMonitorConfigs(agentRollupId).toCompletableFuture().join()) {
            items.add(ImmutableSyntheticMonitorItem.of(config.getId(), MoreConfigDefaults.getDisplayOrDefault(config)));
        }
        return items;
    }

    static String getConditionDisplay(String agentRollupId, AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition alertCondition, long currentOrResolveTime, ConfigRepository configRepository, @Nullable SyntheticResultRepository syntheticResultRepository) throws Exception {
        switch (alertCondition.getValCase()) {
            case METRIC_CONDITION: {
                return AlertConfigJsonService.getConditionDisplay(alertCondition.getMetricCondition());
            }
            case SYNTHETIC_MONITOR_CONDITION: {
                Preconditions.checkNotNull((Object)syntheticResultRepository);
                return AlertConfigJsonService.getConditionDisplay(alertCondition.getSyntheticMonitorCondition(), agentRollupId, currentOrResolveTime, configRepository, syntheticResultRepository);
            }
            case HEARTBEAT_CONDITION: {
                return AlertConfigJsonService.getConditionDisplay(alertCondition.getHeartbeatCondition());
            }
        }
        throw new IllegalStateException("Unexpected alert condition: " + alertCondition.getValCase().name());
    }

    private static void validate(AlertConfigDto configDto) {
        AlertConfigDto.MetricConditionDto metricCondition;
        String errorMessageFilter;
        AlertConfigDto.AlertConditionDto condition = configDto.condition();
        if (condition instanceof AlertConfigDto.MetricConditionDto && (errorMessageFilter = (metricCondition = (AlertConfigDto.MetricConditionDto)condition).errorMessageFilter()) != null && errorMessageFilter.startsWith("/") && errorMessageFilter.endsWith("/")) {
            Pattern.compile(errorMessageFilter.substring(1, errorMessageFilter.length() - 1));
        }
    }

    private static String getConditionDisplay(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.MetricCondition metricCondition) {
        String transactionName;
        StringBuilder sb = new StringBuilder();
        String metric = metricCondition.getMetric();
        String transactionType = metricCondition.getTransactionType();
        if (!transactionType.isEmpty()) {
            sb.append(transactionType);
            sb.append(" - ");
        }
        if (!(transactionName = metricCondition.getTransactionName()).isEmpty()) {
            sb.append(transactionName);
            sb.append(" - ");
        }
        GaugeValueRepository.Gauge gauge = null;
        if (metric.startsWith("gauge:")) {
            String gaugeName = metric.substring("gauge:".length());
            gauge = Gauges.getGauge(gaugeName);
            sb.append("Gauge - ");
            sb.append(gauge.display());
            sb.append(" - ");
        }
        if (metric.equals("transaction:x-percentile")) {
            Preconditions.checkState((boolean)metricCondition.hasPercentile());
            sb.append(Utils.getPercentileWithSuffix(metricCondition.getPercentile().getValue()));
            sb.append(" percentile");
        } else if (metric.equals("transaction:average")) {
            sb.append("average");
        } else if (metric.equals("transaction:count")) {
            sb.append("transaction count");
        } else if (metric.equals("error:rate")) {
            sb.append("error rate");
        } else if (metric.equals("error:count")) {
            String errorMessageFilter = metricCondition.getErrorMessageFilter();
            if (errorMessageFilter.isEmpty()) {
                sb.append("error count");
            } else if (errorMessageFilter.startsWith("/") && errorMessageFilter.endsWith("/")) {
                sb.append("error count matching ");
                sb.append(errorMessageFilter);
            } else {
                sb.append("error count containing \"");
                sb.append(errorMessageFilter);
                sb.append("\"");
            }
        } else if (metric.startsWith("gauge:")) {
            sb.append("average");
        } else {
            throw new IllegalStateException("Unexpected metric: " + metric);
        }
        sb.append(AlertingService.getOverTheLastMinutesText(metricCondition.getTimePeriodSeconds()));
        if (metricCondition.getLowerBoundThreshold()) {
            if (metric.equals("transaction:count") && metricCondition.getThreshold() == 0.0) {
                sb.append(" is equal to ");
            } else {
                sb.append(" is less than or equal to ");
            }
        } else {
            sb.append(" is greater than or equal to ");
        }
        if (metric.equals("transaction:x-percentile") || metric.equals("transaction:average")) {
            sb.append(AlertingService.getWithUnit(metricCondition.getThreshold(), "millisecond"));
        } else if (metric.equals("transaction:count")) {
            sb.append(Formatting.displaySixDigitsOfPrecision(metricCondition.getThreshold()));
        } else if (metric.equals("error:rate")) {
            sb.append(Formatting.displaySixDigitsOfPrecision(metricCondition.getThreshold()));
            sb.append(" percent");
        } else if (metric.equals("error:count")) {
            sb.append(Formatting.displaySixDigitsOfPrecision(metricCondition.getThreshold()));
        } else if (metric.startsWith("gauge:")) {
            sb.append(AlertingService.getGaugeThresholdText(metricCondition.getThreshold(), ((GaugeValueRepository.Gauge)Preconditions.checkNotNull((Object)gauge)).unit()));
        } else {
            throw new IllegalStateException("Unexpected metric: " + metric);
        }
        return sb.toString();
    }

    private static String getConditionDisplay(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.HeartbeatCondition condition) {
        StringBuilder sb = new StringBuilder();
        sb.append("Heartbeat - not received over the last ");
        sb.append(AlertingService.getWithUnit(condition.getTimePeriodSeconds(), "second"));
        return sb.toString();
    }

    private static String getConditionDisplay(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.SyntheticMonitorCondition condition, String agentRollupId, long currentOrResolveTime, ConfigRepository configRepository, SyntheticResultRepository syntheticResultRepository) throws Exception {
        String syntheticMonitorDisplay;
        AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig syntheticMonitorConfig = configRepository.getSyntheticMonitorConfig(agentRollupId, condition.getSyntheticMonitorId()).toCompletableFuture().join();
        if (syntheticMonitorConfig == null) {
            syntheticMonitorDisplay = syntheticResultRepository.getSyntheticMonitorIds(agentRollupId, currentOrResolveTime, currentOrResolveTime).get(condition.getSyntheticMonitorId());
            if (syntheticMonitorDisplay == null && (syntheticMonitorDisplay = syntheticResultRepository.getSyntheticMonitorIds(agentRollupId, currentOrResolveTime - TimeUnit.DAYS.toMillis(30L), currentOrResolveTime + TimeUnit.DAYS.toMillis(30L)).get(condition.getSyntheticMonitorId())) == null) {
                syntheticMonitorDisplay = "<NOT FOUND>";
            }
        } else {
            syntheticMonitorDisplay = MoreConfigDefaults.getDisplayOrDefault(syntheticMonitorConfig);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Synthetic monitor - ");
        sb.append(syntheticMonitorDisplay);
        sb.append(" exceeds ");
        sb.append(AlertingService.getWithUnit(condition.getThresholdMillis(), "millisecond"));
        sb.append(" or results in error");
        return sb.toString();
    }

    @Value.Immutable
    static abstract class AlertConfigDto {
        AlertConfigDto() {
        }

        abstract AlertConditionDto condition();

        abstract AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity severity();

        abstract @Nullable ImmutableEmailNotificationDto emailNotification();

        abstract @Nullable ImmutablePagerDutyNotificationDto pagerDutyNotification();

        abstract @Nullable ImmutableSlackNotificationDto slackNotification();

        abstract Optional<String> version();

        private static AlertConfigDto toDto(AgentConfigOuterClass.AgentConfig.AlertConfig config) {
            ImmutableAlertConfigDto.Builder builder = ImmutableAlertConfigDto.builder().condition(AlertConfigDto.toDto(config.getCondition())).severity(config.getSeverity());
            AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification notification = config.getNotification();
            if (notification.hasEmailNotification()) {
                builder.emailNotification(AlertConfigDto.toDto(notification.getEmailNotification()));
            }
            if (notification.hasPagerDutyNotification()) {
                builder.pagerDutyNotification(AlertConfigDto.toDto(notification.getPagerDutyNotification()));
            }
            if (notification.hasSlackNotification()) {
                builder.slackNotification(AlertConfigDto.toDto(notification.getSlackNotification()));
            }
            return builder.version((Optional<String>)Optional.of((Object)Versions.getVersion((AbstractMessage)config))).build();
        }

        private AgentConfigOuterClass.AgentConfig.AlertConfig toProto() {
            ImmutableSlackNotificationDto slackNotification;
            ImmutablePagerDutyNotificationDto pagerDutyNotification;
            AgentConfigOuterClass.AgentConfig.AlertConfig.Builder builder = AgentConfigOuterClass.AgentConfig.AlertConfig.newBuilder().setCondition(AlertConfigDto.toProto(this.condition())).setSeverity(this.severity());
            ImmutableEmailNotificationDto emailNotification = this.emailNotification();
            if (emailNotification != null) {
                builder.getNotificationBuilder().setEmailNotification(AlertConfigDto.toProto(emailNotification));
            }
            if ((pagerDutyNotification = this.pagerDutyNotification()) != null) {
                builder.getNotificationBuilder().setPagerDutyNotification(AlertConfigDto.toProto(pagerDutyNotification));
            }
            if ((slackNotification = this.slackNotification()) != null) {
                builder.getNotificationBuilder().setSlackNotification(AlertConfigDto.toProto(slackNotification));
            }
            return builder.build();
        }

        private static AlertConditionDto toDto(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition alertCondition) {
            switch (alertCondition.getValCase()) {
                case METRIC_CONDITION: {
                    return AlertConfigDto.toDto(alertCondition.getMetricCondition());
                }
                case SYNTHETIC_MONITOR_CONDITION: {
                    return AlertConfigDto.toDto(alertCondition.getSyntheticMonitorCondition());
                }
                case HEARTBEAT_CONDITION: {
                    return AlertConfigDto.toDto(alertCondition.getHeartbeatCondition());
                }
            }
            throw new IllegalStateException("Unexpected condition kind: " + alertCondition.getValCase().name());
        }

        private static ImmutableEmailNotificationDto toDto(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.EmailNotification emailNotification) {
            return ImmutableEmailNotificationDto.builder().addAllEmailAddresses((Iterable<String>)emailNotification.getEmailAddressList()).build();
        }

        private static ImmutablePagerDutyNotificationDto toDto(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.PagerDutyNotification pagerDutyNotification) {
            return ImmutablePagerDutyNotificationDto.builder().pagerDutyIntegrationKey(pagerDutyNotification.getPagerDutyIntegrationKey()).build();
        }

        private static ImmutableSlackNotificationDto toDto(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.SlackNotification slackNotification) {
            return ImmutableSlackNotificationDto.builder().slackWebhookId(slackNotification.getSlackWebhookId()).addAllSlackChannels((Iterable<String>)slackNotification.getSlackChannelList()).build();
        }

        private static AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition toProto(AlertConditionDto condition) {
            if (condition instanceof MetricConditionDto) {
                return AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.newBuilder().setMetricCondition(AlertConfigDto.toProto((MetricConditionDto)condition)).build();
            }
            if (condition instanceof SyntheticMonitorConditionDto) {
                return AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.newBuilder().setSyntheticMonitorCondition(AlertConfigDto.toProto((SyntheticMonitorConditionDto)condition)).build();
            }
            if (condition instanceof HeartbeatConditionDto) {
                return AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.newBuilder().setHeartbeatCondition(AlertConfigDto.toProto((HeartbeatConditionDto)condition)).build();
            }
            throw new IllegalStateException("Unexpected alert condition type: " + condition.getClass().getName());
        }

        private static AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.EmailNotification toProto(EmailNotificationDto emailNotification) {
            return AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.EmailNotification.newBuilder().addAllEmailAddress(emailNotification.emailAddresses()).build();
        }

        private static AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.PagerDutyNotification toProto(PagerDutyNotificationDto pagerDutyNotification) {
            return AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.PagerDutyNotification.newBuilder().setPagerDutyIntegrationKey(pagerDutyNotification.pagerDutyIntegrationKey()).build();
        }

        private static AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.SlackNotification toProto(SlackNotificationDto slackNotification) {
            return AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.SlackNotification.newBuilder().setSlackWebhookId(slackNotification.slackWebhookId()).addAllSlackChannel(slackNotification.slackChannels()).build();
        }

        private static MetricConditionDto toDto(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.MetricCondition condition) {
            ImmutableMetricConditionDto.Builder builder = ImmutableMetricConditionDto.builder().metric(condition.getMetric());
            if (AlertingService.hasTransactionTypeAndName(condition.getMetric())) {
                builder.transactionType(condition.getTransactionType());
                builder.transactionName(condition.getTransactionName());
            }
            if (condition.hasPercentile()) {
                builder.percentile(condition.getPercentile().getValue());
            }
            if (AlertingService.hasErrorMessageFilter(condition.getMetric())) {
                builder.errorMessageFilter(condition.getErrorMessageFilter());
            }
            if (AlertingService.hasMinTransactionCount(condition.getMetric())) {
                builder.minTransactionCount(condition.getMinTransactionCount());
            }
            return builder.threshold(condition.getThreshold()).lowerBoundThreshold(condition.getLowerBoundThreshold()).timePeriodSeconds(condition.getTimePeriodSeconds()).build();
        }

        private static SyntheticMonitorConditionDto toDto(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.SyntheticMonitorCondition condition) {
            ImmutableSyntheticMonitorConditionDto.Builder builder = ImmutableSyntheticMonitorConditionDto.builder().syntheticMonitorId(condition.getSyntheticMonitorId()).thresholdMillis(condition.getThresholdMillis());
            int consecutiveCount = condition.getConsecutiveCount();
            if (consecutiveCount == 0) {
                builder.consecutiveCount(1);
            } else {
                builder.consecutiveCount(consecutiveCount);
            }
            return builder.build();
        }

        private static HeartbeatConditionDto toDto(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.HeartbeatCondition condition) {
            return ImmutableHeartbeatConditionDto.builder().timePeriodSeconds(condition.getTimePeriodSeconds()).build();
        }

        private static AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.MetricCondition toProto(MetricConditionDto condition) {
            Double percentile;
            AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.MetricCondition.Builder builder = AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.MetricCondition.newBuilder().setMetric(condition.metric());
            if (AlertingService.hasTransactionTypeAndName(condition.metric())) {
                builder.setTransactionType((String)Preconditions.checkNotNull((Object)condition.transactionType()));
                builder.setTransactionName((String)Preconditions.checkNotNull((Object)condition.transactionName()));
            }
            if ((percentile = condition.percentile()) != null) {
                builder.setPercentile(Proto.OptionalDouble.newBuilder().setValue(percentile.doubleValue()));
            }
            if (AlertingService.hasErrorMessageFilter(condition.metric())) {
                builder.setErrorMessageFilter((String)Preconditions.checkNotNull((Object)condition.errorMessageFilter()));
            }
            if (AlertingService.hasMinTransactionCount(condition.metric())) {
                builder.setMinTransactionCount(((Long)Preconditions.checkNotNull((Object)condition.minTransactionCount())).longValue());
            }
            return builder.setThreshold(condition.threshold()).setLowerBoundThreshold(condition.lowerBoundThreshold()).setTimePeriodSeconds(condition.timePeriodSeconds()).build();
        }

        private static AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.SyntheticMonitorCondition toProto(SyntheticMonitorConditionDto condition) {
            return AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.SyntheticMonitorCondition.newBuilder().setSyntheticMonitorId(condition.syntheticMonitorId()).setThresholdMillis(condition.thresholdMillis()).setConsecutiveCount(condition.consecutiveCount()).build();
        }

        private static AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.HeartbeatCondition toProto(HeartbeatConditionDto condition) {
            return AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.HeartbeatCondition.newBuilder().setTimePeriodSeconds(condition.timePeriodSeconds()).build();
        }

        @Value.Immutable
        public static interface SlackNotificationDto {
            public String slackWebhookId();

            public List<String> slackChannels();
        }

        @Value.Immutable
        public static interface PagerDutyNotificationDto {
            public String pagerDutyIntegrationKey();
        }

        @Value.Immutable
        public static interface EmailNotificationDto {
            public List<String> emailAddresses();
        }

        @Value.Immutable
        public static interface HeartbeatConditionDto
        extends AlertConditionDto {
            public int timePeriodSeconds();
        }

        @Value.Immutable
        public static interface SyntheticMonitorConditionDto
        extends AlertConditionDto {
            public String syntheticMonitorId();

            public int thresholdMillis();

            public int consecutiveCount();
        }

        @Value.Immutable
        public static abstract class MetricConditionDto
        implements AlertConditionDto {
            abstract String metric();

            abstract @Nullable String transactionType();

            abstract @Nullable String transactionName();

            abstract @Nullable Double percentile();

            abstract @Nullable String errorMessageFilter();

            abstract double threshold();

            @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
            @Value.Default
            boolean lowerBoundThreshold() {
                return false;
            }

            abstract int timePeriodSeconds();

            abstract @Nullable Long minTransactionCount();
        }

        @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="conditionType")
        @JsonSubTypes(value={@JsonSubTypes.Type(value=ImmutableMetricConditionDto.class, name="metric"), @JsonSubTypes.Type(value=ImmutableSyntheticMonitorConditionDto.class, name="synthetic-monitor"), @JsonSubTypes.Type(value=ImmutableHeartbeatConditionDto.class, name="heartbeat")})
        public static interface AlertConditionDto {
        }
    }

    @Value.Immutable
    static interface DisableAlertingRequest {
        public long disableForNextMillis();
    }

    @Value.Immutable
    @Styles.AllParameters
    static interface SlackWebhookItem {
        public String id();

        public String display();
    }

    @Value.Immutable
    @Styles.AllParameters
    static interface SyntheticMonitorItem {
        public String id();

        public String display();
    }

    @Value.Immutable
    static interface AlertConfigResponse {
        public @Nullable AlertConfigDto config();

        public @Nullable String heading();

        public List<GaugeValueRepository.Gauge> gauges();

        public List<SyntheticMonitorItem> syntheticMonitors();

        public List<PagerDutyConfig.PagerDutyIntegrationKey> pagerDutyIntegrationKeys();

        public List<SlackWebhookItem> slackWebhooks();
    }

    @Value.Immutable
    static interface AlertListItem {
        public String version();

        public String display();
    }

    @Value.Immutable
    static interface AlertListResponse {
        public List<AlertListItem> alerts();

        public @Nullable Long disabledForNextMillis();
    }

    @Value.Immutable
    static interface AlertConfigRequest {
        public Optional<String> version();
    }
}

