/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableAllConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutablePluginConfig;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.google.protobuf.AbstractMessage;
import org.glowroot.agent.shaded.org.glowroot.common.config.AdvancedConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.AlertConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.GaugeConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableAdvancedConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableAlertConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableGaugeConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableInstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableJvmConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableSyntheticMonitorConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableTransactionConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableUiDefaultsConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.InstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.JvmConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.PropertyValue;
import org.glowroot.agent.shaded.org.glowroot.common.config.SyntheticMonitorConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.TransactionConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.UiDefaultsConfig;
import org.glowroot.agent.shaded.org.glowroot.common.util.Versions;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.immutables.value.Value;

@Value.Immutable
abstract class AllConfigDto {
    AllConfigDto() {
    }

    @Value.Default
    ImmutableTransactionConfig transactions() {
        return ImmutableTransactionConfig.builder().build();
    }

    @Value.Default
    ImmutableJvmConfig jvm() {
        return ImmutableJvmConfig.builder().build();
    }

    @Value.Default
    ImmutableUiDefaultsConfig uiDefaults() {
        return ImmutableUiDefaultsConfig.builder().build();
    }

    @Value.Default
    ImmutableAdvancedConfig advanced() {
        return ImmutableAdvancedConfig.builder().build();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    abstract List<ImmutableGaugeConfig> gauges();

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    abstract List<ImmutableSyntheticMonitorConfig> syntheticMonitors();

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    abstract List<ImmutableAlertConfig> alerts();

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    abstract List<ImmutablePluginConfig> plugins();

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    abstract List<ImmutableInstrumentationConfig> instrumentation();

    @Nullable
    abstract String version();

    AgentConfigOuterClass.AgentConfig toProto() {
        AgentConfigOuterClass.AgentConfig.Builder builder = AgentConfigOuterClass.AgentConfig.newBuilder().setTransactionConfig(this.transactions().toProto()).setJvmConfig(this.jvm().toProto()).setUiDefaultsConfig(this.uiDefaults().toProto()).setAdvancedConfig(this.advanced().toProto());
        for (GaugeConfig gaugeConfig : this.gauges()) {
            builder.addGaugeConfig(gaugeConfig.toProto());
        }
        for (SyntheticMonitorConfig syntheticMonitorConfig : this.syntheticMonitors()) {
            builder.addSyntheticMonitorConfig(syntheticMonitorConfig.toProto());
        }
        for (AlertConfig alertConfig : this.alerts()) {
            builder.addAlertConfig(alertConfig.toProto());
        }
        for (PluginConfig pluginConfig : this.plugins()) {
            builder.addPluginConfig(pluginConfig.toProto());
        }
        for (InstrumentationConfig instrumentationConfig : this.instrumentation()) {
            builder.addInstrumentationConfig(instrumentationConfig.toProto());
        }
        return builder.build();
    }

    static AllConfigDto create(AgentConfigOuterClass.AgentConfig config) {
        ImmutableAllConfigDto.Builder builder = ImmutableAllConfigDto.builder().transactions(TransactionConfig.create((AgentConfigOuterClass.AgentConfig.TransactionConfig)config.getTransactionConfig())).jvm(JvmConfig.create((AgentConfigOuterClass.AgentConfig.JvmConfig)config.getJvmConfig())).uiDefaults(UiDefaultsConfig.create((AgentConfigOuterClass.AgentConfig.UiDefaultsConfig)config.getUiDefaultsConfig())).advanced(AdvancedConfig.create((AgentConfigOuterClass.AgentConfig.AdvancedConfig)config.getAdvancedConfig()));
        for (AgentConfigOuterClass.AgentConfig.GaugeConfig gaugeConfig : config.getGaugeConfigList()) {
            builder.addGauges(GaugeConfig.create((AgentConfigOuterClass.AgentConfig.GaugeConfig)gaugeConfig));
        }
        for (AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig syntheticMonitorConfig : config.getSyntheticMonitorConfigList()) {
            builder.addSyntheticMonitors(SyntheticMonitorConfig.create((AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig)syntheticMonitorConfig));
        }
        for (AgentConfigOuterClass.AgentConfig.AlertConfig alertConfig : config.getAlertConfigList()) {
            builder.addAlerts(AlertConfig.create((AgentConfigOuterClass.AgentConfig.AlertConfig)alertConfig));
        }
        for (AgentConfigOuterClass.AgentConfig.PluginConfig pluginConfig : config.getPluginConfigList()) {
            if (pluginConfig.getPropertyCount() <= 0) continue;
            builder.addPlugins(PluginConfig.create(pluginConfig));
        }
        for (AgentConfigOuterClass.AgentConfig.InstrumentationConfig instrumentationConfig : config.getInstrumentationConfigList()) {
            builder.addInstrumentation(InstrumentationConfig.create((AgentConfigOuterClass.AgentConfig.InstrumentationConfig)instrumentationConfig));
        }
        return builder.version(Versions.getVersion((AbstractMessage)config)).build();
    }

    @Value.Immutable
    static abstract class PluginConfig {
        PluginConfig() {
        }

        abstract String id();

        abstract Map<String, PropertyValue> properties();

        AgentConfigOuterClass.AgentConfig.PluginConfig toProto() {
            AgentConfigOuterClass.AgentConfig.PluginConfig.Builder builder = AgentConfigOuterClass.AgentConfig.PluginConfig.newBuilder().setId(this.id());
            for (Map.Entry<String, PropertyValue> entry : this.properties().entrySet()) {
                AgentConfigOuterClass.AgentConfig.PluginProperty.Builder property = AgentConfigOuterClass.AgentConfig.PluginProperty.newBuilder().setName(entry.getKey()).setValue(entry.getValue().toProto());
                builder.addProperty(property);
            }
            return builder.build();
        }

        public static ImmutablePluginConfig create(AgentConfigOuterClass.AgentConfig.PluginConfig config) {
            ImmutablePluginConfig.Builder builder = ImmutablePluginConfig.builder().id(config.getId());
            for (AgentConfigOuterClass.AgentConfig.PluginProperty prop : config.getPropertyList()) {
                builder.putProperties(prop.getName(), PropertyValue.create((AgentConfigOuterClass.AgentConfig.PluginProperty.Value)prop.getValue()));
            }
            return builder.build();
        }
    }
}

