/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.api.Glowroot;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAgentId;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAgentRollupId;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAuthentication;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAutoRefresh;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindRequest;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ChunkSource;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GET;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpServerHandler;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpSessionManager;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableCredentials;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableJsonServiceMapping;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonServiceException;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.LayoutService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.POST;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.QueryStrings;
import org.glowroot.agent.embedded.sql.SQLException;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.google.common.base.Joiner;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.io.CharStreams;
import org.glowroot.agent.shaded.com.google.common.io.Resources;
import org.glowroot.agent.shaded.com.google.common.net.MediaType;
import org.glowroot.agent.shaded.io.netty.buffer.Unpooled;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.DefaultHttpHeaders;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpHeaders;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.glowroot.common.util.Throwables;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.immutables.value.Value;

public class CommonHandler {
    private static final Logger logger = LoggerFactory.getLogger(CommonHandler.class);
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"audit");
    private static final ObjectMapper mapper = ObjectMappers.create((Module[])new Module[0]);
    private static final long TEN_YEARS = TimeUnit.DAYS.toMillis(3650L);
    private static final long ONE_DAY = TimeUnit.DAYS.toMillis(1L);
    private static final long FIVE_MINUTES = TimeUnit.MINUTES.toMillis(5L);
    private static final String RESOURCE_BASE = "org/glowroot/agent/embedded/shaded/org/glowroot/ui/app-dist";
    private static final @Nullable String RESOURCE_BASE_URL_PREFIX;
    private static final ImmutableMap<String, MediaType> mediaTypes;
    private static final int H2_STATEMENT_WAS_CANCELED = 57014;
    private final boolean central;
    private final LayoutService layoutService;
    private final ImmutableMap<Pattern, HttpService> httpServices;
    private final ImmutableList<JsonServiceMapping> jsonServiceMappings;
    private final HttpSessionManager httpSessionManager;
    private final Clock clock;

    CommonHandler(boolean central, LayoutService layoutService, Map<Pattern, HttpService> httpServices, HttpSessionManager httpSessionManager, List<Object> jsonServices, Clock clock) {
        this.central = central;
        this.layoutService = layoutService;
        this.httpServices = ImmutableMap.copyOf(httpServices);
        this.httpSessionManager = httpSessionManager;
        this.clock = clock;
        ArrayList jsonServiceMappings = Lists.newArrayList();
        for (Object jsonService : jsonServices) {
            for (Method method : jsonService.getClass().getDeclaredMethods()) {
                POST annotationPOST;
                GET annotationGET = method.getAnnotation(GET.class);
                if (annotationGET != null) {
                    jsonServiceMappings.add(CommonHandler.build(HttpMethod.GET, annotationGET.path(), annotationGET.permission(), jsonService, method));
                }
                if ((annotationPOST = method.getAnnotation(POST.class)) == null) continue;
                jsonServiceMappings.add(CommonHandler.build(HttpMethod.POST, annotationPOST.path(), annotationPOST.permission(), jsonService, method));
            }
        }
        this.jsonServiceMappings = ImmutableList.copyOf((Collection)jsonServiceMappings);
    }

    public CommonResponse handle(CommonRequest request) throws Exception {
        logger.debug("handleRequest(): path={}", (Object)request.getPath());
        CommonResponse response = this.handleIfLoginOrLogoutRequest(request);
        if (response != null) {
            return response;
        }
        boolean autoRefresh = CommonHandler.isAutoRefresh(request.getParameters("auto-refresh"));
        boolean touchSession = !autoRefresh && !request.getPath().equals("/backend/layout");
        HttpSessionManager.Authentication authentication = this.httpSessionManager.getAuthentication(request, touchSession);
        Glowroot.setTransactionUser(authentication.caseAmbiguousUsername());
        String agentRollupId = CommonHandler.getAgentRollupIdFromRequest(request);
        response = this.handleRequest(request, authentication);
        if (request.getPath().startsWith("/backend/")) {
            String agentRollupLayoutVersion;
            if (!request.getPath().equals("/backend/layout")) {
                response.setHeader("Glowroot-Layout-Version", this.layoutService.getLayoutVersion(authentication));
            }
            if (!request.getPath().equals("/backend/agent-rollup-layout") && agentRollupId != null && (agentRollupLayoutVersion = this.layoutService.getAgentRollupLayoutVersion(authentication, agentRollupId)) != null) {
                response.setHeader("Glowroot-Agent-Rollup-Layout-Version", agentRollupLayoutVersion);
            }
        }
        return response;
    }

    private @Nullable CommonResponse handleIfLoginOrLogoutRequest(CommonRequest request) throws Exception {
        String path = request.getPath();
        if (path.equals("/backend/login")) {
            String content = request.getContent();
            Credentials credentials = (Credentials)mapper.readValue(content, ImmutableCredentials.class);
            Glowroot.setTransactionUser(credentials.username());
            return this.httpSessionManager.login(credentials.username(), credentials.password());
        }
        if (path.equals("/backend/sign-out")) {
            this.httpSessionManager.signOut(request);
            HttpSessionManager.Authentication authentication = this.httpSessionManager.getAnonymousAuthentication();
            Glowroot.setTransactionUser(authentication.caseAmbiguousUsername());
            String anonymousLayout = this.layoutService.getLayoutJson(authentication);
            CommonResponse response = new CommonResponse(HttpResponseStatus.OK, MediaType.JSON_UTF_8, anonymousLayout);
            this.httpSessionManager.deleteSessionCookie(response);
            return response;
        }
        if (path.equals("/backend/check-layout")) {
            String agentRollupLayoutVersion;
            HttpSessionManager.Authentication authentication = this.httpSessionManager.getAuthentication(request, false);
            CommonResponse response = new CommonResponse(HttpResponseStatus.OK);
            response.setHeader("Glowroot-Layout-Version", this.layoutService.getLayoutVersion(authentication));
            List<String> agentRollupIds = request.getParameters("agent-rollup-id");
            if (agentRollupIds != null && agentRollupIds.size() == 1 && (agentRollupLayoutVersion = this.layoutService.getAgentRollupLayoutVersion(authentication, agentRollupIds.get(0))) != null) {
                response.setHeader("Glowroot-Agent-Rollup-Layout-Version", agentRollupLayoutVersion);
            }
            return response;
        }
        if (path.equals("/backend/layout")) {
            HttpSessionManager.Authentication authentication = this.httpSessionManager.getAuthentication(request, false);
            return new CommonResponse(HttpResponseStatus.OK, MediaType.JSON_UTF_8, this.layoutService.getLayoutJson(authentication));
        }
        if (path.equals("/backend/agent-rollup-layout")) {
            HttpSessionManager.Authentication authentication = this.httpSessionManager.getAuthentication(request, false);
            String agentRollupId = request.getParameters("agent-rollup-id").get(0);
            return new CommonResponse(HttpResponseStatus.OK, MediaType.JSON_UTF_8, this.layoutService.getAgentRollupLayoutJson(agentRollupId, authentication));
        }
        return null;
    }

    private CommonResponse handleRequest(CommonRequest request, HttpSessionManager.Authentication authentication) throws Exception {
        String path = request.getPath();
        HttpService httpService = this.getHttpService(path);
        if (httpService != null) {
            return this.handleHttpService(request, httpService, authentication);
        }
        JsonServiceMapping jsonServiceMapping = this.getJsonServiceMapping(request, path);
        if (jsonServiceMapping != null) {
            return this.handleJsonServiceMappings(request, jsonServiceMapping, authentication);
        }
        return this.handleStaticResource(path, request);
    }

    private @Nullable HttpService getHttpService(String path) {
        for (Map.Entry entry : this.httpServices.entrySet()) {
            Matcher matcher = ((Pattern)entry.getKey()).matcher(path);
            if (!matcher.matches()) continue;
            return (HttpService)entry.getValue();
        }
        return null;
    }

    private CommonResponse handleHttpService(CommonRequest request, HttpService httpService, HttpSessionManager.Authentication authentication) throws Exception {
        String agentId;
        String permission = httpService.getPermission();
        if (permission.isEmpty()) {
            return httpService.handleRequest(request, authentication);
        }
        List<String> agentIds = request.getParameters("agent-id");
        String string = agentId = agentIds.isEmpty() ? "" : agentIds.get(0);
        if (!authentication.isPermitted(agentId, permission)) {
            return this.handleNotAuthorized(request, authentication);
        }
        return httpService.handleRequest(request, authentication);
    }

    private @Nullable JsonServiceMapping getJsonServiceMapping(CommonRequest request, String path) {
        for (JsonServiceMapping jsonServiceMapping : this.jsonServiceMappings) {
            if (!jsonServiceMapping.httpMethod().name().equals(request.getMethod()) || !jsonServiceMapping.path().equals(path)) continue;
            return jsonServiceMapping;
        }
        return null;
    }

    private CommonResponse handleJsonServiceMappings(CommonRequest request, JsonServiceMapping jsonServiceMapping, HttpSessionManager.Authentication authentication) throws Exception {
        Object responseObject;
        boolean permitted;
        ArrayList parameterTypes = Lists.newArrayList();
        ArrayList parameters = Lists.newArrayList();
        Map<String, List<String>> queryParameters = request.getParameters();
        if (jsonServiceMapping.bindAgentId()) {
            List<String> values = queryParameters.get("agent-id");
            if (values == null) {
                throw new JsonServiceException(HttpResponseStatus.BAD_REQUEST, "missing agent-id query parameter");
            }
            String agentId = values.get(0);
            if (this.central && agentId.isEmpty()) {
                throw new JsonServiceException(HttpResponseStatus.BAD_REQUEST, "agent-id query parameter is empty");
            }
            if (agentId.endsWith("::")) {
                throw new JsonServiceException(HttpResponseStatus.BAD_REQUEST, "agent rollup id received when expecting an agent id");
            }
            parameterTypes.add(String.class);
            parameters.add(agentId);
            queryParameters.remove("agent-id");
            permitted = authentication.isPermittedForAgentRollup(agentId, jsonServiceMapping.permission());
        } else if (jsonServiceMapping.bindAgentRollup()) {
            List<String> agentRollupIds = queryParameters.get("agent-rollup-id");
            if (agentRollupIds == null) {
                throw new JsonServiceException(HttpResponseStatus.BAD_REQUEST, "missing agent-rollup-id query parameter");
            }
            String agentRollupId = agentRollupIds.get(0);
            parameterTypes.add(String.class);
            parameters.add(agentRollupId);
            queryParameters.remove("agent-rollup-id");
            permitted = authentication.isPermittedForAgentRollup(agentRollupId, jsonServiceMapping.permission());
        } else {
            boolean bl = permitted = jsonServiceMapping.permission().isEmpty() || authentication.isAdminPermitted(jsonServiceMapping.permission());
        }
        if (!permitted) {
            return this.handleNotAuthorized(request, authentication);
        }
        try {
            responseObject = CommonHandler.callMethod(jsonServiceMapping, parameterTypes, parameters, queryParameters, authentication, request);
        }
        catch (Exception e) {
            return this.newHttpResponseFromException(request, authentication, e);
        }
        return CommonHandler.buildJsonResponse(responseObject);
    }

    CommonResponse newHttpResponseFromException(CommonRequest request, HttpSessionManager.Authentication authentication, Exception exception) throws Exception {
        Throwable cause;
        Exception e = exception;
        if (e instanceof InvocationTargetException && (cause = e.getCause()) instanceof Exception) {
            e = (Exception)cause;
        }
        if (e instanceof JsonServiceException) {
            JsonServiceException jsonServiceException = (JsonServiceException)e;
            if (jsonServiceException.getStatus() == HttpResponseStatus.FORBIDDEN) {
                return this.handleNotAuthorized(request, authentication);
            }
            return CommonHandler.newHttpResponseWithMessage(jsonServiceException.getStatus(), jsonServiceException.getMessage());
        }
        logger.error(e.getMessage(), (Throwable)e);
        if (e instanceof SQLException && ((SQLException)e).getErrorCode() == 57014) {
            return CommonHandler.newHttpResponseWithMessage(HttpResponseStatus.REQUEST_TIMEOUT, "Query timed out (timeout is configurable under Configuration > Advanced)");
        }
        return CommonHandler.newHttpResponseWithStackTrace(e, HttpResponseStatus.INTERNAL_SERVER_ERROR, null);
    }

    private CommonResponse handleNotAuthorized(CommonRequest request, HttpSessionManager.Authentication authentication) throws Exception {
        if (authentication.anonymous()) {
            if (this.httpSessionManager.getSessionId(request) != null) {
                return new CommonResponse(HttpResponseStatus.UNAUTHORIZED, MediaType.JSON_UTF_8, "{\"timedOut\":true}");
            }
            return new CommonResponse(HttpResponseStatus.UNAUTHORIZED);
        }
        return new CommonResponse(HttpResponseStatus.FORBIDDEN);
    }

    private CommonResponse handleStaticResource(String path, CommonRequest request) throws IOException {
        URL url = CommonHandler.getSecureUrlForPath(RESOURCE_BASE + path);
        if (url == null) {
            logger.debug("unexpected path: {}", (Object)path);
            return new CommonResponse(HttpResponseStatus.NOT_FOUND);
        }
        Date expires = this.getExpiresForPath(path);
        if (request.getHeader((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE) != null && expires == null) {
            return new CommonResponse(HttpResponseStatus.NOT_MODIFIED);
        }
        int extensionStartIndex = path.lastIndexOf(46);
        Preconditions.checkState((extensionStartIndex != -1 ? 1 : 0) != 0, (String)"found path under %s with no extension: %s", (Object)RESOURCE_BASE, (Object)path);
        String extension = path.substring(extensionStartIndex + 1);
        MediaType mediaType = (MediaType)mediaTypes.get((Object)extension);
        Preconditions.checkNotNull((Object)mediaType, (String)"found extension under %s with no media type: %s", (Object)RESOURCE_BASE, (Object)extension);
        CommonResponse response = new CommonResponse(HttpResponseStatus.OK, mediaType, url);
        if (expires != null) {
            response.setHeader((CharSequence)HttpHeaderNames.EXPIRES, expires);
            response.setHeader((CharSequence)HttpHeaderNames.CACHE_CONTROL, "public, max-age=" + expires.getTime());
        } else {
            response.setHeader((CharSequence)HttpHeaderNames.LAST_MODIFIED, new Date(0L));
            response.setHeader((CharSequence)HttpHeaderNames.EXPIRES, new Date(this.clock.currentTimeMillis() + TEN_YEARS));
            response.setHeader((CharSequence)HttpHeaderNames.CACHE_CONTROL, "public, max-age=" + TEN_YEARS + ", immutable");
        }
        return response;
    }

    private @Nullable Date getExpiresForPath(String path) {
        if (path.startsWith("org/glowroot/agent/embedded/shaded/org/glowroot/ui/app-dist/favicon.")) {
            return new Date(this.clock.currentTimeMillis() + ONE_DAY);
        }
        if (path.endsWith(".js.map") || path.startsWith("/sources/")) {
            return new Date(this.clock.currentTimeMillis() + FIVE_MINUTES);
        }
        return null;
    }

    private static @Nullable String getAgentRollupIdFromRequest(CommonRequest request) {
        List<String> agentIds = request.getParameters("agent-id");
        if (agentIds != null && agentIds.size() == 1) {
            return agentIds.get(0);
        }
        List<String> agentRollupIds = request.getParameters("agent-rollup-id");
        if (agentRollupIds != null && agentRollupIds.size() == 1) {
            return agentRollupIds.get(0);
        }
        return null;
    }

    private static CommonResponse buildJsonResponse(@Nullable Object responseObject) {
        if (responseObject == null) {
            return new CommonResponse(HttpResponseStatus.OK, MediaType.JSON_UTF_8, "");
        }
        if (responseObject instanceof CommonResponse) {
            return (CommonResponse)responseObject;
        }
        if (responseObject instanceof String) {
            return new CommonResponse(HttpResponseStatus.OK, MediaType.JSON_UTF_8, (String)responseObject);
        }
        logger.warn("unexpected type of json service response: {}", (Object)responseObject.getClass().getName());
        return new CommonResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR);
    }

    private static JsonServiceMapping build(HttpMethod httpMethod, String path, String permission, Object jsonService, Method method) {
        boolean bindAgentId = false;
        boolean bindAgentRollup = false;
        Class<?> bindRequest = null;
        boolean bindAutoRefresh = false;
        boolean bindAuthentication = false;
        for (int i = 0; i < method.getParameterAnnotations().length; ++i) {
            Annotation[] parameterAnnotations;
            for (Annotation annotation : parameterAnnotations = method.getParameterAnnotations()[i]) {
                if (annotation.annotationType() == BindAgentId.class) {
                    bindAgentId = true;
                    continue;
                }
                if (annotation.annotationType() == BindAgentRollupId.class) {
                    bindAgentRollup = true;
                    continue;
                }
                if (annotation.annotationType() == BindRequest.class) {
                    bindRequest = method.getParameterTypes()[i];
                    continue;
                }
                if (annotation.annotationType() == BindAutoRefresh.class) {
                    bindAutoRefresh = true;
                    continue;
                }
                if (annotation.annotationType() != BindAuthentication.class) continue;
                bindAuthentication = true;
            }
        }
        return ImmutableJsonServiceMapping.builder().httpMethod(httpMethod).path(path).permission(permission).service(jsonService).method(method).bindAgentId(bindAgentId).bindAgentRollup(bindAgentRollup).bindRequest(bindRequest).bindAutoRefresh(bindAutoRefresh).bindAuthentication(bindAuthentication).build();
    }

    private static @Nullable URL getSecureUrlForPath(String path) {
        URL url = CommonHandler.getUrlForPath(path);
        if (url != null && RESOURCE_BASE_URL_PREFIX != null && url.toExternalForm().startsWith(RESOURCE_BASE_URL_PREFIX)) {
            return url;
        }
        return null;
    }

    private static @Nullable URL getUrlForPath(String path) {
        ClassLoader classLoader = HttpServerHandler.class.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResource(path);
        }
        return classLoader.getResource(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CommonResponse newHttpResponseWithMessage(HttpResponseStatus status, @Nullable String message) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeStringField("message", message);
            jg.writeEndObject();
        }
        return new CommonResponse(status, MediaType.JSON_UTF_8, sb.toString());
    }

    static CommonResponse newHttpResponseWithStackTrace(Exception e, HttpResponseStatus status, @Nullable String simplifiedMessage) throws IOException {
        return new CommonResponse(status, MediaType.JSON_UTF_8, CommonHandler.getHttpResponseWithStackTrace(e, simplifiedMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHttpResponseWithStackTrace(Exception e, @Nullable String simplifiedMessage) throws IOException {
        StringBuilder stackTrace = new StringBuilder();
        e.printStackTrace(new PrintWriter(CharStreams.asWriter((Appendable)stackTrace)));
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            String message = simplifiedMessage == null ? Throwables.getBestMessage((Throwable)e) : simplifiedMessage;
            jg.writeStringField("message", message);
            jg.writeStringField("stackTrace", stackTrace.toString());
            jg.writeEndObject();
        }
        return sb.toString();
    }

    private static @Nullable Object callMethod(JsonServiceMapping jsonServiceMapping, List<Class<?>> parameterTypes, List<Object> parameters, Map<String, List<String>> queryParameters, HttpSessionManager.Authentication authentication, CommonRequest request) throws Exception {
        List<String> autoRefreshParams = queryParameters.remove("auto-refresh");
        boolean autoRefresh = CommonHandler.isAutoRefresh(autoRefreshParams);
        Class<?> bindRequest = jsonServiceMapping.bindRequest();
        if (bindRequest != null) {
            parameterTypes.add(bindRequest);
            if (jsonServiceMapping.httpMethod() == HttpMethod.GET) {
                parameters.add(QueryStrings.decode(queryParameters, bindRequest));
            } else {
                String content = request.getContent();
                auditLogger.info("{} - POST {} - {}", new Object[]{authentication.caseAmbiguousUsername(), request.getUri(), content});
                if (bindRequest == String.class) {
                    parameters.add(content);
                } else {
                    Object param = mapper.readValue(content, QueryStrings.getImmutableClass(bindRequest));
                    Preconditions.checkNotNull((Object)param);
                    parameters.add(param);
                }
            }
        }
        if (jsonServiceMapping.bindAutoRefresh()) {
            parameterTypes.add(Boolean.TYPE);
            parameters.add(autoRefresh);
        }
        if (jsonServiceMapping.bindAuthentication()) {
            parameterTypes.add(HttpSessionManager.Authentication.class);
            parameters.add(authentication);
        }
        Object service = jsonServiceMapping.service();
        if (logger.isDebugEnabled()) {
            String params = Joiner.on((String)", ").join(parameters);
            logger.debug("{}.{}(): {}", new Object[]{service.getClass().getSimpleName(), jsonServiceMapping.method().getName(), params});
        }
        return jsonServiceMapping.method().invoke(service, parameters.toArray(new Object[parameters.size()]));
    }

    private static boolean isAutoRefresh(@Nullable List<String> autoRefreshParams) {
        return autoRefreshParams != null && autoRefreshParams.size() == 1 && Boolean.valueOf(autoRefreshParams.get(0)) != false;
    }

    static {
        mediaTypes = ImmutableMap.builder().put((Object)"html", (Object)MediaType.HTML_UTF_8).put((Object)"js", (Object)MediaType.TEXT_JAVASCRIPT_UTF_8).put((Object)"css", (Object)MediaType.CSS_UTF_8).put((Object)"ico", (Object)MediaType.create((String)"image", (String)"x-icon")).put((Object)"woff", (Object)MediaType.WOFF).put((Object)"woff2", (Object)MediaType.create((String)"application", (String)"font-woff2")).put((Object)"swf", (Object)MediaType.create((String)"application", (String)"vnd.adobe.flash-movie")).put((Object)"map", (Object)MediaType.JSON_UTF_8).build();
        URL resourceBaseUrl = CommonHandler.getUrlForPath("org/glowroot/agent/embedded/shaded/org/glowroot/ui/app-dist/index.html");
        if (resourceBaseUrl == null) {
            RESOURCE_BASE_URL_PREFIX = null;
        } else {
            String externalForm = resourceBaseUrl.toExternalForm();
            RESOURCE_BASE_URL_PREFIX = externalForm.substring(0, externalForm.length() - "/index.html".length());
        }
    }

    public static class CommonResponse {
        private final HttpResponseStatus status;
        private final HttpHeaders headers = new DefaultHttpHeaders();
        private final Object content;
        private @Nullable String zipFileName;
        private boolean closeConnectionAfterPortChange;

        CommonResponse(HttpResponseStatus status, MediaType mediaType, String content) {
            this(status, mediaType, content, true);
        }

        CommonResponse(HttpResponseStatus status, MediaType mediaType, ChunkSource content) {
            this(status, mediaType, content, true);
        }

        CommonResponse(HttpResponseStatus status) {
            this(status, null, "", true);
        }

        private CommonResponse(HttpResponseStatus status, MediaType mediaType, URL url) throws IOException {
            this(status, mediaType, Unpooled.copiedBuffer((byte[])Resources.toByteArray((URL)url)), false);
        }

        private CommonResponse(HttpResponseStatus status, @Nullable MediaType mediaType, Object content, boolean preventCaching) {
            this.status = status;
            this.content = content;
            if (mediaType != null) {
                this.headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mediaType);
            }
            if (preventCaching) {
                this.headers.set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"no-store, must-revalidate");
            }
        }

        void setHeader(CharSequence name, Object value) {
            this.headers.set(name, value);
        }

        void setZipFileName(String zipFileName) {
            this.zipFileName = zipFileName;
        }

        void setCloseConnectionAfterPortChange() {
            this.closeConnectionAfterPortChange = true;
        }

        public HttpResponseStatus getStatus() {
            return this.status;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public Object getContent() {
            return this.content;
        }

        public @Nullable String getZipFileName() {
            return this.zipFileName;
        }

        boolean isCloseConnectionAfterPortChange() {
            return this.closeConnectionAfterPortChange;
        }
    }

    public static interface CommonRequest {
        public String getMethod();

        public String getUri();

        public String getContextPath();

        public String getPath();

        public @Nullable String getHeader(CharSequence var1);

        public Map<String, List<String>> getParameters();

        public List<String> getParameters(String var1);

        public String getContent() throws IOException;
    }

    static enum HttpMethod {
        GET,
        POST;

    }

    @Value.Immutable
    static interface JsonServiceMapping {
        public HttpMethod httpMethod();

        public String path();

        public String permission();

        public Object service();

        public Method method();

        public boolean bindAgentId();

        public boolean bindAgentRollup();

        public @Nullable Class<?> bindRequest();

        public boolean bindAutoRefresh();

        public boolean bindAuthentication();
    }

    @Value.Immutable
    static interface Credentials {
        public String username();

        public String password();
    }
}

