/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.MoreConfigDefaults;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.GaugeValueRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.TransactionTypeRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.AllConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAgentId;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAgentRollupId;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindRequest;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GET;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GaugeValueJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableAdvancedConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableGeneralConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableJvmConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutablePluginConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutablePluginPropertyDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutablePluginResponse;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableSlowThresholdOverrideDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableTransactionConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableTransactionConfigResponse;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableUiDefaultsConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableUiDefaultsConfigResponse;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonServiceException;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.POST;
import org.glowroot.agent.embedded.shaded.org.owasp.html.HtmlPolicyBuilder;
import org.glowroot.agent.embedded.shaded.org.owasp.html.PolicyFactory;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.BooleanNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.DoubleNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.TextNode;
import org.glowroot.agent.shaded.com.google.common.annotations.VisibleForTesting;
import org.glowroot.agent.shaded.com.google.common.base.Optional;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.com.google.common.io.CharStreams;
import org.glowroot.agent.shaded.com.google.protobuf.AbstractMessage;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.agent.shaded.org.glowroot.common.config.PluginNameComparison;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveAggregateRepository;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.glowroot.agent.shaded.org.glowroot.common.util.Versions;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.Proto;
import org.immutables.value.Value;

@JsonService
class ConfigJsonService {
    private static final ObjectMapper mapper = ObjectMappers.create((Module[])new Module[0]);
    private final TransactionTypeRepository transactionTypeRepository;
    private final GaugeValueRepository gaugeValueRepository;
    private final LiveAggregateRepository liveAggregateRepository;
    private final ConfigRepository configRepository;
    private final SanitizationService sanitizationService;

    ConfigJsonService(TransactionTypeRepository transactionTypeRepository, GaugeValueRepository gaugeValueRepository, LiveAggregateRepository liveAggregateRepository, ConfigRepository configRepository) {
        this.transactionTypeRepository = transactionTypeRepository;
        this.gaugeValueRepository = gaugeValueRepository;
        this.liveAggregateRepository = liveAggregateRepository;
        this.configRepository = configRepository;
        this.sanitizationService = new SanitizationService();
    }

    @GET(path="/backend/config/general", permission="agent:config:view:general")
    String getGeneralConfig(@BindAgentRollupId String agentRollupId) throws Exception {
        AgentConfigOuterClass.AgentConfig.GeneralConfig config = this.configRepository.getGeneralConfig(agentRollupId);
        return mapper.writeValueAsString((Object)GeneralConfigDto.create(config, agentRollupId));
    }

    @GET(path="/backend/config/transaction", permission="agent:config:view:transaction")
    String getTransactionConfig(@BindAgentId String agentId) throws Exception {
        AgentConfigOuterClass.AgentConfig.TransactionConfig config = this.configRepository.getTransactionConfig(agentId);
        TreeSet transactionTypes = Sets.newTreeSet();
        transactionTypes.addAll((Collection)this.transactionTypeRepository.read(agentId).toCompletableFuture().join());
        transactionTypes.addAll(this.liveAggregateRepository.getTransactionTypes(agentId));
        transactionTypes.add(this.configRepository.getUiDefaultsConfig(agentId).getDefaultTransactionType());
        return mapper.writeValueAsString((Object)ImmutableTransactionConfigResponse.builder().config(TransactionConfigDto.create(config)).defaultTransactionType(this.configRepository.getUiDefaultsConfig(agentId).getDefaultTransactionType()).addAllAllTransactionTypes(transactionTypes).build());
    }

    @GET(path="/backend/config/jvm", permission="agent:config:view:jvm")
    String getJvmConfig(@BindAgentId String agentId) throws Exception {
        AgentConfigOuterClass.AgentConfig.JvmConfig config = this.configRepository.getJvmConfig(agentId);
        return mapper.writeValueAsString((Object)JvmConfigDto.create(config));
    }

    @GET(path="/backend/config/ui-defaults", permission="agent:config:view:uiDefaults")
    String getUiDefaultsConfig(@BindAgentRollupId String agentRollupId) throws Exception {
        AgentConfigOuterClass.AgentConfig.UiDefaultsConfig config = this.configRepository.getUiDefaultsConfig(agentRollupId);
        TreeSet transactionTypes = Sets.newTreeSet();
        transactionTypes.addAll((Collection)this.transactionTypeRepository.read(agentRollupId).toCompletableFuture().join());
        transactionTypes.addAll(this.liveAggregateRepository.getTransactionTypes(agentRollupId));
        List<GaugeValueRepository.Gauge> gauges = this.gaugeValueRepository.getRecentlyActiveGauges(agentRollupId).toCompletableFuture().get();
        ImmutableList sortedGauges = new GaugeValueJsonService.GaugeOrdering().immutableSortedCopy(gauges);
        return mapper.writeValueAsString((Object)ImmutableUiDefaultsConfigResponse.builder().config(UiDefaultsConfigDto.create(config)).addAllAllTransactionTypes(transactionTypes).addAllAllGauges((Iterable<? extends GaugeValueRepository.Gauge>)sortedGauges).build());
    }

    @GET(path="/backend/config/plugins", permission="agent:config:view:plugin")
    String getPluginConfig(@BindAgentId String agentId, @BindRequest PluginConfigRequest request) throws Exception {
        Optional<String> pluginId = request.pluginId();
        if (pluginId.isPresent()) {
            return this.getPluginConfigInternal(agentId, (String)request.pluginId().get());
        }
        ArrayList pluginResponses = Lists.newArrayList();
        List pluginConfigs = new PluginConfigNameOrdering().sortedCopy(this.configRepository.getPluginConfigs(agentId));
        for (AgentConfigOuterClass.AgentConfig.PluginConfig pluginConfig : pluginConfigs) {
            pluginResponses.add(ImmutablePluginResponse.builder().id(pluginConfig.getId()).name(pluginConfig.getName()).hasConfig(pluginConfig.getPropertyCount() > 0).build());
        }
        return mapper.writeValueAsString((Object)pluginResponses);
    }

    @GET(path="/backend/config/advanced", permission="agent:config:view:advanced")
    String getAdvancedConfig(@BindAgentRollupId String agentRollupId) throws Exception {
        AgentConfigOuterClass.AgentConfig.AdvancedConfig config = this.configRepository.getAdvancedConfig(agentRollupId).toCompletableFuture().get();
        return mapper.writeValueAsString((Object)AdvancedConfigDto.create(config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET(path="/backend/config/json", permission="agent:config:view")
    String getAllConfig(@BindAgentId String agentId) throws Exception {
        AgentConfigOuterClass.AgentConfig config = this.configRepository.getAllConfig(agentId);
        ObjectNode configRootNode = (ObjectNode)mapper.valueToTree((Object)AllConfigDto.create(config));
        ObjectMappers.stripEmptyContainerNodes((ObjectNode)configRootNode);
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.setPrettyPrinter(ObjectMappers.getPrettyPrinter());
            jg.writeObject((Object)configRootNode);
        }
        sb.append(ObjectMappers.NEWLINE);
        return sb.toString();
    }

    @POST(path="/backend/config/general", permission="agent:config:edit:general")
    String updateGeneralConfig(@BindAgentRollupId String agentRollupId, @BindRequest GeneralConfigDto configDto) throws Exception {
        try {
            this.configRepository.updateGeneralConfig(agentRollupId, configDto.convert(), configDto.version(), CassandraProfile.web).toCompletableFuture().join();
        }
        catch (ConfigRepository.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.getGeneralConfig(agentRollupId);
    }

    @POST(path="/backend/config/transaction", permission="agent:config:edit:transaction")
    String updateTransactionConfig(@BindAgentId String agentId, @BindRequest TransactionConfigDto configDto) throws Exception {
        try {
            this.configRepository.updateTransactionConfig(agentId, configDto.convert(), configDto.version(), CassandraProfile.web).toCompletableFuture().join();
        }
        catch (ConfigRepository.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.getTransactionConfig(agentId);
    }

    @POST(path="/backend/config/jvm", permission="agent:config:edit:jvm")
    String updateJvmConfig(@BindAgentId String agentId, @BindRequest JvmConfigDto configDto) throws Exception {
        try {
            this.configRepository.updateJvmConfig(agentId, configDto.convert(), configDto.version(), CassandraProfile.web).toCompletableFuture().join();
        }
        catch (ConfigRepository.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.getJvmConfig(agentId);
    }

    @POST(path="/backend/config/ui-defaults", permission="agent:config:edit:uiDefaults")
    String updateUiDefaultsConfig(@BindAgentRollupId String agentRollupId, @BindRequest UiDefaultsConfigDto configDto) throws Exception {
        configDto = this.sanitizationService.sanitize(configDto);
        try {
            this.configRepository.updateUiDefaultsConfig(agentRollupId, configDto.convert(), configDto.version(), CassandraProfile.web).toCompletableFuture().join();
        }
        catch (ConfigRepository.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.getUiDefaultsConfig(agentRollupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST(path="/backend/config/plugins", permission="agent:config:edit:plugins")
    String updatePluginConfig(@BindAgentId String agentId, @BindRequest PluginUpdateRequest request) throws Exception {
        String firstInvalidRegularExpression;
        String pluginId = request.pluginId();
        if (pluginId.equals("jdbc") && (firstInvalidRegularExpression = ConfigJsonService.getFirstInvalidJdbcPluginRegularExpressions(request.properties())) != null) {
            StringBuilder sb = new StringBuilder();
            try (JsonGenerator jsonGenerator = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("firstInvalidRegularExpression", firstInvalidRegularExpression);
                jsonGenerator.writeEndObject();
            }
            return sb.toString();
        }
        AgentConfigOuterClass.AgentConfig.PluginConfig.Builder builder = AgentConfigOuterClass.AgentConfig.PluginConfig.newBuilder().setId(pluginId);
        for (PluginPropertyDto pluginPropertyDto : request.properties()) {
            builder.addProperty(pluginPropertyDto.convert());
        }
        try {
            this.configRepository.updatePluginConfig(agentId, builder.build(), request.version(), CassandraProfile.web).toCompletableFuture().join();
        }
        catch (ConfigRepository.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.getPluginConfigInternal(agentId, pluginId);
    }

    @POST(path="/backend/config/advanced", permission="agent:config:edit:advanced")
    String updateAdvancedConfig(@BindAgentRollupId String agentRollupId, @BindRequest AdvancedConfigDto configDto) throws Exception {
        try {
            this.configRepository.updateAdvancedConfig(agentRollupId, configDto.convert(), configDto.version(), CassandraProfile.web).toCompletableFuture().join();
        }
        catch (ConfigRepository.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.getAdvancedConfig(agentRollupId);
    }

    @POST(path="/backend/config/json", permission="agent:config:edit")
    String updateAllConfig(@BindAgentId String agentId, @BindRequest AllConfigDto config) throws Exception {
        try {
            this.configRepository.updateAllConfig(agentId, config.toProto(), config.version(), CassandraProfile.web).toCompletableFuture().join();
        }
        catch (ConfigRepository.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.getAllConfig(agentId);
    }

    private String getPluginConfigInternal(String agentId, String pluginId) throws Exception {
        AgentConfigOuterClass.AgentConfig.PluginConfig config = this.configRepository.getPluginConfig(agentId, pluginId);
        if (config == null) {
            throw new IllegalArgumentException("Plugin id not found: " + pluginId);
        }
        return mapper.writeValueAsString((Object)PluginConfigDto.create(config));
    }

    private static @Nullable String getFirstInvalidJdbcPluginRegularExpressions(List<ImmutablePluginPropertyDto> properties) {
        for (PluginPropertyDto pluginPropertyDto : properties) {
            if (!pluginPropertyDto.name().equals("captureBindParametersIncludes") && !pluginPropertyDto.name().equals("captureBindParametersExcludes")) continue;
            for (JsonNode value : (JsonNode)Preconditions.checkNotNull((Object)pluginPropertyDto.value())) {
                String val = ((JsonNode)Preconditions.checkNotNull((Object)value)).textValue();
                try {
                    Pattern.compile(val);
                }
                catch (PatternSyntaxException e) {
                    return val;
                }
            }
        }
        return null;
    }

    private static Proto.OptionalInt32 of(int value) {
        return Proto.OptionalInt32.newBuilder().setValue(value).build();
    }

    @VisibleForTesting
    static class SanitizationService {
        private final PolicyFactory policy = new HtmlPolicyBuilder().toFactory();

        UiDefaultsConfigDto sanitize(UiDefaultsConfigDto configDto) {
            return ImmutableUiDefaultsConfigDto.builder().copyFrom(configDto).build().withDefaultTransactionType(this.policy.sanitize(configDto.defaultTransactionType()));
        }
    }

    private static class PluginConfigNameOrdering
    extends Ordering<AgentConfigOuterClass.AgentConfig.PluginConfig> {
        private PluginConfigNameOrdering() {
        }

        public int compare(AgentConfigOuterClass.AgentConfig.PluginConfig left, AgentConfigOuterClass.AgentConfig.PluginConfig right) {
            return PluginNameComparison.compareNames((String)left.getName(), (String)right.getName());
        }
    }

    @Value.Immutable
    static abstract class UiDefaultsConfigDto {
        UiDefaultsConfigDto() {
        }

        abstract String defaultTransactionType();

        abstract List<Double> defaultPercentiles();

        abstract List<String> defaultGaugeNames();

        abstract String version();

        private AgentConfigOuterClass.AgentConfig.UiDefaultsConfig convert() throws Exception {
            return AgentConfigOuterClass.AgentConfig.UiDefaultsConfig.newBuilder().setDefaultTransactionType(this.defaultTransactionType()).addAllDefaultPercentile((Iterable)Ordering.natural().immutableSortedCopy(this.defaultPercentiles())).addAllDefaultGaugeName(this.defaultGaugeNames()).build();
        }

        private static ImmutableUiDefaultsConfigDto create(AgentConfigOuterClass.AgentConfig.UiDefaultsConfig config) {
            return ImmutableUiDefaultsConfigDto.builder().defaultTransactionType(config.getDefaultTransactionType()).defaultPercentiles((Iterable<Double>)Ordering.natural().immutableSortedCopy((Iterable)config.getDefaultPercentileList())).defaultGaugeNames((Iterable<String>)config.getDefaultGaugeNameList()).version(Versions.getVersion((AbstractMessage)config)).build();
        }
    }

    @Value.Immutable
    static interface UiDefaultsConfigResponse {
        public ImmutableUiDefaultsConfigDto config();

        public List<String> allTransactionTypes();

        public List<GaugeValueRepository.Gauge> allGauges();
    }

    @Value.Immutable
    static abstract class AdvancedConfigDto {
        AdvancedConfigDto() {
        }

        abstract int immediatePartialStoreThresholdSeconds();

        abstract int maxTransactionAggregates();

        abstract int maxQueryAggregates();

        abstract int maxServiceCallAggregates();

        abstract int maxTraceEntriesPerTransaction();

        abstract int maxProfileSamplesPerTransaction();

        abstract int mbeanGaugeNotFoundDelaySeconds();

        abstract boolean weavingTimer();

        abstract String version();

        private AgentConfigOuterClass.AgentConfig.AdvancedConfig convert() {
            return AgentConfigOuterClass.AgentConfig.AdvancedConfig.newBuilder().setImmediatePartialStoreThresholdSeconds(ConfigJsonService.of(this.immediatePartialStoreThresholdSeconds())).setMaxTransactionAggregates(ConfigJsonService.of(this.maxTransactionAggregates())).setMaxQueryAggregates(ConfigJsonService.of(this.maxQueryAggregates())).setMaxServiceCallAggregates(ConfigJsonService.of(this.maxServiceCallAggregates())).setMaxTraceEntriesPerTransaction(ConfigJsonService.of(this.maxTraceEntriesPerTransaction())).setMaxProfileSamplesPerTransaction(ConfigJsonService.of(this.maxProfileSamplesPerTransaction())).setMbeanGaugeNotFoundDelaySeconds(ConfigJsonService.of(this.mbeanGaugeNotFoundDelaySeconds())).setWeavingTimer(this.weavingTimer()).build();
        }

        private static AdvancedConfigDto create(AgentConfigOuterClass.AgentConfig.AdvancedConfig config) {
            return ImmutableAdvancedConfigDto.builder().immediatePartialStoreThresholdSeconds(config.getImmediatePartialStoreThresholdSeconds().getValue()).maxTransactionAggregates(config.getMaxTransactionAggregates().getValue()).maxQueryAggregates(config.getMaxQueryAggregates().getValue()).maxServiceCallAggregates(config.getMaxServiceCallAggregates().getValue()).maxTraceEntriesPerTransaction(config.getMaxTraceEntriesPerTransaction().getValue()).maxProfileSamplesPerTransaction(config.getMaxProfileSamplesPerTransaction().getValue()).mbeanGaugeNotFoundDelaySeconds(config.getMbeanGaugeNotFoundDelaySeconds().getValue()).weavingTimer(config.getWeavingTimer()).version(Versions.getVersion((AbstractMessage)config)).build();
        }
    }

    static enum PropertyType {
        BOOLEAN,
        DOUBLE,
        STRING,
        LIST;

    }

    @Value.Immutable
    static abstract class PluginPropertyDto {
        PluginPropertyDto() {
        }

        abstract String name();

        abstract PropertyType type();

        abstract @Nullable JsonNode value();

        abstract @Nullable String label();

        abstract @Nullable String checkboxLabel();

        abstract @Nullable String description();

        private AgentConfigOuterClass.AgentConfig.PluginProperty convert() {
            return AgentConfigOuterClass.AgentConfig.PluginProperty.newBuilder().setName(this.name()).setValue(this.getValue()).build();
        }

        private AgentConfigOuterClass.AgentConfig.PluginProperty.Value getValue() {
            JsonNode value = this.value();
            switch (this.type()) {
                case BOOLEAN: {
                    Preconditions.checkNotNull((Object)value);
                    return AgentConfigOuterClass.AgentConfig.PluginProperty.Value.newBuilder().setBval(value.booleanValue()).build();
                }
                case DOUBLE: {
                    if (value == null) {
                        return AgentConfigOuterClass.AgentConfig.PluginProperty.Value.newBuilder().setDvalNull(true).build();
                    }
                    return AgentConfigOuterClass.AgentConfig.PluginProperty.Value.newBuilder().setDval(value.numberValue().doubleValue()).build();
                }
                case STRING: {
                    Preconditions.checkNotNull((Object)value);
                    return AgentConfigOuterClass.AgentConfig.PluginProperty.Value.newBuilder().setSval(value.textValue()).build();
                }
                case LIST: {
                    Preconditions.checkNotNull((Object)value);
                    AgentConfigOuterClass.AgentConfig.PluginProperty.StringList.Builder lval = AgentConfigOuterClass.AgentConfig.PluginProperty.StringList.newBuilder();
                    for (JsonNode val : value) {
                        lval.addVal(((JsonNode)Preconditions.checkNotNull((Object)val)).textValue());
                    }
                    return AgentConfigOuterClass.AgentConfig.PluginProperty.Value.newBuilder().setLval(lval).build();
                }
            }
            throw new IllegalStateException("Unexpected property type: " + (Object)((Object)this.type()));
        }

        private static ImmutablePluginPropertyDto create(AgentConfigOuterClass.AgentConfig.PluginProperty property) {
            return ImmutablePluginPropertyDto.builder().name(property.getName()).type(PluginPropertyDto.getPropertyType(property.getValue().getValCase())).value(PluginPropertyDto.getPropertyValue(property.getValue())).label(property.getLabel()).checkboxLabel(property.getCheckboxLabel()).description(property.getDescription()).build();
        }

        private static PropertyType getPropertyType(AgentConfigOuterClass.AgentConfig.PluginProperty.Value.ValCase valCase) {
            switch (valCase) {
                case BVAL: {
                    return PropertyType.BOOLEAN;
                }
                case DVAL_NULL: 
                case DVAL: {
                    return PropertyType.DOUBLE;
                }
                case SVAL: {
                    return PropertyType.STRING;
                }
                case LVAL: {
                    return PropertyType.LIST;
                }
            }
            throw new IllegalStateException("Unexpected property type: " + valCase);
        }

        private static @Nullable JsonNode getPropertyValue(AgentConfigOuterClass.AgentConfig.PluginProperty.Value value) {
            AgentConfigOuterClass.AgentConfig.PluginProperty.Value.ValCase valCase = value.getValCase();
            switch (valCase) {
                case BVAL: {
                    return BooleanNode.valueOf((boolean)value.getBval());
                }
                case DVAL_NULL: {
                    return null;
                }
                case DVAL: {
                    return DoubleNode.valueOf((double)value.getDval());
                }
                case SVAL: {
                    return TextNode.valueOf((String)value.getSval());
                }
                case LVAL: {
                    ArrayNode arrayNode = mapper.createArrayNode();
                    for (String val : value.getLval().getValList()) {
                        arrayNode.add(val);
                    }
                    return arrayNode;
                }
            }
            throw new IllegalStateException("Unexpected property type: " + valCase);
        }
    }

    @Value.Immutable
    static abstract class PluginConfigDto {
        PluginConfigDto() {
        }

        abstract String name();

        abstract List<ImmutablePluginPropertyDto> properties();

        abstract String version();

        private static PluginConfigDto create(AgentConfigOuterClass.AgentConfig.PluginConfig config) {
            ImmutablePluginConfigDto.Builder builder = ImmutablePluginConfigDto.builder().name(config.getName());
            for (AgentConfigOuterClass.AgentConfig.PluginProperty property : config.getPropertyList()) {
                builder.addProperties(PluginPropertyDto.create(property));
            }
            return builder.version(Versions.getVersion((AbstractMessage)config)).build();
        }
    }

    @Value.Immutable
    static interface PluginUpdateRequest {
        public String pluginId();

        public List<ImmutablePluginPropertyDto> properties();

        public String version();
    }

    @Value.Immutable
    static abstract class JvmConfigDto {
        JvmConfigDto() {
        }

        abstract ImmutableList<String> maskSystemProperties();

        abstract ImmutableList<String> maskMBeanAttributes();

        abstract String version();

        private AgentConfigOuterClass.AgentConfig.JvmConfig convert() {
            return AgentConfigOuterClass.AgentConfig.JvmConfig.newBuilder().addAllMaskSystemProperty(this.maskSystemProperties()).addAllMaskMbeanAttribute(this.maskMBeanAttributes()).build();
        }

        private static JvmConfigDto create(AgentConfigOuterClass.AgentConfig.JvmConfig config) {
            return ImmutableJvmConfigDto.builder().maskSystemProperties((Iterable<String>)config.getMaskSystemPropertyList()).maskMBeanAttributes((Iterable<String>)config.getMaskMbeanAttributeList()).version(Versions.getVersion((AbstractMessage)config)).build();
        }
    }

    private static class SlowThresholdOverrideDtoOrdering
    extends Ordering<SlowThresholdOverrideDto> {
        private SlowThresholdOverrideDtoOrdering() {
        }

        public int compare(SlowThresholdOverrideDto left, SlowThresholdOverrideDto right) {
            int compare = left.transactionType().compareToIgnoreCase(right.transactionType());
            if (compare != 0) {
                return compare;
            }
            compare = left.transactionName().compareToIgnoreCase(right.transactionName());
            if (compare != 0) {
                return compare;
            }
            compare = left.user().compareToIgnoreCase(right.user());
            if (compare != 0) {
                return compare;
            }
            return left.thresholdMillis() - right.thresholdMillis();
        }
    }

    @Value.Immutable
    @Styles.AllParameters
    static abstract class SlowThresholdOverrideDto {
        SlowThresholdOverrideDto() {
        }

        abstract String transactionType();

        abstract String transactionName();

        abstract String user();

        abstract int thresholdMillis();

        private AgentConfigOuterClass.AgentConfig.SlowThresholdOverride convert() {
            return AgentConfigOuterClass.AgentConfig.SlowThresholdOverride.newBuilder().setTransactionType(this.transactionType()).setTransactionName(this.transactionName()).setUser(this.user()).setThresholdMillis(this.thresholdMillis()).build();
        }

        private static ImmutableSlowThresholdOverrideDto create(AgentConfigOuterClass.AgentConfig.SlowThresholdOverride slowThreshold) {
            return ImmutableSlowThresholdOverrideDto.builder().transactionType(slowThreshold.getTransactionType()).transactionName(slowThreshold.getTransactionName()).user(slowThreshold.getUser()).thresholdMillis(slowThreshold.getThresholdMillis()).build();
        }
    }

    @Value.Immutable
    static abstract class TransactionConfigDto {
        TransactionConfigDto() {
        }

        abstract int slowThresholdMillis();

        abstract int profilingIntervalMillis();

        abstract boolean captureThreadStats();

        abstract List<ImmutableSlowThresholdOverrideDto> slowThresholdOverrides();

        abstract String version();

        private AgentConfigOuterClass.AgentConfig.TransactionConfig convert() {
            AgentConfigOuterClass.AgentConfig.TransactionConfig.Builder builder = AgentConfigOuterClass.AgentConfig.TransactionConfig.newBuilder().setSlowThresholdMillis(ConfigJsonService.of(this.slowThresholdMillis())).setProfilingIntervalMillis(ConfigJsonService.of(this.profilingIntervalMillis())).setCaptureThreadStats(this.captureThreadStats());
            for (SlowThresholdOverrideDto slowThresholdOverride : new SlowThresholdOverrideDtoOrdering().sortedCopy(this.slowThresholdOverrides())) {
                builder.addSlowThresholdOverride(slowThresholdOverride.convert());
            }
            return builder.build();
        }

        private static ImmutableTransactionConfigDto create(AgentConfigOuterClass.AgentConfig.TransactionConfig config) {
            ImmutableTransactionConfigDto.Builder builder = ImmutableTransactionConfigDto.builder().slowThresholdMillis(config.getSlowThresholdMillis().getValue()).profilingIntervalMillis(config.getProfilingIntervalMillis().getValue()).captureThreadStats(config.getCaptureThreadStats()).version(Versions.getVersion((AbstractMessage)config));
            for (AgentConfigOuterClass.AgentConfig.SlowThresholdOverride slowThresholdOverride : config.getSlowThresholdOverrideList()) {
                builder.addSlowThresholdOverrides(SlowThresholdOverrideDto.create(slowThresholdOverride));
            }
            return builder.build();
        }
    }

    @Value.Immutable
    static interface TransactionConfigResponse {
        public ImmutableTransactionConfigDto config();

        public String defaultTransactionType();

        public List<String> allTransactionTypes();
    }

    @Value.Immutable
    static abstract class GeneralConfigDto {
        GeneralConfigDto() {
        }

        abstract String display();

        abstract @Nullable String defaultDisplay();

        abstract String version();

        private AgentConfigOuterClass.AgentConfig.GeneralConfig convert() {
            return AgentConfigOuterClass.AgentConfig.GeneralConfig.newBuilder().setDisplay(this.display()).build();
        }

        private static GeneralConfigDto create(AgentConfigOuterClass.AgentConfig.GeneralConfig config, String agentRollupId) {
            return ImmutableGeneralConfigDto.builder().display(config.getDisplay()).defaultDisplay(MoreConfigDefaults.getDefaultAgentRollupDisplayPart(agentRollupId)).version(Versions.getVersion((AbstractMessage)config)).build();
        }
    }

    @Value.Immutable
    static interface PluginResponse {
        public String id();

        public String name();

        public boolean hasConfig();
    }

    @Value.Immutable
    static interface PluginConfigRequest {
        public Optional<String> pluginId();
    }
}

