/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.Gauges;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAgentId;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindRequest;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GET;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableGaugeConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableGaugeConfigWithWarningMessages;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableGaugeResponse;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableMBeanAttributeDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableMBeanAttributeNamesResponse;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonServiceException;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.POST;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.google.common.base.Joiner;
import org.glowroot.agent.shaded.com.google.common.base.Optional;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.protobuf.AbstractMessage;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveJvmService;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.glowroot.agent.shaded.org.glowroot.common.util.Versions;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.DownstreamServiceOuterClass;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.immutables.value.Value;

@JsonService
class GaugeConfigJsonService {
    private static final Logger logger = LoggerFactory.getLogger(GaugeConfigJsonService.class);
    private static final ObjectMapper mapper = ObjectMappers.create((Module[])new Module[0]);
    private static final Ordering<AgentConfigOuterClass.AgentConfig.GaugeConfig> orderingByName = new Ordering<AgentConfigOuterClass.AgentConfig.GaugeConfig>(){

        public int compare(AgentConfigOuterClass.AgentConfig.GaugeConfig left, AgentConfigOuterClass.AgentConfig.GaugeConfig right) {
            Joiner joiner = Joiner.on((char)'/');
            return joiner.join(Gauges.getDisplayParts(left.getMbeanObjectName())).compareToIgnoreCase(joiner.join(Gauges.getDisplayParts(right.getMbeanObjectName())));
        }
    };
    private final ConfigRepository configRepository;
    private final @Nullable LiveJvmService liveJvmService;

    GaugeConfigJsonService(ConfigRepository configRepository, @Nullable LiveJvmService liveJvmService) {
        this.configRepository = configRepository;
        this.liveJvmService = liveJvmService;
    }

    @GET(path="/backend/config/gauges", permission="agent:config:view:gauge")
    String getGaugeConfig(@BindAgentId String agentId, @BindRequest GaugeConfigRequest request) throws Exception {
        Optional<String> version = request.version();
        if (version.isPresent()) {
            AgentConfigOuterClass.AgentConfig.GaugeConfig gaugeConfig = this.configRepository.getGaugeConfig(agentId, (String)version.get());
            if (gaugeConfig == null) {
                throw new JsonServiceException(HttpResponseStatus.NOT_FOUND);
            }
            return this.getGaugeResponse(agentId, gaugeConfig);
        }
        ArrayList responses = Lists.newArrayList();
        ImmutableList gaugeConfigs = this.configRepository.getGaugeConfigs(agentId);
        gaugeConfigs = orderingByName.immutableSortedCopy(gaugeConfigs);
        for (AgentConfigOuterClass.AgentConfig.GaugeConfig gaugeConfig : gaugeConfigs) {
            responses.add(ImmutableGaugeConfigWithWarningMessages.builder().config(GaugeConfigDto.create(gaugeConfig)).build());
        }
        return mapper.writeValueAsString((Object)responses);
    }

    @GET(path="/backend/config/new-gauge-check-agent-connected", permission="agent:config:edit:gauges")
    String checkAgentConnected(@BindAgentId String agentId) throws Exception {
        Preconditions.checkNotNull((Object)this.liveJvmService);
        return Boolean.toString(this.liveJvmService.isAvailable(agentId));
    }

    @GET(path="/backend/config/matching-mbean-objects", permission="agent:config:edit:gauges")
    String getMatchingMBeanObjects(@BindAgentId String agentId, @BindRequest MBeanObjectNameRequest request) throws Exception {
        Preconditions.checkNotNull((Object)this.liveJvmService);
        try {
            return mapper.writeValueAsString((Object)this.liveJvmService.getMatchingMBeanObjectNames(agentId, request.partialObjectName(), request.limit()));
        }
        catch (LiveJvmService.AgentNotConnectedException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return "[]";
        }
    }

    @GET(path="/backend/config/mbean-attributes", permission="agent:config:edit:gauges")
    String getMBeanAttributes(@BindAgentId String agentId, @BindRequest MBeanAttributeNamesRequest request) throws Exception {
        Preconditions.checkNotNull((Object)this.liveJvmService);
        boolean duplicateMBean = false;
        for (AgentConfigOuterClass.AgentConfig.GaugeConfig gaugeConfig : this.configRepository.getGaugeConfigs(agentId)) {
            if (!gaugeConfig.getMbeanObjectName().equals(request.objectName()) || Versions.getVersion((AbstractMessage)gaugeConfig).equals(request.gaugeVersion())) continue;
            duplicateMBean = true;
            break;
        }
        DownstreamServiceOuterClass.MBeanMeta mbeanMeta = this.liveJvmService.getMBeanMeta(agentId, request.objectName());
        boolean pattern = ObjectName.getInstance(request.objectName()).isPattern();
        return mapper.writeValueAsString((Object)ImmutableMBeanAttributeNamesResponse.builder().duplicateMBean(duplicateMBean).noMatchFoundForPattern(mbeanMeta.getNoMatchFound() && pattern).noMatchFoundForNonPattern(mbeanMeta.getNoMatchFound() && !pattern).addAllMbeanAttributes((Iterable<String>)mbeanMeta.getAttributeNameList()).build());
    }

    @POST(path="/backend/config/gauges/add", permission="agent:config:edit:gauges")
    String addGauge(@BindAgentId String agentId, @BindRequest GaugeConfigDto gaugeConfigDto) throws Exception {
        AgentConfigOuterClass.AgentConfig.GaugeConfig gaugeConfig = gaugeConfigDto.convert();
        try {
            this.configRepository.insertGaugeConfig(agentId, gaugeConfig, CassandraProfile.web).toCompletableFuture().join();
        }
        catch (ConfigRepository.DuplicateMBeanObjectNameException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new JsonServiceException(HttpResponseStatus.CONFLICT, "mbeanObjectName");
        }
        return this.getGaugeResponse(agentId, gaugeConfig);
    }

    @POST(path="/backend/config/gauges/update", permission="agent:config:edit:gauges")
    String updateGauge(@BindAgentId String agentId, @BindRequest GaugeConfigDto gaugeConfigDto) throws Exception {
        AgentConfigOuterClass.AgentConfig.GaugeConfig gaugeConfig = gaugeConfigDto.convert();
        String version = (String)gaugeConfigDto.version().get();
        try {
            this.configRepository.updateGaugeConfig(agentId, gaugeConfig, version, CassandraProfile.web).toCompletableFuture().join();
        }
        catch (ConfigRepository.DuplicateMBeanObjectNameException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new JsonServiceException(HttpResponseStatus.CONFLICT, "mbeanObjectName");
        }
        return this.getGaugeResponse(agentId, gaugeConfig);
    }

    @POST(path="/backend/config/gauges/remove", permission="agent:config:edit:gauges")
    void removeGauge(@BindAgentId String agentId, @BindRequest GaugeConfigRequest request) throws Exception {
        this.configRepository.deleteGaugeConfig(agentId, (String)request.version().get(), CassandraProfile.web).toCompletableFuture().join();
    }

    private String getGaugeResponse(String agentId, AgentConfigOuterClass.AgentConfig.GaugeConfig gaugeConfig) throws Exception {
        ImmutableGaugeResponse.Builder builder = ImmutableGaugeResponse.builder().config(GaugeConfigDto.create(gaugeConfig));
        DownstreamServiceOuterClass.MBeanMeta mbeanMeta = null;
        if (this.liveJvmService != null) {
            try {
                mbeanMeta = this.liveJvmService.getMBeanMeta(agentId, gaugeConfig.getMbeanObjectName());
            }
            catch (LiveJvmService.AgentNotConnectedException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        boolean pattern = ObjectName.getInstance(gaugeConfig.getMbeanObjectName()).isPattern();
        builder.agentNotConnected(mbeanMeta == null).noMatchFoundForPattern(mbeanMeta != null && mbeanMeta.getNoMatchFound() && pattern).noMatchFoundForNonPattern(mbeanMeta != null && mbeanMeta.getNoMatchFound() && !pattern);
        if (mbeanMeta == null) {
            for (AgentConfigOuterClass.AgentConfig.MBeanAttribute mbeanAttribute : gaugeConfig.getMbeanAttributeList()) {
                builder.addMbeanAvailableAttributeNames(mbeanAttribute.getName());
            }
        } else {
            builder.addAllMbeanAvailableAttributeNames((Iterable<String>)mbeanMeta.getAttributeNameList());
        }
        return mapper.writeValueAsString((Object)builder.build());
    }

    @Value.Immutable
    @Styles.AllParameters
    static abstract class MBeanAttributeDto {
        MBeanAttributeDto() {
        }

        abstract String name();

        abstract boolean counter();

        private AgentConfigOuterClass.AgentConfig.MBeanAttribute convert() {
            return AgentConfigOuterClass.AgentConfig.MBeanAttribute.newBuilder().setName(this.name()).setCounter(this.counter()).build();
        }

        private static ImmutableMBeanAttributeDto create(AgentConfigOuterClass.AgentConfig.MBeanAttribute mbeanAttribute) {
            return ImmutableMBeanAttributeDto.builder().name(mbeanAttribute.getName()).counter(mbeanAttribute.getCounter()).build();
        }
    }

    @Value.Immutable
    static abstract class GaugeConfigDto {
        GaugeConfigDto() {
        }

        abstract @Nullable String display();

        abstract List<String> displayPath();

        abstract String mbeanObjectName();

        abstract ImmutableList<ImmutableMBeanAttributeDto> mbeanAttributes();

        abstract Optional<String> version();

        private AgentConfigOuterClass.AgentConfig.GaugeConfig convert() {
            AgentConfigOuterClass.AgentConfig.GaugeConfig.Builder builder = AgentConfigOuterClass.AgentConfig.GaugeConfig.newBuilder().setMbeanObjectName(this.mbeanObjectName());
            for (MBeanAttributeDto mbeanAttribute : this.mbeanAttributes()) {
                builder.addMbeanAttribute(mbeanAttribute.convert());
            }
            return builder.build();
        }

        private static GaugeConfigDto create(AgentConfigOuterClass.AgentConfig.GaugeConfig config) {
            List<String> displayPath = Gauges.getDisplayParts(config.getMbeanObjectName());
            String display = Joiner.on((String)" / ").join(displayPath);
            ImmutableGaugeConfigDto.Builder builder = ImmutableGaugeConfigDto.builder().display(display).displayPath(displayPath).mbeanObjectName(config.getMbeanObjectName());
            for (AgentConfigOuterClass.AgentConfig.MBeanAttribute mbeanAttribute : config.getMbeanAttributeList()) {
                builder.addMbeanAttributes(MBeanAttributeDto.create(mbeanAttribute));
            }
            return builder.version(Versions.getVersion((AbstractMessage)config)).build();
        }
    }

    @Value.Immutable
    static interface GaugeResponse {
        public GaugeConfigDto config();

        public boolean agentNotConnected();

        public boolean noMatchFoundForPattern();

        public boolean noMatchFoundForNonPattern();

        public ImmutableList<String> mbeanAvailableAttributeNames();
    }

    @Value.Immutable
    static interface MBeanAttributeNamesResponse {
        public boolean noMatchFoundForPattern();

        public boolean noMatchFoundForNonPattern();

        public boolean duplicateMBean();

        public ImmutableList<String> mbeanAttributes();
    }

    @Value.Immutable
    static interface MBeanAttributeNamesRequest {
        public String objectName();

        public @Nullable String gaugeVersion();
    }

    @Value.Immutable
    static interface MBeanObjectNameRequest {
        public String partialObjectName();

        public int limit();
    }

    @Value.Immutable
    static interface GaugeConfigRequest {
        public Optional<String> version();
    }

    @Value.Immutable
    static interface GaugeConfigWithWarningMessages {
        public GaugeConfigDto config();

        public ImmutableList<String> warningMessages();
    }
}

