/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ErrorJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ErrorJsonService.ErrorMessageRequest", generator="Immutables")
@Immutable
final class ImmutableErrorMessageRequest
implements ErrorJsonService.ErrorMessageRequest {
    private final String transactionType;
    private final @org.checkerframework.checker.nullness.qual.Nullable String transactionName;
    private final long from;
    private final long to;
    private final ImmutableList<String> include;
    private final ImmutableList<String> exclude;
    private final int errorMessageLimit;

    private ImmutableErrorMessageRequest(String transactionType, @org.checkerframework.checker.nullness.qual.Nullable String transactionName, long from, long to, ImmutableList<String> include, ImmutableList<String> exclude, int errorMessageLimit) {
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        this.from = from;
        this.to = to;
        this.include = include;
        this.exclude = exclude;
        this.errorMessageLimit = errorMessageLimit;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="transactionName")
    public @org.checkerframework.checker.nullness.qual.Nullable String transactionName() {
        return this.transactionName;
    }

    @Override
    @JsonProperty(value="from")
    public long from() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    public long to() {
        return this.to;
    }

    @Override
    @JsonProperty(value="include")
    public ImmutableList<String> include() {
        return this.include;
    }

    @Override
    @JsonProperty(value="exclude")
    public ImmutableList<String> exclude() {
        return this.exclude;
    }

    @Override
    @JsonProperty(value="errorMessageLimit")
    public int errorMessageLimit() {
        return this.errorMessageLimit;
    }

    public final ImmutableErrorMessageRequest withTransactionType(String value) {
        String newValue = Objects.requireNonNull(value, "transactionType");
        if (this.transactionType.equals(newValue)) {
            return this;
        }
        return new ImmutableErrorMessageRequest(newValue, this.transactionName, this.from, this.to, this.include, this.exclude, this.errorMessageLimit);
    }

    public final ImmutableErrorMessageRequest withTransactionName(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.transactionName, value)) {
            return this;
        }
        return new ImmutableErrorMessageRequest(this.transactionType, value, this.from, this.to, this.include, this.exclude, this.errorMessageLimit);
    }

    public final ImmutableErrorMessageRequest withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        return new ImmutableErrorMessageRequest(this.transactionType, this.transactionName, value, this.to, this.include, this.exclude, this.errorMessageLimit);
    }

    public final ImmutableErrorMessageRequest withTo(long value) {
        if (this.to == value) {
            return this;
        }
        return new ImmutableErrorMessageRequest(this.transactionType, this.transactionName, this.from, value, this.include, this.exclude, this.errorMessageLimit);
    }

    public final ImmutableErrorMessageRequest withInclude(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableErrorMessageRequest(this.transactionType, this.transactionName, this.from, this.to, (ImmutableList<String>)newValue, this.exclude, this.errorMessageLimit);
    }

    public final ImmutableErrorMessageRequest withInclude(Iterable<String> elements) {
        if (this.include == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableErrorMessageRequest(this.transactionType, this.transactionName, this.from, this.to, (ImmutableList<String>)newValue, this.exclude, this.errorMessageLimit);
    }

    public final ImmutableErrorMessageRequest withExclude(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableErrorMessageRequest(this.transactionType, this.transactionName, this.from, this.to, this.include, (ImmutableList<String>)newValue, this.errorMessageLimit);
    }

    public final ImmutableErrorMessageRequest withExclude(Iterable<String> elements) {
        if (this.exclude == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableErrorMessageRequest(this.transactionType, this.transactionName, this.from, this.to, this.include, (ImmutableList<String>)newValue, this.errorMessageLimit);
    }

    public final ImmutableErrorMessageRequest withErrorMessageLimit(int value) {
        if (this.errorMessageLimit == value) {
            return this;
        }
        return new ImmutableErrorMessageRequest(this.transactionType, this.transactionName, this.from, this.to, this.include, this.exclude, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableErrorMessageRequest && this.equalTo(0, (ImmutableErrorMessageRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableErrorMessageRequest another) {
        return this.transactionType.equals(another.transactionType) && Objects.equals(this.transactionName, another.transactionName) && this.from == another.from && this.to == another.to && this.include.equals(another.include) && this.exclude.equals(another.exclude) && this.errorMessageLimit == another.errorMessageLimit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transactionType.hashCode();
        h += (h << 5) + Objects.hashCode(this.transactionName);
        h += (h << 5) + Longs.hashCode((long)this.from);
        h += (h << 5) + Longs.hashCode((long)this.to);
        h += (h << 5) + this.include.hashCode();
        h += (h << 5) + this.exclude.hashCode();
        h += (h << 5) + this.errorMessageLimit;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ErrorMessageRequest").omitNullValues().add("transactionType", (Object)this.transactionType).add("transactionName", (Object)this.transactionName).add("from", this.from).add("to", this.to).add("include", this.include).add("exclude", this.exclude).add("errorMessageLimit", this.errorMessageLimit).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableErrorMessageRequest fromJson(Json json) {
        Builder builder = ImmutableErrorMessageRequest.builder();
        if (json.transactionType != null) {
            builder.transactionType(json.transactionType);
        }
        if (json.transactionName != null) {
            builder.transactionName(json.transactionName);
        }
        if (json.fromIsSet) {
            builder.from(json.from);
        }
        if (json.toIsSet) {
            builder.to(json.to);
        }
        if (json.include != null) {
            builder.addAllInclude((Iterable<String>)json.include);
        }
        if (json.exclude != null) {
            builder.addAllExclude((Iterable<String>)json.exclude);
        }
        if (json.errorMessageLimitIsSet) {
            builder.errorMessageLimit(json.errorMessageLimit);
        }
        return builder.build();
    }

    public static ImmutableErrorMessageRequest copyOf(ErrorJsonService.ErrorMessageRequest instance) {
        if (instance instanceof ImmutableErrorMessageRequest) {
            return (ImmutableErrorMessageRequest)instance;
        }
        return ImmutableErrorMessageRequest.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ErrorJsonService.ErrorMessageRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION_TYPE = 1L;
        private static final long INIT_BIT_FROM = 2L;
        private static final long INIT_BIT_TO = 4L;
        private static final long INIT_BIT_ERROR_MESSAGE_LIMIT = 8L;
        private long initBits = 15L;
        @Nullable
        private String transactionType;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String transactionName;
        private long from;
        private long to;
        private ImmutableList.Builder<String> include = ImmutableList.builder();
        private ImmutableList.Builder<String> exclude = ImmutableList.builder();
        private int errorMessageLimit;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ErrorJsonService.ErrorMessageRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.transactionType(instance.transactionType());
            @org.checkerframework.checker.nullness.qual.Nullable String transactionNameValue = instance.transactionName();
            if (transactionNameValue != null) {
                this.transactionName(transactionNameValue);
            }
            this.from(instance.from());
            this.to(instance.to());
            this.addAllInclude((Iterable<String>)instance.include());
            this.addAllExclude((Iterable<String>)instance.exclude());
            this.errorMessageLimit(instance.errorMessageLimit());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionType(String transactionType) {
            this.transactionType = Objects.requireNonNull(transactionType, "transactionType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionName(@org.checkerframework.checker.nullness.qual.Nullable String transactionName) {
            this.transactionName = transactionName;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(long from) {
            this.from = from;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder to(long to) {
            this.to = to;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInclude(String element) {
            this.include.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInclude(String ... elements) {
            this.include.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder include(Iterable<String> elements) {
            this.include = ImmutableList.builder();
            return this.addAllInclude(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllInclude(Iterable<String> elements) {
            this.include.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExclude(String element) {
            this.exclude.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExclude(String ... elements) {
            this.exclude.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder exclude(Iterable<String> elements) {
            this.exclude = ImmutableList.builder();
            return this.addAllExclude(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExclude(Iterable<String> elements) {
            this.exclude.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errorMessageLimit(int errorMessageLimit) {
            this.errorMessageLimit = errorMessageLimit;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableErrorMessageRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableErrorMessageRequest(this.transactionType, this.transactionName, this.from, this.to, this.include.build(), this.exclude.build(), this.errorMessageLimit);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transactionType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("from");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("to");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("errorMessageLimit");
            }
            return "Cannot build ErrorMessageRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ErrorJsonService.ErrorMessageRequest", generator="Immutables")
    static final class Json
    implements ErrorJsonService.ErrorMessageRequest {
        @Nullable
        String transactionType;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String transactionName;
        long from;
        boolean fromIsSet;
        long to;
        boolean toIsSet;
        @Nullable
        ImmutableList<String> include = ImmutableList.of();
        @Nullable
        ImmutableList<String> exclude = ImmutableList.of();
        int errorMessageLimit;
        boolean errorMessageLimitIsSet;

        Json() {
        }

        @JsonProperty(value="transactionType")
        public void setTransactionType(String transactionType) {
            this.transactionType = transactionType;
        }

        @JsonProperty(value="transactionName")
        public void setTransactionName(@org.checkerframework.checker.nullness.qual.Nullable String transactionName) {
            this.transactionName = transactionName;
        }

        @JsonProperty(value="from")
        public void setFrom(long from) {
            this.from = from;
            this.fromIsSet = true;
        }

        @JsonProperty(value="to")
        public void setTo(long to) {
            this.to = to;
            this.toIsSet = true;
        }

        @JsonProperty(value="include")
        public void setInclude(ImmutableList<String> include) {
            this.include = include;
        }

        @JsonProperty(value="exclude")
        public void setExclude(ImmutableList<String> exclude) {
            this.exclude = exclude;
        }

        @JsonProperty(value="errorMessageLimit")
        public void setErrorMessageLimit(int errorMessageLimit) {
            this.errorMessageLimit = errorMessageLimit;
            this.errorMessageLimitIsSet = true;
        }

        @Override
        public String transactionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable String transactionName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long from() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long to() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<String> include() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<String> exclude() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int errorMessageLimit() {
            throw new UnsupportedOperationException();
        }
    }
}

