/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.AdminJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AdminJsonService.HttpProxyConfigDto", generator="Immutables")
@Immutable
final class ImmutableHttpProxyConfigDto
extends AdminJsonService.HttpProxyConfigDto {
    private final String host;
    private final @org.checkerframework.checker.nullness.qual.Nullable Integer port;
    private final String username;
    private final boolean passwordExists;
    private final String newPassword;
    private final @org.checkerframework.checker.nullness.qual.Nullable String testUrl;
    private final String version;

    private ImmutableHttpProxyConfigDto(Builder builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.username = builder.username;
        this.passwordExists = builder.passwordExists;
        this.testUrl = builder.testUrl;
        this.version = builder.version;
        this.newPassword = builder.newPassword != null ? builder.newPassword : Objects.requireNonNull(super.newPassword(), "newPassword");
    }

    private ImmutableHttpProxyConfigDto(String host, @org.checkerframework.checker.nullness.qual.Nullable Integer port, String username, boolean passwordExists, String newPassword, @org.checkerframework.checker.nullness.qual.Nullable String testUrl, String version) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.passwordExists = passwordExists;
        this.newPassword = newPassword;
        this.testUrl = testUrl;
        this.version = version;
    }

    @Override
    @JsonProperty(value="host")
    String host() {
        return this.host;
    }

    @Override
    @JsonProperty(value="port")
    @JsonInclude
    @org.checkerframework.checker.nullness.qual.Nullable Integer port() {
        return this.port;
    }

    @Override
    @JsonProperty(value="username")
    String username() {
        return this.username;
    }

    @Override
    @JsonProperty(value="passwordExists")
    boolean passwordExists() {
        return this.passwordExists;
    }

    @Override
    @JsonProperty(value="newPassword")
    String newPassword() {
        return this.newPassword;
    }

    @Override
    @JsonProperty(value="testUrl")
    @org.checkerframework.checker.nullness.qual.Nullable String testUrl() {
        return this.testUrl;
    }

    @Override
    @JsonProperty(value="version")
    String version() {
        return this.version;
    }

    public final ImmutableHttpProxyConfigDto withHost(String value) {
        String newValue = Objects.requireNonNull(value, "host");
        if (this.host.equals(newValue)) {
            return this;
        }
        return new ImmutableHttpProxyConfigDto(newValue, this.port, this.username, this.passwordExists, this.newPassword, this.testUrl, this.version);
    }

    public final ImmutableHttpProxyConfigDto withPort(@org.checkerframework.checker.nullness.qual.Nullable Integer value) {
        if (Objects.equals(this.port, value)) {
            return this;
        }
        return new ImmutableHttpProxyConfigDto(this.host, value, this.username, this.passwordExists, this.newPassword, this.testUrl, this.version);
    }

    public final ImmutableHttpProxyConfigDto withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableHttpProxyConfigDto(this.host, this.port, newValue, this.passwordExists, this.newPassword, this.testUrl, this.version);
    }

    public final ImmutableHttpProxyConfigDto withPasswordExists(boolean value) {
        if (this.passwordExists == value) {
            return this;
        }
        return new ImmutableHttpProxyConfigDto(this.host, this.port, this.username, value, this.newPassword, this.testUrl, this.version);
    }

    public final ImmutableHttpProxyConfigDto withNewPassword(String value) {
        String newValue = Objects.requireNonNull(value, "newPassword");
        if (this.newPassword.equals(newValue)) {
            return this;
        }
        return new ImmutableHttpProxyConfigDto(this.host, this.port, this.username, this.passwordExists, newValue, this.testUrl, this.version);
    }

    public final ImmutableHttpProxyConfigDto withTestUrl(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.testUrl, value)) {
            return this;
        }
        return new ImmutableHttpProxyConfigDto(this.host, this.port, this.username, this.passwordExists, this.newPassword, value, this.version);
    }

    public final ImmutableHttpProxyConfigDto withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableHttpProxyConfigDto(this.host, this.port, this.username, this.passwordExists, this.newPassword, this.testUrl, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHttpProxyConfigDto && this.equalTo(0, (ImmutableHttpProxyConfigDto)another);
    }

    private boolean equalTo(int synthetic, ImmutableHttpProxyConfigDto another) {
        return this.host.equals(another.host) && Objects.equals(this.port, another.port) && this.username.equals(another.username) && this.passwordExists == another.passwordExists && this.newPassword.equals(another.newPassword) && Objects.equals(this.testUrl, another.testUrl) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.host.hashCode();
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.passwordExists);
        h += (h << 5) + this.newPassword.hashCode();
        h += (h << 5) + Objects.hashCode(this.testUrl);
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"HttpProxyConfigDto").omitNullValues().add("host", (Object)this.host).add("port", (Object)this.port).add("username", (Object)this.username).add("passwordExists", this.passwordExists).add("newPassword", (Object)this.newPassword).add("testUrl", (Object)this.testUrl).add("version", (Object)this.version).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableHttpProxyConfigDto fromJson(Json json) {
        Builder builder = ImmutableHttpProxyConfigDto.builder();
        if (json.host != null) {
            builder.host(json.host);
        }
        if (json.port != null) {
            builder.port(json.port);
        }
        if (json.username != null) {
            builder.username(json.username);
        }
        if (json.passwordExistsIsSet) {
            builder.passwordExists(json.passwordExists);
        }
        if (json.newPassword != null) {
            builder.newPassword(json.newPassword);
        }
        if (json.testUrl != null) {
            builder.testUrl(json.testUrl);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        return builder.build();
    }

    public static ImmutableHttpProxyConfigDto copyOf(AdminJsonService.HttpProxyConfigDto instance) {
        if (instance instanceof ImmutableHttpProxyConfigDto) {
            return (ImmutableHttpProxyConfigDto)instance;
        }
        return ImmutableHttpProxyConfigDto.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AdminJsonService.HttpProxyConfigDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HOST = 1L;
        private static final long INIT_BIT_USERNAME = 2L;
        private static final long INIT_BIT_PASSWORD_EXISTS = 4L;
        private static final long INIT_BIT_VERSION = 8L;
        private long initBits = 15L;
        @Nullable
        private String host;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable Integer port;
        @Nullable
        private String username;
        private boolean passwordExists;
        @Nullable
        private String newPassword;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String testUrl;
        @Nullable
        private String version;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(AdminJsonService.HttpProxyConfigDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.host(instance.host());
            @org.checkerframework.checker.nullness.qual.Nullable Integer portValue = instance.port();
            if (portValue != null) {
                this.port(portValue);
            }
            this.username(instance.username());
            this.passwordExists(instance.passwordExists());
            this.newPassword(instance.newPassword());
            @org.checkerframework.checker.nullness.qual.Nullable String testUrlValue = instance.testUrl();
            if (testUrlValue != null) {
                this.testUrl(testUrlValue);
            }
            this.version(instance.version());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder port(@org.checkerframework.checker.nullness.qual.Nullable Integer port) {
            this.port = port;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder passwordExists(boolean passwordExists) {
            this.passwordExists = passwordExists;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder newPassword(String newPassword) {
            this.newPassword = Objects.requireNonNull(newPassword, "newPassword");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder testUrl(@org.checkerframework.checker.nullness.qual.Nullable String testUrl) {
            this.testUrl = testUrl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableHttpProxyConfigDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHttpProxyConfigDto(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("host");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("username");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("passwordExists");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build HttpProxyConfigDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AdminJsonService.HttpProxyConfigDto", generator="Immutables")
    static final class Json
    extends AdminJsonService.HttpProxyConfigDto {
        @Nullable
        String host;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable Integer port;
        @Nullable
        String username;
        boolean passwordExists;
        boolean passwordExistsIsSet;
        @Nullable
        String newPassword;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String testUrl;
        @Nullable
        String version;

        Json() {
        }

        @JsonProperty(value="host")
        public void setHost(String host) {
            this.host = host;
        }

        @JsonProperty(value="port")
        @JsonInclude
        public void setPort(@org.checkerframework.checker.nullness.qual.Nullable Integer port) {
            this.port = port;
        }

        @JsonProperty(value="username")
        public void setUsername(String username) {
            this.username = username;
        }

        @JsonProperty(value="passwordExists")
        public void setPasswordExists(boolean passwordExists) {
            this.passwordExists = passwordExists;
            this.passwordExistsIsSet = true;
        }

        @JsonProperty(value="newPassword")
        public void setNewPassword(String newPassword) {
            this.newPassword = newPassword;
        }

        @JsonProperty(value="testUrl")
        public void setTestUrl(@org.checkerframework.checker.nullness.qual.Nullable String testUrl) {
            this.testUrl = testUrl;
        }

        @JsonProperty(value="version")
        public void setVersion(String version) {
            this.version = version;
        }

        @Override
        String host() {
            throw new UnsupportedOperationException();
        }

        @Override
        @org.checkerframework.checker.nullness.qual.Nullable Integer port() {
            throw new UnsupportedOperationException();
        }

        @Override
        String username() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean passwordExists() {
            throw new UnsupportedOperationException();
        }

        @Override
        String newPassword() {
            throw new UnsupportedOperationException();
        }

        @Override
        @org.checkerframework.checker.nullness.qual.Nullable String testUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        String version() {
            throw new UnsupportedOperationException();
        }
    }
}

