/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.MutableThreadStats;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.MutableTimer;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.AggregateMerging;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AggregateMerging.MergedAggregate", generator="Immutables")
@Immutable
final class ImmutableMergedAggregate
implements AggregateMerging.MergedAggregate {
    private final long transactionCount;
    private final ImmutableList<MutableTimer> mainThreadRootTimers;
    private final MutableThreadStats mainThreadStats;
    private final @org.checkerframework.checker.nullness.qual.Nullable MutableTimer auxThreadRootTimer;
    private final @org.checkerframework.checker.nullness.qual.Nullable MutableThreadStats auxThreadStats;
    private final ImmutableList<MutableTimer> asyncTimers;

    private ImmutableMergedAggregate(long transactionCount, ImmutableList<MutableTimer> mainThreadRootTimers, MutableThreadStats mainThreadStats, @org.checkerframework.checker.nullness.qual.Nullable MutableTimer auxThreadRootTimer, @org.checkerframework.checker.nullness.qual.Nullable MutableThreadStats auxThreadStats, ImmutableList<MutableTimer> asyncTimers) {
        this.transactionCount = transactionCount;
        this.mainThreadRootTimers = mainThreadRootTimers;
        this.mainThreadStats = mainThreadStats;
        this.auxThreadRootTimer = auxThreadRootTimer;
        this.auxThreadStats = auxThreadStats;
        this.asyncTimers = asyncTimers;
    }

    @Override
    @JsonProperty(value="transactionCount")
    public long transactionCount() {
        return this.transactionCount;
    }

    @JsonProperty(value="mainThreadRootTimers")
    public ImmutableList<MutableTimer> mainThreadRootTimers() {
        return this.mainThreadRootTimers;
    }

    @Override
    @JsonProperty(value="mainThreadStats")
    public MutableThreadStats mainThreadStats() {
        return this.mainThreadStats;
    }

    @Override
    @JsonProperty(value="auxThreadRootTimer")
    public @org.checkerframework.checker.nullness.qual.Nullable MutableTimer auxThreadRootTimer() {
        return this.auxThreadRootTimer;
    }

    @Override
    @JsonProperty(value="auxThreadStats")
    public @org.checkerframework.checker.nullness.qual.Nullable MutableThreadStats auxThreadStats() {
        return this.auxThreadStats;
    }

    @JsonProperty(value="asyncTimers")
    public ImmutableList<MutableTimer> asyncTimers() {
        return this.asyncTimers;
    }

    public final ImmutableMergedAggregate withTransactionCount(long value) {
        if (this.transactionCount == value) {
            return this;
        }
        return new ImmutableMergedAggregate(value, this.mainThreadRootTimers, this.mainThreadStats, this.auxThreadRootTimer, this.auxThreadStats, this.asyncTimers);
    }

    public final ImmutableMergedAggregate withMainThreadRootTimers(MutableTimer ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMergedAggregate(this.transactionCount, (ImmutableList<MutableTimer>)newValue, this.mainThreadStats, this.auxThreadRootTimer, this.auxThreadStats, this.asyncTimers);
    }

    public final ImmutableMergedAggregate withMainThreadRootTimers(Iterable<? extends MutableTimer> elements) {
        if (this.mainThreadRootTimers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMergedAggregate(this.transactionCount, (ImmutableList<MutableTimer>)newValue, this.mainThreadStats, this.auxThreadRootTimer, this.auxThreadStats, this.asyncTimers);
    }

    public final ImmutableMergedAggregate withMainThreadStats(MutableThreadStats value) {
        if (this.mainThreadStats == value) {
            return this;
        }
        MutableThreadStats newValue = Objects.requireNonNull(value, "mainThreadStats");
        return new ImmutableMergedAggregate(this.transactionCount, this.mainThreadRootTimers, newValue, this.auxThreadRootTimer, this.auxThreadStats, this.asyncTimers);
    }

    public final ImmutableMergedAggregate withAuxThreadRootTimer(@org.checkerframework.checker.nullness.qual.Nullable MutableTimer value) {
        if (this.auxThreadRootTimer == value) {
            return this;
        }
        return new ImmutableMergedAggregate(this.transactionCount, this.mainThreadRootTimers, this.mainThreadStats, value, this.auxThreadStats, this.asyncTimers);
    }

    public final ImmutableMergedAggregate withAuxThreadStats(@org.checkerframework.checker.nullness.qual.Nullable MutableThreadStats value) {
        if (this.auxThreadStats == value) {
            return this;
        }
        return new ImmutableMergedAggregate(this.transactionCount, this.mainThreadRootTimers, this.mainThreadStats, this.auxThreadRootTimer, value, this.asyncTimers);
    }

    public final ImmutableMergedAggregate withAsyncTimers(MutableTimer ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMergedAggregate(this.transactionCount, this.mainThreadRootTimers, this.mainThreadStats, this.auxThreadRootTimer, this.auxThreadStats, (ImmutableList<MutableTimer>)newValue);
    }

    public final ImmutableMergedAggregate withAsyncTimers(Iterable<? extends MutableTimer> elements) {
        if (this.asyncTimers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMergedAggregate(this.transactionCount, this.mainThreadRootTimers, this.mainThreadStats, this.auxThreadRootTimer, this.auxThreadStats, (ImmutableList<MutableTimer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMergedAggregate && this.equalTo(0, (ImmutableMergedAggregate)another);
    }

    private boolean equalTo(int synthetic, ImmutableMergedAggregate another) {
        return this.transactionCount == another.transactionCount && this.mainThreadRootTimers.equals(another.mainThreadRootTimers) && this.mainThreadStats.equals(another.mainThreadStats) && Objects.equals(this.auxThreadRootTimer, another.auxThreadRootTimer) && Objects.equals(this.auxThreadStats, another.auxThreadStats) && this.asyncTimers.equals(another.asyncTimers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.transactionCount);
        h += (h << 5) + this.mainThreadRootTimers.hashCode();
        h += (h << 5) + this.mainThreadStats.hashCode();
        h += (h << 5) + Objects.hashCode(this.auxThreadRootTimer);
        h += (h << 5) + Objects.hashCode(this.auxThreadStats);
        h += (h << 5) + this.asyncTimers.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MergedAggregate").omitNullValues().add("transactionCount", this.transactionCount).add("mainThreadRootTimers", this.mainThreadRootTimers).add("mainThreadStats", (Object)this.mainThreadStats).add("auxThreadRootTimer", (Object)this.auxThreadRootTimer).add("auxThreadStats", (Object)this.auxThreadStats).add("asyncTimers", this.asyncTimers).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMergedAggregate fromJson(Json json) {
        Builder builder = ImmutableMergedAggregate.builder();
        if (json.transactionCountIsSet) {
            builder.transactionCount(json.transactionCount);
        }
        if (json.mainThreadRootTimers != null) {
            builder.addAllMainThreadRootTimers(json.mainThreadRootTimers);
        }
        if (json.mainThreadStats != null) {
            builder.mainThreadStats(json.mainThreadStats);
        }
        if (json.auxThreadRootTimer != null) {
            builder.auxThreadRootTimer(json.auxThreadRootTimer);
        }
        if (json.auxThreadStats != null) {
            builder.auxThreadStats(json.auxThreadStats);
        }
        if (json.asyncTimers != null) {
            builder.addAllAsyncTimers(json.asyncTimers);
        }
        return builder.build();
    }

    public static ImmutableMergedAggregate copyOf(AggregateMerging.MergedAggregate instance) {
        if (instance instanceof ImmutableMergedAggregate) {
            return (ImmutableMergedAggregate)instance;
        }
        return ImmutableMergedAggregate.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AggregateMerging.MergedAggregate", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION_COUNT = 1L;
        private static final long INIT_BIT_MAIN_THREAD_STATS = 2L;
        private long initBits = 3L;
        private long transactionCount;
        private ImmutableList.Builder<MutableTimer> mainThreadRootTimers = ImmutableList.builder();
        @Nullable
        private MutableThreadStats mainThreadStats;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable MutableTimer auxThreadRootTimer;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable MutableThreadStats auxThreadStats;
        private ImmutableList.Builder<MutableTimer> asyncTimers = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(AggregateMerging.MergedAggregate instance) {
            MutableThreadStats auxThreadStatsValue;
            Objects.requireNonNull(instance, "instance");
            this.transactionCount(instance.transactionCount());
            this.addAllMainThreadRootTimers(instance.mainThreadRootTimers());
            this.mainThreadStats(instance.mainThreadStats());
            @org.checkerframework.checker.nullness.qual.Nullable MutableTimer auxThreadRootTimerValue = instance.auxThreadRootTimer();
            if (auxThreadRootTimerValue != null) {
                this.auxThreadRootTimer(auxThreadRootTimerValue);
            }
            if ((auxThreadStatsValue = instance.auxThreadStats()) != null) {
                this.auxThreadStats(auxThreadStatsValue);
            }
            this.addAllAsyncTimers(instance.asyncTimers());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionCount(long transactionCount) {
            this.transactionCount = transactionCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMainThreadRootTimers(MutableTimer element) {
            this.mainThreadRootTimers.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMainThreadRootTimers(MutableTimer ... elements) {
            this.mainThreadRootTimers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mainThreadRootTimers(Iterable<? extends MutableTimer> elements) {
            this.mainThreadRootTimers = ImmutableList.builder();
            return this.addAllMainThreadRootTimers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMainThreadRootTimers(Iterable<? extends MutableTimer> elements) {
            this.mainThreadRootTimers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mainThreadStats(MutableThreadStats mainThreadStats) {
            this.mainThreadStats = Objects.requireNonNull(mainThreadStats, "mainThreadStats");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder auxThreadRootTimer(@org.checkerframework.checker.nullness.qual.Nullable MutableTimer auxThreadRootTimer) {
            this.auxThreadRootTimer = auxThreadRootTimer;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder auxThreadStats(@org.checkerframework.checker.nullness.qual.Nullable MutableThreadStats auxThreadStats) {
            this.auxThreadStats = auxThreadStats;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAsyncTimers(MutableTimer element) {
            this.asyncTimers.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAsyncTimers(MutableTimer ... elements) {
            this.asyncTimers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder asyncTimers(Iterable<? extends MutableTimer> elements) {
            this.asyncTimers = ImmutableList.builder();
            return this.addAllAsyncTimers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAsyncTimers(Iterable<? extends MutableTimer> elements) {
            this.asyncTimers.addAll(elements);
            return this;
        }

        public ImmutableMergedAggregate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMergedAggregate(this.transactionCount, this.mainThreadRootTimers.build(), this.mainThreadStats, this.auxThreadRootTimer, this.auxThreadStats, this.asyncTimers.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transactionCount");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mainThreadStats");
            }
            return "Cannot build MergedAggregate, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AggregateMerging.MergedAggregate", generator="Immutables")
    static final class Json
    implements AggregateMerging.MergedAggregate {
        long transactionCount;
        boolean transactionCountIsSet;
        @Nullable
        List<MutableTimer> mainThreadRootTimers = ImmutableList.of();
        @Nullable
        MutableThreadStats mainThreadStats;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable MutableTimer auxThreadRootTimer;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable MutableThreadStats auxThreadStats;
        @Nullable
        List<MutableTimer> asyncTimers = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="transactionCount")
        public void setTransactionCount(long transactionCount) {
            this.transactionCount = transactionCount;
            this.transactionCountIsSet = true;
        }

        @JsonProperty(value="mainThreadRootTimers")
        public void setMainThreadRootTimers(List<MutableTimer> mainThreadRootTimers) {
            this.mainThreadRootTimers = mainThreadRootTimers;
        }

        @JsonProperty(value="mainThreadStats")
        public void setMainThreadStats(MutableThreadStats mainThreadStats) {
            this.mainThreadStats = mainThreadStats;
        }

        @JsonProperty(value="auxThreadRootTimer")
        public void setAuxThreadRootTimer(@org.checkerframework.checker.nullness.qual.Nullable MutableTimer auxThreadRootTimer) {
            this.auxThreadRootTimer = auxThreadRootTimer;
        }

        @JsonProperty(value="auxThreadStats")
        public void setAuxThreadStats(@org.checkerframework.checker.nullness.qual.Nullable MutableThreadStats auxThreadStats) {
            this.auxThreadStats = auxThreadStats;
        }

        @JsonProperty(value="asyncTimers")
        public void setAsyncTimers(List<MutableTimer> asyncTimers) {
            this.asyncTimers = asyncTimers;
        }

        @Override
        public long transactionCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MutableTimer> mainThreadRootTimers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MutableThreadStats mainThreadStats() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable MutableTimer auxThreadRootTimer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable MutableThreadStats auxThreadStats() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MutableTimer> asyncTimers() {
            throw new UnsupportedOperationException();
        }
    }
}

