/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.InstrumentationConfigJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="InstrumentationConfigJsonService.MethodNamesRequest", generator="Immutables")
@Immutable
final class ImmutableMethodNamesRequest
implements InstrumentationConfigJsonService.MethodNamesRequest {
    private final String className;
    private final String partialMethodName;
    private final int limit;

    private ImmutableMethodNamesRequest(String className, String partialMethodName, int limit) {
        this.className = className;
        this.partialMethodName = partialMethodName;
        this.limit = limit;
    }

    @Override
    @JsonProperty(value="className")
    public String className() {
        return this.className;
    }

    @Override
    @JsonProperty(value="partialMethodName")
    public String partialMethodName() {
        return this.partialMethodName;
    }

    @Override
    @JsonProperty(value="limit")
    public int limit() {
        return this.limit;
    }

    public final ImmutableMethodNamesRequest withClassName(String value) {
        String newValue = Objects.requireNonNull(value, "className");
        if (this.className.equals(newValue)) {
            return this;
        }
        return new ImmutableMethodNamesRequest(newValue, this.partialMethodName, this.limit);
    }

    public final ImmutableMethodNamesRequest withPartialMethodName(String value) {
        String newValue = Objects.requireNonNull(value, "partialMethodName");
        if (this.partialMethodName.equals(newValue)) {
            return this;
        }
        return new ImmutableMethodNamesRequest(this.className, newValue, this.limit);
    }

    public final ImmutableMethodNamesRequest withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableMethodNamesRequest(this.className, this.partialMethodName, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMethodNamesRequest && this.equalTo(0, (ImmutableMethodNamesRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableMethodNamesRequest another) {
        return this.className.equals(another.className) && this.partialMethodName.equals(another.partialMethodName) && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.className.hashCode();
        h += (h << 5) + this.partialMethodName.hashCode();
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MethodNamesRequest").omitNullValues().add("className", (Object)this.className).add("partialMethodName", (Object)this.partialMethodName).add("limit", this.limit).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMethodNamesRequest fromJson(Json json) {
        Builder builder = ImmutableMethodNamesRequest.builder();
        if (json.className != null) {
            builder.className(json.className);
        }
        if (json.partialMethodName != null) {
            builder.partialMethodName(json.partialMethodName);
        }
        if (json.limitIsSet) {
            builder.limit(json.limit);
        }
        return builder.build();
    }

    public static ImmutableMethodNamesRequest copyOf(InstrumentationConfigJsonService.MethodNamesRequest instance) {
        if (instance instanceof ImmutableMethodNamesRequest) {
            return (ImmutableMethodNamesRequest)instance;
        }
        return ImmutableMethodNamesRequest.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InstrumentationConfigJsonService.MethodNamesRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CLASS_NAME = 1L;
        private static final long INIT_BIT_PARTIAL_METHOD_NAME = 2L;
        private static final long INIT_BIT_LIMIT = 4L;
        private long initBits = 7L;
        @Nullable
        private String className;
        @Nullable
        private String partialMethodName;
        private int limit;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(InstrumentationConfigJsonService.MethodNamesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.className(instance.className());
            this.partialMethodName(instance.partialMethodName());
            this.limit(instance.limit());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder className(String className) {
            this.className = Objects.requireNonNull(className, "className");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder partialMethodName(String partialMethodName) {
            this.partialMethodName = Objects.requireNonNull(partialMethodName, "partialMethodName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableMethodNamesRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMethodNamesRequest(this.className, this.partialMethodName, this.limit);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("className");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("partialMethodName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build MethodNamesRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="InstrumentationConfigJsonService.MethodNamesRequest", generator="Immutables")
    static final class Json
    implements InstrumentationConfigJsonService.MethodNamesRequest {
        @Nullable
        String className;
        @Nullable
        String partialMethodName;
        int limit;
        boolean limitIsSet;

        Json() {
        }

        @JsonProperty(value="className")
        public void setClassName(String className) {
            this.className = className;
        }

        @JsonProperty(value="partialMethodName")
        public void setPartialMethodName(String partialMethodName) {
            this.partialMethodName = partialMethodName;
        }

        @JsonProperty(value="limit")
        public void setLimit(int limit) {
            this.limit = limit;
            this.limitIsSet = true;
        }

        @Override
        public String className() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String partialMethodName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int limit() {
            throw new UnsupportedOperationException();
        }
    }
}

