/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TransactionJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TransactionJsonService.TraceFlameGraphRequest", generator="Immutables")
@Immutable
final class ImmutableTraceFlameGraphRequest
extends TransactionJsonService.TraceFlameGraphRequest {
    private final String traceId;
    private final boolean auxiliary;
    private final ImmutableList<String> include;
    private final ImmutableList<String> exclude;
    private final double truncateBranchPercentage;
    private final boolean checkLiveTraces;

    private ImmutableTraceFlameGraphRequest(Builder builder) {
        this.traceId = builder.traceId;
        this.auxiliary = builder.auxiliary;
        this.include = builder.include.build();
        this.exclude = builder.exclude.build();
        this.truncateBranchPercentage = builder.truncateBranchPercentage;
        this.checkLiveTraces = builder.checkLiveTracesIsSet() ? builder.checkLiveTraces : super.checkLiveTraces();
    }

    private ImmutableTraceFlameGraphRequest(String traceId, boolean auxiliary, ImmutableList<String> include, ImmutableList<String> exclude, double truncateBranchPercentage, boolean checkLiveTraces) {
        this.traceId = traceId;
        this.auxiliary = auxiliary;
        this.include = include;
        this.exclude = exclude;
        this.truncateBranchPercentage = truncateBranchPercentage;
        this.checkLiveTraces = checkLiveTraces;
    }

    @Override
    @JsonProperty(value="traceId")
    String traceId() {
        return this.traceId;
    }

    @Override
    @JsonProperty(value="auxiliary")
    boolean auxiliary() {
        return this.auxiliary;
    }

    @Override
    @JsonProperty(value="include")
    ImmutableList<String> include() {
        return this.include;
    }

    @Override
    @JsonProperty(value="exclude")
    ImmutableList<String> exclude() {
        return this.exclude;
    }

    @Override
    @JsonProperty(value="truncateBranchPercentage")
    double truncateBranchPercentage() {
        return this.truncateBranchPercentage;
    }

    @Override
    @JsonProperty(value="checkLiveTraces")
    boolean checkLiveTraces() {
        return this.checkLiveTraces;
    }

    public final ImmutableTraceFlameGraphRequest withTraceId(String value) {
        String newValue = Objects.requireNonNull(value, "traceId");
        if (this.traceId.equals(newValue)) {
            return this;
        }
        return new ImmutableTraceFlameGraphRequest(newValue, this.auxiliary, this.include, this.exclude, this.truncateBranchPercentage, this.checkLiveTraces);
    }

    public final ImmutableTraceFlameGraphRequest withAuxiliary(boolean value) {
        if (this.auxiliary == value) {
            return this;
        }
        return new ImmutableTraceFlameGraphRequest(this.traceId, value, this.include, this.exclude, this.truncateBranchPercentage, this.checkLiveTraces);
    }

    public final ImmutableTraceFlameGraphRequest withInclude(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTraceFlameGraphRequest(this.traceId, this.auxiliary, (ImmutableList<String>)newValue, this.exclude, this.truncateBranchPercentage, this.checkLiveTraces);
    }

    public final ImmutableTraceFlameGraphRequest withInclude(Iterable<String> elements) {
        if (this.include == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTraceFlameGraphRequest(this.traceId, this.auxiliary, (ImmutableList<String>)newValue, this.exclude, this.truncateBranchPercentage, this.checkLiveTraces);
    }

    public final ImmutableTraceFlameGraphRequest withExclude(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTraceFlameGraphRequest(this.traceId, this.auxiliary, this.include, (ImmutableList<String>)newValue, this.truncateBranchPercentage, this.checkLiveTraces);
    }

    public final ImmutableTraceFlameGraphRequest withExclude(Iterable<String> elements) {
        if (this.exclude == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTraceFlameGraphRequest(this.traceId, this.auxiliary, this.include, (ImmutableList<String>)newValue, this.truncateBranchPercentage, this.checkLiveTraces);
    }

    public final ImmutableTraceFlameGraphRequest withTruncateBranchPercentage(double value) {
        if (Double.doubleToLongBits(this.truncateBranchPercentage) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableTraceFlameGraphRequest(this.traceId, this.auxiliary, this.include, this.exclude, value, this.checkLiveTraces);
    }

    public final ImmutableTraceFlameGraphRequest withCheckLiveTraces(boolean value) {
        if (this.checkLiveTraces == value) {
            return this;
        }
        return new ImmutableTraceFlameGraphRequest(this.traceId, this.auxiliary, this.include, this.exclude, this.truncateBranchPercentage, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTraceFlameGraphRequest && this.equalTo(0, (ImmutableTraceFlameGraphRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableTraceFlameGraphRequest another) {
        return this.traceId.equals(another.traceId) && this.auxiliary == another.auxiliary && this.include.equals(another.include) && this.exclude.equals(another.exclude) && Double.doubleToLongBits(this.truncateBranchPercentage) == Double.doubleToLongBits(another.truncateBranchPercentage) && this.checkLiveTraces == another.checkLiveTraces;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.traceId.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.auxiliary);
        h += (h << 5) + this.include.hashCode();
        h += (h << 5) + this.exclude.hashCode();
        h += (h << 5) + Doubles.hashCode((double)this.truncateBranchPercentage);
        h += (h << 5) + Booleans.hashCode((boolean)this.checkLiveTraces);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TraceFlameGraphRequest").omitNullValues().add("traceId", (Object)this.traceId).add("auxiliary", this.auxiliary).add("include", this.include).add("exclude", this.exclude).add("truncateBranchPercentage", this.truncateBranchPercentage).add("checkLiveTraces", this.checkLiveTraces).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTraceFlameGraphRequest fromJson(Json json) {
        Builder builder = ImmutableTraceFlameGraphRequest.builder();
        if (json.traceId != null) {
            builder.traceId(json.traceId);
        }
        if (json.auxiliaryIsSet) {
            builder.auxiliary(json.auxiliary);
        }
        if (json.include != null) {
            builder.addAllInclude((Iterable<String>)json.include);
        }
        if (json.exclude != null) {
            builder.addAllExclude((Iterable<String>)json.exclude);
        }
        if (json.truncateBranchPercentageIsSet) {
            builder.truncateBranchPercentage(json.truncateBranchPercentage);
        }
        if (json.checkLiveTracesIsSet) {
            builder.checkLiveTraces(json.checkLiveTraces);
        }
        return builder.build();
    }

    public static ImmutableTraceFlameGraphRequest copyOf(TransactionJsonService.TraceFlameGraphRequest instance) {
        if (instance instanceof ImmutableTraceFlameGraphRequest) {
            return (ImmutableTraceFlameGraphRequest)instance;
        }
        return ImmutableTraceFlameGraphRequest.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TransactionJsonService.TraceFlameGraphRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRACE_ID = 1L;
        private static final long INIT_BIT_AUXILIARY = 2L;
        private static final long INIT_BIT_TRUNCATE_BRANCH_PERCENTAGE = 4L;
        private static final long OPT_BIT_CHECK_LIVE_TRACES = 1L;
        private long initBits = 7L;
        private long optBits;
        @Nullable
        private String traceId;
        private boolean auxiliary;
        private ImmutableList.Builder<String> include = ImmutableList.builder();
        private ImmutableList.Builder<String> exclude = ImmutableList.builder();
        private double truncateBranchPercentage;
        private boolean checkLiveTraces;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(TransactionJsonService.TraceFlameGraphRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.traceId(instance.traceId());
            this.auxiliary(instance.auxiliary());
            this.addAllInclude((Iterable<String>)instance.include());
            this.addAllExclude((Iterable<String>)instance.exclude());
            this.truncateBranchPercentage(instance.truncateBranchPercentage());
            this.checkLiveTraces(instance.checkLiveTraces());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder traceId(String traceId) {
            this.traceId = Objects.requireNonNull(traceId, "traceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder auxiliary(boolean auxiliary) {
            this.auxiliary = auxiliary;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInclude(String element) {
            this.include.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInclude(String ... elements) {
            this.include.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder include(Iterable<String> elements) {
            this.include = ImmutableList.builder();
            return this.addAllInclude(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllInclude(Iterable<String> elements) {
            this.include.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExclude(String element) {
            this.exclude.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExclude(String ... elements) {
            this.exclude.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder exclude(Iterable<String> elements) {
            this.exclude = ImmutableList.builder();
            return this.addAllExclude(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExclude(Iterable<String> elements) {
            this.exclude.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder truncateBranchPercentage(double truncateBranchPercentage) {
            this.truncateBranchPercentage = truncateBranchPercentage;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder checkLiveTraces(boolean checkLiveTraces) {
            this.checkLiveTraces = checkLiveTraces;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableTraceFlameGraphRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTraceFlameGraphRequest(this);
        }

        private boolean checkLiveTracesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("traceId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("auxiliary");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("truncateBranchPercentage");
            }
            return "Cannot build TraceFlameGraphRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TransactionJsonService.TraceFlameGraphRequest", generator="Immutables")
    static final class Json
    extends TransactionJsonService.TraceFlameGraphRequest {
        @Nullable
        String traceId;
        boolean auxiliary;
        boolean auxiliaryIsSet;
        @Nullable
        ImmutableList<String> include = ImmutableList.of();
        @Nullable
        ImmutableList<String> exclude = ImmutableList.of();
        double truncateBranchPercentage;
        boolean truncateBranchPercentageIsSet;
        boolean checkLiveTraces;
        boolean checkLiveTracesIsSet;

        Json() {
        }

        @JsonProperty(value="traceId")
        public void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @JsonProperty(value="auxiliary")
        public void setAuxiliary(boolean auxiliary) {
            this.auxiliary = auxiliary;
            this.auxiliaryIsSet = true;
        }

        @JsonProperty(value="include")
        public void setInclude(ImmutableList<String> include) {
            this.include = include;
        }

        @JsonProperty(value="exclude")
        public void setExclude(ImmutableList<String> exclude) {
            this.exclude = exclude;
        }

        @JsonProperty(value="truncateBranchPercentage")
        public void setTruncateBranchPercentage(double truncateBranchPercentage) {
            this.truncateBranchPercentage = truncateBranchPercentage;
            this.truncateBranchPercentageIsSet = true;
        }

        @JsonProperty(value="checkLiveTraces")
        public void setCheckLiveTraces(boolean checkLiveTraces) {
            this.checkLiveTraces = checkLiveTraces;
            this.checkLiveTracesIsSet = true;
        }

        @Override
        String traceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean auxiliary() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<String> include() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<String> exclude() {
            throw new UnsupportedOperationException();
        }

        @Override
        double truncateBranchPercentage() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean checkLiveTraces() {
            throw new UnsupportedOperationException();
        }
    }
}

