/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ConfigJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableTransactionConfigDto;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConfigJsonService.TransactionConfigResponse", generator="Immutables")
@Immutable
final class ImmutableTransactionConfigResponse
implements ConfigJsonService.TransactionConfigResponse {
    private final ImmutableTransactionConfigDto config;
    private final String defaultTransactionType;
    private final ImmutableList<String> allTransactionTypes;

    private ImmutableTransactionConfigResponse(ImmutableTransactionConfigDto config, String defaultTransactionType, ImmutableList<String> allTransactionTypes) {
        this.config = config;
        this.defaultTransactionType = defaultTransactionType;
        this.allTransactionTypes = allTransactionTypes;
    }

    @Override
    @JsonProperty(value="config")
    public ImmutableTransactionConfigDto config() {
        return this.config;
    }

    @Override
    @JsonProperty(value="defaultTransactionType")
    public String defaultTransactionType() {
        return this.defaultTransactionType;
    }

    @JsonProperty(value="allTransactionTypes")
    public ImmutableList<String> allTransactionTypes() {
        return this.allTransactionTypes;
    }

    public final ImmutableTransactionConfigResponse withConfig(ImmutableTransactionConfigDto value) {
        if (this.config == value) {
            return this;
        }
        ImmutableTransactionConfigDto newValue = Objects.requireNonNull(value, "config");
        return new ImmutableTransactionConfigResponse(newValue, this.defaultTransactionType, this.allTransactionTypes);
    }

    public final ImmutableTransactionConfigResponse withDefaultTransactionType(String value) {
        String newValue = Objects.requireNonNull(value, "defaultTransactionType");
        if (this.defaultTransactionType.equals(newValue)) {
            return this;
        }
        return new ImmutableTransactionConfigResponse(this.config, newValue, this.allTransactionTypes);
    }

    public final ImmutableTransactionConfigResponse withAllTransactionTypes(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTransactionConfigResponse(this.config, this.defaultTransactionType, (ImmutableList<String>)newValue);
    }

    public final ImmutableTransactionConfigResponse withAllTransactionTypes(Iterable<String> elements) {
        if (this.allTransactionTypes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTransactionConfigResponse(this.config, this.defaultTransactionType, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransactionConfigResponse && this.equalTo(0, (ImmutableTransactionConfigResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableTransactionConfigResponse another) {
        return this.config.equals(another.config) && this.defaultTransactionType.equals(another.defaultTransactionType) && this.allTransactionTypes.equals(another.allTransactionTypes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.config.hashCode();
        h += (h << 5) + this.defaultTransactionType.hashCode();
        h += (h << 5) + this.allTransactionTypes.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TransactionConfigResponse").omitNullValues().add("config", (Object)this.config).add("defaultTransactionType", (Object)this.defaultTransactionType).add("allTransactionTypes", this.allTransactionTypes).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTransactionConfigResponse fromJson(Json json) {
        Builder builder = ImmutableTransactionConfigResponse.builder();
        if (json.config != null) {
            builder.config(json.config);
        }
        if (json.defaultTransactionType != null) {
            builder.defaultTransactionType(json.defaultTransactionType);
        }
        if (json.allTransactionTypes != null) {
            builder.addAllAllTransactionTypes(json.allTransactionTypes);
        }
        return builder.build();
    }

    public static ImmutableTransactionConfigResponse copyOf(ConfigJsonService.TransactionConfigResponse instance) {
        if (instance instanceof ImmutableTransactionConfigResponse) {
            return (ImmutableTransactionConfigResponse)instance;
        }
        return ImmutableTransactionConfigResponse.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConfigJsonService.TransactionConfigResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONFIG = 1L;
        private static final long INIT_BIT_DEFAULT_TRANSACTION_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private ImmutableTransactionConfigDto config;
        @Nullable
        private String defaultTransactionType;
        private ImmutableList.Builder<String> allTransactionTypes = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ConfigJsonService.TransactionConfigResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.config(instance.config());
            this.defaultTransactionType(instance.defaultTransactionType());
            this.addAllAllTransactionTypes(instance.allTransactionTypes());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder config(ImmutableTransactionConfigDto config) {
            this.config = Objects.requireNonNull(config, "config");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultTransactionType(String defaultTransactionType) {
            this.defaultTransactionType = Objects.requireNonNull(defaultTransactionType, "defaultTransactionType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllTransactionTypes(String element) {
            this.allTransactionTypes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllTransactionTypes(String ... elements) {
            this.allTransactionTypes.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder allTransactionTypes(Iterable<String> elements) {
            this.allTransactionTypes = ImmutableList.builder();
            return this.addAllAllTransactionTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAllTransactionTypes(Iterable<String> elements) {
            this.allTransactionTypes.addAll(elements);
            return this;
        }

        public ImmutableTransactionConfigResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransactionConfigResponse(this.config, this.defaultTransactionType, this.allTransactionTypes.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("config");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("defaultTransactionType");
            }
            return "Cannot build TransactionConfigResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConfigJsonService.TransactionConfigResponse", generator="Immutables")
    static final class Json
    implements ConfigJsonService.TransactionConfigResponse {
        @Nullable
        ImmutableTransactionConfigDto config;
        @Nullable
        String defaultTransactionType;
        @Nullable
        List<String> allTransactionTypes = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="config")
        public void setConfig(ImmutableTransactionConfigDto config) {
            this.config = config;
        }

        @JsonProperty(value="defaultTransactionType")
        public void setDefaultTransactionType(String defaultTransactionType) {
            this.defaultTransactionType = defaultTransactionType;
        }

        @JsonProperty(value="allTransactionTypes")
        public void setAllTransactionTypes(List<String> allTransactionTypes) {
            this.allTransactionTypes = allTransactionTypes;
        }

        @Override
        public ImmutableTransactionConfigDto config() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String defaultTransactionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> allTransactionTypes() {
            throw new UnsupportedOperationException();
        }
    }
}

