/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.LayoutService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LayoutService.TransactionPermissions", generator="Immutables")
@Immutable
final class ImmutableTransactionPermissions
extends LayoutService.TransactionPermissions {
    private final boolean overview;
    private final boolean traces;
    private final boolean queries;
    private final boolean serviceCalls;
    private final boolean threadProfile;

    private ImmutableTransactionPermissions(boolean overview, boolean traces, boolean queries, boolean serviceCalls, boolean threadProfile) {
        this.overview = overview;
        this.traces = traces;
        this.queries = queries;
        this.serviceCalls = serviceCalls;
        this.threadProfile = threadProfile;
    }

    @Override
    @JsonProperty(value="overview")
    boolean overview() {
        return this.overview;
    }

    @Override
    @JsonProperty(value="traces")
    boolean traces() {
        return this.traces;
    }

    @Override
    @JsonProperty(value="queries")
    boolean queries() {
        return this.queries;
    }

    @Override
    @JsonProperty(value="serviceCalls")
    boolean serviceCalls() {
        return this.serviceCalls;
    }

    @Override
    @JsonProperty(value="threadProfile")
    boolean threadProfile() {
        return this.threadProfile;
    }

    public final ImmutableTransactionPermissions withOverview(boolean value) {
        if (this.overview == value) {
            return this;
        }
        return new ImmutableTransactionPermissions(value, this.traces, this.queries, this.serviceCalls, this.threadProfile);
    }

    public final ImmutableTransactionPermissions withTraces(boolean value) {
        if (this.traces == value) {
            return this;
        }
        return new ImmutableTransactionPermissions(this.overview, value, this.queries, this.serviceCalls, this.threadProfile);
    }

    public final ImmutableTransactionPermissions withQueries(boolean value) {
        if (this.queries == value) {
            return this;
        }
        return new ImmutableTransactionPermissions(this.overview, this.traces, value, this.serviceCalls, this.threadProfile);
    }

    public final ImmutableTransactionPermissions withServiceCalls(boolean value) {
        if (this.serviceCalls == value) {
            return this;
        }
        return new ImmutableTransactionPermissions(this.overview, this.traces, this.queries, value, this.threadProfile);
    }

    public final ImmutableTransactionPermissions withThreadProfile(boolean value) {
        if (this.threadProfile == value) {
            return this;
        }
        return new ImmutableTransactionPermissions(this.overview, this.traces, this.queries, this.serviceCalls, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransactionPermissions && this.equalTo(0, (ImmutableTransactionPermissions)another);
    }

    private boolean equalTo(int synthetic, ImmutableTransactionPermissions another) {
        return this.overview == another.overview && this.traces == another.traces && this.queries == another.queries && this.serviceCalls == another.serviceCalls && this.threadProfile == another.threadProfile;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.overview);
        h += (h << 5) + Booleans.hashCode((boolean)this.traces);
        h += (h << 5) + Booleans.hashCode((boolean)this.queries);
        h += (h << 5) + Booleans.hashCode((boolean)this.serviceCalls);
        h += (h << 5) + Booleans.hashCode((boolean)this.threadProfile);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TransactionPermissions").omitNullValues().add("overview", this.overview).add("traces", this.traces).add("queries", this.queries).add("serviceCalls", this.serviceCalls).add("threadProfile", this.threadProfile).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTransactionPermissions fromJson(Json json) {
        Builder builder = ImmutableTransactionPermissions.builder();
        if (json.overviewIsSet) {
            builder.overview(json.overview);
        }
        if (json.tracesIsSet) {
            builder.traces(json.traces);
        }
        if (json.queriesIsSet) {
            builder.queries(json.queries);
        }
        if (json.serviceCallsIsSet) {
            builder.serviceCalls(json.serviceCalls);
        }
        if (json.threadProfileIsSet) {
            builder.threadProfile(json.threadProfile);
        }
        return builder.build();
    }

    public static ImmutableTransactionPermissions copyOf(LayoutService.TransactionPermissions instance) {
        if (instance instanceof ImmutableTransactionPermissions) {
            return (ImmutableTransactionPermissions)instance;
        }
        return ImmutableTransactionPermissions.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LayoutService.TransactionPermissions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OVERVIEW = 1L;
        private static final long INIT_BIT_TRACES = 2L;
        private static final long INIT_BIT_QUERIES = 4L;
        private static final long INIT_BIT_SERVICE_CALLS = 8L;
        private static final long INIT_BIT_THREAD_PROFILE = 16L;
        private long initBits = 31L;
        private boolean overview;
        private boolean traces;
        private boolean queries;
        private boolean serviceCalls;
        private boolean threadProfile;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(LayoutService.TransactionPermissions instance) {
            Objects.requireNonNull(instance, "instance");
            this.overview(instance.overview());
            this.traces(instance.traces());
            this.queries(instance.queries());
            this.serviceCalls(instance.serviceCalls());
            this.threadProfile(instance.threadProfile());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder overview(boolean overview) {
            this.overview = overview;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder traces(boolean traces) {
            this.traces = traces;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder queries(boolean queries) {
            this.queries = queries;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serviceCalls(boolean serviceCalls) {
            this.serviceCalls = serviceCalls;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder threadProfile(boolean threadProfile) {
            this.threadProfile = threadProfile;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableTransactionPermissions build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransactionPermissions(this.overview, this.traces, this.queries, this.serviceCalls, this.threadProfile);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("overview");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("traces");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("queries");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("serviceCalls");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("threadProfile");
            }
            return "Cannot build TransactionPermissions, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LayoutService.TransactionPermissions", generator="Immutables")
    static final class Json
    extends LayoutService.TransactionPermissions {
        boolean overview;
        boolean overviewIsSet;
        boolean traces;
        boolean tracesIsSet;
        boolean queries;
        boolean queriesIsSet;
        boolean serviceCalls;
        boolean serviceCallsIsSet;
        boolean threadProfile;
        boolean threadProfileIsSet;

        Json() {
        }

        @JsonProperty(value="overview")
        public void setOverview(boolean overview) {
            this.overview = overview;
            this.overviewIsSet = true;
        }

        @JsonProperty(value="traces")
        public void setTraces(boolean traces) {
            this.traces = traces;
            this.tracesIsSet = true;
        }

        @JsonProperty(value="queries")
        public void setQueries(boolean queries) {
            this.queries = queries;
            this.queriesIsSet = true;
        }

        @JsonProperty(value="serviceCalls")
        public void setServiceCalls(boolean serviceCalls) {
            this.serviceCalls = serviceCalls;
            this.serviceCallsIsSet = true;
        }

        @JsonProperty(value="threadProfile")
        public void setThreadProfile(boolean threadProfile) {
            this.threadProfile = threadProfile;
            this.threadProfileIsSet = true;
        }

        @Override
        boolean overview() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean traces() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean queries() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean serviceCalls() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean threadProfile() {
            throw new UnsupportedOperationException();
        }
    }
}

