/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.net.URL;
import java.nio.charset.Charset;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.CommonHandler;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpSessionManager;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.LayoutService;
import org.glowroot.agent.shaded.com.google.common.base.Charsets;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.io.Resources;
import org.glowroot.agent.shaded.com.google.common.net.MediaType;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpResponseStatus;

class IndexHtmlHttpService
implements HttpService {
    private static final @Nullable String GOOGLE_ANALYTICS_TRACKING_ID = System.getProperty("glowroot.internal.googleAnalyticsTrackingId");
    private final LayoutService layoutService;

    IndexHtmlHttpService(LayoutService layoutService) {
        this.layoutService = layoutService;
    }

    @Override
    public String getPermission() {
        return "";
    }

    @Override
    public CommonHandler.CommonResponse handleRequest(CommonHandler.CommonRequest request, HttpSessionManager.Authentication authentication) throws Exception {
        URL url = IndexHtmlHttpService.class.getResource("/org/glowroot/agent/embedded/shaded/org/glowroot/ui/app-dist/index.html");
        String indexHtml = Resources.toString((URL)((URL)Preconditions.checkNotNull((Object)url)), (Charset)Charsets.UTF_8);
        String layout = this.layoutService.getLayoutJson(authentication);
        String contextPath = request.getContextPath();
        String baseHref = contextPath.equals("/") ? "/" : contextPath + "/";
        indexHtml = indexHtml.replace("<base href=\"/\">", "<base href=\"" + baseHref + "\"><script>var layout=" + layout + ";var contextPath='" + contextPath + "'</script>");
        indexHtml = indexHtml.replaceFirst("<link rel=\"shortcut icon\" href=\"favicon\\.([0-9a-f]+)\\.ico\">", "<script>document.write('<link rel=\"shortcut icon\" href=\"' + document.getElementsByTagName(\"base\")[0].href + 'favicon.$1.ico\">')</script>");
        if (GOOGLE_ANALYTICS_TRACKING_ID != null) {
            indexHtml = indexHtml.replace("</body>", "<script>(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)})(window,document,'script','//www.google-analytics.com/analytics.js','ga');ga('create', '" + GOOGLE_ANALYTICS_TRACKING_ID + "', 'auto')</script>\n</body>");
        }
        CommonHandler.CommonResponse response = new CommonHandler.CommonResponse(HttpResponseStatus.OK, MediaType.HTML_UTF_8, indexHtml);
        response.setHeader("X-UA-Compatible", "IE=edge");
        return response;
    }
}

