/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.RoleConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ActiveAgentRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAuthentication;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindRequest;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GET;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpSessionManager;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableAgentRollupSmall;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableFilteredChildAgentRollup;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableFilteredTopLevelAgentRollup;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.LayoutService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.immutables.value.Value;

class LayoutJsonService {
    private static final ObjectMapper mapper = ObjectMappers.create((Module[])new Module[0]);
    private final ActiveAgentRepository activeAgentRepository;
    private final LayoutService layoutService;

    LayoutJsonService(ActiveAgentRepository activeAgentRepository, LayoutService layoutService) {
        this.activeAgentRepository = activeAgentRepository;
        this.layoutService = layoutService;
    }

    @GET(path="/backend/top-level-agent-rollups", permission="")
    String getTopLevelAgentRollups(@BindRequest TopLevelAgentRollupsRequest request, @BindAuthentication HttpSessionManager.Authentication authentication) throws Exception {
        List<ActiveAgentRepository.TopLevelAgentRollup> topLevelAgentRollups = this.activeAgentRepository.readActiveTopLevelAgentRollups(request.from(), request.to(), CassandraProfile.web).toCompletableFuture().get();
        ArrayList filtered = Lists.newArrayList();
        for (ActiveAgentRepository.TopLevelAgentRollup topLevelAgentRollup : topLevelAgentRollups) {
            RoleConfig.HasAnyPermission hasAnyPermission = authentication.hasAnyPermissionForAgentRollup(topLevelAgentRollup.id());
            if (hasAnyPermission == RoleConfig.HasAnyPermission.NO) continue;
            filtered.add(ImmutableFilteredTopLevelAgentRollup.builder().id(topLevelAgentRollup.id()).display(topLevelAgentRollup.display()).disabled(hasAnyPermission == RoleConfig.HasAnyPermission.ONLY_IN_CHILD).build());
        }
        return mapper.writeValueAsString((Object)filtered);
    }

    @GET(path="/backend/child-agent-rollups", permission="")
    String getChildAgentRollups(@BindRequest ChildAgentRollupsRequest request, @BindAuthentication HttpSessionManager.Authentication authentication) throws Exception {
        List<LayoutService.FilteredChildAgentRollup> childAgentRollups = LayoutJsonService.filterChildAgentRollups(this.activeAgentRepository.readActiveChildAgentRollups(request.topLevelId(), request.from(), request.to(), CassandraProfile.web).toCompletableFuture().get(), authentication);
        ArrayList dropdown = Lists.newArrayList();
        for (LayoutService.FilteredChildAgentRollup childAgentRollup : childAgentRollups) {
            LayoutJsonService.flatten(childAgentRollup, 0, dropdown);
        }
        return mapper.writeValueAsString((Object)dropdown);
    }

    @GET(path="/backend/agent-rollup", permission="")
    String getAgentRollup(@BindRequest AgentRollupRequest request, @BindAuthentication HttpSessionManager.Authentication authentication) throws Exception {
        LayoutService.AgentRollupLayout agentRollupLayout = this.layoutService.buildAgentRollupLayout(authentication, request.id());
        if (agentRollupLayout == null) {
            return "{}";
        }
        if (!agentRollupLayout.permissions().hasSomeAccess()) {
            return "{}";
        }
        return mapper.writeValueAsString((Object)agentRollupLayout);
    }

    private static List<LayoutService.FilteredChildAgentRollup> filterChildAgentRollups(List<ActiveAgentRepository.AgentRollup> agentRollups, HttpSessionManager.Authentication authentication) throws Exception {
        ArrayList filtered = Lists.newArrayList();
        for (ActiveAgentRepository.AgentRollup agentRollup : agentRollups) {
            RoleConfig.HasAnyPermission hasAnyPermission = authentication.hasAnyPermissionForAgentRollup(agentRollup.id());
            if (hasAnyPermission == RoleConfig.HasAnyPermission.NO) continue;
            filtered.add(ImmutableFilteredChildAgentRollup.builder().id(agentRollup.id()).display(agentRollup.display()).lastDisplayPart(agentRollup.lastDisplayPart()).disabled(hasAnyPermission == RoleConfig.HasAnyPermission.ONLY_IN_CHILD).addAllChildren(LayoutJsonService.filterChildAgentRollups(agentRollup.children(), authentication)).build());
        }
        return filtered;
    }

    private static void flatten(LayoutService.FilteredChildAgentRollup filteredChildAgentRollup, int depth, List<AgentRollupSmall> dropdown) throws Exception {
        ImmutableAgentRollupSmall agentRollupLayout = ImmutableAgentRollupSmall.builder().id(filteredChildAgentRollup.id()).display(filteredChildAgentRollup.display()).lastDisplayPart(filteredChildAgentRollup.lastDisplayPart()).disabled(filteredChildAgentRollup.disabled()).depth(depth).build();
        dropdown.add(agentRollupLayout);
        for (LayoutService.FilteredChildAgentRollup child : filteredChildAgentRollup.children()) {
            LayoutJsonService.flatten(child, depth + 1, dropdown);
        }
    }

    @Value.Immutable
    static interface AgentRollupRequest {
        public String id();
    }

    @Value.Immutable
    static interface ChildAgentRollupsRequest {
        public String topLevelId();

        public long from();

        public long to();
    }

    @Value.Immutable
    static interface TopLevelAgentRollupsRequest {
        public long from();

        public long to();
    }

    @Value.Immutable
    static interface AgentRollupSmall {
        public String id();

        public String display();

        public String lastDisplayPart();

        public boolean disabled();

        public int depth();
    }
}

