/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.SyntheticResult;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableGroupedMultiErrorInterval;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.MultiErrorIntervalCollector;
import org.glowroot.agent.shaded.com.google.common.collect.ArrayListMultimap;
import org.glowroot.agent.shaded.com.google.common.collect.ListMultimap;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Multimaps;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.immutables.value.Value;

class MultiErrorIntervalMerger {
    private final List<GroupedMultiErrorInterval> groupedMultiErrorIntervals = Lists.newArrayList();

    MultiErrorIntervalMerger() {
    }

    public void addMultiErrorIntervals(String syntheticMonitorId, List<MultiErrorIntervalCollector.MultiErrorInterval> multiErrorIntervals) {
        for (MultiErrorIntervalCollector.MultiErrorInterval multiErrorInterval : multiErrorIntervals) {
            this.addMultiErrorInterval(syntheticMonitorId, multiErrorInterval);
        }
    }

    private void addMultiErrorInterval(String syntheticMonitorId, MultiErrorIntervalCollector.MultiErrorInterval multiErrorInterval) {
        ArrayList overlapping = Lists.newArrayList();
        Iterator<GroupedMultiErrorInterval> i = this.groupedMultiErrorIntervals.iterator();
        while (i.hasNext()) {
            GroupedMultiErrorInterval groupedMultiErrorInterval = i.next();
            if (!MultiErrorIntervalMerger.isOverlapping(multiErrorInterval, groupedMultiErrorInterval)) continue;
            overlapping.add(groupedMultiErrorInterval);
            i.remove();
        }
        if (overlapping.isEmpty()) {
            this.groupedMultiErrorIntervals.add(ImmutableGroupedMultiErrorInterval.builder().from(multiErrorInterval.from()).to(multiErrorInterval.to()).putErrorIntervals(syntheticMonitorId, multiErrorInterval.errorIntervals()).build());
        } else {
            this.groupedMultiErrorIntervals.removeAll(overlapping);
            this.groupedMultiErrorIntervals.add(MultiErrorIntervalMerger.mergeWithOverlapping(syntheticMonitorId, multiErrorInterval, overlapping));
        }
    }

    public List<GroupedMultiErrorInterval> getGroupedMultiErrorIntervals() {
        return new GroupedMultiErrorIntervalOrdering().sortedCopy(this.groupedMultiErrorIntervals);
    }

    private static boolean isOverlapping(MultiErrorIntervalCollector.MultiErrorInterval multiErrorInterval, GroupedMultiErrorInterval groupedMultiErrorInterval) {
        return multiErrorInterval.from() <= groupedMultiErrorInterval.to() && groupedMultiErrorInterval.from() <= multiErrorInterval.to();
    }

    private static GroupedMultiErrorInterval mergeWithOverlapping(String syntheticMonitorId, MultiErrorIntervalCollector.MultiErrorInterval multiErrorInterval, List<GroupedMultiErrorInterval> overlapping) {
        long minFrom = multiErrorInterval.from();
        long maxTo = multiErrorInterval.to();
        ArrayListMultimap errorIntervals = ArrayListMultimap.create();
        errorIntervals.putAll((Object)syntheticMonitorId, multiErrorInterval.errorIntervals());
        for (GroupedMultiErrorInterval groupedMultiErrorInterval : overlapping) {
            minFrom = Math.min(minFrom, groupedMultiErrorInterval.from());
            maxTo = Math.max(maxTo, groupedMultiErrorInterval.to());
            for (Map.Entry<String, List<SyntheticResult.ErrorInterval>> entry : groupedMultiErrorInterval.errorIntervals().entrySet()) {
                errorIntervals.putAll((Object)entry.getKey(), (Iterable)entry.getValue());
            }
        }
        return ImmutableGroupedMultiErrorInterval.builder().from(minFrom).to(maxTo).putAllErrorIntervals(Multimaps.asMap((ListMultimap)errorIntervals)).build();
    }

    private static class GroupedMultiErrorIntervalOrdering
    extends Ordering<GroupedMultiErrorInterval> {
        private GroupedMultiErrorIntervalOrdering() {
        }

        public int compare(GroupedMultiErrorInterval left, GroupedMultiErrorInterval right) {
            return Longs.compare((long)left.from(), (long)right.from());
        }
    }

    @Value.Immutable
    public static interface GroupedMultiErrorInterval {
        public long from();

        public long to();

        public Map<String, List<SyntheticResult.ErrorInterval>> errorIntervals();
    }
}

