/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ActiveAgentRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.AgentDisplayRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.AggregateRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.GaugeValueRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.TransactionTypeRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.RollupLevelService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAuthentication;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindRequest;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.DataSeries;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GET;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GaugeValueJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpSessionManager;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableAgentRollupSmall;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableFilteredAgentRollup;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableFromToPair;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableTransactionTypesAndGaugesReponse;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonServiceException;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.LayoutJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.LayoutService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TransactionCommonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.google.common.annotations.VisibleForTesting;
import org.glowroot.agent.shaded.com.google.common.base.Function;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.collect.Iterables;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.com.google.common.io.CharStreams;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableAggregateQuery;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableOverviewAggregate;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutablePercentileAggregate;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableThroughputAggregate;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveAggregateRepository;
import org.glowroot.agent.shaded.org.glowroot.common.model.LazyHistogram;
import org.glowroot.agent.shaded.org.glowroot.common.util.CaptureTimes;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.CollectorServiceOuterClass;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.immutables.value.Value;

@JsonService
class ReportJsonService {
    private static final double NANOSECONDS_PER_MILLISECOND = 1000000.0;
    private static final Logger logger = LoggerFactory.getLogger(ReportJsonService.class);
    private static final ObjectMapper mapper = ObjectMappers.create((Module[])new Module[0]);
    private final AgentDisplayRepository agentDisplayRepository;
    private final ConfigRepository configRepository;
    private final ActiveAgentRepository activeAgentRepository;
    private final TransactionTypeRepository transactionTypeRepository;
    private final AggregateRepository aggregateRepository;
    private final GaugeValueRepository gaugeValueRepository;
    private final LiveAggregateRepository liveAggregateRepository;
    private final RollupLevelService rollupLevelService;
    private final ExecutorService executor;

    ReportJsonService(AgentDisplayRepository agentDisplayRepository, ConfigRepository configRepository, ActiveAgentRepository activeAgentRepository, TransactionTypeRepository transactionTypeRepository, AggregateRepository aggregateRepository, GaugeValueRepository gaugeValueRepository, LiveAggregateRepository liveAggregateRepository, RollupLevelService rollupLevelService, ExecutorService executor) {
        this.agentDisplayRepository = agentDisplayRepository;
        this.configRepository = configRepository;
        this.activeAgentRepository = activeAgentRepository;
        this.transactionTypeRepository = transactionTypeRepository;
        this.aggregateRepository = aggregateRepository;
        this.gaugeValueRepository = gaugeValueRepository;
        this.liveAggregateRepository = liveAggregateRepository;
        this.rollupLevelService = rollupLevelService;
        this.executor = executor;
    }

    @GET(path="/backend/report/agent-rollups", permission="")
    String getAllAgentRollups(@BindRequest AgentRollupReportRequest request, @BindAuthentication HttpSessionManager.Authentication authentication) throws Exception {
        TimeZone timeZone = TimeZone.getTimeZone(request.timeZoneId());
        FromToPair fromToPair = ReportJsonService.parseDates(request.fromDate(), request.toDate(), timeZone);
        Date from = fromToPair.from();
        Date to = fromToPair.to();
        List<FilteredAgentRollup> agentRollups = ReportJsonService.filterAndSort(this.activeAgentRepository.readActiveAgentRollups(from.getTime(), to.getTime(), CassandraProfile.web).toCompletableFuture().get(), authentication);
        ArrayList dropdown = Lists.newArrayList();
        for (FilteredAgentRollup agentRollup : agentRollups) {
            ReportJsonService.process(agentRollup, 0, dropdown);
        }
        return mapper.writeValueAsString((Object)dropdown);
    }

    @GET(path="/backend/report/transaction-types-and-gauges", permission="")
    String getAllGauges(@BindRequest TransactionTypesAndGaugesRequest request, @BindAuthentication HttpSessionManager.Authentication authentication) throws Exception {
        ReportJsonService.checkPermissions(request.agentRollupIds(), "agent:transaction:overview", authentication);
        ReportJsonService.checkPermissions(request.agentRollupIds(), "agent:jvm:gauges", authentication);
        TimeZone timeZone = TimeZone.getTimeZone(request.timeZoneId());
        FromToPair fromToPair = ReportJsonService.parseDates(request.fromDate(), request.toDate(), timeZone);
        Date from = fromToPair.from();
        Date to = fromToPair.to();
        TreeSet transactionTypes = Sets.newTreeSet();
        HashSet gauges = Sets.newHashSet();
        for (String agentRollupId : request.agentRollupIds()) {
            transactionTypes.addAll((Collection)this.transactionTypeRepository.read(agentRollupId).toCompletableFuture().join());
            transactionTypes.addAll(this.liveAggregateRepository.getTransactionTypes(agentRollupId));
            try {
                transactionTypes.add(this.configRepository.getUiDefaultsConfig(agentRollupId).getDefaultTransactionType());
            }
            catch (ConfigRepository.AgentConfigNotFoundException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            gauges.addAll((Collection)this.gaugeValueRepository.getGauges(agentRollupId, from.getTime(), to.getTime(), CassandraProfile.web).toCompletableFuture().get());
        }
        return mapper.writeValueAsString((Object)ImmutableTransactionTypesAndGaugesReponse.builder().addAllTransactionTypes(transactionTypes).addAllGauges(new GaugeValueJsonService.GaugeOrdering().sortedCopy(gauges)).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET(path="/backend/report", permission="")
    String getReport(final @BindRequest ReportRequest request, @BindAuthentication HttpSessionManager.Authentication authentication) throws Exception {
        long dataPointIntervalMillis;
        ArrayList dataSeriesFutures;
        int rollupLevel;
        double gapMillis;
        String metric = request.metric();
        if (metric.startsWith("transaction:")) {
            ReportJsonService.checkPermissions(request.agentRollupIds(), "agent:transaction:overview", authentication);
        } else if (metric.startsWith("error:")) {
            ReportJsonService.checkPermissions(request.agentRollupIds(), "agent:error:overview", authentication);
        } else if (metric.startsWith("gauge:")) {
            ReportJsonService.checkPermissions(request.agentRollupIds(), "agent:jvm:gauges", authentication);
        } else {
            throw new IllegalStateException("Unexpected metric: " + metric);
        }
        final TimeZone timeZone = TimeZone.getTimeZone(request.timeZoneId());
        FromToPair fromToPair = ReportJsonService.parseDates(request.fromDate(), request.toDate(), timeZone);
        final Date from = fromToPair.from();
        final Date to = fromToPair.to();
        final RollupCaptureTimeFn rollupCaptureTimeFn = new RollupCaptureTimeFn(request.rollup(), timeZone, request.fromDate());
        switch (request.rollup()) {
            case HOURLY: {
                gapMillis = (double)TimeUnit.HOURS.toMillis(1L) * 1.5;
                break;
            }
            case DAILY: {
                gapMillis = (double)TimeUnit.DAYS.toMillis(1L) * 1.5;
                break;
            }
            case WEEKLY: {
                gapMillis = (double)(TimeUnit.DAYS.toMillis(1L) * 7L) * 1.5;
                break;
            }
            case MONTHLY: {
                gapMillis = (double)(TimeUnit.DAYS.toMillis(1L) * 30L) * 1.5;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected rollup: " + (Object)((Object)request.rollup()));
            }
        }
        if (metric.startsWith("transaction:") || metric.startsWith("error:")) {
            rollupLevel = this.rollupLevelService.getRollupLevelForReport(from.getTime(), RollupLevelService.DataKind.GENERAL);
            if ((rollupLevel = Math.max(rollupLevel, 2)) == 3) {
                ReportJsonService.verifyFourHourAggregateTimeZone(timeZone);
            }
            dataSeriesFutures = this.getTransactionReport(request, timeZone, from, to, rollupLevel, rollupCaptureTimeFn, gapMillis);
            dataPointIntervalMillis = this.configRepository.getRollupConfigs().get(rollupLevel).intervalMillis();
        } else if (metric.startsWith("gauge:")) {
            rollupLevel = Math.max(this.rollupLevelService.getGaugeRollupLevelForReport(from.getTime()), 3);
            if (rollupLevel == 4) {
                ReportJsonService.verifyFourHourAggregateTimeZone(timeZone);
            }
            final String gaugeName = metric.substring("gauge:".length());
            dataSeriesFutures = Lists.newArrayList();
            for (final String agentRollupId : request.agentRollupIds()) {
                dataSeriesFutures.add(this.executor.submit(new Callable<DataSeries>(){

                    @Override
                    public DataSeries call() throws Exception {
                        return ReportJsonService.this.getDataSeriesForGauge(agentRollupId, gaugeName, from, to, rollupLevel, rollupCaptureTimeFn, request.rollup(), timeZone, gapMillis, CassandraProfile.web);
                    }
                }));
            }
            dataPointIntervalMillis = rollupLevel == 0 ? this.configRepository.getGaugeCollectionIntervalMillis() : this.configRepository.getRollupConfigs().get(rollupLevel - 1).intervalMillis();
        } else {
            throw new IllegalStateException("Unexpected metric: " + metric);
        }
        ArrayList dataSeriesList = Lists.newArrayList();
        for (Future dataSeriesFuture : dataSeriesFutures) {
            dataSeriesList.add((DataSeries)dataSeriesFuture.get());
        }
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeObjectField("dataSeries", (Object)dataSeriesList);
            jg.writeNumberField("dataPointIntervalMillis", dataPointIntervalMillis);
            jg.writeEndObject();
        }
        return sb.toString();
    }

    private static FromToPair parseDates(String fromDate, String toDate, TimeZone timeZone) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        simpleDateFormat.setTimeZone(timeZone);
        Date from = simpleDateFormat.parse(fromDate);
        Date to = simpleDateFormat.parse(toDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(to);
        cal.add(5, 1);
        to = cal.getTime();
        return ImmutableFromToPair.builder().from(from).to(to).build();
    }

    private List<Future<DataSeries>> getTransactionReport(final ReportRequest request, final TimeZone timeZone, Date from, Date to, int rollupLevel, final RollupCaptureTimeFn rollupCaptureTimeFn, final double gapMillis) throws Exception {
        ImmutableAggregateQuery query = ImmutableAggregateQuery.builder().transactionType((String)Preconditions.checkNotNull((Object)request.transactionType())).transactionName(Strings.emptyToNull((String)((String)Preconditions.checkNotNull((Object)request.transactionName())))).from(from.getTime() + 1L).to(to.getTime()).rollupLevel(rollupLevel).build();
        ArrayList dataSeriesList = Lists.newArrayList();
        String metric = request.metric();
        for (String agentRollupId : request.agentRollupIds()) {
            dataSeriesList.add(this.executor.submit(new Callable<DataSeries>((LiveAggregateRepository.AggregateQuery)query, metric, agentRollupId){
                final /* synthetic */ LiveAggregateRepository.AggregateQuery val$query;
                final /* synthetic */ String val$metric;
                final /* synthetic */ String val$agentRollupId;
                {
                    this.val$query = aggregateQuery;
                    this.val$metric = string;
                    this.val$agentRollupId = string2;
                }

                @Override
                public DataSeries call() throws Exception {
                    return ReportJsonService.this.getTransactionReport(request, timeZone, rollupCaptureTimeFn, gapMillis, this.val$query, this.val$metric, this.val$agentRollupId);
                }
            }));
        }
        return dataSeriesList;
    }

    private DataSeries getTransactionReport(ReportRequest request, TimeZone timeZone, RollupCaptureTimeFn rollupCaptureTimeFn, double gapMillis, LiveAggregateRepository.AggregateQuery query, String metric, String agentRollupId) throws Exception {
        if (metric.equals("transaction:average")) {
            return this.getDataSeriesForAverage(agentRollupId, query, rollupCaptureTimeFn, request.rollup(), timeZone, gapMillis);
        }
        if (metric.equals("transaction:x-percentile")) {
            return this.getDataSeriesForPercentile(agentRollupId, query, (Double)Preconditions.checkNotNull((Object)request.percentile()), rollupCaptureTimeFn, request.rollup(), timeZone, gapMillis);
        }
        if (metric.equals("transaction:count")) {
            return this.getDataSeriesForThroughput(agentRollupId, query, rollupCaptureTimeFn, request.rollup(), timeZone, gapMillis, new CountCalculator());
        }
        if (metric.equals("error:rate")) {
            return this.getDataSeriesForThroughput(agentRollupId, query, rollupCaptureTimeFn, request.rollup(), timeZone, gapMillis, new ErrorRateCalculator());
        }
        if (metric.equals("error:count")) {
            return this.getDataSeriesForThroughput(agentRollupId, query, rollupCaptureTimeFn, request.rollup(), timeZone, gapMillis, new ErrorCountCalculator());
        }
        throw new IllegalStateException("Unexpected metric: " + metric);
    }

    private DataSeries getDataSeriesForAverage(String agentRollupId, LiveAggregateRepository.AggregateQuery query, RollupCaptureTimeFn rollupCaptureTimeFn, ROLLUP rollup, TimeZone timeZone, double gapMillis) throws Exception {
        long lastRollupCaptureTime;
        DataSeries dataSeries = new DataSeries(this.agentDisplayRepository.readFullDisplay(agentRollupId).toCompletableFuture().get());
        List<LiveAggregateRepository.OverviewAggregate> aggregates = this.aggregateRepository.readOverviewAggregates(agentRollupId, query, CassandraProfile.web).toCompletableFuture().get();
        if ((aggregates = TransactionCommonService.rollUpOverviewAggregates(aggregates, rollupCaptureTimeFn)).isEmpty()) {
            return dataSeries;
        }
        LiveAggregateRepository.OverviewAggregate lastAggregate = (LiveAggregateRepository.OverviewAggregate)Iterables.getLast(aggregates);
        long lastCaptureTime = lastAggregate.captureTime();
        if (lastCaptureTime != (lastRollupCaptureTime = rollupCaptureTimeFn.apply(lastCaptureTime).longValue())) {
            aggregates.set(aggregates.size() - 1, (LiveAggregateRepository.OverviewAggregate)ImmutableOverviewAggregate.builder().copyFrom(lastAggregate).captureTime(lastRollupCaptureTime).build());
        }
        LiveAggregateRepository.OverviewAggregate priorAggregate = null;
        for (LiveAggregateRepository.OverviewAggregate aggregate : aggregates) {
            if (priorAggregate != null && (double)(aggregate.captureTime() - priorAggregate.captureTime()) > gapMillis) {
                dataSeries.addNull();
            }
            dataSeries.add(ReportJsonService.getIntervalAverage(rollup, timeZone, aggregate.captureTime()), aggregate.totalDurationNanos() / ((double)aggregate.transactionCount() * 1000000.0));
            priorAggregate = aggregate;
        }
        double totalDurationNanos = 0.0;
        long transactionCount = 0L;
        for (LiveAggregateRepository.OverviewAggregate aggregate : aggregates) {
            totalDurationNanos += aggregate.totalDurationNanos();
            transactionCount += aggregate.transactionCount();
        }
        Preconditions.checkState((transactionCount != 0L ? 1 : 0) != 0);
        dataSeries.setOverall(totalDurationNanos / ((double)transactionCount * 1000000.0));
        return dataSeries;
    }

    private DataSeries getDataSeriesForPercentile(String agentRollupId, LiveAggregateRepository.AggregateQuery query, double percentile, RollupCaptureTimeFn rollupCaptureTimeFn, ROLLUP rollup, TimeZone timeZone, double gapMillis) throws Exception {
        long lastRollupCaptureTime;
        DataSeries dataSeries = new DataSeries(this.agentDisplayRepository.readFullDisplay(agentRollupId).toCompletableFuture().get());
        List<LiveAggregateRepository.PercentileAggregate> aggregates = this.aggregateRepository.readPercentileAggregates(agentRollupId, query, CassandraProfile.web).toCompletableFuture().get();
        if ((aggregates = TransactionCommonService.rollUpPercentileAggregates(aggregates, rollupCaptureTimeFn)).isEmpty()) {
            return dataSeries;
        }
        LiveAggregateRepository.PercentileAggregate lastAggregate = (LiveAggregateRepository.PercentileAggregate)Iterables.getLast(aggregates);
        long lastCaptureTime = lastAggregate.captureTime();
        if (lastCaptureTime != (lastRollupCaptureTime = rollupCaptureTimeFn.apply(lastCaptureTime).longValue())) {
            aggregates.set(aggregates.size() - 1, (LiveAggregateRepository.PercentileAggregate)ImmutablePercentileAggregate.builder().copyFrom(lastAggregate).captureTime(lastRollupCaptureTime).build());
        }
        LiveAggregateRepository.PercentileAggregate priorAggregate = null;
        for (LiveAggregateRepository.PercentileAggregate aggregate : aggregates) {
            if (priorAggregate != null && (double)(aggregate.captureTime() - priorAggregate.captureTime()) > gapMillis) {
                dataSeries.addNull();
            }
            LazyHistogram durationNanosHistogram = new LazyHistogram(aggregate.durationNanosHistogram());
            dataSeries.add(ReportJsonService.getIntervalAverage(rollup, timeZone, aggregate.captureTime()), (double)durationNanosHistogram.getValueAtPercentile(percentile) / 1000000.0);
            priorAggregate = aggregate;
        }
        LazyHistogram mergedHistogram = new LazyHistogram();
        for (LiveAggregateRepository.PercentileAggregate aggregate : aggregates) {
            mergedHistogram.merge(aggregate.durationNanosHistogram());
        }
        dataSeries.setOverall((double)mergedHistogram.getValueAtPercentile(percentile) / 1000000.0);
        return dataSeries;
    }

    private DataSeries getDataSeriesForThroughput(String agentRollupId, LiveAggregateRepository.AggregateQuery query, RollupCaptureTimeFn rollupCaptureTimeFn, ROLLUP rollup, TimeZone timeZone, double gapMillis, ThroughputAggregateFn throughputAggregateFn) throws Exception {
        long lastRollupCaptureTime;
        DataSeries dataSeries = new DataSeries(this.agentDisplayRepository.readFullDisplay(agentRollupId).toCompletableFuture().get());
        List<LiveAggregateRepository.ThroughputAggregate> aggregates = this.aggregateRepository.readThroughputAggregates(agentRollupId, query, CassandraProfile.web).toCompletableFuture().get();
        if ((aggregates = TransactionCommonService.rollUpThroughputAggregates(aggregates, rollupCaptureTimeFn)).isEmpty()) {
            return dataSeries;
        }
        LiveAggregateRepository.ThroughputAggregate lastAggregate = (LiveAggregateRepository.ThroughputAggregate)Iterables.getLast(aggregates);
        long lastCaptureTime = lastAggregate.captureTime();
        if (lastCaptureTime != (lastRollupCaptureTime = rollupCaptureTimeFn.apply(lastCaptureTime).longValue())) {
            aggregates.set(aggregates.size() - 1, (LiveAggregateRepository.ThroughputAggregate)ImmutableThroughputAggregate.builder().copyFrom(lastAggregate).captureTime(lastRollupCaptureTime).build());
        }
        LiveAggregateRepository.ThroughputAggregate priorAggregate = null;
        for (LiveAggregateRepository.ThroughputAggregate aggregate : aggregates) {
            long rollupIntervalMillis;
            Double value = throughputAggregateFn.getValue(aggregate, rollupIntervalMillis = ReportJsonService.getRollupIntervalMillis(rollup, timeZone, aggregate.captureTime()));
            if (value == null) continue;
            if (priorAggregate != null && (double)(aggregate.captureTime() - priorAggregate.captureTime()) > gapMillis) {
                dataSeries.addNull();
            }
            dataSeries.add(ReportJsonService.getIntervalAverage(rollup, timeZone, aggregate.captureTime()), value);
            priorAggregate = aggregate;
        }
        Double overall = throughputAggregateFn.getOverall();
        if (overall != null) {
            dataSeries.setOverall(overall);
        }
        return dataSeries;
    }

    private DataSeries getDataSeriesForGauge(String agentRollupId, String gaugeName, Date from, Date to, int rollupLevel, RollupCaptureTimeFn rollupCaptureTimeFn, ROLLUP rollup, TimeZone timeZone, double gapMillis, CassandraProfile profile) throws Exception {
        long lastRollupCaptureTime;
        DataSeries dataSeries = new DataSeries(this.agentDisplayRepository.readFullDisplay(agentRollupId).toCompletableFuture().get());
        List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue> gaugeValues = this.gaugeValueRepository.readGaugeValues(agentRollupId, gaugeName, from.getTime() + 1L, to.getTime(), rollupLevel, profile).toCompletableFuture().get();
        if ((gaugeValues = GaugeValueJsonService.rollUpGaugeValues(gaugeValues, gaugeName, rollupCaptureTimeFn)).isEmpty()) {
            return dataSeries;
        }
        CollectorServiceOuterClass.GaugeValueMessage.GaugeValue lastGaugeValue = (CollectorServiceOuterClass.GaugeValueMessage.GaugeValue)Iterables.getLast(gaugeValues);
        long lastCaptureTime = lastGaugeValue.getCaptureTime();
        if (lastCaptureTime != (lastRollupCaptureTime = rollupCaptureTimeFn.apply(lastCaptureTime).longValue())) {
            gaugeValues.set(gaugeValues.size() - 1, lastGaugeValue.toBuilder().setCaptureTime(lastRollupCaptureTime).build());
        }
        CollectorServiceOuterClass.GaugeValueMessage.GaugeValue priorGaugeValue = null;
        for (CollectorServiceOuterClass.GaugeValueMessage.GaugeValue gaugeValue : gaugeValues) {
            if (priorGaugeValue != null && (double)(gaugeValue.getCaptureTime() - priorGaugeValue.getCaptureTime()) > gapMillis) {
                dataSeries.addNull();
            }
            dataSeries.add(ReportJsonService.getIntervalAverage(rollup, timeZone, gaugeValue.getCaptureTime()), gaugeValue.getValue());
            priorGaugeValue = gaugeValue;
        }
        double total = 0.0;
        long weight = 0L;
        for (CollectorServiceOuterClass.GaugeValueMessage.GaugeValue gaugeValue : gaugeValues) {
            total += gaugeValue.getValue() * (double)gaugeValue.getWeight();
            weight += gaugeValue.getWeight();
        }
        Preconditions.checkState((weight != 0L ? 1 : 0) != 0);
        dataSeries.setOverall(total / (double)weight);
        return dataSeries;
    }

    private static List<FilteredAgentRollup> filterAndSort(List<ActiveAgentRepository.AgentRollup> agentRollups, HttpSessionManager.Authentication authentication) throws Exception {
        ArrayList filtered = Lists.newArrayList();
        for (ActiveAgentRepository.AgentRollup agentRollup : agentRollups) {
            LayoutService.Permissions permissions = LayoutService.getPermissions(authentication, agentRollup.id(), false);
            if (!permissions.transaction().overview() || !permissions.error().overview() || !permissions.jvm().gauges()) continue;
            filtered.add(ImmutableFilteredAgentRollup.builder().id(agentRollup.id()).display(agentRollup.display()).lastDisplayPart(agentRollup.lastDisplayPart()).addAllChildren(ReportJsonService.filterAndSort(agentRollup.children(), authentication)).build());
        }
        return new FilteredAgentRollupOrdering().sortedCopy(filtered);
    }

    private static void process(FilteredAgentRollup agentRollup, int depth, List<LayoutJsonService.AgentRollupSmall> dropdown) throws Exception {
        ImmutableAgentRollupSmall agentRollupLayout = ImmutableAgentRollupSmall.builder().id(agentRollup.id()).display(agentRollup.display()).lastDisplayPart(agentRollup.lastDisplayPart()).disabled(false).depth(depth).build();
        dropdown.add(agentRollupLayout);
        for (FilteredAgentRollup childAgentRollup : agentRollup.children()) {
            ReportJsonService.process(childAgentRollup, depth + 1, dropdown);
        }
    }

    private static void checkPermissions(List<String> agentRollupIds, String permission, HttpSessionManager.Authentication authentication) throws Exception {
        for (String agentRollupId : agentRollupIds) {
            if (authentication.isPermittedForAgentRollup(agentRollupId, permission)) continue;
            throw new JsonServiceException(HttpResponseStatus.FORBIDDEN);
        }
    }

    private static void verifyFourHourAggregateTimeZone(TimeZone timeZone) {
        boolean gmt;
        boolean bl = gmt = timeZone.getID().equals("GMT") || timeZone.getID().startsWith("GMT-") || timeZone.getID().startsWith("GMT+");
        if (!gmt || timeZone.getRawOffset() % 14400000 != 0) {
            throw new IllegalStateException("The selected time zone is not supported because the time range exceeds the configured retention for 30-minute interval data and so 4-hour interval data must be used instead");
        }
    }

    private static long getIntervalAverage(ROLLUP rollup, TimeZone timeZone, long captureTime) {
        return captureTime - ReportJsonService.getRollupIntervalMillis(rollup, timeZone, captureTime) / 2L;
    }

    @VisibleForTesting
    static long getRollupIntervalMillis(ROLLUP rollup, TimeZone timeZone, long captureTime) {
        switch (rollup) {
            case HOURLY: {
                return TimeUnit.HOURS.toMillis(1L);
            }
            case DAILY: {
                Calendar calendar = Calendar.getInstance(timeZone);
                calendar.setTimeInMillis(captureTime);
                calendar.add(5, -1);
                return captureTime - calendar.getTimeInMillis();
            }
            case WEEKLY: {
                Calendar calendar = Calendar.getInstance(timeZone);
                calendar.setTimeInMillis(captureTime);
                calendar.add(5, -7);
                return captureTime - calendar.getTimeInMillis();
            }
            case MONTHLY: {
                Calendar calendar = Calendar.getInstance(timeZone);
                calendar.setTimeInMillis(captureTime);
                calendar.add(2, -1);
                return captureTime - calendar.getTimeInMillis();
            }
        }
        throw new IllegalStateException("Unexpected rollup: " + (Object)((Object)rollup));
    }

    private static class FilteredAgentRollupOrdering
    extends Ordering<FilteredAgentRollup> {
        private FilteredAgentRollupOrdering() {
        }

        public int compare(FilteredAgentRollup left, FilteredAgentRollup right) {
            return left.display().compareToIgnoreCase(right.display());
        }
    }

    private static class ErrorCountCalculator
    implements ThroughputAggregateFn {
        private boolean hasErrorCount;
        private long errorCount;

        private ErrorCountCalculator() {
        }

        @Override
        public @Nullable Double getValue(LiveAggregateRepository.ThroughputAggregate aggregate, long rollupIntervalMillis) {
            Long errorCount = aggregate.errorCount();
            if (errorCount == null) {
                return null;
            }
            this.errorCount += errorCount.longValue();
            this.hasErrorCount = true;
            return errorCount.doubleValue();
        }

        @Override
        public @Nullable Double getOverall() {
            return this.hasErrorCount ? Double.valueOf(this.errorCount) : null;
        }
    }

    private static class ErrorRateCalculator
    implements ThroughputAggregateFn {
        private boolean hasErrorRate;
        private long errorCount;
        private long transactionCount;

        private ErrorRateCalculator() {
        }

        @Override
        public @Nullable Double getValue(LiveAggregateRepository.ThroughputAggregate aggregate, long rollupIntervalMillis) {
            Long errorCount = aggregate.errorCount();
            if (errorCount == null) {
                return null;
            }
            this.hasErrorRate = true;
            this.errorCount += errorCount.longValue();
            this.transactionCount += aggregate.transactionCount();
            return 100.0 * (double)errorCount.longValue() / (double)aggregate.transactionCount();
        }

        @Override
        public @Nullable Double getOverall() {
            return this.hasErrorRate ? Double.valueOf(100.0 * (double)this.errorCount / (double)this.transactionCount) : null;
        }
    }

    private static class CountCalculator
    implements ThroughputAggregateFn {
        private long transactionCount;

        private CountCalculator() {
        }

        @Override
        public @Nullable Double getValue(LiveAggregateRepository.ThroughputAggregate aggregate, long rollupIntervalMillis) {
            this.transactionCount += aggregate.transactionCount();
            return aggregate.transactionCount();
        }

        @Override
        public @Nullable Double getOverall() {
            return this.transactionCount;
        }
    }

    private static interface ThroughputAggregateFn {
        public @Nullable Double getValue(LiveAggregateRepository.ThroughputAggregate var1, long var2);

        public @Nullable Double getOverall();
    }

    @VisibleForTesting
    static class RollupCaptureTimeFn
    implements Function<Long, Long> {
        private final ROLLUP rollup;
        private final TimeZone timeZone;
        private final int baseDayOfWeek;

        @VisibleForTesting
        RollupCaptureTimeFn(ROLLUP rollup, TimeZone timeZone, String baseCaptureTime) throws ParseException {
            this.rollup = rollup;
            this.timeZone = timeZone;
            if (rollup == ROLLUP.WEEKLY) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(simpleDateFormat.parse(baseCaptureTime));
                this.baseDayOfWeek = calendar.get(7);
            } else {
                this.baseDayOfWeek = -1;
            }
        }

        public Long apply(Long captureTime) {
            switch (this.rollup) {
                case HOURLY: {
                    return CaptureTimes.getRollup((long)captureTime, (long)TimeUnit.HOURS.toMillis(1L), (TimeZone)this.timeZone);
                }
                case DAILY: {
                    return this.getDailyRollupCaptureTime(captureTime).getTimeInMillis();
                }
                case WEEKLY: {
                    Calendar calendar = this.getDailyRollupCaptureTime(captureTime);
                    int dayOfWeek = calendar.get(7);
                    int diff = this.baseDayOfWeek - dayOfWeek;
                    if (diff < 0) {
                        diff += 7;
                    }
                    calendar.add(5, diff);
                    return calendar.getTimeInMillis();
                }
                case MONTHLY: {
                    Calendar calendar = Calendar.getInstance(this.timeZone);
                    calendar.setTimeInMillis(captureTime);
                    calendar.set(5, 1);
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    if (calendar.getTimeInMillis() == captureTime.longValue()) {
                        return captureTime;
                    }
                    calendar.add(2, 1);
                    return calendar.getTimeInMillis();
                }
            }
            throw new IllegalStateException("Unexpected rollup: " + (Object)((Object)this.rollup));
        }

        private Calendar getDailyRollupCaptureTime(Long captureTime) {
            Calendar calendar = Calendar.getInstance(this.timeZone);
            calendar.setTimeInMillis(captureTime);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            if (calendar.getTimeInMillis() == captureTime.longValue()) {
                return calendar;
            }
            calendar.add(5, 1);
            return calendar;
        }
    }

    static enum ROLLUP {
        HOURLY,
        DAILY,
        WEEKLY,
        MONTHLY;

    }

    @Value.Immutable
    static interface FromToPair {
        public Date from();

        public Date to();
    }

    @Value.Immutable
    static interface ReportRequest {
        public List<String> agentRollupIds();

        public String metric();

        public @Nullable String transactionType();

        public @Nullable String transactionName();

        public @Nullable Double percentile();

        public String fromDate();

        public String toDate();

        public ROLLUP rollup();

        public String timeZoneId();
    }

    @Value.Immutable
    static interface TransactionTypesAndGaugesReponse {
        public List<String> transactionTypes();

        public List<GaugeValueRepository.Gauge> gauges();
    }

    @Value.Immutable
    static interface TransactionTypesAndGaugesRequest {
        public List<String> agentRollupIds();

        public String fromDate();

        public String toDate();

        public String timeZoneId();
    }

    @Value.Immutable
    static interface AgentRollupReportRequest {
        public String fromDate();

        public String toDate();

        public String timeZoneId();
    }

    @Value.Immutable
    static interface FilteredAgentRollup {
        public String id();

        public String display();

        public String lastDisplayPart();

        public List<FilteredAgentRollup> children();
    }
}

