/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ChunkSource;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.CommonHandler;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpSessionManager;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TraceCommonService;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.net.MediaType;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

class TraceDetailHttpService
implements HttpService {
    private static final Logger logger = LoggerFactory.getLogger(TraceDetailHttpService.class);
    private final TraceCommonService traceCommonService;

    TraceDetailHttpService(TraceCommonService traceCommonService) {
        this.traceCommonService = traceCommonService;
    }

    @Override
    public String getPermission() {
        return "agent:trace";
    }

    @Override
    public CommonHandler.CommonResponse handleRequest(CommonHandler.CommonRequest request, HttpSessionManager.Authentication authentication) throws Exception {
        String path = request.getPath();
        String traceComponent = path.substring(path.lastIndexOf(47) + 1);
        List<String> agentIds = request.getParameters("agent-id");
        Preconditions.checkState((!agentIds.isEmpty() ? 1 : 0) != 0, (String)"Missing agent id in query string: %s", (Object)request.getUri());
        String agentId = agentIds.get(0);
        List<String> traceIds = request.getParameters("trace-id");
        Preconditions.checkState((!traceIds.isEmpty() ? 1 : 0) != 0, (String)"Missing trace id in query string: %s", (Object)request.getUri());
        String traceId = traceIds.get(0);
        List<String> checkLiveTracesParams = request.getParameters("check-live-traces");
        boolean checkLiveTraces = !checkLiveTracesParams.isEmpty() && Boolean.parseBoolean(checkLiveTracesParams.get(0));
        logger.debug("handleRequest(): traceComponent={}, agentId={}, traceId={}, checkLiveTraces={}", new Object[]{traceComponent, agentId, traceId, checkLiveTraces});
        ChunkSource detail = this.getDetailChunkSource(traceComponent, agentId, traceId, checkLiveTraces);
        if (detail == null) {
            return new CommonHandler.CommonResponse(HttpResponseStatus.NOT_FOUND);
        }
        return new CommonHandler.CommonResponse(HttpResponseStatus.OK, MediaType.JSON_UTF_8, detail);
    }

    private @Nullable ChunkSource getDetailChunkSource(String traceComponent, String agentId, String traceId, boolean checkLiveTraces) throws Exception {
        if (traceComponent.equals("entries")) {
            String entriesJson = this.traceCommonService.getEntriesJson(agentId, traceId, checkLiveTraces, CassandraProfile.web);
            if (entriesJson == null) {
                return null;
            }
            return ChunkSource.wrap(entriesJson);
        }
        if (traceComponent.equals("queries")) {
            String queriesJson = this.traceCommonService.getQueriesJson(agentId, traceId, checkLiveTraces);
            if (queriesJson == null) {
                return null;
            }
            return ChunkSource.wrap(queriesJson);
        }
        if (traceComponent.equals("main-thread-profile")) {
            String profileJson = this.traceCommonService.getMainThreadProfileJson(agentId, traceId, checkLiveTraces);
            if (profileJson == null) {
                return null;
            }
            return ChunkSource.wrap(profileJson);
        }
        if (traceComponent.equals("aux-thread-profile")) {
            String profileJson = this.traceCommonService.getAuxThreadProfileJson(agentId, traceId, checkLiveTraces);
            if (profileJson == null) {
                return null;
            }
            return ChunkSource.wrap(profileJson);
        }
        throw new IllegalStateException("Unexpected trace component: " + traceComponent);
    }
}

