/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ImmutableTraceQuery;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.TraceRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAgentRollupId;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindRequest;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GET;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TransactionJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.io.CharStreams;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableTracePointFilter;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveTraceRepository;
import org.glowroot.agent.shaded.org.glowroot.common.live.StringComparator;
import org.glowroot.agent.shaded.org.glowroot.common.model.Result;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.immutables.value.Value;

@JsonService
class TracePointJsonService {
    private static final int NANOSECONDS_PER_MILLISECOND = 1000000;
    private static final JsonFactory jsonFactory = new JsonFactory();
    private final TraceRepository traceRepository;
    private final LiveTraceRepository liveTraceRepository;
    private final ConfigRepository configRepository;
    private final @Nullable Ticker ticker;
    private final Clock clock;

    TracePointJsonService(TraceRepository traceRepository, LiveTraceRepository liveTraceRepository, ConfigRepository configRepository, @Nullable Ticker ticker, Clock clock) {
        this.traceRepository = traceRepository;
        this.liveTraceRepository = liveTraceRepository;
        this.configRepository = configRepository;
        this.ticker = ticker;
        this.clock = clock;
    }

    @GET(path="/backend/transaction/trace-count", permission="agent:transaction:traces")
    String getTransactionTraceCount(@BindAgentRollupId String agentRollupId, @BindRequest TransactionJsonService.TransactionDataRequest request) throws Exception {
        ImmutableTraceQuery query = ImmutableTraceQuery.builder().transactionType(request.transactionType()).transactionName(request.transactionName()).from(request.from()).to(request.to()).build();
        long traceCount = this.traceRepository.readSlowCount(agentRollupId, query).toCompletableFuture().get();
        boolean includeActiveTraces = this.shouldIncludeActiveTraces(request);
        if (includeActiveTraces) {
            traceCount += (long)this.liveTraceRepository.getMatchingTraceCount(request.transactionType(), request.transactionName());
        }
        return Long.toString(traceCount);
    }

    @GET(path="/backend/error/trace-count", permission="agent:error:traces")
    String getErrorTraceCount(@BindAgentRollupId String agentRollupId, @BindRequest TraceRepository.TraceQuery query) throws Exception {
        return Long.toString(this.traceRepository.readErrorCount(agentRollupId, query).toCompletableFuture().get());
    }

    @GET(path="/backend/transaction/points", permission="agent:transaction:traces")
    String getTransactionPoints(@BindAgentRollupId String agentRollupId, @BindRequest TracePointRequest request) throws Exception {
        return this.getPoints(LiveTraceRepository.TraceKind.SLOW, agentRollupId, request);
    }

    @GET(path="/backend/error/points", permission="agent:error:traces")
    String getErrorPoints(@BindAgentRollupId String agentRollupId, @BindRequest TracePointRequest request) throws Exception {
        return this.getPoints(LiveTraceRepository.TraceKind.ERROR, agentRollupId, request);
    }

    private boolean shouldIncludeActiveTraces(TransactionJsonService.TransactionDataRequest request) {
        long currentTimeMillis = this.clock.currentTimeMillis();
        return (request.to() == 0L || request.to() > currentTimeMillis) && request.from() < currentTimeMillis;
    }

    private String getPoints(LiveTraceRepository.TraceKind traceKind, String agentRollupId, TracePointRequest request) throws Exception {
        double durationMillisLow = request.durationMillisLow();
        long durationNanosLow = Math.round(durationMillisLow * 1000000.0);
        Long durationNanosHigh = null;
        Double durationMillisHigh = request.durationMillisHigh();
        if (durationMillisHigh != null) {
            durationNanosHigh = Math.round(durationMillisHigh * 1000000.0);
        }
        ImmutableTraceQuery query = ImmutableTraceQuery.builder().transactionType(request.transactionType()).transactionName(request.transactionName()).from(request.from()).to(request.to()).build();
        ImmutableTracePointFilter filter = ImmutableTracePointFilter.builder().durationNanosLow(durationNanosLow).durationNanosHigh(durationNanosHigh).headlineComparator(request.headlineComparator()).headline(request.headline()).errorMessageComparator(request.errorMessageComparator()).errorMessage(request.errorMessage()).userComparator(request.userComparator()).user(request.user()).attributeName(request.attributeName()).attributeValueComparator(request.attributeValueComparator()).attributeValue(request.attributeValue()).build();
        return new Handler(traceKind, agentRollupId, query, (LiveTraceRepository.TracePointFilter)filter, request.limit()).handle();
    }

    @Value.Immutable
    public static abstract class TracePointRequest {
        public abstract String transactionType();

        public abstract @Nullable String transactionName();

        public abstract long from();

        public abstract long to();

        public abstract double durationMillisLow();

        public abstract @Nullable Double durationMillisHigh();

        public abstract @Nullable StringComparator headlineComparator();

        public abstract @Nullable String headline();

        public abstract @Nullable StringComparator errorMessageComparator();

        public abstract @Nullable String errorMessage();

        public abstract @Nullable StringComparator userComparator();

        public abstract @Nullable String user();

        public abstract @Nullable String attributeName();

        public abstract @Nullable StringComparator attributeValueComparator();

        public abstract @Nullable String attributeValue();

        public abstract int limit();
    }

    private class Handler {
        private final LiveTraceRepository.TraceKind traceKind;
        private final String agentRollupId;
        private final TraceRepository.TraceQuery query;
        private final LiveTraceRepository.TracePointFilter filter;
        private final int limit;

        private Handler(LiveTraceRepository.TraceKind traceKind, String agentRollupId, TraceRepository.TraceQuery query, LiveTraceRepository.TracePointFilter filter, int limit) {
            this.traceKind = traceKind;
            this.agentRollupId = agentRollupId;
            this.query = query;
            this.filter = filter;
            this.limit = limit;
        }

        private String handle() throws Exception {
            boolean captureActiveTracePoints = this.shouldCaptureActiveTracePoints();
            ArrayList activeTracePoints = Lists.newArrayList();
            long captureTime = 0L;
            long captureTick = 0L;
            if (captureActiveTracePoints && TracePointJsonService.this.ticker != null) {
                captureTime = TracePointJsonService.this.clock.currentTimeMillis();
                captureTick = TracePointJsonService.this.ticker.read();
                activeTracePoints.addAll(TracePointJsonService.this.liveTraceRepository.getMatchingActiveTracePoints(this.traceKind, this.query.transactionType(), this.query.transactionName(), this.filter, this.limit, captureTime, captureTick));
            }
            Result<LiveTraceRepository.TracePoint> queryResult = this.getStoredAndPendingPoints(captureTime, captureActiveTracePoints);
            ArrayList points = Lists.newArrayList((Iterable)queryResult.records());
            this.removeDuplicatesBetweenActiveAndNormalTracePoints(activeTracePoints, points);
            int traceExpirationHours = TracePointJsonService.this.configRepository.getStorageConfig().traceExpirationHours();
            boolean expired = points.isEmpty() && traceExpirationHours != 0 && this.query.to() < TracePointJsonService.this.clock.currentTimeMillis() - TimeUnit.HOURS.toMillis(traceExpirationHours);
            return this.writeResponse(points, activeTracePoints, queryResult.moreAvailable(), expired);
        }

        private boolean shouldCaptureActiveTracePoints() {
            long currentTimeMillis = TracePointJsonService.this.clock.currentTimeMillis();
            return (this.query.to() == 0L || this.query.to() > currentTimeMillis) && this.query.from() < currentTimeMillis;
        }

        private Result<LiveTraceRepository.TracePoint> getStoredAndPendingPoints(long captureTime, boolean captureActiveTraces) throws Exception {
            List matchingPendingPoints = captureActiveTraces ? TracePointJsonService.this.liveTraceRepository.getMatchingPendingPoints(this.traceKind, this.query.transactionType(), this.query.transactionName(), this.filter, captureTime) : ImmutableList.of();
            Result<LiveTraceRepository.TracePoint> queryResult = this.traceKind == LiveTraceRepository.TraceKind.SLOW ? TracePointJsonService.this.traceRepository.readSlowPoints(this.agentRollupId, this.query, this.filter, this.limit).toCompletableFuture().get() : TracePointJsonService.this.traceRepository.readErrorPoints(this.agentRollupId, this.query, this.filter, this.limit).toCompletableFuture().get();
            List orderedPoints = Lists.newArrayList((Iterable)queryResult.records());
            Iterator iterator = matchingPendingPoints.iterator();
            while (iterator.hasNext()) {
                LiveTraceRepository.TracePoint pendingPoint = (LiveTraceRepository.TracePoint)iterator.next();
                this.insertIntoOrderedPoints(pendingPoint, orderedPoints);
            }
            if (this.limit != 0 && orderedPoints.size() > this.limit) {
                orderedPoints = orderedPoints.subList(0, this.limit);
            }
            return new Result(orderedPoints, queryResult.moreAvailable());
        }

        private void insertIntoOrderedPoints(LiveTraceRepository.TracePoint pendingPoint, List<LiveTraceRepository.TracePoint> orderedPoints) {
            int duplicateIndex = -1;
            int insertionIndex = -1;
            for (int i = 0; i < orderedPoints.size(); ++i) {
                LiveTraceRepository.TracePoint point = orderedPoints.get(i);
                if (pendingPoint.traceId().equals(point.traceId())) {
                    duplicateIndex = i;
                    break;
                }
                if (pendingPoint.durationNanos() <= point.durationNanos()) continue;
                insertionIndex = i;
                break;
            }
            if (duplicateIndex != -1) {
                LiveTraceRepository.TracePoint point = orderedPoints.get(duplicateIndex);
                if (pendingPoint.durationNanos() > point.durationNanos()) {
                    orderedPoints.set(duplicateIndex, pendingPoint);
                }
                return;
            }
            if (insertionIndex == -1) {
                orderedPoints.add(pendingPoint);
            } else {
                orderedPoints.add(insertionIndex, pendingPoint);
            }
        }

        private void removeDuplicatesBetweenActiveAndNormalTracePoints(List<LiveTraceRepository.TracePoint> activeTracePoints, List<LiveTraceRepository.TracePoint> points) {
            Iterator<LiveTraceRepository.TracePoint> i = activeTracePoints.iterator();
            block0: while (i.hasNext()) {
                LiveTraceRepository.TracePoint activeTracePoint = i.next();
                Iterator<LiveTraceRepository.TracePoint> j = points.iterator();
                while (j.hasNext()) {
                    LiveTraceRepository.TracePoint point = j.next();
                    if (!activeTracePoint.traceId().equals(point.traceId())) continue;
                    if (activeTracePoint.durationNanos() > point.durationNanos()) {
                        j.remove();
                        continue block0;
                    }
                    i.remove();
                    continue block0;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String writeResponse(List<LiveTraceRepository.TracePoint> points, List<LiveTraceRepository.TracePoint> activePoints, boolean limitExceeded, boolean expired) throws Exception {
            StringBuilder sb = new StringBuilder();
            try (JsonGenerator jg = jsonFactory.createGenerator(CharStreams.asWriter((Appendable)sb));){
                jg.writeStartObject();
                jg.writeArrayFieldStart("normalPoints");
                for (LiveTraceRepository.TracePoint point : points) {
                    if (point.error() || point.partial()) continue;
                    this.writePoint(point, jg);
                }
                jg.writeEndArray();
                jg.writeArrayFieldStart("errorPoints");
                for (LiveTraceRepository.TracePoint point : points) {
                    if (!point.error() || point.partial()) continue;
                    this.writePoint(point, jg);
                }
                jg.writeEndArray();
                jg.writeArrayFieldStart("partialPoints");
                for (LiveTraceRepository.TracePoint point : points) {
                    if (!point.partial()) continue;
                    this.writePoint(point, jg);
                }
                for (LiveTraceRepository.TracePoint activePoint : activePoints) {
                    this.writePoint(activePoint, jg);
                }
                jg.writeEndArray();
                if (limitExceeded) {
                    jg.writeBooleanField("limitExceeded", true);
                }
                if (expired) {
                    jg.writeBooleanField("expired", true);
                }
                jg.writeEndObject();
            }
            return sb.toString();
        }

        private void writePoint(LiveTraceRepository.TracePoint point, JsonGenerator jg) throws IOException {
            jg.writeStartArray();
            jg.writeNumber(point.captureTime());
            jg.writeNumber((double)point.durationNanos() / 1000000.0);
            jg.writeString(point.agentId());
            jg.writeString(point.traceId());
            if (point.checkLiveTraces()) {
                jg.writeBoolean(true);
            }
            jg.writeEndArray();
        }
    }
}

