/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.h2.bnf.context;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.glowroot.agent.embedded.shaded.org.h2.bnf.context.DbContents;
import org.glowroot.agent.embedded.shaded.org.h2.bnf.context.DbProcedure;
import org.glowroot.agent.embedded.shaded.org.h2.bnf.context.DbTableOrView;
import org.glowroot.agent.embedded.shaded.org.h2.util.New;
import org.glowroot.agent.embedded.shaded.org.h2.util.StringUtils;
import org.glowroot.agent.embedded.sql.SQLException;

public class DbSchema {
    public final String name;
    public final boolean isDefault;
    public final boolean isSystem;
    public final String quotedName;
    private final DbContents contents;
    private DbTableOrView[] tables;
    private DbProcedure[] procedures;

    DbSchema(DbContents dbContents, String string, boolean bl) {
        this.contents = dbContents;
        this.name = string;
        this.quotedName = dbContents.quoteIdentifier(string);
        this.isDefault = bl;
        this.isSystem = string == null ? true : ("INFORMATION_SCHEMA".equals(string) ? true : (!dbContents.isH2() && StringUtils.toUpperEnglish(string).startsWith("INFO") ? true : (dbContents.isPostgreSQL() && StringUtils.toUpperEnglish(string).startsWith("PG_") ? true : dbContents.isDerby() && string.startsWith("SYS"))));
    }

    public DbContents getContents() {
        return this.contents;
    }

    public DbTableOrView[] getTables() {
        return this.tables;
    }

    public DbProcedure[] getProcedures() {
        return this.procedures;
    }

    public void readTables(DatabaseMetaData databaseMetaData, String[] stringArray) throws SQLException {
        ResultSet resultSet = databaseMetaData.getTables(null, this.name, null, stringArray);
        ArrayList<DbTableOrView> arrayList = New.arrayList();
        while (resultSet.next()) {
            DbTableOrView[] dbTableOrViewArray = new DbTableOrView(this, resultSet);
            if (this.contents.isOracle() && dbTableOrViewArray.getName().indexOf(36) > 0) continue;
            arrayList.add((DbTableOrView)dbTableOrViewArray);
        }
        resultSet.close();
        this.tables = new DbTableOrView[arrayList.size()];
        arrayList.toArray(this.tables);
        if (this.tables.length < 500) {
            for (DbTableOrView dbTableOrView : this.tables) {
                try {
                    dbTableOrView.readColumns(databaseMetaData);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    public void readProcedures(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = databaseMetaData.getProcedures(null, this.name, null);
        ArrayList<DbProcedure> arrayList = New.arrayList();
        while (resultSet.next()) {
            arrayList.add(new DbProcedure(this, resultSet));
        }
        resultSet.close();
        this.procedures = new DbProcedure[arrayList.size()];
        arrayList.toArray(this.procedures);
        if (this.procedures.length < 500) {
            for (DbProcedure dbProcedure : this.procedures) {
                dbProcedure.readParameters(databaseMetaData);
            }
        }
    }
}

