/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.h2.command.ddl;

import org.glowroot.agent.embedded.shaded.org.h2.command.ddl.SchemaCommand;
import org.glowroot.agent.embedded.shaded.org.h2.engine.Database;
import org.glowroot.agent.embedded.shaded.org.h2.engine.Session;
import org.glowroot.agent.embedded.shaded.org.h2.message.DbException;
import org.glowroot.agent.embedded.shaded.org.h2.schema.Schema;
import org.glowroot.agent.embedded.shaded.org.h2.schema.Sequence;

public class DropSequence
extends SchemaCommand {
    private String sequenceName;
    private boolean ifExists;

    public DropSequence(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setSequenceName(String string) {
        this.sequenceName = string;
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Sequence sequence = this.getSchema().findSequence(this.sequenceName);
        if (sequence == null) {
            if (!this.ifExists) {
                throw DbException.get(90036, this.sequenceName);
            }
        } else {
            if (sequence.getBelongsToTable()) {
                throw DbException.get(90082, this.sequenceName);
            }
            database.removeSchemaObject(this.session, sequence);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 43;
    }
}

