/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.h2.expression;

import org.glowroot.agent.embedded.shaded.org.h2.engine.Session;
import org.glowroot.agent.embedded.shaded.org.h2.expression.Expression;
import org.glowroot.agent.embedded.shaded.org.h2.expression.ExpressionVisitor;
import org.glowroot.agent.embedded.shaded.org.h2.message.DbException;
import org.glowroot.agent.embedded.shaded.org.h2.schema.Sequence;
import org.glowroot.agent.embedded.shaded.org.h2.table.ColumnResolver;
import org.glowroot.agent.embedded.shaded.org.h2.table.TableFilter;
import org.glowroot.agent.embedded.shaded.org.h2.value.Value;
import org.glowroot.agent.embedded.shaded.org.h2.value.ValueLong;

public class SequenceValue
extends Expression {
    private final Sequence sequence;

    public SequenceValue(Sequence sequence) {
        this.sequence = sequence;
    }

    @Override
    public Value getValue(Session session) {
        long l = this.sequence.getNext(session);
        session.setLastIdentity(ValueLong.get(l));
        return ValueLong.get(l);
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
    }

    @Override
    public Expression optimize(Session session) {
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public long getPrecision() {
        return 10L;
    }

    @Override
    public int getDisplaySize() {
        return 11;
    }

    @Override
    public String getSQL() {
        return "(NEXT VALUE FOR " + this.sequence.getSQL() + ")";
    }

    @Override
    public void updateAggregate(Session session) {
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 1: 
            case 3: 
            case 6: 
            case 9: {
                return true;
            }
            case 0: 
            case 2: 
            case 5: 
            case 8: {
                return false;
            }
            case 4: {
                expressionVisitor.addDataModificationId(this.sequence.getModificationId());
                return true;
            }
            case 7: {
                expressionVisitor.addDependency(this.sequence);
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        return 1;
    }
}

