/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.h2.index;

import java.util.Iterator;
import org.glowroot.agent.embedded.shaded.org.h2.engine.Session;
import org.glowroot.agent.embedded.shaded.org.h2.index.Cursor;
import org.glowroot.agent.embedded.shaded.org.h2.index.ScanIndex;
import org.glowroot.agent.embedded.shaded.org.h2.message.DbException;
import org.glowroot.agent.embedded.shaded.org.h2.result.Row;
import org.glowroot.agent.embedded.shaded.org.h2.result.SearchRow;

public class ScanCursor
implements Cursor {
    private final ScanIndex scan;
    private Row row;
    private final Session session;
    private final boolean multiVersion;
    private Iterator<Row> delta;

    ScanCursor(Session session, ScanIndex scanIndex, boolean bl) {
        this.session = session;
        this.scan = scanIndex;
        this.multiVersion = bl;
        if (bl) {
            this.delta = scanIndex.getDelta();
        }
        this.row = null;
    }

    @Override
    public Row get() {
        return this.row;
    }

    @Override
    public SearchRow getSearchRow() {
        return this.row;
    }

    @Override
    public boolean next() {
        if (this.multiVersion) {
            while (true) {
                if (this.delta != null) {
                    if (!this.delta.hasNext()) {
                        this.delta = null;
                        this.row = null;
                        continue;
                    }
                    this.row = this.delta.next();
                    if (this.row.isDeleted() && this.row.getSessionId() != this.session.getId()) break;
                    continue;
                }
                this.row = this.scan.getNextRow(this.row);
                if (this.row == null || this.row.getSessionId() == 0 || this.row.getSessionId() == this.session.getId()) break;
            }
            return this.row != null;
        }
        this.row = this.scan.getNextRow(this.row);
        return this.row != null;
    }

    @Override
    public boolean previous() {
        throw DbException.throwInternalError();
    }
}

