/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.h2.mvstore;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.glowroot.agent.embedded.shaded.org.h2.mvstore.Chunk;
import org.glowroot.agent.embedded.shaded.org.h2.mvstore.DataUtils;
import org.glowroot.agent.embedded.shaded.org.h2.mvstore.type.StringDataType;
import org.glowroot.agent.embedded.shaded.org.h2.store.fs.FilePath;

public class MVStoreTool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(String string, Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer, true);
        if (!FilePath.get(string).exists()) {
            printWriter.println("File not found: " + string);
            return;
        }
        FileChannel fileChannel = null;
        int n = 4096;
        try {
            fileChannel = FilePath.get(string).open("r");
            long l = fileChannel.size();
            int n2 = Long.toHexString(l).length();
            ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
            long l2 = 0L;
            while (l2 < l) {
                int n3;
                byteBuffer.rewind();
                DataUtils.readFully(fileChannel, l2, byteBuffer);
                byteBuffer.rewind();
                byte by = byteBuffer.get();
                if (by == 72) {
                    printWriter.printf("%0" + n2 + "x fileHeader %s%n", l2, new String(byteBuffer.array(), DataUtils.LATIN).trim());
                    l2 += (long)n;
                    continue;
                }
                if (by != 99) {
                    l2 += (long)n;
                    continue;
                }
                byteBuffer.position(0);
                Chunk chunk = Chunk.readChunkHeader(byteBuffer, l2);
                int n4 = chunk.len * 4096;
                printWriter.printf("%n%0" + n2 + "x chunkHeader %s%n", l2, chunk.toString());
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n4);
                DataUtils.readFully(fileChannel, l2, byteBuffer2);
                int n5 = byteBuffer.position();
                l2 += (long)n4;
                int n6 = chunk.pageCount;
                while (n6 > 0) {
                    byteBuffer2.position(n5);
                    n3 = byteBuffer2.getInt();
                    byteBuffer2.getShort();
                    int n7 = DataUtils.readVarInt(byteBuffer2);
                    int n8 = DataUtils.readVarInt(byteBuffer2);
                    byte by2 = byteBuffer2.get();
                    boolean bl = (by2 & 2) != 0;
                    boolean bl2 = (by2 & 1) != 0;
                    printWriter.printf("+%0" + n2 + "x %s, map %x, %d entries, %d bytes%n", n5, (bl2 ? "node" : "leaf") + (bl ? " compressed" : ""), n7, bl2 ? n8 + 1 : n8, n3);
                    n5 += n3;
                    --n6;
                    long[] lArray = null;
                    long[] lArray2 = null;
                    if (bl2) {
                        int n9;
                        lArray = new long[n8 + 1];
                        for (n9 = 0; n9 <= n8; ++n9) {
                            lArray[n9] = byteBuffer2.getLong();
                        }
                        lArray2 = new long[n8 + 1];
                        for (n9 = 0; n9 <= n8; ++n9) {
                            long l3;
                            lArray2[n9] = l3 = DataUtils.readVarLong(byteBuffer2);
                        }
                    }
                    String[] stringArray = new String[n8];
                    if (n7 == 0) {
                        int n10;
                        if (!bl) {
                            for (int i = 0; i < n8; ++i) {
                                String string2;
                                stringArray[i] = string2 = StringDataType.INSTANCE.read(byteBuffer2);
                            }
                        }
                        if (bl2) {
                            for (int i = 0; i < n8; ++i) {
                                long l4 = lArray[i];
                                printWriter.printf("    %d children < %s @ chunk %x +%0" + n2 + "x%n", lArray2[i], stringArray[i], DataUtils.getPageChunkId(l4), DataUtils.getPageOffset(l4));
                            }
                            long l5 = lArray[n8];
                            printWriter.printf("    %d children >= %s @ chunk %x +%0" + n2 + "x%n", lArray2[n8], stringArray[n8], DataUtils.getPageChunkId(l5), DataUtils.getPageOffset(l5));
                            continue;
                        }
                        if (bl) continue;
                        String[] stringArray2 = new String[n8];
                        for (n10 = 0; n10 < n8; ++n10) {
                            String string3;
                            stringArray2[n10] = string3 = StringDataType.INSTANCE.read(byteBuffer2);
                        }
                        for (n10 = 0; n10 < n8; ++n10) {
                            printWriter.println("    " + stringArray[n10] + " = " + stringArray2[n10]);
                        }
                        continue;
                    }
                    if (!bl2) continue;
                    for (int i = 0; i <= n8; ++i) {
                        long l6 = lArray[i];
                        printWriter.printf("    %d children @ chunk %x +%0" + n2 + "x%n", lArray2[i], DataUtils.getPageChunkId(l6), DataUtils.getPageOffset(l6));
                    }
                }
                n3 = byteBuffer2.limit() - 128;
                byteBuffer2.position(n3);
                printWriter.printf("+%0" + n2 + "x chunkFooter %s%n", n3, new String(byteBuffer2.array(), byteBuffer2.position(), 128, DataUtils.LATIN).trim());
            }
            printWriter.printf("%n%0" + n2 + "x eof%n", l);
        }
        catch (IOException iOException) {
            printWriter.println("ERROR: " + iOException);
            iOException.printStackTrace(printWriter);
        }
        finally {
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
        printWriter.flush();
    }
}

