/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.h2.upgrade;

import java.io.File;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.glowroot.agent.embedded.shaded.org.h2.engine.ConnectionInfo;
import org.glowroot.agent.embedded.shaded.org.h2.jdbc.JdbcConnection;
import org.glowroot.agent.embedded.shaded.org.h2.message.DbException;
import org.glowroot.agent.embedded.shaded.org.h2.store.fs.FileUtils;
import org.glowroot.agent.embedded.shaded.org.h2.util.StringUtils;
import org.glowroot.agent.embedded.shaded.org.h2.util.Utils;
import org.glowroot.agent.embedded.sql.DriverManager;
import org.glowroot.agent.embedded.sql.SQLException;

public class DbUpgrade {
    private static final boolean UPGRADE_CLASSES_PRESENT = Utils.isClassPresent("org.glowroot.agent.embedded.shaded.org.h2.upgrade.v1_1.Driver");
    private static boolean scriptInTempDir;
    private static boolean deleteOldDb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection connectOrUpgrade(String string, Properties properties) throws SQLException {
        ConnectionInfo connectionInfo;
        if (!UPGRADE_CLASSES_PRESENT) {
            return null;
        }
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        Object object = properties.get("password");
        if (object instanceof char[]) {
            properties2.put("password", StringUtils.cloneCharArray((char[])object));
        }
        if ((connectionInfo = new ConnectionInfo(string, properties = properties2)).isRemote() || !connectionInfo.isPersistent()) {
            return null;
        }
        String string2 = connectionInfo.getName();
        if (FileUtils.exists(string2 + ".h2.db")) {
            return null;
        }
        if (!FileUtils.exists(string2 + ".data.db")) {
            return null;
        }
        if (connectionInfo.removeProperty("NO_UPGRADE", false)) {
            return DbUpgrade.connectWithOldVersion(string, properties);
        }
        Class<DbUpgrade> clazz = DbUpgrade.class;
        synchronized (DbUpgrade.class) {
            DbUpgrade.upgrade(connectionInfo, properties);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return null;
        }
    }

    private static Connection connectWithOldVersion(String string, Properties properties) throws SQLException {
        string = "jdbc:h2v1_1:" + string.substring("jdbc:h2:".length()) + ";IGNORE_UNKNOWN_SETTINGS=TRUE";
        return DriverManager.getConnection(string, properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void upgrade(ConnectionInfo connectionInfo, Properties properties) throws SQLException {
        String string = connectionInfo.getName();
        String string2 = string + ".data.db";
        String string3 = string + ".index.db";
        String string4 = string + ".lobs.db";
        String string5 = string2 + ".backup";
        String string6 = string3 + ".backup";
        String string7 = string4 + ".backup";
        String string8 = null;
        try {
            if (scriptInTempDir) {
                new File(Utils.getProperty("java.io.tmpdir", ".")).mkdirs();
                string8 = File.createTempFile("h2dbmigration", "backup.sql").getAbsolutePath();
            } else {
                string8 = string + ".script.sql";
            }
            String string9 = "jdbc:h2v1_1:" + string + ";UNDO_LOG=0;LOG=0;LOCK_MODE=0";
            String string10 = connectionInfo.getProperty("CIPHER", null);
            if (string10 != null) {
                string9 = string9 + ";CIPHER=" + string10;
            }
            Connection connection = DriverManager.getConnection(string9, properties);
            Statement statement = connection.createStatement();
            String string11 = UUID.randomUUID().toString();
            if (string10 != null) {
                statement.execute("script to '" + string8 + "' cipher aes password '" + string11 + "' --hide--");
            } else {
                statement.execute("script to '" + string8 + "'");
            }
            connection.close();
            FileUtils.moveTo(string2, string5);
            FileUtils.moveTo(string3, string6);
            if (FileUtils.exists(string4)) {
                FileUtils.moveTo(string4, string7);
            }
            connectionInfo.removeProperty("IFEXISTS", false);
            connection = new JdbcConnection(connectionInfo, true);
            statement = connection.createStatement();
            if (string10 != null) {
                statement.execute("runscript from '" + string8 + "' cipher aes password '" + string11 + "' --hide--");
            } else {
                statement.execute("runscript from '" + string8 + "'");
            }
            statement.execute("analyze");
            statement.execute("shutdown compact");
            statement.close();
            connection.close();
            if (deleteOldDb) {
                FileUtils.delete(string5);
                FileUtils.delete(string6);
                FileUtils.deleteRecursive(string7, false);
            }
            if (string8 == null) return;
        }
        catch (Exception exception) {
            try {
                if (FileUtils.exists(string5)) {
                    FileUtils.moveTo(string5, string2);
                }
                if (FileUtils.exists(string6)) {
                    FileUtils.moveTo(string6, string3);
                }
                if (FileUtils.exists(string7)) {
                    FileUtils.moveTo(string7, string4);
                }
                FileUtils.delete(string + ".h2.db");
                throw DbException.toSQLException(exception);
            }
            catch (Throwable throwable) {
                if (string8 == null) throw throwable;
                FileUtils.delete(string8);
                throw throwable;
            }
        }
        FileUtils.delete(string8);
        return;
    }
}

